


     TIMOD(M)		    Altos UNIX System V		      TIMOD(M)



     Name
	  timod	- Transport Interface cooperating STREAMS module

     Description
	  timod	is a STREAMS module for	use with the Transport
	  Interface (TI) functions of the Network Services library.
	  The timod module converts a set of ioctl(S) calls into
	  STREAMS messages that	may be consumed	by a transport
	  protocol provider which supports the Transport Interface.
	  This allows a	user to	initiate certain TI functions as
	  atomic operations.

	  The timod module must	only be	pushed (see Streams Primer)
	  onto a stream	terminated by a	transport protocol provider
	  which	supports the TI.

	  All STREAMS messages,	with the exception of the message
	  types	generated from the ioctl commands described below,
	  will be transparently	passed to the neighboring STREAMS
	  module or driver.  The messages generated from the following
	  ioctl	commands are recognized	and processed by the timod
	  module.  The format of the ioctl call	is:

	       #include	<sys/stropts.h>
			 -
			 -
	       struct strioctl strioctl;
			 -
			 -
	       strioctl.ic_cmd = cmd;
	       strioctl.ic_timeout = INFTIM;
	       strioctl.ic_len = size;
	       strioctl.ic_dp =	(char *)buf

	       ioctl(fildes, I_STR, &strioctl);

	  where, on issuance, size is the size of the appropriate TI
	  message to be	sent to	the transport provider and on return,
	  size is the size of the appropriate TI message from the
	  transport provider in	response to the	issued TI message.
	  buf is a pointer to a	buffer large enough to hold the
	  contents of the appropriate TI messages.  The	TI message
	  types	are defined in <sys/tihdr.h>.  The possible values for
	  the cmd field	are:

	  TI_BIND	 Bind an address to the	underlying transport
			 protocol provider.  The message issued	to the
			 TI_BIND ioctl is equivalent to	the TI message
			 type T_BIND_REQ and the message returned by
			 the successful	completion of the ioctl	is
			 equivalent to the TI message type T_BIND_ACK.




     Page 1					     (printed 3/20/91)






     TIMOD(M)		    Altos UNIX System V		      TIMOD(M)



	  TI_UNBIND	 Unbind	an address from	the underlying
			 transport protocol provider.  The message
			 issued	to the TI_UNBIND ioctl is equivalent
			 to the	TI message type	T_UNBIND_REQ and the
			 message returned by the successful completion
			 of the	ioctl is equivalent to the TI message
			 type T_OK_ACK.

	  TI_GETINFO	 Get the TI protocol specific information from
			 the transport protocol	provider.  The message
			 issued	to the TI_GETINFO ioctl	is equivalent
			 to the	TI message type	T_INFO_REQ and the
			 message returned by the successful completion
			 of the	ioctl is equivalent to the TI message
			 type T_INFO_ACK.

	  TI_OPTMGMT	 Get, set, or negotiate	protocol specific
			 options with the transport protocol provider.
			 The message issued to the TI_OPTMGMT ioctl is
			 equivalent to the TI message type
			 T_OPTMGMT_REQ,	and the	message	returned by
			 the successful	completion of the ioctl	is
			 equivalent to the TI message type
			 T_OPTMGMT_ACK.

     Files
	  <sys/timod.h>
	  <sys/tiuser.h>
	  <sys/tihdr.h>
	  <sys/errno.h>

     See Also
	  tirdwr(M)
	  STREAMS Primer
	  STREAMS Programmer's Guide
	  Network Programmer's Guide

     Diagnostics
	  If the ioctl system call returns with	a value	greater	than
	  0, the lower 8 bits of the return value will be one of the
	  TI error codes as defined in <sys/tiuser.h>.	If the TI
	  error	is of type TSYSERR, then the next 8 bits of the	return
	  value	will contain an	error as defined in <sys/errno.h> [see
	  intro(S)].











     Page 2					     (printed 3/20/91)



