	page	60,80
TITLE GENERAL PURPOSE I/O INTERFACE VERSION 1.4
SUBTTL	ERROR HANDLER VERSION 1.4

	.xlist

	include	gifdic.mac
	include	80186.mac
	include options.h
	include equates.h
	include mailboxs.h
	include	data.h
	
boot_err	equ	1

	include	boot_lnk.h

	.list
	.xall

;*********************************************************************
;*
;*		Error handling
;*
;*********************************************************************


badcrb:
	mov	ax,0100h		; bad call
	mov	di,offset crberr
	jmp	do_error
badcomand:
	mov	ax,0400h
	mov	di,offset comerr
	jmp	do_error
badsect:
	mov	ax,0900h		; sector not found
	mov	di,offset secerr
	jmp	do_error
baddev:
	mov	ax,0300h		; bad device
	mov	di,offset deverr
	jmp	do_error
badtype:
	mov	ax,0300h		; bad device
	mov	di,offset typerr
do_error:
	push	ax
	call	perr
	pop	ax
end_com:
	push	ax
	call	get_csb
	pop	ax
	mov	[di].ERROR,ax
	mov	[si].CEROR,ax
	clc
	ret

perr:
	mov	al,cs:sys_flag
	push	ax
	mov	cs:sys_flag,1
	call	ptext
	pop	ax
	mov	cs:sys_flag,al
	ret

ptext:		; print all characters from es:di to 04h ( etx )
	push	ds
	push	si			; save these
	push	cs
	pop	es			; messages are in cs
	jmp	ptext1			; starting point
printone:
	push	es
	push	di
	call	sys_prn
	pop	di
	pop	es
ptext1:
	mov	al,es:[di]		; get character
	inc	di			; next
	cmp	al,etx
	jne	printone		; output one
	pop	si
	pop	ds			; restore these
	ret

phex:			; print a hex byte as two ascii bytes
	push	ax
	sari	al,4	; msb
	call	pnibble
	pop	ax
pnibble:
	and	al,0fh
	or	al,30h	; add bits
	cmp	al,3ah
	jc	decimal
	add	al,7	; adjust
decimal:
	call	sys_prn
	ret

pspace:
	mov	al,20h		; space
	jmp	sys_prn


sys_prn:
	cmp	cs:sys_flag,0
	jnz	do_print
	ret
do_print:
	gifcall	kvddev,write,waitrdy
	ret


signon:	db	lf,lf,cr,'COLEX Universal System Interface. V 1.4A',cr,lf,lf
	db	'Loading Bootstrap.',lf,cr,etx

crberr:	db	cr,lf,'Illegal CRB requested !',cr,lf,etx

comerr:	db	cr,lf,'Bad command.',cr,lf,etx
secerr:	db	cr,lf,'Bad disk sector.',cr,lf,etx
deverr:	db	cr,lf,'Bad disk device.',cr,lf,etx
typerr:	db	cr,lf,'Bad disk type.',cr,lf,etx

eom	db	cr,lf,etx

bootname:	db	0,'CONFIG     '
	db	22 dup (0)			; default file name

errmes:	db	0ah,0dh,'Bootfile file not found.',0ah,0dh,'$'

cfmess: db	cr,lf,'Invalid configuration file',cr,lf,'$'

fifoflow:	db	'.',etx


prog	ends
	end
