;**********************************************************
;
;	MAILBOX DATA STRUCTURES
;
;**********************************************************

BMAIL	equ	0400h		; start
EMAIL	equ	2000h		; end
MDATA	equ	1200h		; start of data area
SMAIL	equ	EMAIL - BMAIL	; size



    if	new_68k

ACCESS	equ	0h

    else

ACCESS	equ	0040h

    endif

;	
;	macro for multiple mailboxes
;

MAKE	MACRO	funct,numbr
M&funct&numbr	&funct <>
	ENDM

;********************************************************
;
;	MAILBOX CURRENT STATUS FLAGS
;
;********************************************************

PEND	struc

PEND1	dw ?
PEND2	dw ?
PEND3	dw ?
PEND4	dw ?

PEND	ends

;**********************************************************
;
;	SYSTEM CONFIGURATION BLOCK
;
;**********************************************************


SCB		struc		; master block

SFLAG		dw 	0180h,05a0h,45a2h,55aah
				; id flag	
VERSN		dw	02
REVIS		dw	0001	; version and revision

		db	20 dup (0)

GMADDM		dw	ACCESS	; global address
GMADDL		dw	400h	; global access
GMAMC		dw	0003	; address modifier for access

MBSIZ		dw	?

LMADDM		dw	00
LMADDL		dw      0400h	; local address

		db	20 dup (0)

		dw	?
STLAB		dw	?	; start of LAB
		dw	?
STCSB		dw	?	; start of CSB
		dw	?
STCRB		dw	?	; start of CRB
		dw	?
STFLG		dw	?	; start of FLAGS
		dw	?
STDAT           dw      ?       ; start of DATA 
		db	12 dup (0)

		dw	0
LABSZ		dw	16 	; size of LAB
		dw	0
CSBTL		dw	32	; maximum number of devices
		dw	0
CRBTL		dw	64	; number of CRBs
		dw	0
FLGSZ		dw	8	; bytes per flag
		dw	0
DATSZ           dw      ?       ; size of data space
		db	12 dup(0)

SYSCT           db      MAXSYS	; number of system devices
DSKCT           db      MAXDSK	; number of disk devices
TTYCT           db      MAXTTY	; number of terminals
RTCCT           db      MAXRTC	; number of clocks
                db      12 dup (0) 

SCB		ends

;**********************************************************
;
;	Low Level Access Block
;
;**********************************************************

LAB		struc
	
OTDAT		db	0	; data out
OTFLG		db	0	; flag in bit 0

INDAT		db	0	; data in
INFLG		db	0	; flag in bit 0

		db 	6 dup (0)

CRATE		dw	300	; ticks per second
CLDIV		dw	6	; divisor
CTICK		dw	0	; ticking spot

LAB		ends

;**********************************************************
;
;	CHANNEL STATUS BLOCKS
;
;**********************************************************

csb		struc		; main part of csb

CSBNO	db ?		; device number
DEVCL	db ?		; major device type ( 0 = tty, 1 = disk, 2 = rtc )
DEVIC	dw ?		; device description
RQMAX	db ?		; max simultanious requests
RQCNT	db ?		; current request count

	dw 12 dup (?)

ERROR	dw ?		; error status

csb		ends


	page
;**********************************************************
;
;	CHANNEL STATUS BLOCK  ;  SYSTEM DEVICE
;
;**********************************************************

csb_sys		struc

	db ?		; csb number ( device number )
	db ?		; device type
	dw ?		; device description
	db ?		; request max
	db ?		; current request count

RAMSZ	dw ?		; upper ram size
RAMAC	dw ?		; lower ram size

	dw 11 dup (?)

csb_sys		ends


;**********************************************************
;
;	CHANNEL STATUS BLOCK  ;  DISK DEVICES
;
;**********************************************************


csb_disk	struc

	db ?		; csb number ( device number )
	db ?		; device type
	dw ?		; device description
	db ?		; request max
	db ?		; current request count

BLKSZ	dw ?		; physical sector size
BLKCTM	dw ?		; msb of last sector
BLKCTL	dw ?		; last sector number
SECTK	dw ?		; sectors per track
HEADS	dw ?		; number of heads
BLKOF	dw ?		; offset to first
BLKS1	dw ?		; size of first
BLKS2	dw ?
BLKS3	dw ?
BLKS4	dw ?
BLKS5	dw ?
BLKS6	dw ?

	dw ?

csb_disk	ends


	page
;**********************************************************
;
;	CHANNEL STATUS BLOCK  ;  REAL TIME CLOCK
;
;**********************************************************

csb_rtc		struc

	db ?		; csb number ( device number )
	db ?		; device type
	dw ?		; device description
	db ?		; request max
	db ?		; current request count

TIMESM	dw ?		; time msb
TIMESL	dw ?		; time lsb

SECND	db ?		; seconds
MINUT	db ?		; minutes
HOURS	db ?		; hours
DAYOM	db ?		; doy of month
MONTH	db ?		; month
YEARS	db ?		; year ad - 1900

	db 16 dup (0)

csb_rtc		ends


;**********************************************************
;
;	CHANNEL STATUS BLOCK  ;  CHARACTER DEVICES
;	CONSOLE, SERIAL PORTS, LINE PRINTER
;
;**********************************************************

csb_tty	struc

	db ?		; csb number ( device number )
	db ?		; device type
	dw ?		; device description
	db ?		; request max
	db ?		; current request count

CHSTS	dw ?		; tty status bit flags
			; bit 0 = DCD
			; bit 1 = Parity error
			; bit 2 = Framing error
			; bit 3 = Overrun error
			; bit 4 = Paper out

	db 24 dup (0)

csb_tty	ends


	page
;**********************************************************
;
;	CHANNEL REQUEST BLOCKS
;
;**********************************************************

crb		struc

DEVNO	db ?		; request on device number
DEVTP	db ?		; request on major device type
COMND	dw ?		; operation code
COUNT	dw ?		; request count

	dw 12 dup (?)

CEROR	dw ?		; error status

crb		ends


;*************************************************************
;*
;*	DEVICE TYPES AND COMMANDS
;*
;*************************************************************

CSYST	equ	00h		; class: system
CDISK	equ	01h		;	 disk
CTTYS	equ	02h		;	 character
CRTCS	equ	03h		;	 real time clock

SYSMS	equ	00h		; description:	MSDOS system

HDISK	equ	0001h		;		hard disk
FDISK	equ	0002h		;		floppy disk
TDISK	equ	0003h		;		tape drive

SYCON	equ	0001h		;		SYSCON video/keyboard
RSTTY	equ	0002h		;		RS serial terminal
CENTP	equ	0003h		;		Centronics printer

SYRTC	equ	0000h		;		SYSCON rtc

REBOT	equ	0001h		; command:	Reboot
MSDOS	equ	0002h		;		MSDOS

FLUSH	equ	0080h		;		Flush with command
DREAD	equ	0101h		;		Read disk
DRITE	equ	0102h		;		Write disk
DSTAT	equ	0103h		;		Disk status
DFORM	equ	0104h		;		Disk format

TINBY	equ	0201h		;		Input byte
TOTBL	equ	0202h		;		Output block
TINFF	equ	0203h		;		Input via fifo
TSTUP	equ	0204h		;		Set up
TSTAT	equ	0205h		;		Status
TOTFF	equ	0206h		;		Output via fifo

READS	equ	0301h		;		Read clock in seconds
RITES	equ	0302h		;		Write clock in seconds
READT	equ	0303h		;		Read clock in h/m/s etc
RITET	equ	0304h		;		Write clock in h/m/s etc



;**********************************************************
;
;	CHANNEL REQUEST BLOCK ; SYSTEM DEVICE
;
;**********************************************************

crb_sys		struc

	db ?		; device number
	db ?		; device type
	dw ?		; command code
	dw ?		; request count

SINIT	dw ?

	dw 13 dup (?)

crb_sys		ends

SYGBL	equ	SINIT	
SYLOC	equ	SINIT

	page
;**********************************************************
;
;	CHANNEL REQUEST BLOCK ; DISK DEVICE
;
;**********************************************************

crb_disk	struc

	db ?		; device number
	db ?		; device type
	dw ?		; command code
	dw ?		; request count

DSECTM	dw ?		; upper sector number
DSECTL	dw ?		; down sector number
SECNT	dw ?		; sector count
DMADDM	dw ?		; dma upper address
DMADDL	dw ?		; dma lower address
DVMEA	dw ?		; vme access code
SECLAM	dw ?		; look ahead sector number upper
SECLAL	dw ?		; look ahead sector number lower
SIZLA	dw ?		; look ahead size

	dw 4 dup (?)

crb_disk	ends

DSECL	equ	DSECTM		; sector size ( format )
DDENS	equ	DSECTL		; density (  format )
FSECN	equ	SECNT		; first sector no. ( format )
LSECN	equ	DMADDM		; last sector no. ( format )
FHEAD	equ	DMADDL		; first head no. ( format )
LHEAD	equ	DVMEA		; last head no. ( format )
FCYLN	equ	SECLAM		; first cylinder no. ( format )
LCYLN	equ	SECLAL		; last cylinder no. ( format )
ILEAV	equ	SIZLA		; interleave ( format )

;**********************************************************
;
;	CHANNEL REQUEST BLOCK ; REAL TIME CLOCK
;
;**********************************************************

crb_rtc		struc

	db ?		; device number
	db ?		; device type
	dw ?		; command code
	dw ?		; request count

STIMEM	dw ?		; time upper word
STIMEL	dw ?		; time lower word

TSECS	db ?		; time: seconds
TMINS	db ?		; minutes
THOUR	db ?		; hours
TDAYM	db ?		; day
TMOTH	db ?		; month
TYEAR	db ?		; year

	dw 8 dup (?)

crb_rtc		ends


	page
;**********************************************************
;
;	CHANNEL REQUEST BLOCK ; CHARACTER DEVICES
;
;**********************************************************

crb_tty		struc

	db ?		; device number
	db ?		; device type
	dw ?		; command code
	dw ?		; request count

INPTR	dw ?			; FIFO input pointer

OTPTR	dw ?			; FIFO output pointer

CHCNT	dw ?			; FIFO size, output count

CHADDM	dw ?			; data address
CHADDL	dw ?

CHVME	dw ?

	dw 7 dup (?)

crb_tty		ends

CCONF	equ	INPTR		; bit 0=1 : enable DTR
				; bit 1,2 : no stop
				;	  : 1 stop
				;	  : 1.5 stop
				;	  : 2 stop
				; bit 3=1 : output halt xoff
				; bit 4=1 : output halt xany
				; bit 5=1 : input halt xoff
				; bit 6=1 : send break
				; bit 7,8 : 5 bit data
				;	  : 6 bit data
				;	  : 7 bit data
				;         : 8 bit data
				; bit 9=1 : strip bit 8
				; bit a=1 : enable parity (i/o)
				; bit b=1 : odd parity (i/o)

BAUDR	equ	OTPTR		; value 0 : not valid
				; value 1 : 50 baud
				; value 2 : 75 baud
				; value 3 : 110 baud
				; value 4 : 134.5 baud
				; value 5 : 150 baud
				; value 6 : 200 baud
				; value 7 : 300 baud
				; value 8 : 600 baud
				; value 9 : 1200 baud
				; value a : 1800 baud
				; value b : 2400 baud
				; value c : 4800 baud
				; value d : 9600 baud
				; value e : 19200 baud
				; value f : external clock


;**************************************************************
;*
;*	flags structure
;*
;**************************************************************

FLAGS		struc

START1	dw 0
START2  dw 0
START3	dw 0
START4	dw 0

BUSY1	dw 0ffffh
BUSY2	dw 0ffffh
BUSY3	dw 0ffffh
BUSY4	dw 0ffffh

DONE1	dw 0
DONE2	dw 0
DONE3	dw 0
DONE4	dw 0

READY1	dw 0
READY2	dw 0
READY3	dw 0
READY4	dw 0

STATS1	dw 0
STATS2	dw 0
STATS3	dw 0
STATS4	dw 0

STACK1	dw 0ffffh
STACK2	dw 0ffffh
STACK3	dw 0ffffh
STACK4	dw 0ffffh

ABORT1	dw 0
ABORT2	dw 0
ABORT3	dw 0
ABORT4	dw 0

ABACK1	dw 0ffffh
ABACK2	dw 0ffffh
ABACK3	dw 0ffffh
ABACK4	dw 0ffffh

ACTON1	dw 0
ACTON2	dw 0
ACTON3	dw 0
ACTON4	dw 0

FLAGS	ends


	page

mailbox segment at 4000h

mailrf	equ	003h+ram_68k		; register file access

	org	BMAIL

MSCB	SCB <>				; initial information

SUSPEND	PEND <>		; marking flags held here



rcount	=	1
	REPT	csbmax
	MAKE	<CSB>,%rcount
rcount	= 	(rcount + 1)
	ENDM

rcount	=	1
	REPT	crbmax
	MAKE	<CRB>,%rcount
rcount	=	(rcount + 1)
	ENDM

MLAB	LAB <>

MFLAGS	FLAGS <>

DSIZE	equ	EMAIL - MDATA

mailbox	ends

