PROM	EQU	-1
TITLE	---	THIS MODULE CONTAINS PRIMITIVE I/O ROUTINES

INCLUDE	\186\XINSTR2.MAC
INCLUDE	\GIFI\SRC\GIFMAC.MAC


PGROUP	GROUP	PROG

PROG	SEGMENT	BYTE PUBLIC 'PROG'

	ASSUME	CS:PGROUP
	IF	NOT PROM
PUBLIC	GIFDIC
GIFDIC	LABEL	DWORD
GIFL	DW	?
GIFH	DW	?
	ELSE
	EXTRN	GIFDIC:FAR
	ENDIF



; FUNCTION : TO DISPLAY A CHARACTER VIA THE OUTPUT CHANNEL
; INPUT PARAMETER : BX -- THE OUTPUT CHANNEL
; 		    AL -- THE CHARACTER TO BE DISPLAYED
; OUTPUT PARAMETER : CY IF ERROR, AND AH CONTAINS THE ERROR CODE
; DESTROYED : NIL

NPROCEDURE DISPCHR

	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	BP
	PUSH	DI
	OR	BX, (WRITE SHL 2)	; LOAD THE WRITE CODE
	MOV	AH,WAITRDY
	CALL	GIFDIC
	POP	DI
	POP	BP
	POP	DX
	POP	CX
	POP	BX
	RET

DISPCHR	ENDP

; FUNCTION : TO DISPLAY A BLOCK OF CHARACTERS VIA THE OUTPUT CHANNEL
; INPUT PARAMETER : ES:DI -- POINTING THE BUFFER OF CHARACTERS
;		    CX -- NUMBER OF CHARACTERS TO DISPLAY
;		   BX -- THE OUTPUT CHANNEL
; OUTPUT PARAMETER : CY IF ERROR, AND AH CONTAINS THE ERROR CODE
; DESTROYED : NIL

NPROCEDURE DISPCHRB

	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	BP
	PUSH	DI
	OR	BX, (WRITE SHL 2)
	MOV	AH, (BLOCK)OR(WAITRDY)
	CALL	GIFDIC
	POP	DI
	POP	BP
	POP	DX
	POP	CX
	POP	BX
	RET

DISPCHRB ENDP

	IF	NOT PROM
; FUNCTION : TO GET THE GIFDIC HANDLER ADDRESS
; INPUT PARAMETER : NIL
; OUTPUT PARAMETER: NIL , BUT THE GIFDIC HANDLER ADDRESS IS GOT
; DESTROYED : NIL

NPROCEDURE GGIFHDLR

	PUSH	AX
	PUSH	CX
	PUSH	DI
	PUSH	ES
	XOR	CX, CX
	INT	99H
	MOV	AX, ES:[DI.GHNDLR]
	MOV	WORD PTR CS:GIFL, AX
	MOV	AX, ES:[DI.SPGROUP]
	MOV	WORD PTR CS:GIFH, AX
	POP	ES
	POP	DI
	POP	CX
	POP	AX
	STI
	RET

GGIFHDLR ENDP
	ENDIF
PROG	ENDS

END

