TITLE	BOOT	RECORD


BURST	EQU	0
CR	EQU	0DH
LF	EQU	0AH
EOM	EQU	-1

;
; PRE-DEFINITION
;
STCK	EQU	300H			; INITIAL STACK POINTER
;
GETGIAT	EQU	99H
;

BPS_	EQU	512			; IF CHANGED, REVIEW PROCEDURE GET_FILE_SIZE

;
INCLUDE	GIFDIC.EQU
;
PUSHA	MACRO
	DB	60H
ENDM
;
POPA	MACRO
	DB	61H
ENDM
;
SHRAX	MACRO	CNT
	DB	0C1H, 0E8H, CNT
ENDM
;
; DISK OPERATION MACRO's
;

RESET_	MACRO
	LOCAL	NOERR
	MOV	BX, RESET*4+DSKDEV*64
	CALL	GIFDIC
	JNC	NOERR
	JMP	FAIL_AND_DIE
NOERR:
ENDM

GST_	MACRO	FUNC
	LOCAL	NOERR
	MOV	DL, FUNC
	MOV	BX, GSTATUS*4+DSKDEV*64
	CALL	GIFDIC
	JNC	NOERR
	JMP	FAIL_AND_DIE
NOERR:
ENDM

SST_	MACRO	FUNC
	LOCAL	NOERR
	MOV	DL, FUNC
	MOV	BX, SSTATUS*4+DSKDEV*64
	MOV	AL, BOOT_DRIVE
	CALL	GIFDIC
	JNC	NOERR
	JMP	FAIL_AND_DIE
NOERR:
ENDM

READ_	MACRO	SEG
	LOCAL	NOERR
	MOV	BX, READ*4+DSKDEV*64
	XOR	DI, DI
	MOV	AX, SEG
	MOV	ES, AX
	MOV	AL, BOOT_DRIVE
	CALL	GIFDIC
	JNC	NOERR
	JMP	FAIL_AND_DIE
NOERR:
ENDM

;
CODE	SEGMENT				; AT 0
	ASSUME	CS:CODE, DS:CODE, ES:CODE
	ORG	0
;VVVVVV
; THE POSITION MUST BE FIXED UNTIL ^^^^^^
PUBLIC	BOOTSTART
BOOTSTART:
	JMP	START
;
	ORG	3
OEM	DB	'COLEXVME CPM68K'
SUSHIFT	DB	1

; INTERNAL DATA AREA

BOOT_DRIVE DB	?
;
; GIAT (GIFDIC INTERNAL ADDRESS TABLE)
;
GIAT	LABEL	WORD
PROMVER	DW	?			; PROM VERSION
GIATSZ	DW	?			; NUMBER OF WORDS IN THIS TABLE
PROMPG	DW	?			; PROM PGROUP
PROMDG	DW	?			; PROM DGROUP
GIFDICC	DW	?			; GIFDIC CALL
GIFDICA	DW	?			; GIFDIC ADDRESS TABLE
ATTRTAB	DW	?			; GIFDIC ATTRIBUTE TABLE
EODATA	DW	?			; END OF PROM DATA AREA
MAXRAM	DD	?			; RAM SIZE IN BYTE

GIATCNT	EQU	($-GIAT)/2
;
; BIOS POINTER
BIOS	LABEL	DWORD
BIOSLOC	DW	2
BIOSSEG	DW	?

; GIFDIC POINTER
GIFDIC	LABEL	DWORD
GFDLOC	DW	?
GFDSEG	DW	?

START:
	CLI
	MOV	AX, CS
	MOV	DS, AX
	MOV	ES, AX
	MOV	SS, AX
	MOV	SP, STCK

; GET GIAT TABLE
	MOV	DI, OFFSET GIAT
	MOV	CX, GIATCNT
	INT	GETGIAT
	MOV	AX, EODATA
	SHRAX	4
	INC	AX
	ADD	AX, PROMDG
	MOV	BIOSSEG, AX
	MOV	AX, GIFDICC
	MOV	GFDLOC, AX
	MOV	AX, PROMPG
	MOV	GFDSEG, AX

	CMP	SUSHIFT, -1
	JNE	BOOTSYS
; NON-SYSTEM DISK
	MOV	DI, OFFSET NON_SYS_MSG
	JMP	PRINT_AND_DIE

BOOTSYS:

	MOV	DI, OFFSET OEM_COPYRIGHT
	CALL	PRINT
	PUSH	ES
	XOR	AX,AX
	MOV	ES,AX
	MOV	DX,AX
	MOV	DI,4500H
	MOV	CX,648H
	SST_	6
	INC	BYTE PTR BOOT_DRIVE
	SST_	6
	POP	ES
	MOV	CX,100H
	MOV	DH,40H
	SST_	2
	DEC	BOOT_DRIVE
	SST_	2
	MOV	BX,SCONDEV*64+READ*4
	MOV	AH,2
	CALL	GIFDIC
	CMP	AL,40H
	JNZ	NMSG
	MOV	DH,80H
	MOV	AL,11
	SST_	12
NMSG:

; GET BOOT DRIVE
	GST_	CTRLOG
	MOV	BOOT_DRIVE, AL

; RESET THE BOOT DRIVE
	RESET_

; SET BOOT DRIVE MEDIA
	MOV	DH,0
	CMP	DH, 0
	JZ	SHORT NONFLPB		; NON-FLOPPY BOOT
	SST_	MEDSET
NONFLPB:
	MOV	CX,1			;READ FIRST SECTOR OF BIOS
	MOV	DX,CX
	READ_	BIOSSEG
	MOV	CL,ES:[DI+1]		;GET LENGTH INTERFACE CODE
	SHR	CL,1
	MOV	CH,ES:[DI+3]		;GETS LENGTH BIOS
	SHR	CH,1
	INC	CH
	ADD	CL,CH
	XOR	CH,CH
	INC	CX
	MOV	DX,1			;READ WHOLE BIOS IN
	READ_	BIOSSEG
;
BOOT_END:
	JMP	BIOS
;
FAIL_AND_DIE:
	MOV	DI, OFFSET BOOT_FAIL_MSG
PRINT_AND_DIE:
	CALL	PRINT
	JMP	$

PRINT	PROC	NEAR
	PUSH	DS
	PUSH	ES
	PUSHA
	MOV	AX, CS
	MOV	ES, AX
	XOR	CX, CX
	MOV	CL, EOM
IF	BURST
	MOV	AH, 0C2H		; BURST MODE, STOP CHAR, WAIT
	MOV	BX, WRITE*4+SCONDEV*64
	CALL	GIFDIC
ELSE
	MOV	AX, ES
	MOV	DS, AX
	MOV	SI, DI
PADLP:
	LODSB
	CMP	AL, CL
	JE	PADLPEND
	MOV	AH, 2
	MOV	BX, WRITE*4+SCONDEV*64
	CALL	GIFDIC
	JMP	PADLP
PADLPEND:
ENDIF
	POPA
	POP	ES
	POP	DS
	RET
PRINT	ENDP

;
OEM_COPYRIGHT DB CR, LF, 'COLEX-2000'
	DB	CR, LF, 'Copyright 1984, COLEX Inc.'
	DB	CR, LF, EOM
NON_SYS_MSG DB	CR, LF, 'Non-System Disk', EOM
BOOT_FAIL_MSG DB CR, LF, 'Boot Failure', EOM
;
;
CODE	ENDS
;
END
