TITLE Monitor Register Command Recognition
;
name monR
;
pgroup group prog
dgroup group data
;
      extrn cmd_tmn:abs, rupd_ind:abs, upd_quit:abs, cr:abs, lf:abs
      extrn R_num:abs, wreg_num:abs
;
; data segment (dummy)
data segment word public 'data'
      extrn reg_set:word, fcw:word, wr_buf:byte
      extrn ds_:word, ssss:word, dsss:word
data ends
;
prog segment byte public 'prog'
      extrn put_char_kb:near, put_str_kb:near
      extrn get_hex:near, hexstr:near
      extrn cur_bck:near
      extrn fetch_oprn:near, ill_char:near, skip_blank:near
      extrn R_disp:near
      extrn cr_:near, crlf_:near
      extrn wreg_name:word, wreg_nend:word
      extrn flag_nend:word
      extrn R_names:word, R_nend:word
      extrn r_disp_head:byte
      public R_proc
      assume cs:pgroup, ds:dgroup, es:dgroup
;
; R_proc :
;   Register operations --
;      'R' for displaying all registers;
;      'Rrr' for updating registers starting from 'rr'.
;      The order is AX, BX, CX, DX, DS, SI, ES, DI, CS, IP,
;        SS, SP, BP for word operation.  Wrap around while ended.
;
R_proc proc near
      call     skip_blank
      lodsw
      cmp      al, cmd_tmn
      je       R_1
      cmp      al, rupd_ind
      jne      reg_upd
; Default clearing all registers and flags
      cmp      ah, cmd_tmn
      je       R_2
      dec      si
      call     skip_blank
      lodsb
      cmp      al, cmd_tmn
      je       R_2
      jmp      R_err
R_2:
      xor      ax, ax
      mov      cx, 1+wreg_num
      mov      di, offset reg_set
      rep stosw
      jmp      R_end
R_1:
      call     R_disp
      mov      ax, ds_
      cmp      ax, dsss
      je       R_3
      mov      dsss, ax
      mov      ssss, 0
R_3:
      jmp      R_end
reg_upd:
; Recognize the register/flag name
      mov      di, offset pgroup:R_names
      mov      cx, R_num
      mov      bx, cs
      mov      es, bx
      repne scasw
      mov      ax, ds
      mov      es, ax
      je       reg_rec
      jmp      R_err
; Recognized
reg_rec:
      sub      di, 2
      cmp      di, offset pgroup:wreg_nend
      jae      wreg_jmp
      mov      bx, di  ; BX holds the name position
      add      di, offset reg_set
      sub      di, offset pgroup:wreg_name
; Mode test
      call     skip_blank
      lodsb
      cmp      al, cmd_tmn
      je       R_upd
      cmp      al, rupd_ind
      je       sng_upd
      jmp      R_err
; Single updating
sng_upd:
      call     fetch_oprn
      jc       wr_sng_act
      mov      dx, 0  ; Default zero
wr_sng_act:
      lodsb
      cmp      al, cmd_tmn
      je       R_4
      jmp      R_err
R_4:
      mov      [di], dx
      jmp      short R_end
; Word register updating
R_upd:
      mov      si, bx  ; Name position
wr_upd_loop:
      call     reg_disp
      mov      cx, 4
      call     get_hex
      jc       wr_act
; Non-active hex
      mov      bx, dx  ; BX as buffer
      cmp      cx, 4
      je       wr_1
      call     cr_
      call     reg_disp
wr_1:
      cmp      bl, cr
      je       wr_lpend
;     cmp      bl, upd_quit  ; No need to check
      call     crlf_
      jmp      short R_end
wr_act:
      mov      [di], dx
wr_lpend:
      call     crlf_
      cmp      si, offset pgroup:wreg_nend-2
      jb       wr_2
      mov      si, offset pgroup:wreg_name
      mov      di, offset reg_set
      jmp      short wr_3
wr_2:
      add      si, 2
      add      di, 2
wr_3:
      jmp      short wr_upd_loop
wreg_jmp:
;     cmp      di, offset pgroup:breg_nend
;     ja       breg_jmp
; Flag names
      mov      dx, 1
      mov      cx, offset pgroup:flag_nend
      sub      cx, di
      shr      cx, 1
      sub      cx, 1
      shl      dx, cl
flg_2:
      call     skip_blank
      lodsb
      cmp      al, '0'
      jne      flg_1
      not      dx
      and      fcw, dx
      jmp      R_end
flg_1:
      cmp      al, '1'
      jne      flg_3
      or       fcw, dx
      jmp      R_end
flg_3:
      cmp      al, cmd_tmn
      jne      R_err
      xor      al, al
R_err:
      call     ill_char
R_end:
      ret
R_proc endp
;
; reg_disp :
;   Display register
;   (AX and DX will be destroyed)
;
reg_disp proc near
      push     di
      push     si
; Edit register name
      mov      ax, cs:[si]
      add      si, 2
      mov      wr_buf+3, rupd_ind
      mov      word ptr wr_buf+1, ax
; Edit content
      mov      dx, [di]
      mov      di, offset wr_buf+4
      call     hexstr
      mov      wr_buf, 7
      mov      si, offset wr_buf
      call     put_str_kb
; Move to content
      mov      dl, 4
      call     cur_bck
      pop      si
      pop      di
      ret
reg_disp endp
;
prog ends
;
end
