TITLE String/Hex conversion module
;
name HEXCVT
;
pgroup group prog
;
prog segment byte public 'prog'
      public strhex, strhex_byte, hexstr, strhex
      assume cs:pgroup
;
; String to Hex value convertion routine
;   The source string is pointed by DS:SI
;   The value converted is returned thru DX
;   DS:SI will point to the character immediately following the
;   hex string.  None of the other registers are destroyed.
;
; Note :  The input hex string should contain only '0' to '9',
;         and 'A' to 'F' (In capital).  However, the length of
;         it is not necessarily be 4.  Any characters not in the
;         range above and/or the fifth one will terminate this
;         procedure.
;
strhex proc near
      push     cx
      mov      cx, 4
      call     near ptr strhex_work
      pop      cx
      ret
strhex endp
;
; strhex_byte :  Same as strhex but fetch a byte each time
;
strhex_byte proc near
      push     cx
      mov      cx, 2
      call     near ptr strhex_work
      pop      cx
      ret
strhex_byte endp
;
; strhex_work
;
strhex_work proc near
      push     ax
      xor      ax, ax
      xor      dx, dx
sh_loop:
      lodsb
      cmp      al, 'A'
      jb       sh_tst_0_9
      cmp      al, 'F'
      ja       sh_end
      add      al, 9
      jmp      sh_cal
sh_tst_0_9:
      cmp      al, '0'
      jb       sh_end
      cmp      al, '9'
      ja       sh_end
sh_cal:
      and      al, 0fh
      shl      dx, 1
      shl      dx, 1
      shl      dx, 1
      shl      dx, 1
      or       dx, ax
      loop     sh_loop
      inc      si
; Ending
sh_end:
      dec      si
      pop      ax
      ret
strhex_work endp
;
; Hex value to String convertion routine
;   The source value is passed in thru DX
;   The destination string is pointed by ES:DI
;   ES:DI will point to the character immediately following the
;   hex string.  None of the other registers are destroyed.
;
; Note :  The output hex string contains only '0' to '9',
;         and 'A' to 'F' (In capital).
;
hexstr proc near
      push     ax
      push     cx
      push     dx
      mov      cx, 4
hs_loop:
      rol      dx, 1
      rol      dx, 1
      rol      dx, 1
      rol      dx, 1
      mov      ax, dx
      and      ax, 000fh
      cmp      ax, 0ah
      jb       hs_1
      add      ax, 7
hs_1:
      add      ax, 30h
      stosb
      loop     hs_loop
      pop      dx
      pop      cx
      pop      ax
      ret
hexstr endp
;
prog ends
;
end
