TITLE Monitor Utilities
;
name monutl
;
pgroup group prog
dgroup group data
;
      extrn cr:abs, lf:abs
      extrn wreg_num:abs, flag_num:abs, rupd_ind:abs
      extrn gh_quit:abs
;
; data segment (dummy)
data segment word public 'data'
      extrn wr_buf:byte, reg_set:word, flag_name:word, ip_offset:word
      extrn cs_:word, ip_:word
      extrn ds_:word, si_:word
      extrn es_:word, di_:word
      extrn ss_:word, sp_:word
data ends
;
prog segment byte public 'prog'
      extrn steal_char_kb:near, put_char_kb:near, put_str_kb:near
      extrn put_msg_kb:near
      extrn strhex:near, hexstr:near, crlf_:near, bell_:near
      extrn ill_char_msg:byte, r_disp_head:byte
      extrn cs_ip:byte, ds_si:byte, es_di:byte, ss_sp:byte
      public skip_blank, ill_char, fetch_oprn, hex_test, get_hex
      public show_hex, R_disp
      assume cs:pgroup, ds:dgroup
;
; skip_blank :
;   Move the SI to point to the first non-blank location not before it.
;
skip_blank proc near
      push     ax
sb_loop:
      lodsb
      cmp      al, ' '
      je       sb_loop
      dec      si
      pop      ax
      ret
skip_blank endp
;
; ill_char :
;   The Illegal character is in al.
;
ill_char proc near
      mov      si, offset pgroup:ill_char_msg
      call     put_msg_kb
      mov      dl, al
      call     put_char_kb
      mov      dl, '"'
      call     put_char_kb
      call     crlf_
      ret
ill_char endp
;
;
; fetch_oprn :
;   Fetch the next operand into DX.  The leading blanks are skipped.
;   DS:SI will point to the terminator then.  If there is no operand,
;   the carry will be cleared.  Otherwise, it is set. (C : Active-flag)
;
fetch_oprn proc near
      call     skip_blank
      call     near ptr hex_test
      jnc      fo_end  ; If not hex, it is default.
      call     strhex
      call     near ptr hex_test
      jc       fo_end  ; Hex character as terminator.  Left to caller.
      call     skip_blank
      call     near ptr hex_test
      jnc      fo_1  ; If carry, then terminator is blank
      dec      si  ; Point to blank
fo_1:
      stc
fo_end:
      ret
fetch_oprn endp
;
; hex_test :
;   Test the character pointed by DS:SI.  If it is a hex character,
;   then set the carry bit.  Otherwise, it is reset. (C : Hex-flag)
;
hex_test proc near
      cmp      byte ptr [si], '0'
      jb       non_hex
      cmp      byte ptr [si], '9'
      jbe      ok_hex
      cmp      byte ptr [si], 'A'
      jb       non_hex
      cmp      byte ptr [si], 'F'
      ja       non_hex
ok_hex:
      stc
      jmp      ht_end
non_hex:
      clc
ht_end:
      ret
hex_test endp
;
; get_hex :
;   Get not more than four digits and thus form a hex in DX.
;   The number of digits is stored in CX.
;   If <CR> or '.' is encountered, the carry will be cleared and the
;   DL will hold the terminator.  Otherwise, the carry will be set.
;
get_hex proc near
      push     ax
      push     cx
      xor      ax, ax
get_hex_loop:
      call     steal_char_kb
      cmp      dl, '0'
      jb       hex_cr
      cmp      dl, '9'
      ja       hex_a_f
      call     put_char_kb
      and      dl, 0fh
      jmp      short store_hex
hex_a_f:
      cmp      dl, 'A'
      jb       hex_cr
      cmp      dl, 'F'
      ja       hex_small
hex_big:
      call     put_char_kb
      sub      dl, 'A'-0ah
      jmp      short store_hex
hex_small:
      cmp      dl, 'a'
      jb       hex_cr
      cmp      dl, 'f'
      ja       hex_cr
      sub      dl, 'a'-'A'
      jmp      short hex_big
hex_cr:
      cmp      dl, cr
      jne      hex_quit
      clc
      jmp      short gh_end
hex_quit:
      cmp      dl, gh_quit
      jne      hex_err
      clc
      jmp      short gh_end
hex_err:
      call     bell_
      jmp      short get_hex_loop
store_hex:
      shl      ax, 1
      shl      ax, 1
      shl      ax, 1
      shl      ax, 1
gh_2:
      or       al, dl
      loop     get_hex_loop
      mov      dx, ax
      stc
gh_end:
      pop      cx
      pop      ax
      ret
get_hex endp
;
; show_hex :
;   Display a hex in DX
;
show_hex proc near
      push     si
      push     di
      mov      wr_buf, 4
      mov      di, offset wr_buf+1
      call     hexstr
      mov      si, offset wr_buf
      call     put_str_kb
      pop      di
      pop      si
      ret
show_hex endp
;
show_seg_ptr macro sg, pt
; Display sg&:pt
      mov      si, offset pgroup:sg&_&pt
      call     put_msg_kb
      mov      es, sg&_
      mov      di, pt&_
      mov      dx, es:[di]
      mov      ax, ds
      mov      es, ax
      xchg     dh, dl
      call     show_hex
endm
;
; R_disp :
;   Display all registers
;
R_disp proc near
      call     crlf_
      mov      si, offset pgroup:r_disp_head
      call     put_msg_kb
      mov      wr_buf, 5
      mov      wr_buf+5, ' '
; Display the registers
      mov      si, offset reg_set
      mov      cx, wreg_num
rd_loop:
      lodsw
      mov      dx, ax
      call     show_hex
      mov      dl, ' '
      call     put_char_kb
      loop     rd_loop
; Display the flags
      mov      dl, ' '
      call     put_char_kb
      lodsw  ; It's the FCW following the register set
      mov      bx, ax  ; BX as FCW buffer
      mov      si, offset pgroup:flag_name
      mov      cx, -1+flag_num
      mov      dx, 1
      shl      dx, cl
      mov      cx, dx
fd_loop:
      mov      dl, 20h
      lodsw  ; The flag name
      cmp      ax, '  '
      je       put_f
      add      dl, 10h
      test     bx, cx
      jz       put_f
      inc      dl
put_f:
      call     put_char_kb
      sar      cx, 1  ; Arithmetic Shifting for Zero status setting
      jnz      fd_loop
      call     crlf_
; Display CS:IP
      mov      si, offset pgroup:cs_ip
      call     put_msg_kb
      mov      dx, ip_offset
      cmp      dx, 0
      je       csip_1
      call     show_hex
      mov      ax, dx
      mov      dl, '+'
      call     put_char_kb
      neg      ax
      mov      dx, ax
csip_1:
      add      dx, ip_
      call     show_hex
      mov      dl, ')'
      call     put_char_kb
      mov      dl, '='
      call     put_char_kb
      mov      es, cs_
      mov      di, ip_
      mov      dx, es:[di]   ; The 1st word
      mov      bx, es:[di+2] ; The 2nd word
      mov      ax, ds
      mov      es, ax
      xchg     dh, dl
      call     show_hex
      mov      dx, bx
      xchg     dh, dl
      call     show_hex
      show_seg_ptr ds, si  ; display DS:SI
      show_seg_ptr es, di  ; display ES:DI
      show_seg_ptr ss, sp  ; display SS:SP
      call    crlf_
      ret
R_disp endp
;
prog ends
;
end
