TITLE Monitor Port Update
;
name Pupd
;
pgroup group prog
dgroup group data
;
      extrn upd_row:abs, up_arrow:abs, down_arrow:abs
      extrn upd_rub:abs, upd_quit:abs, cr:abs, port_intro:abs
;
; data segment (dummy)
data segment word public 'data'
      extrn last_port:word, wr_buf:byte
data ends
;
prog segment byte public 'prog'
;
      extrn steal_char_kb:near, put_str_kb:near
      extrn hexstr:near, get_hex:near
      extrn cr_:near, crlf_:near, clr_scr:near, clr_eoln:near
      extrn cur_up:near, cur_down:near, cur_fwd:near, bell_:near
      extrn ill_char:near
      public P_update, paddr_disp, port_disp
      assume cs:pgroup, ds:dgroup, es:dgroup
;
; P_update
;
P_update proc near
      call     clr_scr
      mov      dl, upd_row
      call     cur_down
      mov      cx, 4
P_upd_loop:
      mov      dx, last_port
      call     port_disp
      call     cr_
      call     steal_char_kb
      cmp      dl, down_arrow
      jne      down_arr_jmp
; Down
      mov      dl, 1
      call     cur_down
      add      last_port, 2
      jmp      P_upd_lpend
down_arr_jmp:
      cmp      dl, up_arrow
      jne      up_arrow_jmp
; Up
      mov      dl, 1
      call     cur_up
      sub      last_port, 2
      jmp      short P_upd_lpend
up_arrow_jmp:
      cmp      dl, upd_rub
      jne      rub_jmp
; Rub and enter
      call     rub_update
      jmp      short P_upd_lpend
rub_jmp:
      cmp      dl, upd_quit
      je       P_upd_end
; Error update code
      call     bell_
P_upd_lpend:
      jmp      P_upd_loop
P_upd_end:
      call     crlf_
      ret
P_update endp
;
; rub_update
;
rub_update proc near
rupd_loop:
      mov      dl, 5
      call     cur_fwd
      call     clr_eoln
      call     get_hex
      jc       hex_ok
; exit code
      cmp      dl, cr
      jne      hex_quit
      call     cr_
      mov      dx, last_port
      call     port_disp
      jmp      short gh_lpend
hex_quit:
      call     cr_
      jmp      short rupd_end
hex_ok:
; output to port
      mov      ax, last_port
      xchg     ax, dx
      out      dx, ax
gh_lpend:
      call     crlf_
      add      last_port, 2
      mov      dx, last_port
      call     port_disp
      call     cr_
      jmp      rupd_loop
rupd_end:
      ret
rub_update endp
;
; paddr_disp :
;   Display the address in DX.
;   (DI will be destroyed)
;
paddr_disp proc near
      push     si
      mov      di, offset wr_buf+1
      call     hexstr
      mov      wr_buf+5, port_intro
      mov      wr_buf, 5
      mov      si, offset wr_buf
      call     put_str_kb
      pop      si
      ret
paddr_disp endp
;
; port_disp :
;   Display the port content pointed by DX.  Digit count in CX.
;   (DI will be destroyed)
;
port_disp proc near
      push     si
      push     dx
      call     paddr_disp
      in       ax, dx
      mov      dx, ax
      mov      di, offset wr_buf+1
      call     hexstr
      mov      si, cx
      neg      si
      lea      si, 4+wr_buf[si]
      mov      byte ptr [si], cl
      call     put_str_kb
      pop      dx
      pop      si
      ret
port_disp endp
;
prog ends
;
end
