TITLE Simulation of the SYSCON I/O functions
;
name SML_IO
;
dgroup group data
pgroup group prog
;
include \gifi\gifmac.mac
;
cr equ 0dh
lf equ 0ah
rub equ 07fh
bell equ 7
bck_spc equ 8
esc equ 1bh
;
; Editing
;
up_arrow equ '['
down_arrow equ ']'
upd_rub equ 7fh
public up_arrow, down_arrow, upd_rub
;
; System
;
int3 equ 66h
trap_vector equ 6
trace_vector equ 2
boot_key equ 2  ; ^B
send_null_count equ 1
public int3, boot_key
;
pusha macro
      db 60h
endm
;
popa macro
      db 61h
endm
;
data segment word public 'data'
      extrn quit_point:dword
data ends
;
;
prog segment byte public 'prog'
;     public RAM_base, stack_seg, stack_ptr
      public steal_char_kb, pool_kb, put_msg_kb
      public get_char_kb, put_char_kb, get_str_kb, put_str_kb
      public crlf_, cr_, bell_
      public cur_up, cur_down, cur_fwd, cur_bck, clr_eoln, clr_scr
      public send_type, send_end, read_file
      public set_trap, set_single, set_trace, enable_int
      public terminate
      extrn gifdic:far
      assume cs:pgroup, ds:dgroup
;
if 0
rom_rtn segment at 0ff20h
      org 9
rdcon label far
      org 12
wrcon label far
      org 18
rdaux label far
      org 21
wraux label far
rom_rtn ends
endif
;
;
; I/O procedures
;
;;
;
; pool_kb :
;   Input :  No
;   Output:  DL -- Character read or hex FF to indicate not ready
;
pool_kb proc near
      push     ax
      push     bx
      gifcall  dcondev, gstatus, noopt
      mov      dl, -1
      jc       pk_end
      mov      dl, al
pk_end:
      pop      bx
      pop      ax
      ret
pool_kb endp
;
; steal_char_kb :
;   Input :  No
;   Output:  DL -- Character read
;
steal_char_kb proc near
      push     ax
      push     bx
      gifcall  dcondev, read, waitrdy
      mov      dl, al
      pop      bx
      pop      ax
      ret
steal_char_kb endp
;
; put_char_kb :
;   Input :  DL -- Character to write
;   Output:  No
;
put_char_kb proc near
      push     ax
      push     bx
      mov      al, dl
      gifcall  dcondev, write, waitrdy
      pop      bx
      pop      ax
      ret
put_char_kb endp
;
; get_char_kb :
;   Input :  No
;   Output:  DL -- Character read
;
get_char_kb proc near
      call     steal_char_kb
      call     put_char_kb
      ret
get_char_kb endp
;
; get_str_kb:
;   Input :  (The string typed thru the keyboard, with <CR> excluded
;             but <boot_key> included)
;   Output:  ES:DI -- String (with the first byte as length)
;   Note :  ES:DI will point to the first byte (count byte) of the
;           string read.
get_str_kb proc near
      push     ax
      push     bx
      push     dx
      mov      bx, di
      inc      di
gs_loop:
      call     steal_char_kb
      cmp      dl, rub
      jne      gs_1
; Rub
      dec      di
      cmp      di, bx
      jne      gs_2
      inc      di
      jmp      short gs_loop
gs_2:
      mov      dl, bck_spc
      call     put_char_kb
      mov      dl, ' '
      call     put_char_kb
      mov      dl, bck_spc
      call     put_char_kb
      jmp      short gs_loop
gs_1:
      cmp      dl, cr
      je       gs_end
      cmp      dl, boot_key
      jne      gs_3
      mov      al, dl
      stosb
      mov      dl, '^'
      call     put_char_kb
      mov      dl, al
      or       dl, 40h
      call     put_char_kb
      jmp      short gs_end
gs_3:
      mov      al, dl
      stosb
      call     put_char_kb
      jmp      short gs_loop
; Ending
gs_end:
      mov      ax, di
      sub      ax, bx
      dec      ax
      mov      di, bx
      mov      es:[di], al
      mov      dl, cr
      call     put_char_kb
      mov      dl, lf
      call     put_char_kb
      pop      dx
      pop      bx
      pop      ax
      ret
get_str_kb endp
;
; put_str_kb:
;   Input :  DS:SI -- String (with the first byte as length)
;   Output:  (The string display on the screen)
;   Note :  DS:SI will point to the character immediately following
;           the string printed.
;
put_str_kb proc near
      push     ax
      push     cx
      push     dx
      xor      ch, ch
      lodsb
      mov      cl, al
ps_loop:
      lodsb
      mov      dl, al
      call     put_char_kb
      loop     ps_loop
      pop      dx
      pop      cx
      pop      ax
      ret
put_str_kb endp
;
; put_msg_kb :
;   Input :  CS:SI -- String (with the first byte as length)
;   Output:  (The string display on the screen)
;   Note :  CS:SI will point to the character immediately following
;           the string printed.
;
put_msg_kb proc near
      push     ax
      push     ds
      mov      ax, cs
      mov      ds, ax
      call     put_str_kb
      pop      ds
      pop      ax
      ret
put_msg_kb endp
;
; cur :
;   Input :  DL -- Repetition
;            DH -- Code
;   Output:  (Cursor more)
;
cur proc near
      pusha
      xor      cx, cx
      mov      cl, dl
cur_loop:
      mov      al, esc
      gifcall  dcondev, write, waitrdy
      mov      al, dh
      gifcall  dcondev, write, waitrdy
      loop     cur_loop
      popa
      ret
cur endp
;
; cur_down :
;   Input :  DL -- Repetition
;   Output:  (Cursor down)
;
cur_down proc near
      push     dx
      mov      dh, 'B'
      call     cur
      pop      dx
      ret
cur_down endp
;
; cur_up :
;   Input :  DL -- Repetition
;   Output:  (Cursor up)
;
cur_up proc near
      push     dx
      mov      dh, 'A'
      call     cur
      pop      dx
      ret
cur_up endp
;
; cur_fwd :
;   Input :  DL -- Repetition
;   Output:  (Cursor forward)
;
cur_fwd proc near
      push     dx
      mov      dh, 'C'
      call     cur
      pop      dx
      ret
cur_fwd endp
;
; cur_bck :
;   Input :  DL -- Repetition
;   Output:  (Cursor backward)
;
cur_bck proc near
      push     cx
      push     dx
      xor      cx, cx
      mov      cl, dl
      mov      dl, bck_spc
cur_bck_loop:
      call     put_char_kb
      loop     cur_bck_loop
      pop      dx
      pop      cx
      ret
cur_bck endp
;
; clr_eoln :
;   I/O :  No
;
clr_eoln proc near
      push     dx
      mov      dh, 'K'
      mov      dl, 1
      call     cur
      pop      dx
      ret
clr_eoln endp
;
; clr_scr :
;   I/O :  No
;
clr_scr proc near
      push     dx
      mov      dh, 'H'
      mov      dl, 1
      call     cur
      mov      dh, 'J'
      mov      dl, 1
      call     cur
      pop      dx
      ret
clr_scr endp
;
; crlf_ :
;   I/O :  No
;
crlf_ proc near
      push     dx
      mov      dl, cr
      call     put_char_kb
      mov      dl, lf
      call     put_char_kb
      pop      dx
      ret
crlf_ endp
;
; cr_ :
;   I/O :  No
;
cr_ proc near
      push     dx
      mov      dl, cr
      call     put_char_kb
      pop      dx
      ret
cr_ endp
;
; bell_ :
;   I/O :  No
;
bell_ proc near
      push     dx
      mov      dl, bell
      call     put_char_kb
      pop      dx
      ret
bell_ endp
;
; steal_char_port :
;   Input :  No
;   Output:  DL -- Character read
;
steal_char_port proc near
      push     ax
      push     bx
      gifcall  dtedev, read, waitrdy
      mov      dl, al
      pop      bx
      pop      ax
      ret
steal_char_port endp
;
; put_char_port :
;   Input :  DL -- Character to write
;   Output:  No
;
put_char_port proc near
      push     ax
      push     bx
      mov      al, dl
      gifcall  dtedev, write, waitrdy
      pop      bx
      pop      ax
      ret
put_char_port endp
;
; Send TYPE command to the host (Simulated)
;
;extrn host_type_msg:byte, cmd_tmn:abs
send_type proc near
; Ignore the incoming characters
      push     ax
;     push     si
skp_lp:
      call     steal_char_port
      jnz      skp_lp
;     mov      si, offset pgroup:host_type_msg
;     mov      ax, cs
;     mov      ds, ax
snd_cmd_lp:
;     lodsb
;     cmp      al, 0
;     je       snd_fn
;     mov      dl, al
;     call     put_char_port
;     jmp      snd_cmd_lp
snd_fn:
;     pop      si
;     mov      ax, es
;     mov      ds, ax
snd_fn_lp:
;     lodsb
;     cmp      al, cmd_tmn
;     je       snd_end
;     mov      dl, al
;     call     put_char_port
;     jmp      snd_fn_lp
snd_end:
;     mov      dl, cr
;     call     put_char_port
      pop      ax
      ret
send_type endp
;
; send_end :
;
send_end proc near
      push     ax
      push     cx
      mov      cx, send_null_count
se_lp:
      call     steal_char_port
      loop     se_lp
      pop      cx
      pop      ax
      ret
send_end endp
;
; read_file :
;   read the file from the host.
;   ES:DI points to the read buffer.  CX stores the number of bytes
;   ready to read, and returns the number of bytes not yet read.
;
read_file proc near
      push     ax
      push     dx
rd_lp:
      call     steal_char_port
      mov      al, dl
      stosb
      loop     rd_lp
      pop      dx
      pop      ax
      ret
read_file endp
;
; set_trap :
;    Set int-3 location to CS:DX
;
set_trap proc near
      push     ax
      push     es
      push     di
      xor      ax, ax
      mov      es, ax
      mov      di, trap_vector*4
      mov      ax, dx
      stosw
      mov      ax, cs
      stosw
      pop      di
      pop      es
      pop      ax
      ret
set_trap endp
;
; set_single :
;    Set int-1 location to CS:DX
;
set_single proc near
      push     ax
      push     es
      push     di
      xor      ax, ax
      mov      es, ax
      mov      di, 4
      mov      ax, dx
      stosw
      mov      ax, cs
      stosw
      pop      di
      pop      es
      pop      ax
      ret
set_single endp
;
; set_trace :
;   I/O :  No
;
set_trace proc near
      push     ax
      push     es
      push     di
      xor      ax, ax
      mov      es, ax
      mov      di, trace_vector*4
      mov      ax, dx
      stosw
      mov      ax, cs
      stosw
      pop      di
      pop      es
      pop      ax
      ret
set_trace endp
;
; Enable_int :
;
enable_int proc near
      push     ax
      push     dx
      mov      ax, trace_vector
      mov      dx, 0ff22h
      out      dx, ax
      xor      ax, ax
      mov      dx, 0ff3ah
      out      dx, ax
      pop      dx
      pop      ax
      ret
enable_int endp
;
; terminate :
;   I/O :  No
;
terminate proc near
      jmp      quit_point
terminate endp
;
;RAM_base dw 60h
;stack_seg dw 20h  ; Offset from RAM_base
;stack_ptr dw 100h  ; 128 word stack
;
prog ends
;
end
;

