/**
*
* This header file contains information needed to use the Terminal Independ-
* ence Package (TIP).  
*
*/


/**
*
* The following symbols define the various CP/M BIOS functions accessed
* by TIP.
*
*/
#ifdef CPM
#define KBSTAT 2	/* Get keyboard status */
#define KB 3		/* Get keyboard input */
#define CRT 4		/* Send CRT output */
#define PRINT 5		/* Send printer output */
#endif


/**
*
* The following symbols define various standard ASCII characters.
*
*/
#define BELL 7		/* Bell or buzzer */
#define BS 8		/* Backspace */
#define LF 10 		/* Line feed */
#define FF 12		/* Form feed */
#define CR 13		/* Carriage return */
#define ESC 27		/* Escape */
#define DEL 127		/* Delete */


/**
*
* The following symbols are pseudo-characters that generate various output
* control sequences when recognized by TIP's "tput" function.  To distinguish
* pseudo-characters from normal ASCII, each pseudo-character has its high
* bit set.
*
*/
#define TO_CS 0x80	/* Clear screen */
#define TO_MCH 0x81	/* Move cursor home */
#define TO_MCU 0x82	/* Move cursor up */
#define TO_MCD 0x83	/* Move cursor down */
#define TO_MCR 0x84	/* Move cursor right */
#define TO_MCL 0x85	/* Move cursor left */
#define TO_IL 0x86	/* Insert line */
#define TO_DL 0x87	/* Delete line */
#define TO_IC 0x88	/* Insert character */
#define TO_DC 0x89	/* Delete character */
#define TO_ERL 0x8a	/* Erase rest of line */
#define TO_ERS 0x8b	/* Erase rest of screen */
#define TO_BPM 0x8c	/* Begin protect mode */
#define TO_EPM 0x8d	/* End protect mode */
#define TO_BPF 0x8e	/* Begin protect field */
#define TO_EPF 0x8f	/* End protect field */

#define TO_VN 0xa0	/* Set video normal */
#define TO_VR 0xa1	/* Set video reverse */
#define TO_VNU 0xa2	/* Set video normal, underlined */
#define TO_VRU 0xa3	/* Set video reverse, underlined */
#define TO_VNF 0xa4	/* Set video normal, flashing */
#define TO_VRF 0xa5	/* Set video reverse, flashing */

#define TO_MC 0xf1	/* Move cursor to V-H coordinate */
#define TO_MCV 0xf2	/* Move cursor to V coordinate */
#define TO_ESC 0xff	/* Escape the next character */


/**
*
* The following symbols are various pseudo-characters returned by TIP's
* "tget" function when a control character or control sequence is trans-
* lated.
*
*/
#define TI_CAN 0x80	/* Cancel input line */
#define TI_MCH 0x81	/* Move cursor home */
#define TI_MCU 0x82	/* Move cursor up */
#define TI_MCD 0x83	/* Move cursor down */
#define TI_MCR 0x84	/* Move cursor right */
#define TI_MCL 0x85	/* Move cursor left */
#define TI_IL 0x86	/* Insert line */
#define TI_DL 0x87	/* Delete line */
#define TI_IC 0x88	/* Insert character */
#define TI_DC 0x89	/* Delete character */
#define TI_ERL 0x8a	/* erase rest of line */
#define TI_F0 0x90	/* Function 0 */
#define TI_F1 0x91	/* Function 1 */
#define TI_F2 0x92	/* Function 2 */
#define TI_F3 0x93	/* Function 3 */
#define TI_F4 0x94	/* Function 4 */
#define TI_F5 0x95	/* Function 5 */
#define TI_F6 0x96	/* Function 6 */
#define TI_F7 0x97	/* Function 7 */
#define TI_F8 0x98	/* Function 8 */
#define TI_F9 0x99	/* Function 9 */
#define TI_FA 0x9a	/* Function a */
#define TI_FB 0x9b	/* Function b */
#define TI_FC 0x9c	/* Function c */
#define TI_FD 0x9d	/* Function d */
#define TI_FE 0x9e	/* Function e */
#define TI_FF 0x9f	/* Function f */

/**
*
* The following structure is the Terminal Description Block (TDB) that
* contains the various translation tables and control sequences for a
* particular terminal.  
*
*/
struct TDB
{
byte ttype;		/* TDB type */
byte tflags;		/* Miscellaneous flags */
byte tcode[4];		/* Terminal code */
byte tname[24];		/* Terminal name (null-terminated) */
byte tvsize;		/* Vertical size (i.e. number of lines) */
byte thsize;		/* Horizontal size (i.e. number of columns) */
byte tvoff;		/* Vertical offset (added to V coordinate) */
byte thoff;		/* Horizontal offset (added to H coordinate) */

byte ticst[64][2];	/* Control sequence table */

byte tocst[64][5];	/* Output control sequence table */

byte toinit[10];	/* Initialization sequence */
byte toterm[10];	/* Termination sequence */

byte tomc[10];		/* Sequence to move cursor */
};

#define TDBSIZ sizeof(struct TDB) 	/* size of TDB in memory */
#define TDBMAX 512	/* maximum size of TDB block on disk */

/**
*
* The following symbols define the bits in TDB.tflags.
*
*/
#define TF_VSA 1	/* Set for visible state attributes.  This means that
			   a state command, such as TO_VR occupies a character
			   space.  
			*/

