TITLE	READ/WRITE -- DISK DRIVER

IF1
%OUT	PASS	1...
ELSE
%OUT	PASS	2...
ENDIF

DGROUP	GROUP	DATA
PGROUP	GROUP	PROG

%OUT	INCLUDING
INCLUDE	\SYSCON\SYSCON.EQU
INCLUDE	SRC\DDRIV.EQU
INCLUDE	SRC\SCBP.EQU
INCLUDE	\GIFI\SRC\GIFMAC.MAC
INCLUDE	\186\XINSTR.MAC

DATA	SEGMENT	WORD PUBLIC 'data'
	ASSUME	DS:DGROUP
	EXTRN	DMASLP:WORD, DMASUP:WORD, DMADLP:WORD, DMADUP:WORD
	EXTRN	DMACNT:WORD, DMACMD:WORD, DMALOC:WORD
	EXTRN	DOP:BYTE, DUNT:BYTE, DADR:WORD, DCNT:WORD, CNTEXD:WORD
	EXTRN	BYTEBUF:BYTE
	PUBLIC	SECSIZE
FLPMODE	DB	?
SECSIZE	DW	?
DATA	ENDS


%OUT	CODE	SEGMENT

	EXTRN	DDINIT:NEAR, FADDR:NEAR, NXTSEC:NEAR
	EXTRN	TASK:NEAR, FERR:NEAR, XERR:NEAR, MRSASI:NEAR
PROG	SEGMENT	BYTE PUBLIC 'prog'
	ASSUME	CS:PGROUP
	PUBLIC	DRD, DWR,FRDST


DRDWR	PROC	FAR

DRD:
	MOV	DOP, READ
	JMP	DRW
FRDST:
	MOV	FLPMODE,1		;FLAG PHYSICAL ACCESS MODE
	CALL	DRDWR
	MOV	FLPMODE,0		;CLEAR ACCESS FLAG
	RET


DWR:
	MOV	DOP, WRITE

DRW:
	PUSHA
	CALL	DDINIT
	JNC	RW5
	JMP	RWEXIT
RW5:
	CMP	DCNT, 0
	JNZ	RW8
	JMP	RWOK
RW8:
	TEST	FLPMODE,1
	JNZ	RWF1
	TEST	[BX.MEDIA], XBC_
	JZ	RWHD
RWF1:
	JMP	RWFLP


; HARD DISK READ/WRITE
RWHD:
	LEA	SI, [BX.CMDLEN]		; CBB (COMMAND BYTE BLOCK)
	LEA	DI, [BX.STSLEN]		; SBB (STATUS BYTE BLOCK)
	MOV	CL, [BX.CTRL]		; CONTROLLER
; DMA ADDRESSING
	MOV	AX, ES
	ROL	AX, 1
	ROL	AX, 1
	ROL	AX, 1
	ROL	AX, 1
	MOV	DX, AX
	AND	DX, 0FH
	AND	AL, 0F0H
	ADD	AX, DMALOC
	ADC	DL, DH
; READ/WRITE SECTORS
	CMP	DOP, WRITE
	JNE	HD4
; WRITE
	MOV	DMASLP, AX
	MOV	DMASUP, DX
	MOV	DMADLP, SASIDP
	MOV	DMADUP, 0
	MOV	DMACMD, DMACMDW
	MOV	BP, OFFSET DS:DMASLP
	MOV	CH, (DMAOUT OR DMANOB)	; NO REGISTER BUFFER INIT
	MOV	[BX.CB], XWRITE
	JMP	SHORT HD3
; READ
HD4:
	MOV	DMASLP, SASIDP
	MOV	DMASUP, 0
	MOV	DMADLP, AX
	MOV	DMADUP, DX
	MOV	DMACMD, DMACMDR
	MOV	BP, OFFSET DS:DMADLP
	MOV	CH, (DMAIN OR DMANOB)	; NO REGISTER BUFFER INIT
	MOV	[BX.CB], XREAD
HD3:
	MOV	BYTE PTR [DI], XBSTL
	MOV	AL, DUNT
	AND	AL, 0F8H		; UPPER 5 BITS
	OR	AL, [BX.DRV]
	ROR	AL, 1
	ROR	AL, 1
	ROR	AL, 1
	MOV	[BX.CB+1], AL		; LUN + HADR
	MOV	AX, DADR
	XCHG	AH, AL			; MADR + LADR
	MOV	WORD PTR [BX.CB+2], AX

; READ/WRITE LOOP
;	SECTOR & DMA ADDRESS ARE SET, BUT NOT DMA COUNT
HDLP:
	MOV	AX, DCNT
	OR	AL, AL
	JNZ	HD6			; IF ZERO, MAKE IT LARGEST
	DEC	AL
HD6:
	MOV	[BX.CBCNT], AL
	CMP	AL, SECSEG
	JBE	HD1
	MOV	AL, SECSEG
	MOV	[BX.CBCNT], AL
HD1:
; INIT DMA COUNT (SECTOR SIZE DEPENDENT)
	XOR	AH, AH
	SHLAX	SCSZSFT
	MOV	DMACNT, AX

; DS:SI - CBB; DS:DI - SBB; CH - DMA CODE; CL - CONTROLLER.
	CALL	TASK
	HDERRC	HDRWERR
; OK OPERATION
	XOR	DH, DH
	MOV	DL, [BX.CBCNT]
	JMP	HDADV
; ERROR OPERATION : ERROR SECTOR IN SBB
HDRWERR:
	PUSH	AX			; ERROR CODE
	MOV	DX, WORD PTR [BX.SB+2]
	XCHG	DH, DL
	MOV	AX, WORD PTR [BX.CB+2]
	XCHG	AH, AL
; AS BLOCK COUNT ALWAYS 16 BITS, SIMPLY SUBTRACTION IS OK
	SUB	DX, AX
	POP	AX
	CMP	AH, XBECC
	JE	HDERRCV
	CMP	AH, XBNOERR
	JNE	HDEAD

; ERROR RECOVERED
HDERRCV:
	INC	DX
	JMP	SHORT HDADV

; ERROR UNRECOVERABLE
HDEAD:
	SUB	DCNT, DX
	JMP	RWEXERR

; ADVANCE : DX - SECTORS TRANSFERRED (DH MUST BE ZERO)
HDADV:
	SUB	DCNT, DX
	JBE	RWOK
; ADVANCE SECTOR ADDRESS
	ADD	[BX.CB+3], DL
	ADC	[BX.CB+2], DH
	ADC	[BX.CB+1], 0
; ADVANCE DMA
; SECTOR SIZE DEPENDENT HERE - DMA POINTER WXYZ; (WXY SHL 1) <-- + AX
	SHL	DX, 1
	ADC	BYTE PTR DS:[BP+3], 0
	ADD	DS:[BP+1], DX
	ADC	BYTE PTR DS:[BP+3], 0
	JMP	HDLP
RWOK:
	MOV	AH, NOERR
	JMP	SHORT RWCOMPL

RWEXERR:
	OR	[BX.MEDIA], NOK
RWEXIT:
	MOV	BYTEBUF, AH
	POPA
	MOV	CX, DCNT
	ADD	CX, CNTEXD
	XOR	AH, AH
	XCHG	AH, BYTEBUF
	CMP	BYTEBUF, AH		; GENERATE CY IF NON-ZERO
	RET

RWCOMPL:
	CMP	CNTEXD, 0
	JE	RWEXIT
	CMP	AH, NOERR
	JNE	RWEXIT
	MOV	AH, NOSCTR
	JMP	RWEXERR


; FLOPPY DISKETTE READ/WRITE
RWFLP:
; SEEK TRACK
	MOV	CH, [BX.MEDIA]
	TEST	FLPMODE,1		; IF PHYSICAL ACCESS MODE
	JZ	NPF1
	MOV	AL,DH			; TRACK IN AL
	XOR	AH,AH
	SHR	DL,1			; SIDE SELECT IN AH
	RCL	AH,1
	JMP	SHORT PF1
NPF1:
	CALL	FADDR
PF1:
	LEA	SI, [BX.CMDLEN]		; CBB (COMMAND BYTE BLOCK)
	LEA	DI, [BX.STSLEN]		; SBB (STATUS BYTE BLOCK)
	MOV	CL, [BX.CTRL]		; CONTROLLER
	AND	[BX.CB], (DS0_ OR DS1_ OR SD_)
	OR	[BX.CB], AH
	MOV	[BX.CBSEC], DL
; ADJUST THE TRACK (IN AL)
	MOV	BYTEBUF, AL
	TEST	[BX.MEDIA], T40
	JZ	RW1
	SHL	AL, 1
RW1:
	CMP	AL, [BX.TRK]		; IF SAME TRACK
	JE	RW6			; SKIP SEEKING
	MOV	[BX.CBCMD], AL
	XCHG	AL, [BX.TRK]		; INCONSISTANT IF ERROR
	MOV	[BX.CBTRK], AL
; SET DEST TRACK
;	OR	[BX.CB], CT0
	MOV	BYTE PTR [DI], SL0
	MOV	CH, DMAOFF
	CALL	TASK
	FLPERRC	RWEXERR, 0
;
	AND	[BX.CB], NMASK
	OR	[BX.CB], (CT3 OR NMCMD)
	MOV	[BX.CBCMD], FSEEK
	MOV	BYTE PTR [DI], SL3
	CALL	TASK			; SEEK
	FLPERRC	RWEXERR, 1

RW6:
	MOV	AX, ES
	ROL	AX, 1
	ROL	AX, 1
	ROL	AX, 1
	ROL	AX, 1
	MOV	DX, AX
	AND	DX, 0FH
	AND	AL, 0F0H
	ADD	AX, DMALOC
	ADC	DL, DH
; READ/WRITE SECTORS
	AND	[BX.CB], NMASK
	CMP	DOP, WRITE
	JNE	RW2
; WRITE
	MOV	DMASLP, AX
	MOV	DMASUP, DX
	MOV	DMADLP, SASIDP
	MOV	DMADUP, 0
	MOV	DMACMD, DMACMDW
	MOV	BP, OFFSET DS:DMASLP
	MOV	CH, (DMAOUT OR DMANOB)	; NO REGISTER BUFFER INIT
	OR	[BX.CB], CT2
	MOV	[BX.CBCMD], FWRITES
	JMP	SHORT RW3
; READ
RW2:
	MOV	DMASLP, SASIDP
	MOV	DMASUP, 0
	MOV	DMADLP, AX
	MOV	DMADUP, DX
	MOV	DMACMD, DMACMDR
	MOV	BP, OFFSET DS:DMADLP
	MOV	CH, (DMAIN OR DMANOB)	; NO REGISTER BUFFER INIT
	OR	[BX.CB], CT3
	MOV	[BX.CBCMD], FREADS
RW3:
	MOV	BYTE PTR [DI], SL3
	MOV	DMACNT,AX
	MOV	AX,SECSIZE
	XCHG	DMACNT,AX
	MOV	AL, BYTEBUF
	MOV	[BX.CBTRK], AL

; DS:SI - CBB; DS:DI - SBB; CH - DMA CODE; CL - CONTROLLER.
RWLP:
	CALL	TASK
	FLPERRC	RWEXERR
; OK OPERATION
	DEC	DCNT
	JA	RWADVDMA
	MOV	AH, NOERR
	JMP	RWCOMPL
RWADVDMA:
; ADVANCE DMA POINTER
	ADD	DS:[BP], SCSZ
	ADC	WORD PTR DS:[BP+2], 0
; ADVANCE SECTOR
	CALL	NXTSEC
	JNC	RWLP
; ADVANCE TRACK
	PUSH	WORD PTR [BX.CB]
	PUSH	WORD PTR [BX.CB+2]
	PUSH	WORD PTR [BX.SB]
	PUSH	CX
	AND	[BX.CB], NMASK
;	OR	[BX.CB], CT0
	MOV	AL, [BX.TRK]
	MOV	[BX.CBTRK], AL
	TEST	[BX.MEDIA], T40
	JZ	RWADV1
; 40 TRACK - SEEK NEXT 2 TRACK
	INC	AL
RWADV1:
	INC	AL
	MOV	[BX.CBCMD], AL
	MOV	[BX.TRK], AL
	MOV	BYTE PTR [DI], SL0
	MOV	CH, DMAOFF
	CALL	TASK
	FLPERRC	RWADVED
;	AND	[BX.CB], NMASK
	OR	[BX.CB], (CT3 OR NMCMD)
	MOV	[BX.CBCMD], FSEEK
	MOV	BYTE PTR [DI], SL3
	CALL	TASK
	FLPERRC	, 0
RWADVED:
	POP	CX
	POP	WORD PTR [BX.SB]
	POP	WORD PTR [BX.CB+2]
	POP	WORD PTR [BX.CB]
	JNC	RW7
	JMP	RWEXERR
RW7:
	JMP	RWLP

DRDWR	ENDP


PROG	ENDS

END
