TITLE	ROUTINES -- DISK DRIVER

IF1
%OUT	PASS	1...
ELSE
%OUT	PASS	2...
ENDIF

PGROUP	GROUP	PROG
DGROUP	GROUP	DATA

%OUT	INCLUDING

INCLUDE	\SYSCON\SYSCON.EQU
INCLUDE	SRC\SCBP.EQU
INCLUDE	SRC\UTIL.MAC
INCLUDE	SRC\DDRIV.EQU
INCLUDE	\GIFI\SRC\GIFMAC.MAC
INCLUDE	\186\XINSTR.MAC



SHLBX	MACRO	CNT
	DB	0C1H, 0E3H, CNT
ENDM


;
; DATA SEGMENT
;

DATA	SEGMENT	WORD PUBLIC 'data'
	ASSUME	DS:DGROUP
	EXTRN	DDFLG:BYTE, DOP:BYTE, DADR:WORD, DUNT:BYTE, DCNT:WORD
	EXTRN	CNTEXD:WORD
	EXTRN	DDBLOC:WORD, DDB:BYTE, CBB:BYTE, SBB:BYTE, MAXDRV:BYTE
	EXTRN	DMALOC:WORD, DMACBUF:WORD, DMACMD:WORD, DMACNT:WORD
	EXTRN	DMASLP:WORD, DMASUP:WORD, DMADLP:WORD, DMADUP:WORD
	EXTRN	XBICTAB:BYTE
DATA	ENDS


%OUT	CODE	SEGMENT

;
; CODE SEGMENT
;

PROG	SEGMENT	BYTE PUBLIC 'prog'
	ASSUME	CS:PGROUP
	EXTRN	WRCON:NEAR, WRMSG:NEAR, PRBYTE:NEAR, MRSASI:NEAR
	EXTRN	INIDMA:NEAR, OUTCMD:NEAR, OUTDAT:NEAR, INSTAT:NEAR
	EXTRN	WAITZR:NEAR
	PUBLIC	DDINIT, DDBINIT, TASK, FADDR, NXTSEC, FERR, XERR, XBINIT


; DISK DRIVER INIT (FROM GIFDIC TO DUNT, DADR, DCNT, AND DDBLOC)
;	<ECY>
DDINIT	PROC
	CMP	AL, MAXDRV
	JB	DI1
; NOT READY
	MOV	AH, ILLDEV
	STC
	JMP	DIEXIT
DI1:
	MOV	DMALOC, DI
	MOV	DUNT, AL		; UPPER 5 BITS IS HIGHEST DADR
; LOCATE THE DDB
	AND	AX, 7			; 3 BIT UNIT # ONLY
	SHLAX	DDBSZ2
	ADD	AX, OFFSET DS:DDB
	MOV	DDBLOC, AX
; SAVE OPCODE
	MOV	BX, AX
	TEST	[BX.MEDIA], NOK
	JZ	DI2
; NOT OK (NOT RESET AFTER ERROR)
	MOV	AH, DEAD
	STC
	JMP	DIEXIT
DI2:
; EXCEED MAP ?
	MOV	CNTEXD, 0
	MOV	AH, DUNT
	SHRAH	3
	PUSH	AX
	PUSH	DX
	ADD	DX, CX
	ADC	AH, 0
	SUB	DX, WORD PTR [BX.IMGSIZE]
	JNE	DI4
	CMP	AH, [BX.IMGSIZE+2]
	JE	DI3
DI4:
	SBB	AH, [BX.IMGSIZE+2]
	JB	DI3
; EXCEED
	SUB	CX, DX
	JG	DI5
; STARTING ALREADY EXCEED
	ADD	DX, CX
	XOR	CX, CX
DI5:
	MOV	CNTEXD, DX
DI3:
	POP	DX
	POP	AX
;
	MOV	DCNT, CX
	ADD	DX, WORD PTR [BX.STRTSEC]
	ADC	AH, [BX.STRTSEC+2]
	MOV	DADR, DX
	SHLAH	3
	AND	DUNT, 7
	OR	DUNT, AH
	MOV	AH, NOERR
	CLC
DIEXIT:
	RET
DDINIT	ENDP


; DDB INIT - LOCATE DDB POINTER IN BX
;	<ECY>
DDBINIT	PROC
	CMP	AL, MAXDRV
	JB	DB1
; NOT READY
	MOV	AH, ILLDEV
	STC
	JMP	DBEXIT
DB1:
; LOCATE THE DDB
	PUSH	AX
	AND	AX, 7			; 3 BITS ONLY
	SHLAX	DDBSZ2
	MOV	BX, AX
	ADD	BX, OFFSET DS:DDB
	MOV	DDBLOC, BX
	POP	AX
	MOV	AH, NOERR
	CLC
DBEXIT:
	RET
DDBINIT	ENDP


; PERFORM THE TASK IN CBB POINTED TO BY DS:SI IN CONTROLLER CL;
;	ENABLE DMA WHEN NECESSARY; AND GET STATUS INTO SBB POINTED
;	TO BY DS:DI. <ECYI>
;	DESTROYED : AX, DX
TASK	PROC
	PUSH	BX
	PUSH	CX

	MOV	AL, CH			; SAVE THE DMA CONTROL CODE
	AND	CH, (NOT DMANOB)
	TEST	AL, DMANOB		; IF NO DMA CONTROL BYTES OUTPUT
	JNZ	TK2
	CMP	CH, DMAOFF
	JE	TK1
; DMA ADDRESSING
	MOV	AX, ES
	ROL	AX, 1
	ROL	AX, 1
	ROL	AX, 1
	ROL	AX, 1
	MOV	DX, AX
	AND	DX, 0FH
	AND	AL, 0F0H
	ADD	BX, AX
	ADC	DL, DH

	CMP	CH, DMAOUT
	JE	TKDOUT
; DMA IN
	MOV	DMADLP, BX
	MOV	DMADUP, DX
	MOV	DMASLP, SASIDP
	MOV	DMASUP, 0
	MOV	DMACMD, DMACMDR
	JMP	SHORT TK2
; DMA OUT
TKDOUT:
	MOV	DMASLP, BX
	MOV	DMASUP, DX
	MOV	DMADLP, SASIDP
	MOV	DMADUP, 0
	MOV	DMACMD, DMACMDW
TK2:
	PUSH	CX
	MOV	CX, 6
	LEA	BX, DMACBUF
	CALL	INIDMA
	POP	CX
TK1:
	CMP	CH, DMAOFF
	JE	TK3
;
	TESTSKP	TK3
	PUSH	SI
	CMP	CH, DMAOUT
	JE	TK4
	PRINT	' RDDMA'
	JMP	SHORT TK5
TK4:
	PRINT	' WRDMA'
TK5:
	POP	SI
TK3:
;
	MOV	CH, [SI]
	MOV	BX, SI
	INC	BX
	CALL	OUTCMD			; CL IS THE CONTROLLER
	JNC	TK6
; INTERNAL ERROR
	CMP	AH, NOCTRLR
	JNE	TK7
; CONTROLLER UNSELECTABLE
	XOR	BX, BX
	MOV	BL, CL
	SHLBX	XBICSFT
	MOV	WORD PTR XBICTAB[BX], -1; MARK IT NON-EXISTING
TK7:
	PUSH	AX
	CALL	MRSASI
	POP	AX
	STC
	JMP	SHORT TKEXIT
TK6:
;
	MOV	CH, [DI]
	MOV	BX, DI
	INC	BX
	CALL	INSTAT
	JC	TK7

TKEXIT:
	POP	CX
	POP	BX
	RET
TASK	ENDP


; CONVERT LOGICAL SECTOR IN DX WITH MEDIA CH INTO TRACK AL,
;	SECTOR DL, AND SS1_ IN AH
;	DESTROYED : CX
FADDR	PROC
	MOV	CL, SCMX
	TEST	CH, SC8
	JZ	FASC9
; 8 SECTORS
	MOV	CL, SCMN
; 9 SECTORS
FASC9:
	MOV	AX, DX
; AX - LOGICAL SECTOR
	DIV	CL
	INC	AH
	MOV	DL, AH
; AL - LOGICAL TRACK
	MOV	AH, SS1_
	TEST	CH, HD2
	JZ	FAHD1
; 2 HEADS
	SHR	AL, 1
	JNC	FAHD1
	XOR	AH, AH
FAHD1:

	RET
FADDR	ENDP


; ADVANCE THE TRK+HEAD+SECTOR
;	(CY TO SIGNIFY PHYSICAL TRACK ADVANCED)
NXTSEC	PROC
	MOV	AL, SCMX
	TEST	[BX.MEDIA], SC8
	JZ	NSC9
	MOV	AL, SCMN
NSC9:
	INC	[BX.CBSEC]
	CMP	[BX.CBSEC], AL
	JA	NS1
; SAME TRACK
	CLC
	JMP	SHORT NSEXIT
NS1:
; NEXT TRACK
	MOV	[BX.CBSEC], 1
	TEST	[BX.MEDIA], HD2
	JZ	NSTK
; DOUBLE HEAD
	XOR	[BX.CB], SS1_
	TEST	[BX.CB], SS1_
	CLC
	JZ	NSEXIT			; HEAD 1 - NO TRACK ADVANCING
; INCREASE TRACK
NSTK:
	INC	[BX.CBTRK]
	STC
NSEXIT:
	RET
NXTSEC	ENDP


; INIT XEBEC CONTROLLER IN CL WITH CHAR. IN [DS:SI]
;	DESTROYED : AX, CH, DX
XBINIT	PROC
	PUSH	BX
	MOV	CH, HCMDL
	MOV	BX, OFFSET DS:CBB
	MOV	BYTE PTR [BX], XIDC
	CALL	OUTCMD
	JC	XIEXIT
; OUTPUT CHARACTER BYTE
	MOV	CH, XBICLEN
	MOV	BX, SI
; WAIT FOR DATA TRANSFER
	WAIT	RQ_, ZR
	CALL	OUTDAT
; INPUT STATUS
	MOV	CH, XBSTL
	MOV	BX, OFFSET DS:SBB
	CALL	INSTAT
	JC	XIEXIT
; CHECK STATUS
	XOR	AH, AH
	TEST	BYTE PTR [BX], HDERR
	CLC
	JZ	XIEXIT
; FAIL
	MOV	AH, XBIERR
	STC

XIEXIT:
	POP	BX
	RET
XBINIT	ENDP


; FLOPPY CONTROLLER STATUS CHECK
FERR	PROC
	MOV	AL, [BX.SB]
	TEST	AL, FRNF
	JZ	NRNF
	MOV	AH, NOSCTR		; SECTOR NOT FOUND
	JMP	SHORT FEXIT
NRNF:
	TEST	AL, FCRC
	JZ	NCRC
	MOV	AH, CRCERR		; CRC ERROR
	JMP	SHORT FEXIT
NCRC:
; LOST DATA
	CMP	DOP, READ
	JNE	NRDFLT
	MOV	AH, RDFLT		; READ FAULT
	JMP	SHORT FEXIT
NRDFLT:
	CMP	DOP, WRITE
	JNE	NWRFLT
	TEST	AL, FWP
	JZ	NWP
	MOV	AH, WRPRT
	JMP	SHORT FEXIT
NWP:
	MOV	AH, WRFLT		; WRITE FAULT
	JMP	SHORT FEXIT
NWRFLT:
	MOV	AH, DEAD		; GENERAL FAILURE
FEXIT:
	STC
	RET
FERR	ENDP


; XEBEC CONTROLLER STATUS CHECK
XERR	PROC
	PUSH	CX
; SENSE STATUS
	MOV	AH, [BX.CB+1]
	MOV	AL, XRSS
	MOV	WORD PTR CBB, AX
	MOV	CH, HCMDL
	MOV	BX, OFFSET DS:CBB
	CALL	OUTCMD
	JNC	XE1
	CMP	AH, TMOUT
	MOV	AH, DEAD
	JNE	XE2
	MOV	AH, TIMOUT
	JMP	SHORT XE2
XE1:
; GET ERROR STATUS BYTE
	TESTMSG	<CR, LF, 'XEBEC ERROR:'>
	MOV	CX, XBESTL
	LEA	BX, [DI+1]
	WAIT	RQ_, ZR
	JC	XE5
	MOV	DX, SASIDP
XELP:
	IN	AL, DX
	MOV	[BX], AL
	INC	BX
	TESTSKP	XE3
	CALL	PRBYTE
	MOV	AL, BSPR
	CALL	WRCON
XE3:
	LOOP	XELP
; STATUS FOR SENSE OPERATION
	MOV	CH, XBSTL
	MOV	BX, OFFSET DS:SBB
	CALL	INSTAT
	JNC	XE4
XE5:
	CMP	AH, TMOUT
	MOV	AH, DEAD
	JNE	XE2
	MOV	AH, TIMOUT
	JMP	XE2
XE4:
	MOV	AH, [DI+1]
XE2:
	STC
	MOV	BX, DDBLOC
	POP	CX
	RET
XERR	ENDP


PROG	ENDS

END

N

