TITLE	UTILITIES -- DISK DRIVER

; PLEASE SEARCH FOR "REMARK" FOR INFORMATION

IF1
%OUT	PASS	1...
ELSE
%OUT	PASS	2...
ENDIF

PGROUP	GROUP	PROG
DGROUP	GROUP	DATA

%OUT	INCLUDING

INCLUDE	\186\XINSTR.MAC
INCLUDE	SRC\UTIL.MAC
INCLUDE	SRC\SCBP.EQU
INCLUDE	SRC\DDRIV.EQU
INCLUDE	\GIFI\SRC\GIFMAC.MAC
INCLUDE	\SYSCON\SYSCON.EQU


ONSCRN	EQU	0			; MESSAGE DIRECTLY ON SCREEN

; GO TO SASI INTERRUPT WITH SERVICE ROUTINE SPECIFIED
;
GOINT	MACRO	INTRTN
	MOV	SASISVC, OFFSET CS:INTRTN
	CALL	WAITINT
ENDM


;
; DATA SEGMENT
;

DATA	SEGMENT	WORD PUBLIC 'data'
	ASSUME	DS:DGROUP
	PUBLIC	DDWAIT,DDSTART
	EXTRN	DELTAB:WORD
DDWAIT	DD	?			;ROUTINE ADDRESS WAIT ROUTINE
DDSTART	DD	?			;ROUTINE ADDRESS START ROUTINE

DDDSTR	LABEL	BYTE
PUBLIC	DDDSTR

DDFLG	DB	?			; DISK DRIVER FLAGS
ERRNR	DB	?			; SERIOUS ERROR NUMBER
PUBLIC	DDFLG

; GET/SET FUNCTION TABLE
DGFTAB	DW	MXNGS DUP (?)
DSFTAB	DW	MXNSS DUP (?)
PUBLIC	DGFTAB,	DSFTAB

; SASI INTERRUPT SERVICE ROUTINE POINTER
	PUBLIC	SASISVC
SASISVC	DW	?

; SASI SERVICE PARAMETERS
SASIBUF	LABEL	DWORD
SBLOC	DW	?
SBSEG	DW	?
SBCNT	DB	?

MAXDRV	DB	?			; MAXIMUM LOGICAL DRIVER #
BYTEBUF	DB	?			; BYTE BUFFER
BOOTDRV	DB	?			; BOOT DRIVE
DRIVLOG	LABEL	WORD			; DRIVE LOG
HDLOG	DB	?
FPLOG	DB	?
DUMPHD	DW	?			; DUMP DISPLAY HANDLE
PUBLIC	MAXDRV,	BYTEBUF, BOOTDRV, DRIVLOG, HDLOG, FPLOG, DUMPHD

DOP	DB	?			; DISK OPCODE
DUNT	DB	?			; DISK LOGICAL UNIT
DCNT	DW	?			; DISK COUNT
DADR	DW	?			; DISK ADDRESS
CNTEXD	DW	?			; DISK COUNT EXCEED
DMALOC	DW	?			; DMA TRANSFER BUFFER LOCATION
DDBLOC	DW	?			; DDB LOCATION
PUBLIC	DOP,	DUNT, DCNT, DADR, CNTEXD, DMALOC, DDBLOC

EVEN
DMACBUF	LABEL	WORD
DMASLP	DW	?
DMASUP	DW	?
DMADLP	DW	?
DMADUP	DW	?
DMACNT	DW	?
DMACMD	DW	?
PUBLIC	DMACBUF, DMASLP, DMASUP, DMADLP, DMADUP, DMACNT, DMACMD

; COMMON CBB AND SBB
;
CBB	DB	7 DUP (?)
SBB	DB	5 DUP (?)
PUBLIC	CBB,	SBB

; XEBEC CONTROLLER TABLE
;
XBICTAB	DB	NUMLDRV*XBICLEN DUP (?)
PUBLIC	XBICTAB

; DISK DATA BLOCK
;
DDB	DB	NUMLDRV*(SIZE DDBS) DUP (?)
PUBLIC	DDB

; MEDIA INFORMATION
;
MEDCNT	DB	5
FLPMEDS	LABEL	BYTE			;	   MED	 SIDE	SEC	TRK
	DB	(XBC_ OR HD2)		; COLEX	   11	 2	9	80
	DB	(XBC_ OR T40 OR HD2)	; IBM 2.0  15	 2	9	40
	DB	(XBC_ OR T40 OR HD2 OR SC8); IBM 1.1  17	 2	8	40
	DB	(XBC_ OR T40)		; IBM 2.0  14	 1	9	40
	DB	(XBC_ OR T40 OR SC8)	; IBM 1.1  16	 1	8	40
PUBLIC	MEDCNT,	FLPMEDS

EVEN
DDDEND	LABEL	BYTE
PUBLIC	DDDEND

; GIFDIC TABLE
GIFDICTABLE DW	GIFDICJMP
GIFDICJMP DD	10H DUP (?)
PUBLIC	GIFDICTABLE, GIFDICJMP


; SECTOR BUFFER
SECBUF	DB	SCSZ DUP (?)
PUBLIC	SECBUF

DATA	ENDS


IF	ONSCRN
PROMSEG	SEGMENT	AT 0FC80H
	ORG	1E45H
WRCON_	LABEL	FAR
PROMSEG	ENDS
ENDIF


%OUT	CODE	SEGMENT

;
; CODE SEGMENT
;

PROG	SEGMENT	BYTE PUBLIC 'prog'
	ASSUME	CS:PGROUP
	EXTRN	DATSEG:WORD, GIFDIC:FAR
	PUBLIC	WRCON, WRMSG, PRDGT, PRBYTE, PRWORD,SNDB,WAITINT
	PUBLIC	RSASI, SEL, INIDMA, OUTCMD, OUTDAT, INSTAT, ERRTN, SASINT


; COMMON UTILITIES PATCHING
IF	ONSCRN
WRCON:
	PUSHA
	CALL	WRCON_
	POPA
	RET
ELSE
; REMARK :
; WRCON PROCEDURE SHOULD BE REPLACED BY GIFDIC WRITE CONSOLE CALL.
;	SAVE EVERY REGISTER EXCEPT AX.
WRCON:
	PUSH	DS
	PUSHA
	MOV	DS, CS:DATSEG
	MOV	BX, 12*64+WRITE*4
	MOV	AH, 2
	CALL	GIFDIC
	POPA
	POP	DS
	RET
ENDIF

WRMSG_PROC
PRWORD_PROC


;
; BASIC UTILITIES
;

; WAIT UNTIL AH AND SASISP IS ZERO
;	DESTROYED : AL, DX
WAITZR	PROC
;	PUSH	CX
;	MOV	CX, TMOCNT
	MOV	DX, SASISP
WTZRLP:
	IN	AL, DX
	TEST	AL, AH
	CLC
	JNZ	WTZRLP
;	LOOP	WTZRLP
;	MOV	AH, TMOUT
;	STC
WTZREX:
;	POP	CX
	RET
WAITZR	ENDP
PUBLIC	WAITZR


; WAIT UNTIL AH AND SASISP IS NON-ZERO
;	DESTROYED : AL, DX
WAITNZ	PROC
;	PUSH	CX
;	MOV	CX, TMOCNT
	MOV	DX, SASISP
WTNZLP:
	IN	AL, DX
	TEST	AL, AH
	CLC
	JZ	WTNZLP
;	LOOP	WTNZLP
;	MOV	AH, TMOUT
;	STC
WTNZEX:
;	POP	CX
	RET
WAITNZ	ENDP
PUBLIC	WAITNZ


; SASI INTERRUPT (CRQINT) SERVICE ROUTINE

SASINT	PROC
	PUSHA
	OUTPUT	INT3RG, INT3MD
	STI
	PUSH	ES
	PUSH	DS
	MOV	AX, CS:DATSEG
	MOV	DS, AX
	TEST	DDFLG, SINT
	JZ	SI3
	ERROR	ILLINT
	JMP	SHORT SIEXIT
SI3:
	TESTMSG	' SASINT:'
	INPUT	SASISP, B
	XOR	AL, DDFLG
	TEST	AL, I_O
	JZ	SI1
	ERROR	DIRERR
	JMP	SHORT SI2
; DIRECTION OK
SI1:
	CALL	[SASISVC]
SI2:
	SET	DDFLG, SINT
	CALL	DWORD PTR DS:DDSTART	;START DISK HANDLER AGAIN
SIEXIT:
	POP	DS
	POP	ES
	OUTPUT	EOIRG, INT3VC
	POPA
	IRET
SASINT	ENDP


; WAIT FOR INTERRUPT
;	DESTROYED : AX, DX
WAITINT	PROC
	TESTMSG	' WAITINT'
	MOV	[DELTAB+2],TMOCNT	;SETUP TIMEOUT COUNTER
	RES	DDFLG, SINT
	OUTPUT	INT3RG, <INT3MD AND INT3MSK>
; ALWAYS NC AFTER TEST
	TEST	DDFLG, SINT
	JNZ	WIEXIT
; TIME OUT CHECK HERE
WILP:
	CALL	DWORD PTR DS:DDWAIT	;WAIT FOR INTERUPT
	JB	WILP1			;IF TIMOUT BY RMX
	TEST	DDFLG,SINT		;IF SERVICED
	JNZ	WIEXIT			;EXIT
	CMP	[DELTAB+2],0		;LOOP UNTIL READY OR TIMEOUT
	JNZ	WILP
WILP1:
	TEST	DDFLG,NOTMO		;IF TIMEOUT DISABLED
	JNZ	WILP			;LOOP FOREVER
; TIME OUT
	SET	DDFLG, SINT
	MOV	ERRNR, TMOUT
	STC
WIEXIT:
	RET
WAITINT	ENDP


; RESET SASI
;	DESTROYED : AX, CX, DX
RSASI	PROC
	TESTMSG	<CR, LF, 'RSASI'>
	OUTPUT	SASIRST, 1
	INPUT	SASIDP			; HARDWARE TRICK -- RESET U69 IN SASI
	OUTPUT	SASIRST, 0
	OUTPUT	INT3RG, INT3MD
	MOV	CX, 1000H
RSWTLP:
	STI
	NOP
	LOOP	RSWTLP
	RET
RSASI	ENDP


; SELECT THE CONTROLLER IN CL
;	DESTROYED : AL, DX <ECYI>
SEL	PROC
	TESTSKP	SE2
	PUSH	SI
	PRINT	' SEL '
	MOV	AL, CL
	CALL	PRDGT
	POP	SI
SE2:
	MOV	DX, SASISP
; TIME-OUT CHECK HERE
	PUSH	CX
	MOV	CX, SLTMOUT
SEBSEP:
	IN	AL, DX
	TEST	AL, BUSY_
	JNZ	SE3
	LOOP	SEBSEP
	POP	CX
	MOV	AH, TMOUT
	STC
	JMP	SHORT SEEXIT
SE3:
	POP	CX
; BUSY REMOVED
;	OUTPUT	PACSR,PACSV+3	; INSERT WAIT STATES
	MOV	DX, SASISEL
	MOV	AX, 101H		; AH <- 1; AL <- 1
	SHL	AH, CL			; AH : CONTROLLER #
; NO INTERRUPT (STABLIZE THE DATA BUS)
	CLI
	OUT	DX, AL
	OUTPUT	SASIDP, AH, B
	OUTPUT	SASISEL, 0, B
	STI
;	OUTPUT	PACSR,PACSV	; DISABLE WAIT STATES
; INTERRUPT ENABLED AGAIN
	TSTPORT	SASISP, BUSY_, B
	CLC
	MOV	AH, NOERR
	JZ	SEEXIT
	MOV	AH,NOCTRLR
	STC
;	ERROR	NOCTRLR
SEEXIT:
	RET
SEL	ENDP


; OUTPUT CH COMMAND BYTES IN [DS:BX] TO SASI CONTROLLER CL
;	DESTROYED : AL, DX <ECYI>
OUTCMD	PROC
	TESTMSG	<CR, LF, 'OUTCMD'>
	MOV	ERRNR, 0
	CALL	SEL
	JC	OCEXIT
; SELECTED
	PUSH	DS
	MOV	DX, DS
	MOV	AX, CS:DATSEG
	MOV	DS, AX
	MOV	SBSEG, DX
	MOV	SBLOC, BX
	MOV	SBCNT, CH
	SET	DDFLG, I_O
	GOINT	SNDB
	PASSERR
	POP	DS
OCEXIT:
	RET
OUTCMD	ENDP


; SEND COMMAND BYTES IN SB (SASI BUFFER)
SNDB	PROC
	XOR	CH, CH
	MOV	CL, SBCNT
	PUSH	DS
	LDS	SI, SASIBUF
	MOV	DX, SASIDP
SBLP:
	LODSB
	OUT	DX, AL
	TESTSKP	SB1
	CALL	PRBYTE
	MOV	AL, BSPR
	CALL	WRCON
SB1:
	LOOP	SBLP
	POP	DS
	RET
SNDB	ENDP


; INPUT CH STATUS BYTES FROM SASI CONTROLLER SELECTED INTO [DS:BX]
;	DESTROYED : AL, DX <ECYI>
INSTAT	PROC
	TESTMSG	<CR, LF, 'INSTAT'>
	PUSH	DS
	MOV	DX, DS
	MOV	DS, CS:DATSEG
	MOV	SBSEG, DX
	MOV	SBLOC, BX
	MOV	SBCNT, CH
	RES	DDFLG, I_O
	GOINT	RCVB
	PASSERR
	POP	DS
	RET
INSTAT	ENDP


; RECEIVE STATUS BYTES IN SB (SASI BUFFER)
RCVB	PROC
	OUTPUT	DMACTRL, DMASTOP
	PUSH	ES
	LES	DI, SASIBUF
; GET THE FIRST BYTE
RB0:
	INPUT	SASIDP
	STOSB
	TESTSKP	RB1
	CALL	PRBYTE
	MOV	AL, BSPR
	CALL	WRCON
RB1:
	DEC	SBCNT
	JZ	IS1
	WAIT	RQ_,ZR
	JMP	RB0
IS1:
	POP	ES
	RET
RCVB	ENDP


; OUTPUT CH BYTES FROM [DS:BX] TO SASI DATA PORT
;	DESTROYED : AX, DX, SI
OUTDAT	PROC
	TESTMSG	<CR, LF, 'OUTDAT '>
	PUSH	CX
	MOV	CL, CH
	XOR	CH, CH
	MOV	SI, BX
	MOV	DX, SASIDP
ODLP:
	LODSB
	OUT	DX, AL
	TESTSKP	OD1
	CALL	PRBYTE
	MOV	AL, BSPR
	CALL	WRCON
OD1:
	LOOP	ODLP
	POP	CX
	RET
OUTDAT	ENDP


; INIT DMA CH0 CONTROL BLOCK FOR CX BYTES IN [DS:BX]
;	DESTROYED : BX, CX, DX
INIDMA	PROC
	TESTMSG	<CR, LF, 'INIDMA:'>
	XCHG	SI, BX
	MOV	DX, DMACB
IDLP:
	OUTSW
	TESTSKP	ID1
	PUSH	AX
	MOV	AX, [SI-2]
	CALL	PRWORD
	MOV	AL, BSPR
	CALL	WRCON
	POP	AX
ID1:
	ADD	DX, 2
	LOOP	IDLP
	MOV	SI, BX
	RET
INIDMA	ENDP



ERRTN	PROC
	PUSHA
	PUSH	DS
	MOV	ERRNR, AL
	MOV	BL, AL
	XOR	BH, BH
	MOV	AX, CS
	MOV	DS, AX
	ASSUME	DS:PGROUP
	PRINT	<CR, LF, '*** Serious Error : '>
	DEC	BX
	SHL	BX, 1
	MOV	SI, ERRMSG[BX]
	MOV	CX, ERRMSG[BX+2]
	SUB	CX, SI
	CALL	WRSTR
	POP	DS
	POPA
	STC
	RET
ERRTN	ENDP





ERRMSG	LABEL	WORD
DW	PGROUP:TMOUTMSG			; ERR 1
DW	PGROUP:DIRERRMSG		; ERR 2
DW	PGROUP:NOCTRLRMSG		; ERR 3
DW	PGROUP:ILLINTMSG		; ERR 4
DW	PGROUP:XBIERRMSG		; ERR 5
DW	PGROUP:ERRMEND

TMOUTMSG DB	'Time out'
DIRERRMSG DB	'SASI Transfer direction error'
NOCTRLRMSG DB	'Controller unselectable'
ILLINTMSG DB	'Illegal SASINT'
XBIERRMSG DB	'XEBEC Init fail'
ERRMEND	LABEL	NEAR

PROG	ENDS

END
I



