	NAME	GIFINT
	TITLE	GIFDIC HANDLER,TABLES,SYSDEV HANDLER
;
	INCLUDE	\GIFI\SRC\GIFMAC.MAC
	INCLUDE	\186\MPROC.MAC
	INCLUDE	\186\XINSTR.MAC
	INCLUDE	\GIFI\SRC\IDAT.EQU
	.LALL
	EXTRN	MSITABL:ABS
	PUBLIC	DEVCNT
DEVCNT	EQU	16			;N DEVICES
SYSINTV	EQU	99H			;INTERUPT# SYSINIT
FRAMEC	EQU	1
;
;

GS	STRUC				;FRAME STRUCTURE GIFDIC HANDLER
RETADR	DD	?
GBP	DW	?
GDI	DW	?
GES	DW	?
GDX	DW	?
GCX	DW	?
GBX	DW	?
GAX	DW	?
GS	ENDS

PGROUP	GROUP	PROG
DGROUP	GROUP	DATA
	ASSUME	CS:PGROUP,DS:DGROUP
;
;
;
PROG	SEGMENT	WORD PUBLIC 'PROG'
;
	EXTRN	DEVTAB:NEAR,TSTSUPB:FAR,RDSUPB:FAR
	EXTRN	DATSEG:WORD,LINKSH:FAR,ULINKSH:FAR
;
	.LIST
;
X	PROC	FAR			;FLAG ILLEGAL FUNTION CALL
	MOV	AH,ILLDEV
	STC
	RET
X	ENDP
;
	SUBTTL	GIFDIC HANDLER
;
	PUBLIC	GIFDIC,GIFJMP
;
GIFDIC	PROC	FAR			;GIFDIC INTERFACE HANDLER
	STI
	PUSH	SI
	PUSH	DS
	MOV	DS,CS:DATSEG		;INIT DATASEGMENT
	MOV	SI,OFFSET DGROUP:GIFDICD;START HANDLER ADR TABLE
	AND	BL,0FCH
	CMP	BX,(DEVCNT-1)*64+3CH
	JNA	GIFDIC1
	CALL	X
	JMP	SHORT GIFDIC2
GIFDIC1:
	ADD	SI,BX			;SI=OFFSET TO HANDLER
	DB	0C1H,0EBH,5		;SHR BX,5
	ADD	BX,OFFSET DGROUP:ATB	;GET ADDRESS DEVICE 
	MOV	BX,[BX]			;ATTRIBUTE TABLE
	CALL	DWORD PTR[SI]		;PERFORM HANDLER CALL
GIFDIC2:
	JB	GIFDIC3			;EXIT TO ERROR HANDLER IF ERROR
	XOR	AH,AH			;ELSE EXIT
GIFDIC4:
	POP	DS
	POP	SI
	RET
GIFDIC3:
	TEST	BYTE PTR DS:[GIFFLGS],FRAMEC;IF CALLED BY FRAME ORIENTED HANDLER
	STC
	JNZ	GIFDIC4			;EXIT TO IT
	JMP	DWORD PTR DS:GIFDICE	;ELSE GO TO ERROR HANDLER
GIFDIC	ENDP
;
;	LOGICAL GIFDIC HANDLER
;	DEVICES WILL BE REMAPED
;
GIFDICL	PROC	FAR
	PUSH	CX
	MOV	CX,BX
	DB	0C1H,0EBH,6		;SHR BX,6
	ADD	BX,OFFSET DGROUP:GIFLTAB
	MOV	BH,[BX]
	MOV	BL,0
	AND	CL,3CH
	DB	0C1H,0E8H,2
	OR	BL,CL
	POP	CX
	JMP	SHORT GIFDIC
GIFDICL	ENDP
;
;
GIFDICF	PROC	FAR			;FRAME BASE GIFDIC HANDLER
	PUSHA
	PUSH	ES
	MOV	AX,[BP.GAX]		;INIT ENTRY PARAMETERS
	MOV	BX,[BP.GBX]
	MOV	CX,[BP.GCX]
	MOV	DX,[BP.GDX]
	MOV	ES,[BP.GES]
	MOV	DI,[BP.GDI]
	CALL	GIFDIC
	MOV	[BP.GDI],DI
	MOV	[BP.GES],ES
	MOV	[BP.GDX],DX
	MOV	[BP.GCX],CX
	MOV	[BP.GBX],BX
	MOV	[BP.GAX],AX
	POP	ES
	POPA
	RET
GIFDICF	ENDP
;
;
GIFJMP	PROC	NEAR			;JMP TO S/GSTATUS PROC #DL
	PUSH	DX
	XOR	DH,DH
	AND	DL,7EH
	CMP	DL,BYTE PTR CS:[SI]	;TEST FOR VALID REQUEST
	JBE	GIFJMP1
	MOV	AH,ILLOPC
	STC
	POP	DX
	DB	0CBH
GIFJMP1:
	INC	SI
	ADD	SI,DX
	POP	DX
	TEST	AL,1
	JMP	WORD PTR CS:[SI]
GIFJMP	ENDP
;
;
;
;
;
	PUBLIC	IDAT,CIDAT
CIDAT	PROC	FAR
	PUSH	CS
	POP	ES
IDAT	PROC	FAR
	PUSH	BP
	MOV	BP,BX
	MOV	ES,PGRP
	MOV	CX,ES:[DI]
	ADD	DI,2
IDATLP:
	MOV	SI,WORD PTR ES:[DI]
	CMP	SI,STOCS		;IF CS SHOULD BE STORED
	JNZ	IDAT1
	MOV	SI,ES			;STORE CS (BASE)
	JMP	SHORT IDAT5
IDAT1:
	CMP	SI,ALLOC		;IF BUFFER ALLOCATION
	JNZ	IDAT2
	MOV	SI,DX			;CURR BUFFER=POINTER
	ADD	DI,2			;GET LENGTH
	ADD	DX,ES:[DI]
	DEC	CX
	JMP	SHORT IDAT5
IDAT2:
	CMP	SI,COPYI
	JNZ	IDAT3
	ADD	DI,2
	MOV	SI,ES:[DI]		;DISPLACMENT
	NEG	SI
	MOV	SI,[BX+SI]		;GET VALUE
	DEC	CX
	JMP	SHORT IDAT5
IDAT3:
	CMP	SI,ALLBX
	JNZ	IDAT4
	MOV	BX,DX
	MOV	BP,DX
	SUB	BP,ES:[DI+2]
	ADD	DX,ES:[DI+4]
	SUB	DX,ES:[DI+2]
	DEC	CX
	DEC	CX
	ADD	DI,4
	JMP	SHORT IDAT6
IDAT4:
	CMP	SI,STOCB
	JNZ	IDAT5
	MOV	SI,DX
IDAT5:
	MOV	[BX],SI
	ADD	BX,2
IDAT6:
	ADD	DI,2
	LOOP	IDATLP
	MOV	BX,BP
	POP	BP
	RET
IDAT	ENDP
CIDAT	ENDP
;
;
;
	PUBLIC	ICTINIT
;
;
ICTINIT	PROC	NEAR
	MOV	ES,WORD PTR PGRP
	MOV	CX,ES:[BX]		;DCST TABLE LENTH
	MOV	AX,ES:[BX+2]		;DEFAULT VECTOR
	MOV	BP,ES:[BX+4]		;SOURCE TABLE
	MOV	DI,ES:[BX+6]		;DCST TABLE
	MOV	BX,0			;BX = DISPLACEMENT
ICTINIT0:
	MOV	WORD PTR[BX+DI],AX
	MOV	[BX+DI+2],CS
	ADD	BX,4
	LOOP	ICTINIT0
ICTINIT1:
	MOV	SI,ES:[BP]		;POINTER TO HANDLER TABLE
	ADD	BP,2
ICTINIT2:
	INC	SI			;IF AT END OF TABLE
	JZ	ICTINIT5		;EXIT
	INC	SI
	MOV	BX,ES:[SI-2]		;ELSE GET #DEVICE,FUNKTIONS SUPPORTED
	MOV	CX,BX
	AND	BX,0FFC0H
	AND	CX,01FH
ICTINIT3:
	MOV	AX,ES:[SI]		;LOOK UP IP
	ADD	SI,2
	CMP	AX,0FFFFH		;IF NOT VALID
	JZ	ICTINIT4		;LEAVE DEFAULT VECTOR THERE
	MOV	[BX+DI],AX		;ELSE STORE IT
ICTINIT4:
	ADD	BX,4
	LOOP	ICTINIT3
	CMP	WORD PTR ES:[SI],0FFFFH	;IF AN OTHER DEV SPECD IN TABLE
	JNZ	ICTINIT2		;XFER NXT ENTRY
	JMP	ICTINIT1		;ELSE LOOK FOR AN OTHER TABLE
ICTINIT5:
	RET
ICTINIT	ENDP
;
;
;
	SUBTTL	SYSTEM DEVICE HANDLER
;
	PUBLIC	SYSRST,SYSREAD

;	SYSTEM DEVICE RESET
;
SYSIT:
	DW	DEVCNT*16
	DW	OFFSET PGROUP:X
	DW	OFFSET PGROUP:DEVTAB
	DW	OFFSET DGROUP:GIFDICD
;
SYSRST	PROC	FAR
	MOV	WORD PTR[GIFERADL],OFFSET PGROUP:GIFDIC4;INIT
	MOV	BX,CS			;GIFDIC ERROR EXIT ADDRES TO AN RETF
	MOV	GIFERADH,BX
	MOV	BX,OFFSET DGROUP:SYSADDR;INIT SYSTEM ADDRESS TABLE
	MOV	DI,OFFSET PGROUP:SYSADDRI
	CALL	IDAT
	MOV	SI,CS:DATSEG
	MOV	DGRP,SI
	MOV	BX,OFFSET PGROUP:SYSIT
	CALL	ICTINIT
	MOV	CX,DEVCNT		;NOW RESET ALL DEVICES
	MOV	BX,KVDDEV*64+RESET*4	;START WITH FIRST DEVICE
SYSRST1:
	PUSH	CX
	PUSH	BX
	XOR	DI,DI			;NO ATTRIBUTES VALID
	MOV	ES,DI
	MOV	CX,DI
	MOV	AX,DI
	DEC	AL
	MOV	DX,MEMEND
	CALL	GIFDIC			;EXECUTE RESET
	MOV	CX,BX
	POP	BX			;STORE POINTER TO DATA AREA
	JC	SYSRST3
	AND	DX,DX			;IF MEMORY HAS BEEN ALLOCATED
	JZ	SYSRST2
	ADD	MEMEND,DX
SYSRST2:
	MOV	SI,BX
	DB	0C1H,0EEH,5		;SHR SI,5
	ADD	SI,OFFSET DGROUP:ATB
	MOV	[SI],CX
SYSRST3:
	POP	CX
	ADD	BX,64			;NXT DEVICE
	LOOP	SYSRST1
	INITVC	SYSINTV,SYSRDI		;INIT VECTOR SYSTEM INIT
	STI
	RET
SYSRST	ENDP
;
;
;	SYSTEM DEVICE READ
;
SYSRDM:
SYSREAD	PROC	FAR
	OR	CX,CX			;IF POINTER IS REQUESTED
	JZ	SYSREAD2		;LOAD ADDR OF SYSADDR INTO ES:DI
	PUSH	DS
	MOV	DS,CS:DATSEG
	MOV	AH,DEVOVR		;PRESET FOR OVERFLOW ERR
	CMP	CX,SYSADDRM		;TEST FOR VALID LOOP CNT
	JA	SYSREAD1		;ERROR EXIT IF ILLEGAL LOOP CNT
	PUSH	SI			;TRANSFER #CX WORDS FROM SYSTEM ADDRESS TABLE
	MOV	SI,OFFSET DGROUP:SYSADDR;TO USER BUFFER [ES:DI]
	CLD
	REP	MOVSW
	POP	SI
SYSREAD1:
	CMC
	POP	DS
	RET
SYSREAD2:
;	LOADS ADDR OF SYSADDR INIT ES:DI
;
	MOV	ES,CS:DATSEG
	MOV	DI,OFFSET DGROUP:SYSADDR
	XOR	AH,AH
	RET
SYSREAD	ENDP
;
;
;
;
;
;
;	SYSTEM ADDRESS INTERUPT
;		THIS INTERUPT LOADS THE ADDRESS OF THE SYSTEM
;		ADDRESS TABLE INTO ES:DI
;
;
SYSRDI:
	CALL	SYSREAD			;LOAD SYSTEM ADDRESS TABLE
	CLI
	ADD	SP,6
	PUSHF
	SUB	SP,4
	IRET
;
;
	XOR	AH,AH
;	SYSTEM DEV GETSTATUS FUNCTIONS
;
SGST	PROC	FAR
	MOV	SI,OFFSET PGROUP:SGSTT
	JMP	GIFJMP
SGST	ENDP
;
;
SGSTT:
	DB	SGSTTE-SGSTT-3
	DW	OFFSET PGROUP:SGST0
	DW	OFFSET PGROUP:SGST1
	DW	OFFSET PGROUP:TSTSUPB
	DW	OFFSET PGROUP:RDSUPB
SGSTTE:
;
;
;
;	COPY SYSTEM HANDLER ADDRESS TABLE DEV # AL TO BUFFER [ES:DI]
;	LOAD POINTER DATA AREA DEV# AL IN CX
;
SGST0	PROC	FAR
	CMP	AL,DEVCNT
	JNA	SGST00
	STC
	MOV	AH,1
	RET
SGST00:
	PUSH	DI
	CLD
	XOR	AH,AH
	ADD	AL,AL
	MOV	SI,AX
	ADD	SI,SI
	ADD	SI,SI
	ADD	SI,SI
	ADD	SI,SI
	ADD	SI,SI
	ADD	SI,OFFSET DGROUP:GIFDICD
	MOV	CX,32			;16 HNDLRS
	REP	MOVSW
	MOV	BX,OFFSET DGROUP:ATB	;XFER
	ADD	BX,AX			;POINTER TO DATA AREA
	MOV	CX,[BX]
	POP	DI
	XOR	AH,AH
	RET
SGST0	ENDP
;
;
;
;	RDLDEVT
;
SGST1	PROC	FAR
	CMP	AL,DEVCNT		;TEST FOR LEGAL DEV NR
	JLE	SGST101
	MOV	AH,DEVOVR
	STC
	RET
SGST101:
	XOR	AH,AH			;READ ENTRY #AL
	MOV	BX,OFFSET DGROUP:GIFLTAB
	ADD	BX,AX
	MOV	CL,[BX]
	RET
SGST1	ENDP
;
;
;	SYSTEM DEV SETSTATUS FUNCTIONS
;
SSST	PROC	FAR
	MOV	SI,OFFSET PGROUP:SSSTT
	JMP	GIFJMP
SSST	ENDP
;
;
SSSTT:
	DB	SSSTTE-SSSTT-3
	DW	OFFSET PGROUP:SSST0
	DW	OFFSET PGROUP:SSST1
	DW	OFFSET PGROUP:SSST2
	DW	OFFSET PGROUP:SSST3
	DW	OFFSET PGROUP:SSST4
	DW	OFFSET PGROUP:SSST5
	DW	OFFSET PGROUP:LINKSH
	DW	OFFSET PGROUP:ULINKSH
	DW	OFFSET PGROUP:XCHGERH
SSSTTE:
;
;	SYSTEM DEV SSTATUS FUNKTION 0
;	COPY BUFFER [ES:DI] TO SYSTEM HANDLER ADDRESS TABLE ENTRY #AL
;	LOAD CX IN POINTER DATA AREA DEV# AL 
;
;
;
SSST0	PROC	FAR
	CMP	AL,DEVCNT
	JNA	SSST00
	STC
	MOV	AH,1
	RET
SSST00:
	PUSH	DI
	CLD
	XOR	AH,AH
	ADD	AL,AL
	MOV	SI,DI
	MOV	DI,AX
	ADD	DI,DI
	ADD	DI,DI
	ADD	DI,DI
	ADD	DI,DI
	ADD	DI,DI
	ADD	DI,OFFSET DGROUP:GIFDICD
	PUSH	DS
	PUSH	ES
	POP	DS
	PUSH	ES
	MOV	ES,CS:DATSEG
	PUSH	CX
	MOV	CX,32			;16 HNDLRS
	REP	MOVSW
	POP	CX
	MOV	BX,OFFSET DGROUP:ATB	;XFER
	ADD	BX,AX			;POINTER TO DATA AREA
	MOV	ES:[BX],CX
	XOR	AH,AH
	POP	DI
	POP	ES
	POP	DS
	RET
SSST0	ENDP

;	WRLDEVT
;
SSST1	PROC	FAR
	CMP	AL,DEVCNT		;TEST FOR LEGAL DEV NR
	JLE	SSST101
	MOV	AH,DEVOVR
	STC
	RET
SSST101:
	XOR	AH,AH			;WRITEENTRY #AL
	MOV	BX,OFFSET DGROUP:GIFLTAB
	ADD	BX,AX
	MOV	[BX],CL
	RET
SSST1	ENDP
;
;
	EXTRN	SRDWORD:NEAR,FRETI:NEAR

;
;
;	LINK1,UNLINK1,LINK20,UNLINK20
;
;
;
;
;	LINK1,LINK20
;
;
SSST4	PROC	FAR			;20 MS INTERUPT
	MOV	SI,OFFSET DGROUP:MSTAB20
	JMP	SHORT SSST20
SSST2	PROC	FAR			;1 MS INTERUPT
	MOV	SI,OFFSET DGROUP:MSTAB1	;HADDR TABLE 1MS INT
SSST20:
	PUSH	ES
	PUSH	DI
	PUSH	CX
	PUSH	CS
	POP	ES
	MOV	DI,OFFSET PGROUP:FRETI
	MOV	CX,MSITABL
	CALL	SRDWORD
	POP	CX
	POP	DI
	POP	ES
	MOV	AH,DEVOVR		;IF NO LOC FREE
	JB	SSST21			;FLAG ERROR,EXIT
	CLI				;ELSE STORE HANDLER ADDRESS
	MOV	[SI],DI
	MOV	[SI+2],ES
	STI
	XOR	AH,AH
SSST21:
	RET
SSST2	ENDP
SSST4	ENDP
;
;
;	UNLINK1,UNLINK20
;
;
SSST5	PROC	FAR			;20 MS
	MOV	SI,OFFSET DGROUP:MSTAB20
	JMP	SHORT SSST30
SSST3	PROC	FAR			;1 MS
	MOV	SI,OFFSET PGROUP:MSTAB1
SSST30:
	PUSH	CX
	MOV	CX,MSITABL
	CALL	SRDWORD			;SEARCH FOR REQUESTED HANDLER IS IN LINK
	POP	CX
	MOV	AH,DEVOVR		;ERR EXIT IF NO MATCH
	JB	SHORT SSST31
	CLI				;ELSE REMOVE HANDLER
	MOV	WORD PTR[SI],OFFSET PGROUP:FRETI
	MOV	[SI+2],CS
	STI
	XOR	AH,AH
SSST31:
	RET
SSST3	ENDP
SSST5	ENDP
;
;
XCHGERH	PROC	FAR			;EXCHANGE CURRENT ERROR HANDLER ADDRESS
;WITH ES:DI
	MOV	SI,ES
	CLI
	XCHG	GIFERADL,DI		;OFFSET
	XCHG	GIFERADH,SI		;SEGMENT
	STI
	MOV	ES,SI
	CLC
	RET
XCHGERH	ENDP
	SUBTTL	SYSTEM DEVICE ADDRESS TABLE
;
;	SYSTEM STATUS (0)
;
	PUBLIC	SYSTAB
SYSTAB:
	DW	5			;DEV 0,5 CALLS
	DW	OFFSET PGROUP:SYSRST
	DW	0FFFFH
	DW	OFFSET PGROUP:SGST
	DW	OFFSET PGROUP:SSST
	DW	OFFSET PGROUP:SYSRDM
	DW	0FFFFH
;
;
;
SYSADDRI:
	DW	(SYSADDRE-SYSADDRI-2)/2	;# ENTRYS IN TABLE
	DW	1			;VERSION
	DW	(SYSADDRE-SYSADDRI-2)/2	;# ENTRYS IN TABLE
	DW	PGROUP
	DW	?
	DW	OFFSET PGROUP:GIFDIC
	DW	OFFSET DGROUP:GIFDICD
	DW	OFFSET DGROUP:ATB
	DW	OFFSET DGROUP:DEND	;END OF DATA AREA
	DD	20000H
	DW	OFFSET DGROUP:VIDPAR
	DW	OFFSET PGROUP:GIFDICL
	DW	OFFSET PGROUP:GIFDICF
SYSADDRE:
PROG	ENDS


DATA	SEGMENT	WORD PUBLIC 'DATA'
	PUBLIC	PGRP,ATB,SYSADDR,MEMEND,MEMAX
	EXTRN	DEND:NEAR,MSTAB1:WORD,MSTAB20:WORD,VIDPAR:NEAR
GIFDICD	DB	DEVCNT*64 DUP (?)
SYSADDR	DW	?			;VERSION
	DW	?			;#ENTRYS IN THIS TABLE
PGRP	DW	?			;CODE SEGMENT
DGRP	DW	?			;DATA SEGMENT
	DW	?			;GIFDIC HANDLER ADDRESS
	DW	?			;GIFDIC HANDLER ADDRESS TABLE
	DW	?			;ADR TABLE GIFDIC HANDLER ATTRIBUTE TABLE
MEMEND	DW	?			;END OF DATA AREA
MEMAX	DD	?
SYSADDRD EQU	SYSADDRE-SYSADDRI+SYSADDR-$
	DB	SYSADDRD DUP (?)
SYSADDRM EQU	($-SYSADDR)/2
ATB	DW	DEVCNT DUP (?)
GIFLTAB	DB	DEVCNT DUP (?)
GIFDICE	LABEL	DWORD
GIFERADL DW	?			;ADDRESS OF GIFDIC ERROR HANDLER
GIFERADH DW	?
GIFFLGS	DB	?			;GIFDIC FLAGS
DATA	ENDS


	END
A

G



