TITLE Initialization module of the SYSCON hardware GIFDIC PROM
;
name INITSCG
;
	INCLUDE	SYSCON.EQU
umcsr equ 0ffa0h  ; Chip select register locations
lmcsr equ 0ffa2h
pacsr equ 0ffa4h
mpcsr equ 0ffa8h
umcsv equ 0f038h  ; 64K, no wait states, XT RDY SUP
lmcsv equ 3ff8h   ; 256K external RDY used
pacsv equ 3bh+SIOBASE     ; Peripheral base 3 WAIT STATES
mpcsv equ 0bah    ; PCS5 and 6 supplies,
                  ; Peripherals in I/O space

monitor segment at 0f800h
monitor_start label far
monitor ends

;
; Initialize routine
;
iniseg segment
assume cs:iniseg
init proc far
      mov      dx, umcsr  ; Program the umcs register
      mov      ax, umcsv
      out      dx, ax
      mov      dx, lmcsr  ; Program the lmcs register
      mov      ax, lmcsv
      out      dx, ax
      mov      dx, pacsr  ; Set up the peripheral chip
                          ; selects (Note the mid-range
                          ; memory chip selects are not
                          ; needed in this system, and
                          ; are thus not initialized
      mov      ax, pacsv
      out      dx, ax
      mov      dx, mpcsr
      mov      ax, mpcsv
      out      dx, ax
	jmp	monitor_start
;
; Reset location
      org      0f0h
	MOV	DX,SYSFAIL	;SET SYSFAIL
	MOV	AL,1
	OUT	DX,AX
      jmp      init
init endp
;
iniseg ends
;
end
