TITLE	KB Driver
	include \gifi\fifo.s86


pgroup group prog
dgroup group data

etx		equ 3	;Ctrl-C
esc		equ 1bh	;ESC
kb_buf_len	equ 50

extrn ignore:abs, ctsize:abs,noscrl:abs,noscrlcy:abs

data segment word public 'data'
	extrn	atb:word,scrlf:byte


shft_flag	db  ?	; 0 means released

data ends


prog segment byte public 'prog'
	assume cs:pgroup, ds:dgroup, es:pgroup
	extrn	putifi:far,home:near

public kb_init
kb_init:
	mov	shft_flag, 0
	ret

public put_buff
put_buff:		; Scan code in AX.
	cmp	ax, ctsize
	ja	buf_err
	mov	bx,word ptr dgroup:[atb.2] ;point to kb data area
	push	cs
	pop	es
	dec	ax		; Scan code to Offset
	extrn chrtab:byte
	mov	si, offset pgroup:chrtab
	add	si, ax
	mov	dl, es:[si]
	cmp	dl, ignore	; Ignore?
	je	pbf_end
	test	dl, 80h		; b7=0 means ascii
	jnz	func_key	; No -- Function key
	cmp	shft_flag, 0	; Shift Locked ?
	jz	pbf1
	cmp	dl, 'A'
	jb	pbf1
	cmp	dl, 'Z'
	ja	pbf2
	add	dl, 'a'-'A'
	jmp	short pbf1
pbf2:
	cmp	dl, 'a'
	jb	pbf1
	cmp	dl, 'z'
	ja	pbf1
	sub	dl, 'a'-'A'
pbf1:
	mov	al, dl
	mov	cx, 1		; Output only 1 char
	call	put_buf
	jnc	pbf_end
; Buffer error
public buf_err
buf_err:
	stc
	ret
pbf_end:
	clc
	ret

func_key:
	test	dl, 40h		; b6=1 means ESC sequence
	jnz	esc_seq
	shl	dl, 1		; Word address
	xor	dh, dh
	extrn funtab:word
	lea	si, es:funtab
	add	si, dx
	jmp	es:[si]

esc_seq:
	and	dl, 3fh		; Just lower 6 bits
	add	dl, 'A'
	mov	al, esc		; ESC
	mov	cx, 2		; Prepare for two characters
	call	put_buf
	jc	buf_err
	mov	al, dl		; Code following ESC
	mov	cx, 1
	call	put_buf
	jnc	pbf_end
	jmp	buf_err

public shift_lock
shift_lock:
	mov	shft_flag, -1
	ret

public shift_release
shift_release:
	mov	shft_flag, 0
	ret

put_buf:
	call	putifi
	ret

	public	disscrl,shome,fbreak
	
disscrl	proc	near
	add	scrlf,noscrl		;toggle scroll enable flag
	and	scrlf,(not noscrlcy) and 0ffh;clear carry
	ret
disscrl	endp

shome	proc	near
	call	home
	ret
shome	endp


fbreak	proc	near
	or	[bx.fifoflgs],80h	;flag break
	and	scrlf,(not noscrl) and 0ffh ;reenable scrolling
	ret
fbreak	endp
prog ends

end



