	PAGE	60,132
	TITLE	VT 52 EMULATOR

DGROUP	GROUP	DATA
PGROUP	GROUP	PROG
	INCLUDE	\GIFI\SRC\GIFMAC.MAC
	INCLUDE	\GIFI\SRC\VIDS.S86
	INCLUDE	\186\XINSTR.MAC
	INCLUDE	\GIFI\SRC\FIFO.S86
;
DATA	SEGMENT	WORD PUBLIC 'DATA'
	ASSUME	DS:DATA
;
	EXTRN	VIDPAR:WORD,CURSADDR:WORD,CURLADDR:WORD
	EXTRN	XCURS:BYTE,YCURS:BYTE,INVERS:WORD
	PUBLIC	SNEWL,SAUCR,SWRAP,VPROC,VFLG
;
SCRNADDL DW	?
VT52SW	DW	?
VPROC	DD	?
VFLG	DB	?
GRPX	DB	?
SNEWL	DB	?
SAUCR	DB	?
SWRAP	DB	?
TEMP	DB	?
CNT	DB	?
CNTR1	DB	?
CNTR2	DB	?
DATA	ENDS
;

PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME	CS:PGROUP
;
	EXTRN	ERSCRN:NEAR,DATSEG:WORD,CLRSCRN:NEAR,GIFDIC:FAR
	EXTRN	MOVCURS:NEAR,SCRLDN:NEAR,CLRCURS:NEAR
	PUBLIC	WR52,VT52INIT,LFV,HOME
;
;
VT52INIT:
	MOV	VT52SW,OFFSET PGROUP:SCW2;INIT SWITCH
	RET
;
SJMP	PROC	NEAR
	AND	AL,7FH
	CMP	AL,(OFFSET SCHRTABE-OFFSET SCHRTAB)/2
	JNB	VT52INIT
	MOV	SI,OFFSET PGROUP:SCHRTAB
	JMP	JMPTAB2
JMPTAB	PROC	NEAR
	MOV	SI,OFFSET PGROUP:CCHRTAB
JMPTAB2:
	PUSH	ES
	PUSH	DI
	PUSH	CX
	XOR	AH,AH
	ADD	AL,AL
	ADD	SI,AX
	CALL	CS:[SI]
	POP	CX
	POP	DI
	POP	ES
X:
	RET
JMPTAB	ENDP
SJMP	ENDP
;
;

BEL	PROC	NEAR			;BELL
	RET
BEL	ENDP
;
BS	PROC	NEAR
	TEST	SWRAP,2			;IF WRAPAROUND WITH HALF LINE OFFSET EN
	JZ	BS1
	MOV	AL,BYTE PTR [VIDPAR.ABYTES];CHECK FOR AT MIDDLE OF LINE
	SHR	AL,1
	CMP	AL,XCURS
	JZ	BS2			;CHECK FOR WRAPED AROUND
BS1:
	CMP	XCURS,0			;ELSE IF NOT AT COLUMN 0
	JZ	BS3
	DEC	XCURS			;EXECUTE BACK SPACE
	JMP	VT52INIT
BS2:
	TEST	SWRAP,0FCH		;IF WRAPED AROUND
	JZ	BS1
	SUB	SWRAP,4			;COUNT DOWN WRAPAROUND COUNTER
BS3:
	TEST	SWRAP,3			;IF WRAPAROUND ENABLED
	JZ	VT52INIT
	MOV	AL,BYTE PTR[VIDPAR.ABYTES];POINT TO PREVIOUS LINE
	DEC	AL
	MOV	XCURS,AL
	JMP	CUP
BS	ENDP
;
LFV	PROC	NEAR
	TEST	SAUCR,1			;IF AUTO CR ENABLED
	JZ	LF0
	MOV	XCURS,0			;EXECUTE CR
LF0:
	MOV	AL,YCURS		;IF NOT AT LOWEST LINE
	CMP	AL,[VIDPAR.YMAXI]
	JZ	LF1
	INC	YCURS			;ENTER NEXT LINE
	RET
LF1:
	JMP	SCRLDN			;ELSE SCROLL
	RET
LFV	ENDP
;
CR	PROC	NEAR
	AND	SWRAP,3			;RESET WRAPED AROUND CNTR
	MOV	XCURS,0
	TEST	SNEWL,1			;IF NEW LINE ENABLED
	JNZ	LFV			;ENTER NEW LINE
	RET
CR	ENDP
;
;	ESCAPE FUNCTIONS
;
CUP	PROC	NEAR
	CMP	YCURS,0			;IF CURSOR NOT AT TOP
	JZ	CUP1
	DEC	YCURS			;MOVE IT  ONE UP
CUP1:
	JMP	VT52INIT
CUP	ENDP
;
CDN	PROC	NEAR
	MOV	AL,[VIDPAR.YMAXI]			;IF CURSOR NOT AT BOTTOM
	CMP	AL,YCURS
	JZ	CUP1
	INC	YCURS
	JMP	VT52INIT
CDN	ENDP
;
CSR	PROC	NEAR
	MOV	AL,XCURS		;IF CURSOR NOT AT RIGHT MARGIN
	CMP	AL,[VIDPAR.XMAXI]
	JZ	CUP1
	INC	XCURS			;MOVE IT ONE RIGHT
	JMP	VT52INIT
CSR	ENDP
;
HOME	PROC	NEAR
	MOV	WORD PTR XCURS,0
	CALL	MOVCURS
	JMP	VT52INIT
HOME	ENDP
;
ERSCRI	PROC
	CMP	YCURS,0			;IF CURSOR AT HOME POSITION
	JNZ	ERSCRI1
	CALL	CLRSCRN			;CLR WHOLE SCREEN AND RESET
	JMP	VT52INIT		;LINK LIST
ERSCRI0:
	MOV	DH,[VIDPAR.YMAXI]	;ELSE CLR FROM CURRENT CURSOR
	ADD	DH,[VIDPAR.YNR]		;TO END OF SCREEN
	JMP	SHORT ERSCRI1
ERSCRI	ENDP
;
ERLINE	PROC
	MOV	DH,YCURS
;
ERSCRI1:
	CALL	ERSCRN
	JMP	VT52INIT
ERLINE	ENDP
;
;
ESCTAB:
	DW	OFFSET PGROUP:CUP,OFFSET PGROUP:CDN,OFFSET PGROUP:CSR,OFFSET PGROUP:BS
	DW	OFFSET PGROUP:X,OFFSET PGROUP:X,OFFSET PGROUP:X,OFFSET PGROUP:HOME
	DW	OFFSET PGROUP:X,OFFSET PGROUP:ERSCRI,OFFSET PGROUP:ERLINE
GSIZE PROC	NEAR
	AND	AL,7
	CMP	AL,4
	JA	CHSILL
	MOV	CNT,1
	MOV	CL,AL
	SHL	CNT,CL
	MOV	VT52SW,OFFSET PGROUP:CHAROUT
	RET
CHSILL:
	JMP	VT52INIT
GSIZE ENDP
;
;
CHAROUT	PROC	NEAR
	CMP	AL,20H
	JB	CHSILL
	CMP	AL,7EH
	JA	CHSILL
	MOV	DL,CNT
	SUB	AL,' '
	MUL	[VIDPAR.LCHAR]		;POINT TO ENTRY IN CHARACTER GEN
	MOV	BP,AX
	ADD	BP,[VIDPAR.UTABLE]
	MOV	AL,[VIDPAR.LCHAR]	;SETUP ROW COUNTER
	MOV	CNTR2,AL
	XOR	AH,AH
	ADD	BP,AX
	DEC	BP
	MOV	ES,[VIDPAR.VSEG]	;POINT TO BOTTOM OF CURRENT LINE
	MOV	SI,CURSADDR
	ADD	SI,[VIDPAR.OFFSNXT]
	SUB	SI,[VIDPAR.BYTES]
	XOR	CH,CH
	MOV	BX,[VIDPAR.BYTES]
	MOV	DH,BYTE PTR INVERS
CHAROUT0:
	PUSH	SI
	MOV	CNTR1,8			;8 BITS
	MOV	AH,CS:[BP]		;GET ENTRY
	DEC	BP
CHAROUT1:
	CMP	DL,8			;IF BYTE OR WORD MODE
	JB	CHAROUT10
	DEC	CNTR1			;1 BIT DONE
	ROL	AH,1			;GET BIT
	MOV	AL,DH			;EXTEND
	JNB	CHAROUT2
	NOT	AL
CHAROUT2:
	CMP	DL,16
	JB	CHAROUT12		;STORE BYTE
	XOR	AL,DH
	MOV	ES:[SI],AL			;OR WORD
	INC	SI
	JMP	SHORT CHAROUT12
CHAROUT10:
	CMP	DL,1			;IF 1 TO ONE
	JNZ	CHAROUT19
	MOV	AL,AH
	MOV	CNTR1,0
	JMP	SHORT CHAROUT12		;BYTE DONE
CHAROUT01:
	JMP	CHAROUT0
CHAROUT19:
	CMP	DL,2			;IF 1 TO TWO
	JNZ	CHAROUT18
	MOV	CL,4
CHAROUT17:
	ROL	AH,1			;STORE 4 BITS
	PUSHF
	RCL	AL,1
	POPF
	RCL	AL,1
	LOOP	CHAROUT17
	SUB	CNTR1,4
	JMP	SHORT CHAROUT12
CHAROUT18:
	MOV	CL,2
CHAROUT16:
	ROL	AH,1
	PUSHF
	PUSHF
	PUSHF
	RCL	AL,1
	POPF
	RCL	AL,1
	POPF
	RCL	AL,1
	POPF
	RCL	AL,1
	LOOP	CHAROUT16
	SUB	CNTR1,2
CHAROUT12:
	XOR	AL,DH			;INVERSE VIDEO
	MOV	ES:[SI],AL
	INC	SI
CHAROUT11:
	CMP	CNTR1,0			;LOOP IF NOT ALL COLUMNS
	JNZ	CHAROUT1
	POP	SI
	MOV	AL,DL
	PUSH	DS
	MOV	DI,ES
	MOV	DS,DI
	CMP	DL,1
	JZ	CHAROUT21
CHAROUT20:
	MOV	CL,DL
	MOV	DI,SI
	SUB	DI,BX
	PUSH	SI
	CLD
	REP	MOVSB
	POP	SI
CHAROUT21:
	SUB	SI,BX
	DEC	AL
	JNZ	CHAROUT20
	POP	DS
	DEC	CNTR2			;LOOP UNTIL ALL ROWS
	JNZ	CHAROUT01
CHSILL1:
	JMP	CHSILL
CHAROUT	ENDP
;
;
ESCSEQ	PROC	NEAR
	CMP	AL,'A'			;TEST FOR FUNCTION A-K
	JB	ESCSEQ2
	CMP	AL,'K'
	JA	ESCSEQ2
	MOV	SI,OFFSET PGROUP:ESCTAB	;EXECUTE FUNCTION A-K
	SUB	AL,'A'
	XOR	AH,AH
	ADD	AL,AL
	ADD	SI,AX
	JMP	CS:[SI]
ESCSEQ2:
	CMP	AL,'Y'			;ELSE CHECK FOR CURSOR ADDRESSING
	JZ	ADRCURS
	CMP	AL,'p'			;ELSE TEST FOR INVERSE VIDEO ON
	JNZ	ESCSEQ3
	MOV	WORD PTR INVERS,0FFFFH	;EN INVRS VIDEO
ESCSEQ3:
	CMP	AL,'q'			;OR FOR INVERS VIDEO OFF
	JNZ	ESCSEQ4
	MOV	WORD PTR INVERS,0
ESCSEQ4:
	CMP	AL,'P'			;CHARACTER SIZE (NON VT52/H19)
	JNZ	ESCSEQ5
	MOV	VT52SW,OFFSET PGROUP:GSIZE
	RET
ESCSEQ5:
	JMP	VT52INIT
;
;
ADRCURS	PROC	NEAR			;DIRECT CURSOR ADDRESSING
	MOV	VT52SW,OFFSET PGROUP:ADRCURS1;INPUT #L
	RET
ADRCURS1:
	SUB	AL,20H
	CMP	AL,[VIDPAR.YMAXI]
	JBE	ADC11
	XOR	AL,AL
ADC11:
	MOV	BYTE PTR YCURS,AL	;SAVE #LINE
	MOV	VT52SW,OFFSET PGROUP:ADRCURS2;INPUT #C
	RET
ADRCURS2:
	SUB	AL,20H			;IF BIGGER THEN LIMIT
	CMP	AL,[VIDPAR.XMAXI]
	JBE	ADC21
	XOR	AL,AL			;X-0
ADC21:
	MOV	BYTE PTR XCURS,AL	;SAVE #COLUMN
	JMP	VT52INIT
	RET
ADRCURS	ENDP
;
;
ESCSEQ	ENDP
;
;
ESC	PROC	NEAR			;ESCAPE
; SWITCH TO ESCAPE SEQUENCE INPUT MODE
	MOV	VT52SW,OFFSET PGROUP:ESCSEQ
	RET
ESC	ENDP
;
;
GRP3:
	MOV	SI,SCRNADDL		;GET ADDRESS
	MOV	ES,[VIDPAR.VSEG]
	XOR	AX,INVERS
	MOV	ES:[SI],AL		;STORE CHARACTER
	ADD	SI,[VIDPAR.BYTES]	;CALCULATE ADDRESS OF NEXT BYTE
	CMP	SI,[VIDPAR.SCRNMAX]	;IF OVERFLOW
	JA	GRP31
	MOV	SCRNADDL,SI
	JMP	SHORT GRP32
GRP31:
	CALL	GRP20			;IGNORE ANY OTHER GRAPHICS CHARACTERS
GRP32:
	DEC	GRPX			;IF ALL BYTES WRITTEN
	JNZ	GRP33
	JMP	CSR			;MOV CURSOR ONE LOC RIGHT
GRP33:
	RET
;
;
GRP2:
	XOR	AH,AH			;CALCULATE OFFSET FOM CURSOR
	MUL	[VIDPAR.BYTES]
	ADD	AX,CURSADDR		;+ ADDRESS OF CURSOR
	JNB	GRP21			;IF OVERFLOW
GRP20:
	MOV	VT52SW,OFFSET PGROUP:GRP32;IGN ALL GRAPHICS CHARS
	RET
GRP21:
	MOV	SCRNADDL,AX		;ELSE STORE ADDRSS
	MOV	VT52SW,OFFSET PGROUP:GRP3;AND DRAW
	RET
;
;
GRP1:
	MOV	GRPX,AL			;SAVE BYTE COUNT
	MOV	VT52SW,OFFSET PGROUP:GRP2;INPUT Y
	RET
;
;
GRP	PROC	NEAR
	JMP	VT52INIT
	MOV	VT52SW,OFFSET GRP1	;INPUT X
	RET
GRP	ENDP
;
;
;
CCHRTAB:
	DW	OFFSET PGROUP:X,OFFSET PGROUP:X,OFFSET PGROUP:X,OFFSET PGROUP:X
	DW	OFFSET PGROUP:X,OFFSET PGROUP:X,OFFSET PGROUP:X,OFFSET PGROUP:BEL
	DW	OFFSET PGROUP:BS,OFFSET PGROUP:X,OFFSET PGROUP:LFV,OFFSET PGROUP:X
	DW	OFFSET PGROUP:X,OFFSET PGROUP:CR,OFFSET PGROUP:X,OFFSET PGROUP:X
	DW	OFFSET PGROUP:X,OFFSET PGROUP:sh	es
	mov	ax, ds
	mov	es, ax
	pop	ds
	mov	ah, noerr
	clc
xsexit:
	mov	bytebuf, ah
	pop	di
	pop	cx
	pop	ax
	mov	ah, bytebuf
	ret
xbics	endp


; XEBEC Init

xbini	proc near
	cmp	ch, numldrv
	jb	xi1
; Error
	mov	ah, badcall
	stc
	jmp	short xiexit
xi1:
	push	ax
	push	cx
	push	dx
	mov	al, ch
	xor	ah, ah
	shlax	xbicsft
	add	ax, offset ds:xbictab
	mov	si, ax
	mov	cl, ch
	call	xbinit
	mov	bytebuf, ah
	pop	dx
	pop	cx
	pop	ax
	mov	ah, bytebuf
xiexit:
	ret
xbini	endp


msgdump	proc near
	test	dh, newdmph
	jz	mg1
	and	ax, not 63
	or	ax, write*4
	mov	dumphd, ax
mg1:
	and	ddflg, not tm
	test	dh, 80h
	jz	mg2
	or	ddflg, tm
mg2:
	mov	ah, noerr
	clc
	ret
msgdump	endp


tmoctrl	proc near
	and	ddflg, not notmo
	test	dh, 80h
	jz	tm1
	or	ddflg, notmo
tm1:
	mov	ah, noerr
	clc
	ret
tmoctrl	endp

;set address of disk handler wait,start routine
;
;entry:
;	es:di		address
;	al	bit 	0
;			0	wait handler
;			1	start handler
;
;
setwsr	proc	near
	cli
	mov	si,0
	and	al,al
	jz	setwsr1	;if wait routine
	mov	si,4
setwsr1:
	mov	word ptr[si+ddwait],di
	mov	word ptr[si+ddwait+2],es
	sti
	ret
setwsr	endp

;Set size
;entry: CX size of sector
;
;
SETSIZE	PROC	NEAR
	MOV	SECSIZE,CX
	XOR	AH,AH
	RET
SETSIZE	ENDP
;
;
prog	ends

end

	CMP	SI,[BX.FIFOXONL]	;AND MODEM SHOULD BE ENABLED
	JA	SCCFIO3
	TEST	[BX.FIFOFLGS],XONEN	;IF XON IS ENABLED
	JNZ	SCCFIO1			;ENABLE VIA XON
	PUSH	DX
	MOV	DX,[BX.FIFOPORT]	;SCC PORT ADDRESS
	PUSH	AX
	MOV	AX,505H			;ELSE ENABLE MODEM VIA HANDSHAKE
	CLI
	OUT	DX,AL
	CALL	SRD
	OR	AL,2
	OUT	DX,AL
	STI
	CALL	SWR
	POP	AX
	POP	DX
	JMP	SHORT SCCFIO2
SCCFIO1:
	MOV	[BX.FIFOBYTE],XON	;OUTPUT XON
SCCFIO2:
	TEST	[BX.FIFOFLGS],OUTDIS	;IF OUTPUT IS NOT
	JNZ	SCCFIO3			;DISABLED
	OR	[BX.FIFOFLGS],MODEN	;FLAG ENABLED
SCCFIO3:
	RET
ENIN	ENDP
;
;
;	FIFO READ
;
;
CFIFOIO:
	MOV	BX,[BX]
SCCFIO	PROC	FAR			;SCC RAED
	CALL	ENIN
FIFOIO	PROC	FAR
	MOV	SI,[BX.FIFOIPTO]	;OUTPUT POINTER
	TEST	AH,ANYATTR		;IF ATTRIBUTES VALID
	JNZ	FIFOIO3			;SWITCH
;
;
;	CHARACTER MODE
;
;
FIFOIO00:
	CMP	[BX.FIFOICNT],0		;TEST FOR FIFO IS EMPTY
	JZ	FIFOIO1			;FIFO EMPTY
	MOV	AL,[SI]			;ELSE GET CHAR
	DEC	[BX.FIFOICNT]		;CNT -1
	INC	SI			;ADV PTR
	CMP	SI,[BX.FIFOIFIE]	;IF WRAP AROUND
	JB	FIFOIO0
	MOV	SI,[BX.FIFOIFIS]	;SET BACK TO START
FIFOIO0:
	CLC
FIFOIO01:
	MOV	[BX.FIFOIPTO],SI	;STORE NEW PTR
	RET
FIFOIO1:
	PUSH	BX
	CALL	DWORD PTR[BX.FIFOIWT]	;WAIT
	POP	BX
	JMP	FIFOIO			;TRY AGAIN
FIFOIO2:
	TEST	AH,WAIT			;IF IMM RET
	JZ	FIFOIO21		;FLAG NOT READY,EXIT
	RET				;ELSE WAIT
FIFOIO21:
	MOV	AH,NOTRDY		;FLAG NOT READY
	ADD	SP,6
	STC
	RET
FIFOIO3:
	TEST	AH,GENATTRI		;IF ATTRIBUTES FROM TABLE ARE VALID
	JZ	FIFOIO4
	MOV	AH,[BX.FIFOATRB]	;USE THESE BITS
FIFOIO4:
	TEST	AH,BURSTMD		;IF NO BLOCK /STRING MODE
	JZ	FIFOIO00		;CONTINUE IN CHARACTER MODE
;
;
;	BLOCK MODE
;
;
	JCXZ	FIFOIO11		;EXIT IF CHAR CNT=0 OR NO START,STOP CHR VALID
FIFOIO5:
	CMP	[BX.FIFOICNT],0		;IF NO CHARACTERS VALID
	JZ	FIFOIO8			;WAIT
	TEST	AH,STRMD		;ELSE IF STRING MODE
	JNZ	FIFOIO10		;STRING MODE
FIFOIO6:
	MOV	AL,[SI]
	MOV	ES:[DI],AL
	INC	DI
	INC	SI
	CMP	SI,[BX.FIFOIFIE]	;IF WRAP AROUND
	JNZ	FIFOIO7
	MOV	SI,[BX.FIFOIFIS]	;SET BACK TO START
FIFOIO7:
	DEC	[BX.FIFOICNT]		;UNTIL USR BUFFER FULL OR FIFO EMPTY
	LOOPNZ	FIFOIO6
	JCXZ	FIFOIO0			;EXIT IF USR BUFFER FULL
FIFOIO8:
	PUSHA				;ELSE SAVE STATUS
	CALL	DWORD PTR[BX.FIFOIWTB]	;AND WAIT
	POPA
	JMP	FIFOIO5			;CONTINUE
;
;
;	STRING MODE
;
;
FIFOIO10:
	AND	CH,CH			;IF NO START CHAR VALID
	JZ	FIFOIO13		;TRANSFER FROM CURRENT BUFFER
	CMP	[SI],CH			;ELSE SEARCH FOR MATCH
	JNZ	FIFOIO11
	MOV	CH,0			;FLAG FOUND
FIFOIO11:
	INC	SI
	CMP	SI,[BX.FIFOIFIE]
	JNZ	FIFOIO12
	MOV	SI,[BX.FIFOIFIS]
FIFOIO12:
	DEC	[BX.FIFOICNT]
	JNZ	FIFOIO10
	JMP	FIFOIO8			;WAIT
FIFOIO13:
	CMP	ES:[DI-1],CL		;IF END OF STRING FOUND
FIFOIO131:
	JZ	FIFOIO0			;EXIT
	CMP	DI,DX			;IF AT END OF USER BUFFER
	JA	FIFOIO15		;FLAG ERROR
	CMP	SI,[BX.FIFOIFIE]
	JNZ	FIFOIO14
	MOV	SI,[BX.FNDS
	END
R

N

P

R

	




O

P


P

