

/*==============================================================*/
/*			SYSUP Utility				*/
/*			Module 2 - System Table Upgrade		*/
/*				   routines			*/	
/*==============================================================*/
#include "sysup.os"
#include "c:switch.os"

#include "hardio.h"
#include "sysup.h"
#include "sysup2.h"

#define Banner2	"Upgrade2 01/26/84 17:45\n"
/*page*/
/*==============================================================*/
/* Static data for Disk I/O routines in syslib2			*/
/*==============================================================*/
#define	LEN_STAT	4
CHAR	statbuf [LEN_STAT];
CHAR	hd_type;
int	error = FALSE;
int	abort_req = FALSE;

/*==============================================================*/
/* Static data for Cold Boot Upgrade				*/
/*==============================================================*/ 
extern int	BIOStype;	/* inport from SYSUP1 module	*/

#define HD_5_INCH	0
#define HD_8_INCH	1

#define BOOTNAME bootfiles [(hd_controller () == XEBEC ? HD_5_INCH : HD_8_INCH) + BIOStype]

CHAR	*bootfiles [] = {
	"HBOOT5.SYS",
	"HBOOT8.SYS",
	"MBOOT5.SYS",
	"MBOOT8.SYS"
	};
int	cbfn; 		/* Cold boot file			*/
CHAR	*cbname;	/* ptr to name of cold boot loader	*/

/*page*/
/*==============================================================*/
/*			I/O Macros				*/
/*==============================================================*/
#define OSTCHUNKS	8

/* read macros */
		/* HD_xfer is used to disable hd writes during debugging */ 
#ifndef NODEBUG
HD_xfer(r,t,s,b,l) {
	hd_xfer(r,t,s,b,l); 
	printf("\t%s %0x @ trk=%0x sec=%0x for %0x secs\n",r==READ?"READING":"WRITEING",b,t,s,l); 
	}
#else
#define HD_xfer hd_xfer
#endif
	/* This works only if the alloc table's size MOD sectorsize is 0 */
/* #define get_DAT(b)	hd_xfer (READ, DATtrack, DATsector, b, DATlength)*/
	/* This works only if the config table's size MOD sectorsize is 0 */
#define get_oUCT(b)	hd_xfer (READ, oUCTtrack, oUCTsector, b, oUCTlength)
	/* This works only if the name table's size MOD sectorsize is 0 */
#define get_oUNT(b)	hd_xfer (READ, oUNTtrack, oUNTsector, b, oUNTlength)

/* write macros */
#define put_boot(b,off)	HD_xfer (WRITE, CBtrack, CBsector+off, b, 1)
#define put_FWT(b)	HD_xfer (WRITE, FWTtrack, FWTsector, b, FWTlength)
#define put_OST(b,off)	HD_xfer (WRITE, OSTtrack, OSTsector+off, b, OSTCHUNKS)
#define put_PT(b)	HD_xfer (WRITE, PTtrack, PTsector, b, PTlength)
#define put_PWT(b)	HD_xfer (WRITE, PWTtrack, PWTsector, b, PWTlength)
#define put_SD(b)	HD_xfer (WRITE, SDtrack, SDsector, b, SDlength)
#define put_nUNT(b)	HD_xfer (WRITE, UNTtrack, UNTsector, b, UNTlength)
#define put_nUCT(b)	HD_xfer (WRITE, UCTtrack, UCTsector, b, UCTlength)
#define put_DAT(b)	HD_xfer (WRITE, DATtrack, DATsector, b, DATlength)
#define get_DAT(b)	HD_xfer (READ, DATtrack, DATsector, b, DATlength)

/*page*/
/*==============================================================*/
/* ColdBoot_Upgrade	- Upgrade the cold boot loader		*/
/*==============================================================*/
BOOLEAN ColdBoot_Upgrade () {
CHAR	buf [SECTSIZE];
int	sect_offset	= 0;
int	n;		/* number of bytes read	*/
#ifndef NODEBUG
	printf ("--Upgrading Cold Boot Loader\n");
#endif
	while ((n = read (cbfn, buf, SECTSIZE)) > 0) {
		put_boot (buf, sect_offset);
		++sect_offset;
		}

#ifndef NODEBUG
	printf ("\tCold Boot Loader Upgrade Complete\n");
#endif

	if (n == EOF) return (FALSE);
	else return (close (cbfn) == EOF);
	}


/*page*/
/*==============================================================*/
/* FindColdBoot	- find and open the file containing		*/
/*		  the appropriate cold boot loader		*/
/*==============================================================*/
BOOLEAN FindColdBoot () {

#ifndef NODEBUG
	printf ("--FindColdBoot. opening %s\n", BOOTNAME);
#endif
	return ((cbfn = open ((cbname = BOOTNAME), O_RDONLY)) == EOF);
	}
/*page*/
/*==============================================================*/
/* FWT_upgrade	- First Write Table Upgrade			*/
/*==============================================================*/
FWT_upgrade () {
struct	FWTentry FWTable [MAXVOLS];

#ifndef NODEBUG
	printf ("--First Write Table Upgrade\n");
#endif
	clear (FWTable, FWTSIZE, 0xFF);
#ifndef NODEBUG
	printf ("\tFWT set to FFh\n");
#endif
	put_FWT (FWTable);
	}

/*page*/
/*==============================================================*/
/* OST_upgrade	- Operating Systems Table Upgrade		*/
/*==============================================================*/
OST_upgrade () {
CHAR	OSTpart [OSTCHUNKS * SECTSIZE];
int	i;

#ifndef NODEBUG
	printf ("--Operating Systems Table Upgrade\n");
	printf ("\tOST is set to NULL\n");
#endif
	/* since the OST is so big and is being set to NULL
	   only write out 1K at a time, and save some data space */
	clear (OSTpart, OSTCHUNKS * SECTSIZE, '\0');
	for (i = 0; i < OSTlength; i += OSTCHUNKS) 
		put_OST (OSTpart, i);
	}

/*page*/
/*==============================================================*/
/* PT_upgrade	- Product Type Table Upgrade			*/
/*==============================================================*/
PT_upgrade () {
struct PTentry	PTable [PTMAX];

#ifndef NODEBUG
	printf ("--Product Type Table Upgrade\n");
	printf ("\tPT is set to NULL\n");
#endif
	clear (PTable, PTSIZE, '\0');
	put_PT (PTable);
	}

/*page*/
/*==============================================================*/
/* PWT_upgrade	- Password Table Upgrade			*/
/*==============================================================*/
PWT_upgrade () {
struct PWTtype PWT;

#ifndef NODEBUG	
	printf ("--Password Table Upgrade\n");
	printf ("\tPWT is set to blanks\n");
#endif

	clear (&PWT.table [0], PWTMAX * PWlen, ' ');
	blockmv (&PWT.table[0], SEPBOOT, PWlen);
	PWT.autoflag = PWT.PWreserved = 0;
	put_PWT (&PWT);
	}

/*page*/
/*==============================================================*/
/* SD_upgrade	- Initailize the System Directory to Null	*/
/*==============================================================*/
SD_upgrade () {
struct SDentry	SDirectory [SDMAX];

#ifndef NODEBUG
	printf ("--System Directory Upgraded\n");
	printf ("\tSD set to NULL\n");
#endif

	clear (SDirectory, SDSIZE, '\0');
	put_SD (SDirectory);
	}

/*page*/
/*==============================================================*/
/* UCT_upgrade	- User Configuration Table Upgrade		*/ 
/*==============================================================*/
UCT_upgrade () {
struct oUCTentry	oUCTable [UCTMAX];
struct oUCTentry	*oldentry;
struct UCTentry		*UCTable;
struct UCTentry		*newentry;
int			i;

#ifndef NODEBUG
	printf ("--User Configuration Table Upgrade\n");
#endif
	get_oUCT (oUCTable);
	/* convert old format to new - in place */
	UCTable = oldentry = newentry = oUCTable;
	for (i = 0; i < UCTMAX 
		&& oldentry->Adrive [0] != 0
		&& oldentry->Adrive [0] != 0xE5; 
		++i, ++oldentry, ++newentry) {
		blockmv (newentry, oldentry, 32);
		blockmv (&newentry->lth_typeahead,
			&oldentry->olth_typeahead, 32);
#ifndef NODEBUG
		printf ("\tUCT [%d]\n", i);
		printf ("\t\t    A:%-8.8s", newentry->Adrive);
		printf ("\t    C:%-8.8s\n", newentry->Cdrive);
		printf ("\t\t    B:%-8.8s", newentry->Bdrive);
		printf ("\t    D:%-8.8s\n", newentry->Ddrive);
		if (newentry->lth_typeahead > 31)
			newentry->typeahead [newentry->lth_typeahead] = NULL;
		printf ("\t\t    typeahead:%-31.31s\n", newentry->typeahead);
#endif
		}
	if (i < UCTMAX) /* Blank the rest of the table */
		clear (newentry, sizeof (struct UCTentry)*(UCTMAX - i), '\0');
	put_nUCT (UCTable);
	}

/*page*/
/*==============================================================*/
/* UNT_upgrade	- User Name Table Upgrade			*/
/*==============================================================*/
UNT_upgrade () {
struct	UNTentry	UNTable [UNTMAX];
struct	UNTentry	*p;
int			i;


#ifndef NODEBUG
	printf ("--User Name Table Upgrade\n");
#endif
	get_oUNT (UNTable);
	p = UNTable;
	for (i = 0; i < UNTMAX 
		&& p->User_Name [0] != 0
		&& p->User_Name [0] != 0xE5; 
		++i, ++p) {
		p->OS_Code = DFLTOS;
		p->flags = DFLTFLAGS;
#ifndef NODEBUG
	printf ("\tUNT [%d]\t%-8.8s\n", i, p->User_Name);
#endif
		}
	if (i < UNTMAX) /* blank entry the rest of the table */
		clear (p, sizeof (struct UNTentry) * (UNTMAX - i), '\0');
	put_nUNT (UNTable); 
	}



/*==============================================================*/
/* DAT_upgrade	- Chage all read write contol bytesis data table to onwable
/*==============================================================*/
DAT_upgrade () {
	int	i; char k; 
	struct DATentry DATS[DATMAX]; 
	char	x[9];

	get_DAT (&DATS[0]);	/* read in table */
	/* update all entries */
	for (i = 0; i < DATMAX; i++)
	{	if (DAT_r_w (k = DATS[i].control))
		{	DATS[i].control = ((k & ~WM_MASK) | 0x20); 
				/* control byte to ownable */
#ifndef NODEBUG
			blockmv (x,DATS[i].Part_Name,8);
			x[8] = '\0';
			printf ("\nChanged partition %s to ownable.",x);
#endif		
		} /* if read write */
	}
	put_DAT (&DATS[0]); /* write it back out */

}	/* end of DAT_upgrade */

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/

