REM *** MBASESM 3.0 ***  MAG/base SCREEN MANAGEMENT FUNCTIONS
REM
REM CB80 VERSION - COMMON FILE
REM
REM WRITTEN: 08/01/79  UPDATED: 05/23/92 FROM 03/13/82 VERSION
REM
REM PROPRIETARY SOFTWARE OF:
REM  MICRO APPLICATIONS GROUP
REM  20201 SHERMAN WAY, SUITE 205
REM  CANOGA PARK, CA 91306
REM
REM  (C) COPYRIGHT MAG 1979-1982 ALL RIGHTS RESERVED
REM
%NOLIST

REM
REM	CLEAR SCREEN
REM
	DEF FN.CLR.SCRN$
	PRINT TDR.CS$;
	RETURN
	FEND

REM
REM	POSITION CURSOR
REM
	DEF FN.POS.CURSOR1$(FP.LINE%,FP.COL%)
	PRINT TDR.PC$;
	IF TDR.PCFLIP$="N" THEN \
	   PRINT CHR$(FP.LINE%+TDR.LPLUS%)+ \
	         CHR$(FP.COL%+TDR.CPLUS%); \
	ELSE \
	   PRINT CHR$(FP.COL%+TDR.CPLUS%)+ \
	         CHR$(FP.LINE%+TDR.LPLUS%);
	RETURN
	FEND

REM
REM	HOME CURSOR
REM
	DEF FN.HOM.CURSOR$
	IF TDR.HM$<>CHR$(0) THEN \
	   PRINT TDR.HM$; \
	ELSE \
	   FI.DUM$=FN.POS.CURSOR1$(1,1)
	RETURN
	FEND

REM
REM	POSITION CURSOR WITH CLEAR LINE AND CLEAR TO END OF LINE
REM
REM	   FP.CLR$="CLL" = CLEAR LINE
REM	           "CEL" = CLEAR TO END OF LINE
REM
	DEF FN.POS.CURSOR$(FP.LINE%,FP.COL%,FP.CLR$)
	WHILE (FP.CLR$="CLL" OR FP.CLR$="CEL") AND TDR.CL$<>CHR$(0)
	   IF FP.CLR$="CLL" THEN \
	      FI.DUM$=FN.POS.CURSOR1$(FP.LINE%,1)
	   IF FP.CLR$="CEL" THEN \
	      FI.DUM$=FN.POS.CURSOR1$(FP.LINE%,FP.COL%)
	   PRINT TDR.CL$;
	   FI.DUM$=FN.POS.CURSOR1$(FP.LINE%,FP.COL%)
	   RETURN
	WEND
	FI.BLNK$="                                        "+ \
	         "                                        "
	FI.CLR%=80
	IF FP.LINE%=24 THEN FI.CLR%=79
	IF FP.CLR$="CEL" THEN \
	   FI.DUM$=FN.POS.CURSOR1$(FP.LINE%,FP.COL%): \
 	   PRINT MID$(FI.BLNK$,FP.COL%,FI.CLR%);
	IF FP.CLR$="CLL" THEN \
	   FI.DUM$=FN.POS.CURSOR1$(FP.LINE%,1): \
	   PRINT MID$(FI.BLNK$,1,FI.CLR%);
	FI.DUM$=FN.POS.CURSOR1$(FP.LINE%,FP.COL%)
	RETURN
	FEND

REM
REM	DISPLAY STANDARD MESSAGE LINE
REM
REM	  FP.TYPE$="ERR" = ERROR MESSAGE
REM	  FP.TYPE$="FAT" = FATAL EEROR
REM	  FP.TYPE$="WAR" = WARNING MESSAGE
REM
	DEF FN.DISP.MSG$(FP.MSG$,FP.TYPE$)
	IF FP.TYPE$="ERR" THEN \
	   FP.MSG$=">> Error:  "+FP.MSG$+"  Please reenter."
	IF FP.TYPE$="FAT" THEN \
	   FP.MSG$=">> Fatal Error:  "+FP.MSG$
	IF FP.TYPE$="WAR" THEN \
	   FP.MSG$=">> Warning:  "+FP.MSG$
 	FP.MSG$=LEFT$(FP.MSG$,79)
	FI.DUM$=FN.POS.CURSOR$(24,1,"CLL"): REM BLANK ERROR LINE
	IF FP.TYPE$="ERR" OR FP.TYPE$="FAT" OR FP.TYPE$="WAR" THEN \
	   PRINT TDR.BRT$+TDR.BEL$;
	PRINT FP.MSG$;
 	PRINT TDR.NORM$;
	RETURN
	FEND

REM
REM	DISPLAY ANY LINE OF TEXT
REM
REM	  FP.CTR$="CTR" = CENTER LINE
REM	  FP.CLR$ - SEE FN.POS.CURSOR$
REM
	DEF FN.DISP.LINE$(FP.MSG$,FP.LINE%,FP.COL%,FP.CTR$,FP.CLR$)
	FI.COL%=FP.COL%
	IF FP.CTR$="CTR" THEN \
	   FI.COL%=INT((80-LEN(FP.MSG$))/2)
	FI.DUM$=FN.POS.CURSOR$(FP.LINE%,FI.COL%,FP.CLR$)
	PRINT FP.MSG$;
	RETURN
	FEND

REM
REM	DISPLAY STANDARD HEADING LINES (3.0)
REM
	DEF FN.DISP.HEAD$(FP.FUNC1$,FP.FUNC2$,FP.FILE$,FP.KEY$,FP.LINE4$)
	PRINT
	FI.DUM$=FN.CLR.SCRN$
	PRINT FP.FUNC1$;
	IF FP.FILE$<>"" THEN \
	   PRINT TAB(23+LEN(TDR.CS$));"File: ";FP.FILE$;
	PRINT TAB(61+LEN(TDR.CS$));HDR.HEAD$
	PRINT FP.FUNC2$;
	IF FP.KEY$<>"" THEN \
	   PRINT TAB(23);"Key:  ";FP.KEY$;
	PRINT TAB(72);EDR.SYSDATE$
	FI.DUM$="===================="
	PRINT FI.DUM$;FI.DUM$;FI.DUM$;LEFT$(FI.DUM$,19)
	FI.DUM$=FN.DISP.LINE$(FP.LINE4$,4,1,"","")
	RETURN
	FEND

REM
REM	DISPLAY STANDARD HEADING LINES  (PRIOR TO RELEASE 3.0)
REM
REM	DEF FN.DISP.HEAD$(FP.HEAD1$,FP.HEAD2$,FP.HEAD3$,FP.SCRNO$)
REM	FI.DUM$=FN.CLR.SCRN$
REM	FI.DUM$=FN.DISP.LINE$(FP.HEAD1$,1,0,"CTR","")
REM	FI.DUM$=FN.DISP.LINE$(FP.HEAD2$,2,0,"CTR","")
REM	IF FP.SCRNO$<>"" THEN \
REM	   FI.DUM$=FN.POS.CURSOR1$(2,70): \
REM	   PRINT "SCREEN ";FP.SCRNO$;
REM	FX.LINECT%=4
REM	IF FP.HEAD3$<>"" THEN \
REM	   FI.DUM$=FN.DISP.LINE$(FP.HEAD3$,FX.LINECT%,1,"",""): \
REM	   FX.LINECT%=6
REM	RETURN
REM	FEND

REM
REM	DISPLAY ANY FIELD LINE
REM
	DEF FN.DISP.FLD$ \
	   (FP.NO%, \
	    FP.DESC$, \
	    FP.FIELD$, \
	    FP.LINE%, \
	    FP.CLR$)
	FI.DUM$=FN.POS.CURSOR$(FP.LINE%,1,FP.CLR$): REM CLEAR LINE
	IF FP.NO%=0 THEN \
	   PRINT FP.DESC$;: \
	ELSE \
	   PRINT RIGHT$("   "+STR$(FP.NO%),3);". ";FP.DESC$;
	FI.DUM$=FN.POS.CURSOR$(FP.LINE%,40,"CEL")
	PRINT FP.FIELD$;
	RETURN
	FEND

REM
REM	RE-DISPLAY FIELD
REM
	DEF FN.RDISP.FLD$(FP.FIELD$,FP.LINE%)
	FI.DUM$=FN.POS.CURSOR$(FP.LINE%,40,"CEL")
	PRINT FP.FIELD$;
	RETURN
	FEND

REM
REM	REQUEST INPUT - ENTER\EDIT
REM
	DEF FN.ENTER$ \
	   (FP.NO%, \
      	    FP.DESC$, \
	    FP.TYPE$, \
	    FP.MINL%, \
	    FP.MAXL%, \
	    FP.DEC%, \
	    FP.MINV, \
	    FP.MAXV, \
	    FP.END$)
.20010	REM  MAIN LINE LOGIC
	GOSUB .20100: REM DISPLAY REQUEST
      	GOSUB .20200: REM DISPLAY ENTRY PATTERN
.20030	GOSUB .20300: REM REQUEST INPUT
	IF FP.END$="END" AND UCASE$(FI.FIELD$)="END" THEN \
	   FN.ENTER$="END": \
	   GOTO .20090
	GOSUB .21000: REM EDIT ENTRY
	IF FI.ERRCD$=CHR$(255) THEN \
	   FI.DUM$=FN.DISP.MSG$(FI.ERROR$,"ERR"): \ DISPLAY ERROR
	   FI.ERRCD$="": \
	   FI.DUM$=FN.POS.CURSOR$(23,FI.CPOS%,"CEL"): \
	   PRINT FI.PAT$;: \
	   GOTO .20030: REM TRY AGAIN
.20080	FN.ENTER$=FI.FIELD$: REM GOOD ENTRY
.20090	FI.DUM$=FN.POS.CURSOR$(24,1,"CLL"): REM CLEAR ERROR LINE
	RETURN: REM GO HOME
.20100	REM REQUEST ENTRY
	IF FI.UL$="" THEN \
	   FOR FI.I%=1 TO 35:FI.UL$=FI.UL$+TDR.UL$:NEXT FI.I%
	FN.ENTER$=""
	FI.DUM$=FN.POS.CURSOR1$(23,1)
	IF FP.NO%=0 THEN \
	   PRINT "Enter ";FP.DESC$;":  ";: \
	   FI.CPOS%=10+LEN(FP.DESC$) \
	ELSE \
	   PRINT RIGHT$("   "+STR$(FP.NO%),3);". Enter ";FP.DESC$;":  ";: \
	   FI.CPOS%=15+LEN(FP.DESC$)
	FI.DUM$=FN.POS.CURSOR$(23,FI.CPOS%,"CEL")
	RETURN
.20200	REM  DISPLAY ENTRY PATTERNS
	IF FP.TYPE$="A" THEN GOSUB .21100: REM TEXT
	IF FP.TYPE$="N" THEN GOSUB .21200: REM NUMERIC
	IF FP.TYPE$="$" THEN GOSUB .21300: REM MONETARY
	IF FP.TYPE$="D" THEN GOSUB .21400: REM DATE
	IF FP.TYPE$="Y" THEN GOSUB .21500: REM YES/NO
	RETURN
.20300	REM  REQUEST INPUT
	FI.DUM$=FN.POS.CURSOR1$(23,FI.CPOS%)
	FI.LEN%=0:FI.FIELD$=""
.20310 	FI.CHAR%=CONCHAR%
	IF FI.CHAR%=TDR.CR% THEN GOTO .20390: REM <CR> - DONE
	IF FP.END$="END" AND FI.LEN%=0 AND FI.CHAR%=27 THEN \ <ESC>
	   FI.FIELD$="END": \
	   GOTO .20390: REM DONE
	IF FI.CHAR%=TDR.QMRK% AND FI.LEN%=0 THEN \ <?>
	   GOSUB .20400: \ DISP FLD DEF
	   FI.DUM$=FN.POS.CURSOR1$(23,FI.CPOS%): \
	   PRINT LEFT$(FI.PAT$,1);: \ DISP ENTRY PATTERN
	   GOTO .20300
	IF FI.CHAR%=TDR.CTLX% THEN \ <CTL-X>
	   FI.DUM$=FN.POS.CURSOR$(23,FI.CPOS%,"CEL"): \
	   PRINT FI.PAT$;: \  DISPLAY ENTRY PATTERN
	   GOTO .20300
	WHILE (FI.CHAR%=TDR.BS% OR FI.CHAR%=TDR.DEL%) AND FI.LEN%>0 
	   FI.LEN%=FI.LEN%-1
	   FI.FIELD$=LEFT$(FI.FIELD$,FI.LEN%)
	   FI.DUM$=FN.POS.CURSOR1$(23,FI.CPOS%+FI.LEN%)
	   IF FI.LEN%<LEN(FI.PAT$) THEN \
	      PRINT MID$(FI.PAT$,FI.LEN%+1,1);: \
	   ELSE \
	      PRINT " ";
	   FI.DUM$=FN.POS.CURSOR1$(23,FI.CPOS%+FI.LEN%)
	   GOTO .20310
	   WEND
	IF FI.CHAR%<32 OR FI.CHAR%>125 THEN GOTO .20310: REM NON-CHAR
	FI.LEN%=FI.LEN%+1
	FI.FIELD$=FI.FIELD$+CHR$(FI.CHAR%)
	GOTO .20310
.20390	RETURN
.20400	REM  DISPLAY FIELD DEF LINE
	FI.MSG$="Type="+FP.TYPE$+"  Min Len="+STR$(FP.MINL%)+ \
	   "  Max Len="+STR$(FP.MAXL%)
	IF FP.TYPE$="N" OR FP.TYPE$="$" THEN \
	   FI.MSG$=FI.MSG$+"  Dec="+STR$(FP.DEC%)
	IF FP.MINV<>0. THEN \
	      FI.MSG$=FI.MSG$+"  Min Val="+STR$(FP.MINV)
	IF FP.MAXV<>0. THEN \
	      FI.MSG$=FI.MSG$+"  Max Val="+STR$(FP.MAXV)
	FI.DUM$=FN.DISP.MSG$(FI.MSG$,"")
	RETURN
.21000	REM  EDIT ENTRY
	IF FP.TYPE$="A" THEN GOSUB .22100: REM TEXT
	IF FP.TYPE$="N" THEN GOSUB .22200: REM NUMERIC
	IF FP.TYPE$="$" THEN GOSUB .22300: REM MONETARY
	IF FP.TYPE$="D" THEN GOSUB .22400: REM DATE
	IF FP.TYPE$="Y" THEN GOSUB .22500: REM YES/NO
	RETURN
.21100	REM TEXT PATTERN
	FI.PAT$=LEFT$(FI.UL$,FP.MAXL%)
	PRINT FI.PAT$;
	RETURN
.21200	REM NUMERIC PATTERN
	FI.PAT$=""
	IF FP.MAXL%-FP.DEC%>0 THEN \
	   FI.PAT$=LEFT$(FI.UL$,FP.MAXL%-FP.DEC%)
	IF FP.DEC%=0 THEN GOTO .21299
	FI.PAT$=FI.PAT$+"."
	FI.PAT$=FI.PAT$+LEFT$(FI.UL$,FP.DEC%)
.21299	PRINT FI.PAT$;
	RETURN
.21300	REM MONETARY PATTERN
	GOSUB .21200: REM SAME AS NUMERIC
	RETURN
.21400	REM DATE PATTERN
	FI.PAT$="mmddyy"
	PRINT FI.PAT$;
	RETURN
.21500	REM YES/NO PATTERN
	FI.PAT$=TDR.UL$
	PRINT FI.PAT$;
	RETURN
.22100	REM EDIT TEXT 
	IF LEN(FI.FIELD$)>FP.MAXL% AND FP.MAXL%<>0 THEN \
 	   FI.ERROR$="Entry longer than "+STR$(FP.MAXL%)+" characters.": \
	   GOTO .22190
	IF LEN(FI.FIELD$)<FP.MINL% THEN \
	   FI.ERROR$="Entry less than "+STR$(FP.MINL%)+" characters.": \
	   GOTO .22190
	GOTO .22199
.22190	FI.ERRCD$=CHR$(255): REM SET ERROR CODE
.22199	RETURN
.22200	REM  EDIT NUMERIC
	FI.PERIOD%=0:FI.DEC%=0:FI.NLEN%=0:FI.J%=1
	IF LEN(FI.FIELD$)=0 AND FP.MINL%>0 THEN GOTO .22250
	IF LEN(FI.FIELD$)=0 THEN GOTO .22299
.22210	IF LEFT$(FI.FIELD$,1)=" " THEN \
	   FI.FIELD$=RIGHT$(FI.FIELD$,LEN(FI.FIELD$)-1): \
	   GOTO .22210
	IF LEFT$(FI.FIELD$,1)="-" THEN FI.J%=2
	FOR FI.I%=FI.J% TO LEN(FI.FIELD$)
	    FI.TEMP$=MID$(FI.FIELD$,FI.I%,1)
            IF ((FI.TEMP$<"0" OR \
	       FI.TEMP$>"9") AND \
               (FI.TEMP$<>".")) OR \
	       (FI.TEMP$="." AND FI.PERIOD%>0) THEN \
	       FI.ERROR$="Entry not numeric.": \
	       GOTO .22290
	   IF FI.PERIOD%>=1 THEN FI.DEC%=FI.DEC%+1
	   IF FI.TEMP$="." THEN \
	      FI.PERIOD%=FI.PERIOD%+1 \
	   ELSE \
	      FI.NLEN%=FI.NLEN%+1
	NEXT FI.I%
	IF FP.DEC%=0 AND FI.NLEN%>FP.MAXL% AND FP.MAXL%<>0 THEN \
	   FI.ERROR$="Entry longer than "+STR$(FP.MAXL%)+" digits.": \
	   GOTO .22290
	IF FP.DEC%<>0 AND FI.NLEN%-FI.DEC%>FP.MAXL%-FP.DEC% AND \
	   FP.MAXL%<>0 THEN \
	   FI.ERROR$="Entry longer than "+STR$(FP.MAXL%-FP.DEC%)+ \
	      "."+STR$(FP.DEC%)+" digits.": \
	   GOTO .22290
.22250	IF FI.NLEN%<FP.MINL% THEN \
	   FI.ERROR$="Entry less than "+STR$(FP.MINL%)+" digits.": \
	   GOTO .22290
	IF FI.PERIOD%>1 OR FI.DEC%>FP.DEC% THEN \
	   FI.ERROR$="More than "+STR$(FP.DEC%)+" decimal places.": \
	   GOTO .22290
	IF FP.MAXV<>0 AND VAL(FI.FIELD$)>FP.MAXV THEN \
	   FI.ERROR$="Value greater than "+STR$(FP.MAXV)+".": \
	   GOTO .22290
	IF FP.MINV<>0 AND VAL(FI.FIELD$)<FP.MINV THEN \
	   FI.ERROR$="Value less than "+STR$(FP.MINV)+".": \
	   GOTO .22290
	IF FP.DEC%=FI.DEC% THEN GOTO .22299
	FI.ZERO$=".00000000000000"
	IF FI.PERIOD%=0 THEN FI.ZERO$=LEFT$(FI.ZERO$,FP.DEC%+1)
	IF FI.PERIOD%<>0 THEN FI.ZERO$=RIGHT$(FI.ZERO$,FP.DEC%-FI.DEC%)
	FI.FIELD$=FI.FIELD$+FI.ZERO$
	GOTO .22299
.22290	FI.ERRCD$=CHR$(255)
.22299	RETURN
.22300	REM EDIT MONETARY
	GOSUB .22200: REM TEST FOR NUMERIC
.22399	RETURN
.22400	REM EDIT DATE
	IF LEN(FI.FIELD$)=0 AND FP.MINL%=0 THEN GOTO .22499
	MAGDATE$(1)="C":MAGDATE$(2)=FI.FIELD$
	DUM$=FN.MAGDATS$: REM MAGDATE - EDIT ONLY
.22450	IF MAGDATE%(1)<>0 THEN \
	   FI.ERROR$="Invalid date.": \
	   GOTO .22490
	FI.DATE$=RIGHT$(FI.FIELD$,2)+LEFT$(FI.FIELD$,4): REM YYMMDD
	IF FP.MINV=0 THEN GOTO .22460
	FI.TEMP$=RIGHT$("000000"+STR$(FP.MINV),6)
	FI.MIN$=RIGHT$(FI.TEMP$,2)+LEFT$(FI.TEMP$,4): REM YYMMDD
	IF FI.DATE$<FI.MIN$ THEN \
	   FI.ERROR$="Date less than "+FI.TEMP$+".": \	
	   GOTO .22490
.22460	IF FP.MAXV=0 THEN GOTO .22499
	FI.TEMP$=RIGHT$("000000"+STR$(FP.MAXV),6)
	FI.MAX$=RIGHT$(FI.TEMP$,2)+LEFT$(FI.TEMP$,4): REM YYMMDD
	IF FI.DATE$>FI.MAX$ THEN \
	   FI.ERROR$="Date greater than "+FI.TEMP$+".": \
	   GOTO .22490
	GOTO .22499
.22490	FI.ERRCD$=CHR$(255)
.22499	RETURN
.22500	REM EDIT YES/NO
	IF LEN(FI.FIELD$)=0 AND FP.MINL%=0 THEN GOTO .22599
	FI.FIELD$=LEFT$(UCASE$(FI.FIELD$),1)
	IF FI.FIELD$<>"Y" AND FI.FIELD$<>"N" THEN \
	   FI.ERROR$="Entry should b 'Y or 'N'.": \
	   GOTO .22590
	GOTO .22599
.22590	FI.ERRCD$=CHR$(255)
.22599	RETURN
	FEND

REM
REM 	CHAIN FORWARD FUNCTION
REM
	DEF FN.CHNFWD$(FP.PROG$,FP.DATA$)
	MSG$="Initiating Function - Please Wait ..."
	FI.RET$=FN.DISP.LINE$(MSG$,23,01,"","CLL")
	STACKLEVEL%=STACKLEVEL%+1
	IF MID$(FP.PROG$,2,1)=":" THEN \
	   PROGSTACK$(STACKLEVEL%)=FP.PROG$ \
	ELSE \
	   PROGSTACK$(STACKLEVEL%)=SYSDRIVE$+":"+FP.PROG$
	DATASTACK$(STACKLEVEL%)=FP.DATA$
	IF RIGHT$(PROGSTACK$(STACKLEVEL%),4)=".COM" THEN \ CB80
	   CREATE "MBASECOM.DAT" AS 20: \ CB80
	   PRINT #20; "N", \ CB80
	      PASSWORD$,PASSCODE$,STACKLEVEL%, \
	      PROGSTACK$(0), \
	      PROGSTACK$(1),PROGSTACK$(2),PROGSTACK$(3),PROGSTACK$(4), \
	      PROGSTACK$(5),PROGSTACK$(6),PROGSTACK$(7),PROGSTACK$(8), \
	      PROGSTACK$(9),PROGSTACK$(10),PROGSTACK$(11),PROGSTACK$(12), \
	      PROGSTACK$(13),PROGSTACK$(14),PROGSTACK$(15),PROGSTACK$(16), \
	      PROGSTACK$(17),PROGSTACK$(18),PROGSTACK$(19),PROGSTACK$(20), \
	      DATASTACK$(0), \
	      DATASTACK$(1),DATASTACK$(2),DATASTACK$(3),DATASTACK$(4), \ 
	      DATASTACK$(5),DATASTACK$(6),DATASTACK$(7),DATASTACK$(8), \ 
	      DATASTACK$(9),DATASTACK$(10),DATASTACK$(11),DATASTACK$(12), \ 
	      DATASTACK$(13),DATASTACK$(14),DATASTACK$(15),DATASTACK$(16), \ 
	      DATASTACK$(17),DATASTACK$(18),DATASTACK$(19),DATASTACK$(20), \ 
	      CDR.CONAME$,CDR.COADDR1$,CDR.COADDR2$,CDR.COCITY$, \
	      CDR.COSTATE$,CDR.COZIP$,HDR.HEAD$,FUNCTION$, \
	      EDR.SYSDATE$,EDR.PRTCOLS%,EDR.DISKS%, \
	      SYSDRIVE$,EDR.SYSBUF$,EDR.MAXRECL%, \
%INCLUDE MBASETDR
	IF RIGHT$(PROGSTACK$(STACKLEVEL%),4)=".COM" THEN \ CB80
	   CLOSE 20
	CHAIN PROGSTACK$(STACKLEVEL%)
	FEND

REM
REM 	CHAIN RETURN FUNCTION
REM
	DEF FN.CHNRTN$
	STACKLEVEL%=STACKLEVEL%-1
	IF PROGSTACK$(STACKLEVEL%)="" THEN \
	   MSG$="Ending MAG/base ...": \
	   FI.RET$=FN.DISP.LINE$(MSG$,23,01,"","CLL"): \
	   STOP
	MSG$="Ending Function - Please Wait ..."
	FI.RET$=FN.DISP.LINE$(MSG$,23,01,"","CLL")
	IF MID$(PROGSTACK$(STACKLEVEL%),2,1)<>":" THEN \
	   PROGSTACK$(STACKLEVEL%)=SYSDRIVE$+":"+PROGSTACK$(STACKLEVEL%)
	CHNFLAG$="N": REM CB80
	IF RIGHT$(PROGSTACK$(STACKLEVEL%),7)=":MBASES" THEN \ CB80
	      CHNFLAG$="Y": REM CB80
	IF RIGHT$(PROGSTACK$(STACKLEVEL%),4)=".COM" OR \ CB80
	   RIGHT$(PROGSTACK$(STACKLEVEL%),7)=":MBASES" THEN \ CB80
	   CREATE "MBASECOM.DAT" AS 20: \ CB80
	   PRINT #20; CHNFLAG$, \ CB80
	      PASSWORD$,PASSCODE$,STACKLEVEL%, \
	      PROGSTACK$(0), \
	      PROGSTACK$(1),PROGSTACK$(2),PROGSTACK$(3),PROGSTACK$(4), \
	      PROGSTACK$(5),PROGSTACK$(6),PROGSTACK$(7),PROGSTACK$(8), \
	      PROGSTACK$(9),PROGSTACK$(10),PROGSTACK$(11),PROGSTACK$(12), \
	      PROGSTACK$(13),PROGSTACK$(14),PROGSTACK$(15),PROGSTACK$(16), \
	      PROGSTACK$(17),PROGSTACK$(18),PROGSTACK$(19),PROGSTACK$(20), \
	      DATASTACK$(0), \
	      DATASTACK$(1),DATASTACK$(2),DATASTACK$(3),DATASTACK$(4), \ 
	      DATASTACK$(5),DATASTACK$(6),DATASTACK$(7),DATASTACK$(8), \ 
	      DATASTACK$(9),DATASTACK$(10),DATASTACK$(11),DATASTACK$(12), \ 
	      DATASTACK$(13),DATASTACK$(14),DATASTACK$(15),DATASTACK$(16), \ 
	      DATASTACK$(17),DATASTACK$(18),DATASTACK$(19),DATASTACK$(20), \ 
	      CDR.CONAME$,CDR.COADDR1$,CDR.COADDR2$,CDR.COCITY$, \
	      CDR.COSTATE$,CDR.COZIP$,HDR.HEAD$,FUNCTION$, \
	      EDR.SYSDATE$,EDR.PRTCOLS%,EDR.DISKS%, \
	      SYSDRIVE$,EDR.SYSBUF$,EDR.MAXRECL%, \
%INCLUDE MBASETDR
	IF RIGHT$(PROGSTACK$(STACKLEVEL%),4)=".COM" THEN \ CB80
	   CLOSE 20: REM CB80
	IF RIGHT$(PROGSTACK$(STACKLEVEL%),7)=":MBASES" THEN \ CB80
	   CLOSE 20: \ CB80
	   CHAIN SYSDRIVE$+":MAGBASE.COM": REM CB80
	CHAIN PROGSTACK$(STACKLEVEL%)
	FEND

%LIST
