PROGRAM Mail7;
{ MAIL7.PAS--Final version of prototype electronic system .
		Version 0.4 4/5/82 rld
		Version 0.5 4/9/82 rld Categorization added
		Version 0.6 4/27/82 rld Show mail enhancements 
		Version 1.0 6/16/82 rld Screen Scrolling 
					and file read/write
		Version 1.2 6/28/82 rld Notes (self-self msgs)
		Version 1.4 8/3/82  rld Add explicit CLOSE for 8086
		Version 1.5 3/2/83  rld Password not echo'd,
					More terminals, Strip Parity on
					get message from file
			    4/15/83 rld MP/M-86 Locking implemented }
CONST
  dly_const = 7000;
TYPE
  pstrg = ^string;
  mode_type = (All, Categorized, Respond, Self, Unread);

{$I D:inclmail.pas }
  l,
   ior	: integer;
  cpm_drive,
    bs,
    ctrl_Z,
    cr,
    lf,
    DEL,
    NUL,
    FF,
    esc    : char;
  more,
    give_up,
    hit_a_new_one : Boolean;
  mode : mode_type;
  source,
    target  : string [8];
  s_head,
    t_head : m1_header_block;
  s_no,
    t_no,
    msg_ptr,
    nxt_msg,
    fst_msg_at_entry_to_Review,
    original_first_msg : rec_ptr;
  dis_line,
    count : integer;
  ch,
    gch,
    command :char;
  status_report : string[64];
  scrn_len : byte;

{$IMAILCOMM.PAS }

FUNCTION strip_parity(ch:char):char;
BEGIN
  strip_parity := chr(ord(ch) & $7F);
END;

FUNCTION f9_delay_but_look(limit:integer;
			   wiggle:Boolean;var ch:char):Boolean;
VAR
  mini,
    i : integer;
  key,
    star : Boolean;
BEGIN
  star := false;
  for i:=1 to limit do 
      begin
	if wiggle AND ((i MOD (limit DIV 10)) = 0) then
	   begin
	     if star then write([addr(out_ch)],' ',bs)
		     else write([addr(out_ch)],'*',bs);
	     star := NOT star;
	   end;
	key := keypressed;
	f9_delay_but_look := key;
	if key then 
	   begin
	     ch := ch_ucase(in_nech);
	     if (ch in ['A','C','F','N','Q','R','S','U']) then EXIT;
	   { If user didn't hit legal command, then continue }
	   end;
      end;
END;

FUNCTION f10_delete_msg(header, next_ptr,del_ptr:rec_ptr):rec_ptr;
VAR
  prior_ptr : rec_ptr;
BEGIN
{ First, must find (securely) the block which points to the one
  to be deleted. }
  lock(header);
  seekread(msg,header);
  prior_ptr := header;
  While msg^.name_link<>del_ptr do
    begin
      lock(msg^.name_link);
      unlock(prior_ptr);
      prior_ptr := msg^.name_link;
      seekread(msg,prior_ptr);
    end;
{ On exit from While loop, The block which points to the block to be
  deleted is in memory as msg^ and is locked.  It is block prior_ptr. }
  msg^.name_link := next_ptr;
  seekwrite(msg,prior_ptr);
  unlock(prior_ptr);

{ Delete returns a pointer to the prior block so anyone trying
  to search the list of messages can start up again in the right place. }
  f10_delete_msg := prior_ptr;
{ Now return the blocks of the message to be deleted to the free list. }
  p7_return_msg_to_free_list(del_ptr);
END;

FUNCTION f11_passes(msg:m0_message_block; mode:mode_type;
		    desired_category:cat_range):Boolean;
BEGIN
  with msg do
    case mode of
      All     : f11_passes := true;
      Categorized : f11_passes := (categ=desired_category);
      Respond : f11_passes := response_needed;
      Unread  : f11_passes := NOT has_been_read;
      Self    : f11_passes := (categ=Self_msg);
    end; { Case }
END;

FUNCTION p21_wait:char;
VAR
  out,
    OK_command	  : Boolean;
  ior : integer;
{internal} PROCEDURE prompt;
	   BEGIN
	     goto_row_col(dis_line,1);		{ get in synch }
	     writeln([addr(out_ch)],'Waiting for Mail');
	     writeln([addr(out_ch)]);
	     writeln([addr(out_ch)],'   Review ALL old mail            [A]');
	     writeln([addr(out_ch)],'   Review CATEGORIZED mail        [C]');
	     writeln([addr(out_ch)],'   Review RESPONSE REQUIRED mail  [R]');
	     writeln([addr(out_ch)],'   Review NOTES                   [N]');
	     writeln([addr(out_ch)],'   Review UNREAD mail             [U]');
	     writeln([addr(out_ch)],'   Send mail from FILE            [F]');
	     writeln([addr(out_ch)],'   SEND mail from keyboard        [S]');
	     writeln([addr(out_ch)],'   QUIT                           [Q]');
	     writeln([addr(out_ch)],'                          Which?  [ ]');
	     writeln([addr(out_ch)]);
	     write  ('Waiting for Mail');
	   { Leave cursor in [ ] prompt brackers...
	     WARNING Changing menu changes this position }
	     goto_row_col(dis_line+10,36);
	   END; { prompt }

BEGIN
  write([addr(out_ch)],clr_scrn);
  writeln([addr(out_ch)],'          Mail System Version 1.52  11/21/83');
  writeln([addr(out_ch)],
	'(c) Information Tools and Digital Microsystems 1982,1983');
  writeln([addr(out_ch)]);
  writeln([addr(out_ch)],'Status: ',status_report);
  writeln([addr(out_ch)]);
  dis_line := 7;
  out := false;
  prompt;
  REPEAT
(*  close(indx,ior); { This is supposed to ensure that we re-read }
    reset(indx);     {    the NetSlave 1K read buffer }
    close(msg,ior);  { Required for MT+86 }
    if ior=255 then ERROR('MSG file error!');
    reset(msg); { This is supposed to ensure that we re-read the file window}*)

  { COERCE the next read to be fresh }
    lock(1); unlock(1);
    seekread(msg,s_head.name_link);   { Re-read header }
    if ioresult<>0 then ERROR('MSG file read error!');
    msg_ptr := msg^.name_link;
    if msg_ptr<>original_first_msg then
       begin
	 original_first_msg := msg_ptr;
	 hit_a_new_one := true;
	 p20_show_messages(msg_ptr,Unread);
	 writeln([addr(out_ch)],clr_scrn,'Status: ',status_report);
	 dis_line := 3;
	 prompt;
       end
    else
       begin
       { TRICKERY: Delay loop contains test for legal
		   command character  }
	 out:=f9_delay_but_look(dly_const,true,command);
       end;
				UNTIL out;
  p21wait := command;
END;

PROCEDURE p22_get_right_rec(var current:rec_ptr; desired:rec_ptr);
VAR
  ior : integer;
  err_mes,rec_no : string[10];
BEGIN
  if current<>desired then
     begin
       seekread(msg,desired);
       ior := ioresult;
       if ior<>0 then 
	  begin
	    conv_i_s(ior,err_mes);
	    err_mes := concat(err_mes,' r:');
	    conv_i_s(desired,rec_no);
	    err_mes := concat(err_mes,rec_no);
	    ERROR(concat('Read Error! #:',err_mes));
	  end;
       current := desired;
     end;
END;

PROCEDURE p20_show_messages(msg_ptr:rec_ptr; mode:mode_type);
VAR
  lcat : cat_range;
  lresp : Boolean;
  l,
    lpscreen,	  { Max lines per screenful }
    scroll_inc,
    top_line : integer;
  start_next : sc0_window_state;
  force_redisplay,
    immediate_reply : Boolean;
  desired_cat : cat_range;
  ch: char;
  command: char;
  cur_msg_ptr: rec_ptr;
  hour : byte;
  ph   : string[2];
BEGIN
  writeln([addr(out_ch)],clr_scrn);
  lpscreen := scrn_len - 7;   { Depends on headings and menu... } 
  scroll_inc := lpscreen - 2; { Change to suit yr taste... }
  force_redisplay := false;
  status_report := 'No more messages for you right now.';
  if mode=Categorized then
     begin
       writeln([addr(out_ch)],'Reviewing old, categorized mail:');
       writeln([addr(out_ch)]);
       write([addr(out_ch)],'Which Category? [1..7]  [ ]',bs,bs);
       REPEAT
	 read([addr(in_nech)],ch);
			      UNTIL ch in ['1'..'7'];
       writeln([addr(out_ch)],ch);
       desired_cat := ord(ch) - ord('0');
       status_report := concat('Done reviewing category ',ch);
     end;
    command := ' ';    { Don't have one yet. }
    cur_msg_ptr := null;
    while msg_ptr<>null do
       begin
	 p22_get_right_rec(cur_msg_ptr,msg_ptr);
	 immediate_reply := false;
	 if f11_passes(msg^,mode,desired_cat) OR force_redisplay then
	    with msg^ do
	      begin
	     { Next condition prevents Self-sent messges from 
	       being shown immediately. 		       }
	       if (Categ=Self_msg) AND hit_a_new_one then
		  begin
		    status_report :='Note (from you) is available.';
		    EXIT;
		  end;
	       begin
		 lcat := Categ;
		 lresp:= Response_needed;
		 if hit_a_new_one then write([addr(out_ch)],chr(beep));
		 hit_a_new_one := false;
	       { ASSERTION: Within this block, msg_ptr always points
			    to the first block of a messge.	     }
		  write([addr(out_ch)],clr_scrn);
		  write([addr(out_ch)],'To   : ',s_head.name);
		  goto_row_col(1,20);
		  writeln([addr(out_ch)],'From : ',indx^.n_head[Sender].Name);
		{ extract date and time }
		  write([addr(out_ch)],'Date : ',date[1]:2,'/',date[2]:2,
				       '/',date[3]);
		  goto_row_col(2,20);
		  write([addr(out_ch)],'Time : ',time[1]:2,':');
		  if time[2]<10 then out_ch('0');
		  writeln([addr(out_ch)],time[2]);
		  p11_draw_line;
		  top_line := 1;
		  with start_next do  { Initialize window state }
		       begin
			 blk  := msg_ptr;
			 posn := 1;
			 line := 1;
			 mas := true;
			 first_row := 4;	  { WARNING: These two }
			 max_lines := lpscreen;   { depend on prompts  }
		       end;
		  cur_msg_ptr := msg_ptr;
		  p13_display_window(start_next,scroll_inc,
				     cur_msg_ptr);
		  writeln([addr(out_ch)]);
		  goto_row_col(scrn_len-3,1);
		  p11_draw_line;
		{ Make sure we're back to the first block of this
		       message...  }
		  p22_get_right_rec(cur_msg_ptr, msg_ptr);
		  force_redisplay := false;
      { ASSERTION: At this point, msg_ptr indicates the first block
		   of the current message, and msg^ is the contents
		   of that cur_msg_ptr. 			      }
		REPEAT
		  command := f21_options(msg^,lcat,lresp);
		  case command of
		  'D':	{ Delete }
		     begin
		       p22_get_right_rec(cur_msg_ptr,msg_ptr);
		       nxt_msg := msg^.name_link;
		       msg_ptr := f10_delete_msg(s_head.name_link,
						 msg^.name_link,msg_ptr);
		       seekread(msg,msg_ptr);
		       cur_msg_ptr := msg_ptr;
		       if msg_ptr=fst_msg_at_entry_to_Review then
			  original_first_msg := nxt_msg;
		     end;
  '0','1','2','3','4','5','6','7':  { Categorize it }
		     begin
		       lcat :=ord(command) - ord('0');
		     end;
		  'I':	{ Immediate Response }
		     begin
		       immediate_reply := true;
		       force_redisplay := true;
		     end;
		  'R':	{ Response Required }
		     begin
		       lresp :=NOT lresp;
		     end;
		  'F':	{ Go to Front of message }
		     begin
		     { F command just redisplays from top of message. }
		       force_redisplay := true;
		     end;
		  'E':	{ Scroll toward End of message }
		     begin
		       p13_display_window(start_next,scroll_inc,
					  cur_msg_ptr);
		     end;
		  'W':	{ Write a copy to file }
		     begin
		       cur_msg_ptr := msg_ptr;
		       p32_write_msg_to_file(cur_msg_ptr);
		       force_redisplay := true;
		     end;
		  else begin end;  { Do nothing for 'Q', 'N' }
		     end;  { Case }
				  UNTIL command in ['D','I','F','N','Q','W'];
		end; { With msg }
	      if command<>'D' then begin
	      p22_get_right_rec(cur_msg_ptr,msg_ptr);  { Ensure head block }
	      categ := lcat;
	      Response_needed := lresp;
	      Has_been_read := true;
	      seekwrite(msg,msg_ptr); { Record any changes to header fields }
	      end; { Update changes if msg not Deleted }
	    end; { if passes }

       { If we're to quit, signal loop so via null.
	 Else we want to move to next message unless
	 we're about to do an immediate reply in
	 which case we will return to the current message. }
	 if command='Q' then msg_ptr:= null
	 else begin
	      if NOT force_redisplay then msg_ptr := msg^.name_link;
	      end;			{ msg_ptr => next s Mesg header }

       { At this point we're ready to go on to the next existing message
	 in source list.  If we're to reply to this message, however,
	 now is time to send a message from source to Sender, where
	 Sender is the Sender of the message we just displayed. }
	 if immediate_reply then
	    begin
	      p14_send_messages(msg^.Sender,true);
	      cur_msg_ptr := null; { Who knows where we are after Send?? }
	    end;
       end; { while msg_ptr<>null }
END;

PROCEDURE p13_display_window(var start:sc0_window_state; 
			     scroll_inc:integer; var cur_blk:rec_ptr);
VAR
  l,
    chars_on_line,
    on_screen : integer;
  c : char;
  enough_lines : Boolean;
  debug_blk : rec_ptr;
BEGIN
  with start do
  begin
    if NOT mas then EXIT;      { No more text, so do nothing }
    p22_get_right_rec(cur_blk,blk);
    for l := first_row to first_row + max_lines -1 do
	begin
	  goto_row_col(l,1);
	  write([addr(out_ch)],clr_line);
	end;
    goto_row_col(first_row,1);	{ Get cursor back to first of msg window }
    chars_on_line := 0;
    on_screen := 0;
    enough_lines := false;
    with msg^ do begin
	 l := posn;
	 REPEAT
	   while (l<= filled) AND (NOT enough_lines) do
	     begin
	       c := msg_text[l];
	       write([addr(out_ch)],c);
	       if c=bs then write([addr(out_ch)],' ',bs);
	       chars_on_line := chars_on_line + 1;
	       if (c=cr) OR (chars_on_line>=sc_width) then 
		  begin
		    writeln([addr(out_ch)]);
		    chars_on_line := 0;
		    on_screen := on_screen + 1;
		    if on_screen=scroll_inc then
		       begin
		       { Now know where next scroll will occur from }
			 blk := cur_blk;
			 posn := l+1;	      { Step past cr, loop handles}
		 (*	 line := on_screen;*) { case where l+1>filled	  }
			 mas := true;
		       end;
		  end;
	       l := l + 1;
	       enough_lines := (on_screen>=max_lines);
	     end;   { While still have chars and not enough lines }
	   if NOT enough_lines then
	      begin
		if msg_link=null then
		   mas := false
		else
		   begin
		     cur_blk := msg_link;
		     seekread(msg,cur_blk);  { Move to next block of msge }
		     l := 1;		     { Reset loop counter }
		   end;
	      end;
			       UNTIL (NOT mas) OR (enough_lines);
       end;  { With msg^ }
  end; { With start }
END;

PROCEDURE p32_write_msg_to_file(var block:rec_ptr);
VAR
  fname : string[15];
  exists,
    have_name,
    more,
    Ok	: Boolean;
    c	: char;
  ph,
    am	  : string[2];
  hour	: byte;
  l,
    ior     : integer;
  msg_ptr   : rec_ptr;
{ Internal procedures... }
  PROCEDURE dwrite(s:string);
  VAR
    l : integer;
  BEGIN
(*  write([addr(out_ch)],s);	     Don't send to screen *)
    for l:=1 to length(s) do
	begin
(*	  write(ext,s[l]);  *)
	  twnb(s[l]);
	  if ioresult<>0 then ERROR('Trouble writing file.');
	end;
  END;

  PROCEDURE dwriteln(s:string);
  VAR
    l : integer;
  BEGIN
(*  writeln([addr(out_ch)],s);	    *)
    dwrite(s);
    twnbeol;
    if ioresult<>0 then ERROR('Trouble writing file.');
  END;

BEGIN
{ Plan:
    Get file name.
    Check it.
    Open it.
    Write msg a char at a time to file.
    Report finish.			}
    writeln([addr(out_ch)],clr_scrn);
    writeln([addr(out_ch)],'Write Message to File Module:');
    REPEAT
      Ok := false;
      writeln([addr(out_ch)]);
      p33_get_ext_file_name(fname,true);
      have_name := (length(fname)>0);
      if have_name then
	 if p31_ext_file_Ok(fname,exists) then
	    begin
	    if exists then
	       begin
		 writeln([addr(out_ch)]);
		 write([addr(out_ch)],'File ',fname,' exists.  Write over it? [y/n] [ ]',
			bs,bs);
		 read([addr(in_echo)],c);  writeln([addr(out_ch)]);
		 if c in ['y','Y'] then p_create(Ok);
	       end
	    else { New file }
	       begin
		 p_create(Ok);
	       end;
	    end;
				UNTIL Ok OR (NOT have_name);
    if have_name then 
       begin
       msg_ptr := null;
       p22_get_right_rec(msg_ptr,block);
       with msg^ do
	  begin
	    block := msg_ptr; { Record current block }
	    writeln([addr(out_ch)]); writeln([addr(out_ch)],'Sending message to ',fname);
	    dwrite('-- Electronic Mail Message --');
	    dwriteln('');
	    dwrite('To   : '); dwriteln(s_head.name);
	    dwrite('From : '); dwriteln(indx^.n_head[Sender].Name);
	    dwrite('Date : '); 
	    conv_i_s(date[1],ph); dwrite(ph); dwrite('/');
	    conv_i_s(date[2],ph); dwrite(ph); dwrite('/');
	    conv_i_s(date[3],ph); dwriteln(ph); 
	    dwrite('Time : ');
	    conv_i_s(time[1],ph); dwrite(ph); dwrite(':');
	    conv_i_s(time[2],ph); dwrite(ph); dwriteln(' ');
     (*     p11_draw_line;  *)
	    p110_draw_file_line;
	    with msg^ do begin
		 REPEAT
		   for l:=1 to filled do
		       begin
			 c := msg_text[l];
			 dwrite(c);
			 if c=cr then
			    begin
			      dwrite(lf);
			      write([addr(out_ch)],'+');    { Show progress }
			    end;
		       end;
		   if msg_link=null then
		      more := false
		   else
		      begin
			seekread(msg,msg_link);
			more := true;
			block := msg_link;     { Keep track of where we are }
		      end;
				       UNTIL NOT more;
		 end;
     (*     p11_draw_line;	*)
	    p110_draw_file_line;
	    dwriteln('');
	  { Close off file, please. }
     {0     ext^ := ctrl_Z;
	    put(ext);	    0}
	    twnb(FF);		     { Form Feed for printer. }
	    twnb(ctrl_Z);
	    close(ext,ior);
	    if ior=255 then ERROR('Trouble closing file.');
	    writeln([addr(out_ch)]);
	  end;
  end;
END;

PROCEDURE p_create(var Ok:Boolean);
BEGIN
  rewrite(ext);
  Ok := (ioresult <> 255);
  if NOT Ok then ERROR('Trouble creating file');
END;

FUNCTION f21_options(head:m0_message_block;cat:cat_range;resp:Boolean):char;
{ f21_options (re)displays the bottom part of the message display
  screen, accepts a char from the user, and if acceptable,
  returns the upper case version of that char for handling
  in calling routine }
CONST
  col1 = 1;
  col2 = 26;
  col3 = 53;
VAR
  ch : char;
BEGIN
  with head do
  begin
    goto_row_col(scrn_len-2,col1); write([addr(out_ch)],clr_line);
    write([addr(out_ch)],'[DEL]ete');
    goto_row_col(scrn_len-2,col2);
    write([addr(out_ch)],'[I]mmediate response');
    goto_row_col(scrn_len-2,col3);
    write([addr(out_ch)],'[R]esponse Required : ');
    if resp then write([addr(out_ch)],'YES')
	    else write([addr(out_ch)],'NO');
    goto_row_col(scrn_len-1,col1); write([addr(out_ch)],clr_line);
    write([addr(out_ch)],'Category [1...7] : ');
    if cat=0 then write([addr(out_ch)],'none')
    else if cat=Self_msg then write([addr(out_ch)],'note')
	 else write([addr(out_ch)],cat);
    goto_row_col(scrn_len-1,col2);
    write([addr(out_ch)],'[N]ext message');
    goto_row_col(scrn_len-1,col3);
    write([addr(out_ch)],'[W]rite copy to file');
    goto_row_col(scrn_len,col1); write([addr(out_ch)],clr_line);
    write([addr(out_ch)],'toward [F]ront or [E]nd');
    goto_row_col(scrn_len,col2);
    write([addr(out_ch)],'[Q]uit');	
    goto_row_col(scrn_len,col3);
    write([addr(out_ch)],'WHICH? [ ]',bs,bs);
    REPEAT
      ch := ch_u_case(in_nech);
      if ch='D' then ch := NUL;       { Prevent 'D' from keyboard }
      if ch=DEL then ch := 'D';
		   UNTIL ch in ['0'..'7','D','E','F','I','N','Q','R','W'];
  end; { with message header }
  write([addr(out_ch)],ch);  { Briefly show what user typed }
  f21_options := ch;
END;

{ Following procedures were originally in SENDMAIL.PAS }
{ p3_accept_msg accepts message text from user 'source'
		and to the user whose list of messages
		starts with the List header pointed to by t_head }
PROCEDURE p3_accept_msg(source:string;t_head:rec_ptr; t_no:rec_ptr;
			     target:string; from_keybd:Boolean);
VAR
  empty : m0_message_block;
  msg_head_ptr,
    empty_rec_no : rec_ptr;
  ch : char;
  Ok,
   have_name,
   exists   : Boolean;
  fname     : string[14];
  on_screen,
    chars_on_line : integer;

{ internal } PROCEDURE top_of_screen_stuff;
	     BEGIN
	       writeln([addr(out_ch)]);
	       writeln([addr(out_ch)],clr_scrn);
	       writeln([addr(out_ch)],'Message to : ',target);
	       writeln([addr(out_ch)]);
	     END;

{ internal } FUNCTION pgnb(var f:Text_file):char;
(*****	     VAR	{clrbit(ch,7) DOESN'T WORK}
	       ch : char; ***************)
	     BEGIN
	       pgnb := strip_parity(gnb(f));  { Get next char from text file }
	       		       { and Strip parity bit (Good old WordStar) }
	     END;

BEGIN
    { Get an empty message block. }
      empty_rec_no := f2_get_empty_block(empty);
      msg_head_ptr := empty_rec_no;  { Keep track of 1st block
				  --this is Message Header }
      with empty do
      begin
      { Record who msg is from... }
	empty.sender := s_no;
      { If note from user to himself, mark Category as Self_msg }
	if s_no=t_no then empty.categ := Self_msg;
      { Stamp message }
	GDate(empty.date);
	GTime(empty.time);
      end; { With empty }
       
      status_report := concat('Done sending to ',indx^.n_head[t_no].name);
      if from_keybd then
	 begin
	   on_screen := 0;
	   chars_on_line := 0;
	   top_of_screen_stuff;
	   writeln([addr(out_ch)],
		   'Enter message (strike CTRL-Z to send, ESC to cancel)');
	   p11_draw_line;
	   ch := in_nech;
	   while ((ch<>ctrl_Z) AND (ch<>ESC)) do
	     begin
	       if (ch=bs) OR (ch=chr($7F)) then 
		  begin
		    if chars_on_line>0 then
		       begin
			 write([addr(out_ch)],bs,' ',bs);
			 chars_on_line := chars_on_line - 1;
			 if empty.filled>0 then
			    empty.filled := empty.filled - 1;
		    end;
		  end
	       else
		 begin
		   if ((ch>=' ') AND (ch<='~')) OR (ch=cr) then begin
		   p34_install_char(ch,empty,empty_rec_no);
		   chars_on_line := chars_on_line + 1;
		   out_ch(ch);
		   if (ch=cr) OR (chars_on_line>=sc_width) then
		      begin
			writeln([addr(out_ch)]);
			chars_on_line := 0;
			on_screen := on_screen + 1;
		      end;
		   end;
		 end;
	       ch := in_nech;
	     end;
	     p5_close_msg(empty,empty_rec_no);
	     writeln([addr(out_ch)]);
	     p11_draw_line;
	     if (ch=ESC) then 
		begin
		  writeln([addr(out_ch)],'Message Canceled');
		  p7_return_msg_to_free_list(msg_head_ptr);
		end
	     else
		begin
		  writeln([addr(out_ch)],'Sending Message');
		  seekread(msg,msg_head_ptr);	{ Pick up first blk of msg }
		  p4_insert_block_in_namelink_path(t_head,msg_head_ptr,msg^);
		end;
	 end
      else  { NOT from_keybd }
	 begin
	 { Open msg file and transfer }
	 { First get file name.  If file is not
	   on MAIL partition, try to open it.
	   If found, pump it char by char to disk. }   
	   top_of_screen_stuff;
	   writeln([addr(out_ch)],'Send Message from File Module:');
	  REPEAT
	    Ok := false;
	    writeln([addr(out_ch)]);
	    p33_get_ext_file_name(fname,false);
	    have_name := (length(fname)>0);
	    if have_name then
	       begin
		if NOT p31_ext_file_Ok(fname,exists) then
		   ERROR('Error Opening File');
		if NOT exists then
		   begin
		     writeln([addr(out_ch)]);
		     write([addr(out_ch)],'Can''t find File ',fname,' !');
		   end
		else
		   Ok := true;
	       end;
				      UNTIL Ok OR (NOT have_name);
	   if have_name then 
	      begin
		writeln([addr(out_ch)]);
		writeln([addr(out_ch)],'Sending file ',fname);
		ch := pgnb(ext);    { Get first char... }
		while (ch<>chr($1A)) do  { Look for CPM EndOfFile Explicitly }
		  begin
		    p34_install_char(ch,empty,empty_rec_no);
		    if ch=cr then
		       begin
			 REPEAT
		  	   ch := pgnb(ext);
					UNTIL (ch<>chr($0A));
			 write([addr(out_ch)],'+');	{ Show progress }
		       end
		    else
		      ch := pgnb(ext);
		  end;
		p5_close_msg(empty,empty_rec_no);
		writeln([addr(out_ch)]); writeln([addr(out_ch)]);
		writeln([addr(out_ch)],'Message Sent');
		seekread(msg,msg_head_ptr);   { Pick up first blk of msg }
		p4_insert_block_in_namelink_path(t_head,msg_head_ptr,msg^);
	     end; { Pumping file to message partition.}
	 end;	{ If from file option }
END;

{ f2_get_empty_block:  Extract a message block from the free list,
			   and return it and a pointer to it.	    }
FUNCTION f2_get_empty_block(var empty : m0_message_block) : rec_ptr;
VAR
  temp :rec_ptr;
BEGIN
  lock(indx^.free); { Lock the free head, don't return until it is locked }
  seekread(msg,indx^.free);  { Get the current free head record }
  free_head := msg^;	     { Pull it out of file buffer }
{DEBUG	writeln([addr(out_ch)],'Free_head.name_link=',free_head.name_link); }
  if free_head.name_link=null then ERROR('No more room for messages!');
(*lock(free_head.name_link); { Lock the first free record (NOT NECESSARY?)}*)
  seekread(msg,free_head.name_link);
  f2_get_empty_block := free_head.name_link;
  empty := msg^;	{ This is the first free block }
  free_head.name_link := empty.name_link;  { Reconnect free list }
  msg^ := free_head;
  seekwrite(msg,indx^.free);
  unlock(indx^.free);
{ DEBUG: Make obvious that we're getting a record   write([addr(out_ch)],'|');  }
  with empty do
    begin
       name_link := null;
       msg_link := null; { Be sure no old links remain }
       Has_been_read := false;
       Response_needed := false;
       Categ := 0;
       filled := 0;
    end;
END;

PROCEDURE p34_install_char(ch:char;
			   var blk:m0_message_block;var where:rec_ptr);
VAR
  temp : rec_ptr;
  temp_blk : m0_message_block;
BEGIN
  with blk do
    begin 
      if filled>=text_length then
	 begin
	   { Must write this block out, get another and continue }
	   temp := f2_get_empty_block(temp_blk);
	   p6_append_via_msg_link(blk,where,temp_blk,temp);
	   p5_close_msg(blk,where);
	   where := temp;
	   blk := temp_blk;
	 end;
      filled:=filled+1;
      msg_text[filled]:=ch;
    end;
END;

{ Following procedure currently used only to send an
  already constructed message.	       }
PROCEDURE p4_insert_block_in_namelink_path(t_head:rec_ptr;
			  msg_ptr:rec_ptr; blk:m0_message_block);
BEGIN
{DEBUG writeln([addr(out_ch)],'t-head,msg-ptr=',t_head,' ',msg_ptr); }
  lock(t_head);
  seekread(msg,t_head);
  blk.name_link := msg^.name_link;
  msg^.name_link := msg_ptr;
{ Add 1 to Unread msgs, 1 to Total }
  seekwrite(msg,t_head);	    { Write new header for target }
  msg^ := blk;
  seekwrite(msg,msg_ptr);	    { Write top of new message }
  unlock(t_head);		    { Path is now continuous again }
  count := count + 1;
END;

PROCEDURE p5_close_msg(blk:m0_message_block; blk_no:rec_ptr);
BEGIN
  msg^ := blk;
  seekwrite(msg,blk_no);
END;

PROCEDURE p6_append_via_msg_link(var blk:m0_message_block;where:rec_ptr;
				var empty_blk:m0_message_block;empty:rec_ptr);
BEGIN
  blk.msg_link := empty;
END;
{ End of procedures extracted from old SENDMAIL.PAS }

{ p14_send_messages accepts a single messages.
  If we already know who the message is to, targ will
  be non-null.	If it is null, we must ask.	     }
PROCEDURE p14_send_messages(targ:integer;from_keybd:Boolean); 
VAR
  user_wants_to_quit : Boolean;
  p_row, p_col : byte;
BEGIN
{ DEBUG:    writeln([addr(out_ch)],'Entering p14_send_messages with ',targ);}
  count := 0;
  writeln([addr(out_ch)],clr_scrn,'Send Mail Module');	 { Row 1 }
  writeln([addr(out_ch)]);
  user_wants_to_quit := false; 
  t_no := targ;
  if targ=null then
    begin
{Row 3} write([addr(out_ch)],'Send a Message to whom (<CR> to cancel) ?');
{row 3} write([addr(out_ch)],' [        ]');
	p_row := 3; p_col := 44;
      REPEAT
	goto_row_col(p_row,p_col);
	p35_read_and_echo_console_string(sizeof(target)-1,target,true);
	writeln([addr(out_ch)]);
	if length(target)=0 then user_wants_to_quit := true
	else
	  begin
	    t_no := f1_find_header(target);
	    if t_no=null then
	       begin
		 p26_show_names(target);
		 goto_row_col(p_row,p_col);	{ Blank bad name }
		 write([addr(out_ch)],'        ');
	       end;
	  end;
				    UNTIL (t_no<>null) OR user_wants_to_quit;
    end; { if targ unknown }
    if NOT user_wants_to_quit then
       begin
	 p3_accept_msg(source,indx^.n_head[t_no].name_link, t_no,
			    indx^.n_head[t_no].name,from_keybd);
       end
    else
	 status_report := 'Not sending after all!';
END; { p14_send_messages }

PROCEDURE p15_execute_command(var command:char);
BEGIN
  hit_a_new_one := false;
  case command of
  'A':	begin
	  p20_show_messages(msg_ptr,All);
	  command := 'W';
	end;

  'C':	begin
	  p20_show_messages(msg_ptr,Categorized);
	  command := 'W';
	end;

  'R':	begin
	  p20_show_messages(msg_ptr,Respond);
	  command := 'W';
	end;

  'N':	begin	{ Show NOTES (self sent messages) }
	  p20_show_messages(msg_ptr,Self);
	  command := 'W';
	end;

  'U':	begin	{ Show UNREAD mail }
	  p20_show_messages(msg_ptr,Unread);
	  command := 'W';
	end;

  'F':	begin	{ Send mail from FILE }
	  p14_send_messages(null,false);
	  command := 'W';
	end;

  'S':	begin	{ Send mail from Keyboard }
	  p14_send_messages(null,true);
	  command := 'W';
	end;

  'Q':	begin end;

  'W':	begin
	  command := p21_wait;
	  fst_msg_at_entry_to_Review := s_head.name_link;
	end;
    end; { Case }
END;

PROCEDURE ERROR(s:string);
BEGIN
  writeln([addr(out_ch)]);
  writeln([addr(out_ch)],s);
  writeln([addr(out_ch)],'Bye!'); writeln([addr(out_ch)]);
  @HLT;
END;
				      
BEGIN
  NUL	 := chr($00);
  ctrl_Z := chr($1A);
  esc	 := chr($1B);	  { ASCII ESC char }
  bs	 := chr($08);		{ BackSpace }
  cr	 := chr($0D);	  { CarriageReturn }
  FF	 := chr($0C);		{ FormFeed }
  lf	 := chr($0A);		{ LineFeed }
  DEL	 := chr($7F);		{ DELete   }

  c_init;	{ Set up direct BIOS calls }
  p0_open_mail_partition;
{ we are user indx^.n_head[s_no] }
  s_head := indx^.n_head[s_no];
  writeln([addr(out_ch)],clr_scrn);
  command := 'I';
  REPEAT    { Main command loop }
    if command='I' then { Initialization mode }
       begin
       { Sneak a peek at the pointer out of our header. }
	 msg_ptr := s_head.name_link;
	 seekread(msg,msg_ptr);
	 msg_ptr := msg^.name_link;
	 original_first_msg := msg_ptr;
	 if msg_ptr=null then		  { msg_ptr => First after s header } 
	    begin
	      status_report := 'You have no messages.';
	      command := 'W';  { Wait for mail }
	    end
	 else
	   begin	       { Automatically show unread messages }
	     seekread(msg,msg_ptr);
	     if NOT msg^.Has_been_read then
		begin
		  hit_a_new_one := true;
		  p20_show_messages(msg_ptr,Unread);
		  command := 'W';
		end 
	     else { Have No Unread Mail, so wait for some }
	       begin
		 status_report := 'You have no unread messages.';
		 command := 'W';
	       end;
	   end;
       end; { If in Initialize Mode }
				      { msg_ptr => next s message of concern }
       p15_execute_command(command);
					UNTIL command='Q';
{ Normal Exit }
    writeln([addr(out_ch)],clr_scrn);

END.
  
