{ This module defines Pascal callable routines
  for LOCK, UNLOCK, and COERCE (Force re-read
  of 1K read buffer) for use by MAIL system.
     3/26/82 rld
     8/3/82  rld  Added hooks for GDATE and GTIME 
     8/3/82  rld  Added CINIT, CSTAT, CONIN, OUT_CH
     4/9/83  rld  MP/M-86 case handled...		}

MODULE Mail8086;
CONST
{$Ihinet.inc}


{ Relevant CP/M-86 BIOS calls }
  BCONST	=	2;
  BCONIN	=	3;
  BCONOUT	=	4;
  dir_cons_io	=	6;
  Block 	=	$1E;
  lockack	=	0;
  Bunlock	=	$1F;
  BCoerce	=	$20;
  BHog		=	$21;
  BHDStat	=	$22;
  BTimDat	=	$23;

time_offset	=	0;
date_offset	=	3;
TYPE
  ptr = ^integer;

  BIOS_entry_table = RECORD
		      cmd  : byte;
		      case Boolean of
		        true: (CXval : integer;
		      	       DXval : integer);
			false:(CXch  : char);
		     END; { RECORD }

  address	   = RECORD
		     case Boolean of
			  true: (offset:integer;
				 segment:integer);
			 false: (p:ptr);
		     END; { RECORD and Case }

  time_array	   =  packed array [1..3] of char;

  date_array	   =  packed array [1..3] of char;
	
VAR
  table  : BIOS_entry_table;
  a	 : address;
  lock_string : string[13];
  td_buff : packed array [0..6] of char;
  dontcare : ptr;
  status,
    inpt   : byte;
  
{ Software interrupts for entry into MP/M-86 XIOS }
EXTERNAL FUNCTION H_int(func:integer; parm1:ptr):integer;
EXTERNAL FUNCTION H_int2(func:integer; parm1:ptr; parm2:integer):integer;
EXTERNAL FUNCTION BDOSbx(func:integer; parm:ptr):integer;

EXTERNAL FUNCTION @BDOS86(func:integer; parm:ptr):char;

{ call_BIOS_direct sets up a direct BIOS call to BIOS function
    func, and passes CX and DX appropriately.  }
FUNCTION call_BIOS_direct(func:integer; parm:ptr):char;
CONST
  direct_bios_call = $32;
VAR
  CX_DX : address;
BEGIN
  CX_DX.p := parm;
  table.cmd  := func;		 { BIOS function # }
  table.CXval := CX_DX.offset;
  table.DXval := CX_DX.segment;
  call_BIOS_direct := @BDOS86(direct_bios_call,addr(table));
END;

FUNCTION CPM_not_MPM:Boolean;
CONST
  GetVersNo	=	$0C;	{ Is it CP/M or MP/M? }
BEGIN
{ If CP/M-86 then return value is 00xx, if MPM, then
  	          return value is 11xx... }
  CPM_not_MPM := (abs(BDOSbx(GetVersNo,dontcare)) <= 255);
END;

PROCEDURE lock(rec_no:integer);
VAR
  resp : char;
BEGIN
  lock_string := 'mail';
  lock_string := concat(lock_string,chr(rec_no MOD 256));
  lock_string := concat(lock_string, chr(rec_no DIV 256));
  REPEAT
    if CPM_not_MPM then resp := call_BIOS_direct(Block,addr(lock_string))
		   else resp := chr(H_int(p_lock, addr(lock_string)));
						UNTIL resp=chr(lockack);
END {lock};

PROCEDURE unlock(rec_no:integer);
VAR
  resp : char;
BEGIN
  lock_string := 'mail';
  lock_string := concat(lock_string,chr(rec_no MOD 256));
  lock_string := concat(lock_string, chr(rec_no DIV 256));
  REPEAT
    if CPM_not_MPM then resp := call_BIOS_direct(Bunlock,addr(lock_string))
		   else resp := chr(H_int(p_unlock,addr(lock_string)));
					UNTIL resp = chr(lockack);
END {unlock};

PROCEDURE coerce;
VAR
  junk : char;
BEGIN
  if CPM_not_MPM then junk := call_BIOS_direct(BCoerce,dontcare);
END;

{ Get Date and Get Time use BIOS hook to get current date
  and time from master.
  td_buff:
      0    1    2    3    4    5    6
    ticks sec  min  hrs  mon  day   yr
           ^              ^            
         				}

PROCEDURE GDATE(var date:date_array);
VAR
  junk : char;
  p : integer;
BEGIN
  if CPM_not_MPM then junk := call_BIOS_direct(BTimDat,addr(td_buff))
		 else junk := chr(H_int(p_timdat,addr(td_buff)));
  for p:= 1 to 3 do
      date[p] := td_buff[p + date_offset];
END;

PROCEDURE GTIME(var time:time_array);
VAR
  junk : char;
  p : integer;
BEGIN
  if CPM_not_MPM then junk := call_BIOS_direct(BTimDat,addr(td_buff))
		 else junk := chr(H_int(p_timdat,addr(td_buff)));
  time[1] := td_buff[3]; { Hours   }
  time[2] := td_buff[2]; { Minutes }
  time[3] := td_buff[1]; { Seconds }
END;

PROCEDURE console_BIOS_direct(func:integer; ch:char; var ret:char);
CONST
  direct_bios_call = $32;
BEGIN
  table.cmd := func;
  table.CXch := ch;
  ret := @BDOS86(direct_bios_call,addr(table));
END;

PROCEDURE cinit;
{ Set up directo bios calls.  }
BEGIN
{ Nothing needs to be done in CP/M-86
  since BDOS provides for direct BIOS calls }
END;

FUNCTION cstat:byte;
VAR
  dontcare, ret : char;
BEGIN
{ Must pass $FE in DL to trigger constat }
(*  a.offset := ord($FE);
  cstat := ord(@BDOS86(dir_cons_io,a.p));*)

  console_BIOS_direct(BCONST, dontcare, ret);
  cstat := ord(ret);
END;

PROCEDURE out_ch(ch:char);
VAR
  dontcare : char;
BEGIN
(*  a.offset := ord(ch);
  dontcare := @BDOS86(dir_cons_io,a.p); *)
  
  console_BIOS_direct(BCONOUT, ch, dontcare);
END;

FUNCTION keypressed : Boolean;	   { Uses direct BIOS call to constat }
BEGIN
  keypressed := (cstat<>0);
END;

FUNCTION in_echo : char;
VAR
  ch : char;
BEGIN
  ch := in_nech;
  in_echo := ch;
  out_ch(ch);
END;

FUNCTION in_nech : char;
VAR
  dontcare, ret : char;
BEGIN
{ NOTE: This call must use a DIRECT XIOS CONIN call so that when running
  under MP/M-86, console blocking will occur.   }
  console_BIOS_direct(BCONIN, dontcare, ret);
  in_nech := ret;
END;

FUNCTION conin:char;
BEGIN
{ Pass $FF in DL to trigger conin call }
(*   a.offset := ord($FF);
     conin := @BDOS86(dir_cons_io,a.p); *)
  conin := in_echo;

END;

MODEND.
