MODULE MAILUSER;
CONST
  max_name = 64;
  sc_width = 77;	{ Max chars per line }
TYPE
  ptr = ^integer;

  rec_ptr = integer;
  
  link_type = (inter,intra);

  cat_range = 0..8;    { WARNING: 8 is Self_msg (see CONST section) }

  m1_header_block   =  RECORD
			 Name_link : rec_ptr;
			 Name : string [8];
			 Password : string [6];
			 uclr_scrn,
			   uclr_line,
			   ugoto     : string[4];
			 uoff : byte;
			 r_then_c : Boolean;
			 ur_zero,
			   uc_zero : byte;
			 uscrn_len : byte;
			 u_room_for_expansion : packed array [1..8] of char;
		       END;
  
   m4_parameter_block =  RECORD
			  unique : integer;
			  numb_names : integer;
			  iversion   : integer;
			END;
  
  m5_head	   =  RECORD
			params : m4_parameter_block;
			free   : rec_ptr;
			n_head : array [1..max_name] of m1_header_block;
		      END;
  
  m7_header_file = file of m5_head;

VAR
  indx : EXTERNAL m7_header_file;
 
EXTERNAL PROCEDURE out_ch(ch:char);


PROCEDURE  p26_show_names(bad_name: string);
VAR
  n : 0..max_name ;
  fill,
    names_on_line : integer;
BEGIN
  writeln([addr(out_ch)],'I don''t know anyone named ',bad_name,'.');
  writeln([addr(out_ch)]);
  writeln([addr(out_ch)],'             --Current Mail System User Names--');
  names_on_line := 0;
  with indx^ do
    for n := 1 to params.numb_names do
    with n_head[n] do
    begin
      if ((n-1) MOD 8)=0 then writeln([addr(out_ch)]);
      write([addr(out_ch)],Name);
      for fill:=1 to 9 - length(Name) do write([addr(out_ch)],' ');
    end;
  writeln([addr(out_ch)]);
  writeln([addr(out_ch)]);
  writeln([addr(out_ch)],'Please enter another name. (<CR> to quit)'); 
END;

MODEND.
