h31108
s 00278/00000/00000
d D 1.1 83/03/17 15:58:50 tes 1 0
c date and time created 83/03/17 15:58:50 by tes
e
u
4
U
t
T
I 1
 
 
         TITLE   'BITMAP SCAN AND DISPLAY OUTPUT PROCESSOR'
 
; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ;                                                                          ;
; ;  SCANER : SCAN AND OUTPUT one 'PLOT STRIP' from BITMAP to PRINTER        ;
; ;                                                                          ;
; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;  Revision : NOV. 14, 1982   File "SCANIT.ASM"   Version 1.0                ;
;                                                                            *
;***** MODE NOTES :  *********************************************************
;                                                                            *
;      1) BITMAP BUFFER EMPTY FLAG  11/3                                     *
;      2) Check BITMAP EMPTY FLAG : If set, then Call GLF (<cr><lf>)         *
;      3) No. of Graphic Bytes per Line COUNT : Limited to 127 bytes (7 BITS)*
;      4) Zero the 8th bit of all graphic bytes send to the printer          *
;                                                                            *
;***** MODE NOTES :  *********************************************************
;                                                                            ;
;  Scaner (pline, xw)                                                        ;
;                                                                            ;
;  Function : SCAN and OUTPUT entire 'PLOT STRIP' from BITMAP to PRINTER.    ;
;                                                                            ;
;             Actually sets up the bit patterns in graphic byte              ;
;             format and output to the printer byte by byte                  ;
;                                                                            ;
;               for j = 1 to pline   ;loop to output one strip               ;
;                 {for i = 1 to xw   ;  loop to output one line              ;
;                   { cnt = cnt + 1  ;    increment byte count               ;
;                     if cnt >= 127                                          ;
;                        reset printer byte count (call genter)              ;
;                     call bytout }  ;      transpose and output one byte    ;
;                                                                            ;
;  Input   : PLINE  - No. of print lines per plot strip                      ;
;            XW     - No. of bytes per print line                            ;
;            LSIZE  - Offset to the start of next line to output in Bitmap   ;
;                                                                            ;
;  Output  : None                                                            ;
;                                                                            ;
;  Calls   : BYTOUT - Transpose and output one byte to printer               ;
;            POUT   - Output one byte to printer port (CALL BDOS)            ;
;            GETMIN - Returns Minimum of <hl> and <de>                       ;
;----------------------------------------------------------------------------;
;
;  CALL SCANER
;  RET
;
         PUBLIC SCANER
         EXTRN  POUT, GENTER, GLF
         EXTRN  ABSHL, NEGHL, SUBDH, CMPS, CMPDH, MIDH, DIDH, IMOD
         extrn  getmin
         EXTRN  BITMAP, MAPEND, MPTY
         EXTRN  XW, NEGXW, YW, PLINE, NSTRIP, LSIZE
         EXTRN  XMAX, YMAX, XMIN, YMIN
         EXTRN  EPSON1, BWIDE
 
;----------------------------------------------------------------------------+
;        PRINTER CONSTANTS (EPSON MX-80)
;----------------------------------------------------------------------------+
 
PIXL     EQU    7                ;7 pixels printed per graphic byte
ESC      EQU    1BH              ;Escape Code
BCNT     DS     02               ;BYTE COUNTER
         page
 
 
SCANER
         LHLD   MAPEND           ;<HL> = first byte address in bitmap
                                 ;       to start scanning bit pattern
      MOV    B,     H
         MOV    C,     L
         LHLD   PLINE            ;No. of Print Lines per Strip
                                 ;PLINE = Outer loop count
 
;        for j = 1 to pline
 
JLOOP
         PUSH   H                ;Save line count
 
;        If BITMAP is EMPTY, SKIP SCANNING ENTIRE LINE
 
         LDA    MPTY
         ORA    A
         JNZ    IL0
         CALL   GLF
         JMP    JLOOP9
IL0      LHLD   BWIDE
         SHLD   BCNT             ;GET BYTE COUNT PER LINE
 
ILOOP0
         PUSH   B                ;ADDRESS OF BYTE IN BITMAP
 
;        Determine no. of bytes to send to the printer
 
         LHLD   BCNT             ;No. of bytes per Print Line
         LXI    D,     120       ;BYTE COUNT MUST BE MULTIPLE OF 8
         CALL   GETMIN           ;Graphic Byte Count for the Current Line =
                                 ;The  SMALLER VALUE OF BWIDE AND 120 IN <HL>
         SHLD   EPSON1           ;Tell the Printer No. of Graphic Bytes
         CALL   GENTER           ;to Expect
                                 ;EPSON1 / 8 = Inner loop count
;        for i = 1 to EPSON1
 
         LDA    EPSON1           ;EPSON1 / 8 = NO. OF BYTES THE PRINTER IS
         RRC                     ;EXPECTING
         RRC
         RRC
         pop    d
ILOOP    PUSH   PSW              ;Save byte count
         CALL   BYTOUT           ;Invert and Print one byte, byte address in D
         POP    PSW
         INX    D                ;Point to next byte in BITMAP
;                                  ** BYTOUT returns DE unchanged **
         DCR    A                ;Decrement byte count
                                 ;Any more bytes ?
         JNZ    ILOOP            ;Yes, Do next byte
 
         MOV    B,     D
         MOV    C,     E         ;Save Current Bitmap Address in <BC>
         LHLD   BCNT
         LXI    D,     -120
         DAD    D                ;Decrement byte count
         SHLD   BCNT
         MOV    A,     H
         ORA    H
         JP     ILOOP0
 
JLOOP9
         CALL   GLF              ;SEND <CR> <LF>
         POP    H                ;Get Line count
         DCX    H                ;Decrement line count, Done yet?
         MOV    A,     H
         ORA    L
         RZ                      ;Yes, Return
 
;        No, Update the BITMAP address pointer to start of next Print Line
 
         XCHG
         LHLD   LSIZE            ;Get the offset to start of next line
         DAD    B                ;addr = addr - XW*(PIXL+1)
         MOV    B,     H
         MOV    C,     L
         XCHG                    ;Address pointer in HL
         JMP    JLOOP            ;Go do another line
 
         page
; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ;                                                                          ;
; ;  BYTOUT : SCAN OUTPUT one BYTE from BITMAP to PRINTER                    ;
; ;                                                                          ;
; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;  bytout (nbyt)                                                             ;
;                                                                            ;
;  Function : SCAN and OUTPUT one BYTE from BITMAP to PRINTER                ;
;                                                                            ;
;             Mask out PIXL bytes of bit pattern from BITMAP (starting       ;
;             at NBYT) into graphic byte format befor output to printer      ;
;                                                                            ;
;             PIXL = No. of bits printed in each graphic byte                ;
;                    Datasouth = 6, Prism = 7                                ;
;               for i= 1 to 8 {                                              ;
;                   set mask                                                 ;
;                   call mskout(mask,byte)                                   ;
;                   output byte }                                            ;
;                                                                            ;
;  Input    : NBYT  - Starting byte position in BITMAP buffer                ;
;                                                                            ;
;  Calls    : MSKOUT - Get the desired bits from BITMAP                      ;
;             POUT   - Output one byte to printer port (BDOS function)       ;
;                                                                            ;
;----------------------------------------------------------------------------;
;
;  CALL BYTOUT
;    DE = NBYT, start address in BITMAP
;  RET
;    DE = Unchanged
;
BYTOUT
          LXI  H,   0801H     ;H=loop count, L=shift count
                              ;  shift count used by MSKOUT to rotate
                              ;  the result to printer print wire position
 
          MVI  B,   80H       ;Initialize the bit mask
 
REPEAT    MVI  C,   PIXL      ;No. of bits to Mask out
 
          PUSH D              ;Save BITMAP start address pointer NBYT
          PUSH H              ;Save counters
          CALL MSKOUT         ;Get the desired bits from BITMAP
          CALL POUT           ;Output the byte to printer
          POP  H
          POP  D              ;Restore the address pointer for MSKOUT
 
          MOV  A,   B         ;Update the bit mask to next bit position
          RRC
          MOV  B,   A
          INR  L              ;Update the shift correction count
          DCR  H              ;One more byte moved
          JNZ  REPEAT         ;Done yet ?
          RET                 ;Yes
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;  Mskout (nbyt, nbit, result)                                               ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;  Function : Mask out PIXL bits from BITMAP Buffer into one                 ;
;             printer output byte (RESULT)                                   ;
;             one bit is masked out of bytes BITMAP(nbyt), BITMAP(nbyt-      ;
;             XW*1),..., BITMAP(nbyt-XW*PIXL)                                ;
;             PIXL = No. of bits printed in each graphic byte                ;
;                   Datasouth = 6, Prism = 7                                 ;
;               for i = 1 to pixl {                                          ;
;                 bit = bitmap(nbyt) ^ mask                                  ;
;                 byte = (byte v bit)                                        ;
;                 shift byte left to make room for next bit                  ;
;                 nbyt = nbyt - (xw * pixl)  }                               ;
;                                                                            ;
;  Input    : NBYT   - Byte position to start transposing                    ;
;             NBIT   - Bit position to transpose from BITMAP                 ;
;             XW     - No. of bytes per print line (row order in buffer)     ;
;                      used to calculate offset to the same byte in next line;
;             PIXL   - No. of bits to transpose until final result           ;
;                                                                            ;
;  Output   : RESULT - Printer graphic byte with bit pattern transposed      ;
;                      from BITMAP                                           ;
;                                                                            ;
;  Calls    : None                                                           ;
;                                                                            ;
;----------------------------------------------------------------------------;
;
;  CALL MSKOUT
;    DE = NBYT, start address
;    B  = NBIT, mask
;    C  = PIXL, loop count
;    L  = Count to shift bits into correct print wire position
;  RET
;    A  = RESULT, on 'RETURN'
;    B  = unchanged mask
;    All other reg clubbered
;
;
MSKOUT
          PUSH H              ;Save away shift counter
          XCHG                ;HL points to NBYT address
          XRA  A              ;Clear work reg
 
AGAIN     RLC                 ;Make room for next bit
          MOV  E,   A         ;Save temp result
 
          MOV  A,   M         ;Get next byte from BITMAP
          ANA  B              ;Leave only the desired bit
          ORA  E              ;Combine with temp result
          XCHG                ;Current NBYT address pointer in DE
 
          LHLD NEGXW          ;Get Offset to same byte in next line
          DAD  D              ;HL Points to next byte
          DCR  C              ;Done yet ?
          JNZ  AGAIN          ;No, continue
;
;  The resulting bit pattern still needs to be rotated into correct
;  Printer wire position : LSB bits
;
          POP  H              ;Get the shift count
ROTA      RLC                 ;Rotate bits until correct position
          DCR  L
          JNZ  ROTA           ;Done yet ?
          ani  7fh            ;zero bit 8
 
          RET                 ;Return with result in A
 
          END
 
E 1
