h04225
s 00004/00004/00104
d D 1.7 83/03/30 22:44:35 mjb 7 6
c changed clipping
e
s 00002/00004/00106
d D 1.6 83/03/04 20:09:03 tes 6 5
c fixed hershey text scaling problem
e
s 00001/00001/00109
d D 1.5 83/03/02 11:32:26 tes 5 4
c modified for hshlng interface change from integer*4 to real
e
s 00004/00003/00106
d D 1.4 83/02/17 15:02:59 tes 4 3
c fixed text picking problems, mostly problems with hershey interface
e
s 00015/00026/00094
d D 1.3 83/02/08 18:38:15 mjb 3 2
c mods for changed justification globals, and no rotations allowed
e
s 00037/00019/00083
d D 1.2 83/01/20 20:53:07 tes 2 1
c Modified hershy font interface so that size corr. to viewport
e
s 00102/00000/00000
d D 1.1 83/01/20 11:11:05 tes 1 0
c date and time created 83/01/20 11:11:05 by tes
e
u
tes
mjb
U
t
T
I 1
subroutine gptxat (index)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set the text attributes associated with specified index#
#                                                                      #
#     Input Parameters:                                                #
#            none                                                      #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - device driver control                            #
#            gpsatt - Set an attribute on the current device           #
#                                                                      #
########################################################################
integer index

integer contrl(5), opcd, intin(3), ptsin(2), intout(1), ptsout(4), intin1, 
	intin2, intin3, acthgt, actwdt, k, iout
I 2
integer hhite
I 4
D 5
LONGINT xoff, yoff
E 5
I 5
D 7
real xoff, yoff
E 7
I 7
integer hshwid, hshhgt
E 7
E 5
E 4
SHORTINT tststr(2)

E 2
D 6
real radagl

E 6
D 2
integer khshfn, khshts
E 2
I 2
integer khshfn
E 2
 
include(`pltcom')
 
D 2
common /hshext/ khshfn, khshts
E 2
I 2
common /hshext/ khshfn
E 2

equivalence (contrl(OPCODE), opcd), (intin(1), intin1),
	    (intin(2), intin2), (intin(3), intin3),
	    (ptsout(2), acthgt), (ptsout(3), actwdt)

I 2
data tststr /BIGA, NUL/

E 2
DxB write (DEBUGxUNIT, 100) index
DxB 100 format (' gptxzt:', i5)
 
   #call gpsatt (SETxTEXTxFONT, nfont(index), iout)
   khshfn = nfont(index)
I 2
   if (khshfn > 1) {
      hhite = ztxsiz(index)*(xvwlng/32767.)*(yvwlng/32767.) + 0.5
      if (hhite <= 0) hhite = 1
      call hshsiz (hhite, hhite)
E 2

D 2
   # contrl(1) = SETxCHARACTERxHEIGHT
   opcd = SETxCHARACTERxHEIGHT
   contrl(VERTICESxIN) = 1
   ptsin(1) = 0
   ptsin(2) = (ztxsiz(index)/100.) * yvwlng + 0.5
   khshts = ztxsiz(index)
E 2
I 2
      # the hershy length/height is returned in device space, non-scaled
D 4
      call hshlng (khshfn-2, tststr, zchwdt, zchhgt)
      zchwdt = (hhite*zchwdt)/xvwlng
      zchhgt = (hhite*zchhgt)/yvwlng
E 4
I 4
D 7
      call hshlng (khshfn-2, tststr, xoff, yoff)
D 6
      zchwdt = (hhite*xoff)/xvwlng
      zchhgt = (hhite*yoff)/yvwlng
E 6
I 6
      zchwdt = xoff/xvwlng
      zchhgt = yoff/yvwlng
E 7
I 7
      call hshfnt (khshfn-2)
      zchwdt = hshwid(tststr)/xvwlng
      zchhgt = hshhgt()/yvwlng
E 7
E 6
E 4
      zchsiz = zchhgt * 100.0
      call hshclr (ntxclr(index))
      }
   else {
E 2

D 2
   call gzddop (contrl, intin, ptsin, intout, ptsout)
E 2
I 2
      # contrl(1) = SETxCHARACTERxHEIGHT
      opcd = SETxCHARACTERxHEIGHT
      contrl(VERTICESxIN) = 1
      ptsin(1) = 0
      ptsin(2) = (ztxsiz(index)/100.) * yvwlng + 0.5
E 2

D 2
   zchwdt = float(actwdt)/xvwlng
   zchhgt = float(acthgt)/yvwlng
   zchsiz = zchhgt * 100.0
E 2
I 2
      call gzddop (contrl, intin, ptsin, intout, ptsout)
E 2

D 2
   call gpsatt (SETxTEXTxCOLORxINDEX, ntxclr(index), iout)
E 2
I 2
      zchwdt = float(actwdt)/xvwlng
      zchhgt = float(acthgt)/yvwlng
      zchsiz = zchhgt * 100.0
E 2

D 2
   #  If the text rotation is non-zero then set character precision otherwise
   #  use string precision. Character precision is used so that the rotated
   #  text will appear in the correct location for devices which do not rotate
   #  text.
E 2
I 2
      call gpsatt (SETxTEXTxCOLORxINDEX, ntxclr(index), iout)
      }

D 3
   #  If the text rotation is non-zero then set character precision 
   #  otherwise use string precision. Character precision is used so
   #  that the rotated text will appear in the correct location for
   #  devices which do not rotate text.
E 2
 
   if (ztxrot(index) == 0.0) txtpre = 1
   else                      txtpre = 2
E 3
I 3
   # no text rotations are allowed, set to 0
E 3

   # contrl(1) = SETxCHARACTERxUPxVECTOR
   opcd = SETxCHARACTERxUPxVECTOR
   contrl(VERTICESxIN) = 0
   # intin(1) = ztxrot(index) * 10.0 + 0.5
D 3
   intin1 = ztxrot(index) * 10.0 + 0.5
D 2

E 2
I 2
  
E 2
   radagl = ztxrot(index)*.0174533
   zdx = cos(radagl)           # Set dx/dy globals
   zdy = sin(radagl)
D 2

E 2
I 2
   
E 3
I 3
   intin1 = 0
E 3
E 2
   # intin(2) = cos(radagl)
D 3
   intin2 = zdx * 100.0 
E 3
I 3
   intin2 = 100
E 3
   # intin(3) = sin(radagl)
D 3
   intin3 = zdy * 100.0 
E 3
I 3
   intin3 = 0
E 3
 
   call gzddop (contrl, intin, ptsin, intout, ptsout)

   k = njust(index)
D 3
   if (k > 6) {          # Map the character justification of 1-9 (lower left to
      txtjv = 0          #   upper right as follows:
      txtjh = k - 7      #      1 - 0,4
      }                  #      2 - 1,4        7   8   9
   else if (k > 3) {     #      3 - 2,4        4   5   6
      txtjv = 2          #      4 - 0,2        1   2   3
      txtjh = k - 4      #      5 - 1,2
      }                  #      6 - 2,2
   else {                #      7 - 0,0
      txtjv = 4          #      8 - 1,0
      txtjh = k - 1      #      9 - 2,0
E 3
I 3
   if (k > 6) {        # Map the character justification of 1-9 (lower left to
      txtjv = 2          #   upper right as follows:
      txtjh = k - 7      #      1 - 0,0
      }                  #      2 - 1,0        7   8   9
   else if (k > 3) {     #      3 - 2,0        4   5   6
      txtjv = 1          #      4 - 0,1        1   2   3
      txtjh = k - 4      #      5 - 1,1
      }                  #      6 - 2,1
   else {                #      7 - 0,2
      txtjv = 0          #      8 - 1,2
      txtjh = k - 1      #      9 - 2,2
E 3
      }
 
   return
end
E 1
