h10221
s 00043/00000/00000
d D 1.1 83/01/20 11:16:15 tes 1 0
c date and time created 83/01/20 11:16:15 by tes
e
u
tes
mjb
U
t
T
I 1
subroutine upck4b (inbyte, nible1, nible2)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Pack 2 4 bit nibles into one 8 bit byte                #
#                                                                      #
#     Input Parameters:                                                #
#            inbyte - input byte containing the two nibles to be       #
#                     returned                                         #
#                                                                      #
#     Output Parameters:                                               #
#            nible1 - byte which contains 4 bits for left half of      #
#                     input byte                                       #
#            nible2 - byte which contains 4 bits for right half of     #
#                     input byte                                       #
#                                                                      #
#     Routines Called:                                                 #
#            None                                                      #
#                                                                      #
########################################################################
SHORTINT inbyte, nible1, nible2
integer temp

# first move the byte into an integer to prevent the sign bit from interfering,
# then if the byte had its 8th bit set (negative) add 256 to bias positive,
# then shift the first nible right 4 bits (divide by 16) to obtain the first
# nible, and obtain the second nible via modulo 16 of the original integer
# thereby removing the high order nible.

temp = inbyte
if (temp < 0) temp = temp + 256
nible1 = temp/16
nible2 = mod (temp, 16)

return
end
E 1
