h17534
s 00002/00003/00105
d D 1.2 83/03/31 12:28:39 mmm 2 1
c 
e
s 00108/00000/00000
d D 1.1 83/03/15 21:35:44 tes 1 0
c date and time created 83/03/15 21:35:44 by tes
e
u
4
U
t
T
I 1
subroutine gfa (n, px, py)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Fill an area                                           #
#                                                                      #
#     Input Parameters:                                                #
#            n      - number of points   (3...n) n<=40                 #
#            px     - array of x coordinates for vertices              #
#            py     - array of y coordinates for vertices              #
#     Output Parameters:                                               #
#            none                                                      #
#     Errors:                                                          #
#            5 GKS not in proper state: GKS must be either in the      #
#              state WSAC or in the state SGOP                         #
#          100 Number of points is invalid                             #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#            gkserr - KERNEL error reporter                            #
#            gzcleg - clip a polygon against a given edge              #
#            gzddop - d/i interface to device driver                   #
#            gzwndc - transform a point from 2d world to NDC           #
#            gzndcd - transform a point from NDC to device coordinates #
#                                                                      #
########################################################################
integer n
real px(n), py(n)
 
integer i, kount, j, ptsin(82), idummy(1), contrl(5),
	iedge1, iedge2, size1, size2
real xtmp1(41), ytmp1(41), xtmp2(41), ytmp2(41),
D 2
     edge1, edge2
REALS GETREAL
E 2
I 2
     edge1, edge2, gtreal
E 2

ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

include(`gkscom') 

ifdef(`ERROR_ON',`
      rounum = GFA
      errind = errchk(ierdum(1), ierdum)
      ')

   kount = n
   if (n < 3) {
      ifdef(`ERROR_ON',`call gkserr (100)')
      return
      }
   if (n > 40) {
      ifdef(`ERROR_ON',`call gkserr (100)')
      kount = 40
      }

   # transform vertices from world to ndc space
   do i=1, kount {
D 2
      call gzwndc (GETREAL(px(i)), GETREAL(py(i)), xtmp1(i), ytmp1(i))
E 2
I 2
      call gzwndc (gtreal (px, i-1), gtreal (py, i-1), xtmp1(i), ytmp1(i))
E 2
      }
   
   # insure we have a closed polygon by copying the first point as the
   #   last point
   size1 = kount + 1
   xtmp1(size1) = xtmp1(1)
   ytmp1(size1) = ytmp1(1)
   
   iedge1 = LEFT   # Set up to clip the left and right extremes of the
   edge1 = zxleft  #   viewing area.
   iedge2 = RIGHT
   edge2 = zxrght
         
   # clip to each clipping edge as pairs, LEFT/RIGHT and TOP/BOTTOM
   do i=1, 2 {
      call gzcleg (size1,xtmp1,ytmp1,edge1,iedge1,size2,xtmp2,ytmp2)
      call gzcleg (size2,xtmp2,ytmp2,edge2,iedge2,size1,xtmp1,ytmp1)
      iedge1 = TOP   # Set up to clip the top and bottom extremes of the
      edge1 = zytop  #  viewing area.
      iedge2 = BOTTOM
      edge2 = zybotm
      }
      
   if (size1 > 2) {
      j = 1
      do i = 1, size1 {   # Convert points to device coordinates
         call gzndcd (xtmp1(i), ytmp1(i), xtmp2(i), ytmp2(i))
	 ptsin(j) = xtmp2(i)   # Store device coordinates to be shipped to dd
	 ptsin(j+1) = ytmp2(i)
	 j = j+2
	 }

      contrl(OPCODE) = FILLxAREA
      contrl(VERTICESxIN) = size1    # Number of vertices 
      call gzddop (contrl, idummy, ptsin, idummy, idummy)

      # Set screen erase flag to erase
       eraflg = YES
      }

   return
end
E 1
