h05291
s 00002/00003/00150
d D 1.2 83/03/31 12:28:53 mmm 2 1
c 
e
s 00153/00000/00000
d D 1.1 83/03/15 21:35:51 tes 1 0
c date and time created 83/03/15 21:35:51 by tes
e
u
4
U
t
T
I 1
subroutine ggdp (n, px, py, primid, il, ia)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Send device-specific information to workstation        #
#               which will then perform device-specific actions        #
#               (Generalized Drawing Primitive)                        #
#                                                                      #
#     Input Parameters:                                                #
#            n      - number of points                                 #
#            px(n), py(n) - coordinates of points in world coords.     #
#            primid - GDP identifier                                   #
#            il     - length of data record                            #
#            ia(il) - data record                                      #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Errors:                                                          #
#        5 GKS not in proper state: GKS must be either in the state    #
#          WSAC or in the state SGOP                                   #
#      100 Number of points is invalid                                 #
#      102 Generalized drawing primitive identifier is invalid         #
#                                                                      #
#     Routines Called:                                                 #
#            gzwndc - convert point from world to NDC space            #
#            gzndcd - convert point from NDC to DC space               #
#            gzddop - d/i interface to device driver                   #
#            errchk - perform appropriate error checking               #
#            gkserr - KERNEL error reporter                            #
#                                                                      #
########################################################################
integer n, primid, il, ia(1)
real px(n), py(n)
 
integer contrl(6), ptsin(40), idummy(1), i, j
real xndc, yndc, xdc, ydc, xtemp, ytemp, radius, startx, starty,
D 2
     endx, endy
REALS GETREAL
E 2
I 2
     endx, endy, gtreal
E 2

ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

include(`gkscom')
 
ifdef(`ERROR_ON',`
      rounum = GGDP
      errind = errchk(primid, ierdum)
      ')
 
      contrl(OPCODE) = GENERALIZEDxDRAWINGxPRIMITIVE
      contrl(VERTICESxIN) = n

      if (primid == BAR | primid == CIRCLE) { 
	 if (n < 2) {
	    ifdef(`ERROR_ON',`call gkserr (100)')
	    return
	    }
         if (n > 2) {
	    ifdef(`ERROR_ON',`call gkserr (100)')
	    contrl(VERTICESxIN) = 2
	    }
	 }
      if (primid == ARC | primid == PIExSLICE) {
	 if (n < 3) {
	    ifdef(`ERROR_ON',`call gkserr (100)')
	    return
	    }
         if (n > 3) {
	    ifdef(`ERROR_ON',`call gkserr (100)')
	    contrl(VERTICESxIN) = 3 
	    }
         }
      if (primid == PRINTxGRAPHICxCHARACTERS) {
	 if (n != 0) {
	    ifdef(`ERROR_ON',`call gkserr (100)')
	    contrl(VERTICESxIN) = 0
	    }
         }
      if (n > 20) {
	 ifdef(`ERROR_ON',`call gkserr (100)')
	 contrl(VERTICESxIN) = 20
	 }

      contrl(INTEGERxINxLENGTH) = il
      contrl(6) = primid

      j = 1
      for (i=1; i<=contrl(VERTICESxIN); i=i+1) {
	 # Convert points to right format
D 2
	 call gzwndc (GETREAL(px(i)), GETREAL(py(i)), xndc, yndc)
E 2
I 2
	 call gzwndc (gtreal (px, i-1), gtreal (py, i-1), xndc, yndc)
E 2
	 if (xndc < 0.0 | xndc > 1.0) return # Do not output anything
	 if (yndc < 0.0 | yndc > 1.0) return # if values out of bounds
	 call gzndcd (xndc, yndc, xdc, ydc)
	 ptsin(j) = xdc
	 ptsin(j+1) = ydc
	 j = j + 2
	 }
      
      # If GDP is an arc or pie slice (2 or 3) or a circle (4), 
      # radius must be calculated and converted to DC (0 - 32k) space

   if (contrl(6) == ARC | contrl(6) == PIExSLICE | contrl(6) == CIRCLE) {
	 # calculate the radius of the circle (arc , pie-slice)
	 xtemp = ptsin(3) - ptsin(1)
	 ytemp = ptsin(4) - ptsin(2)
	 if (ytemp == 0.0) ytemp = zeps # Check for bug in fortran lib
	 radius = sqrt(xtemp*xtemp + ytemp*ytemp)
	 if (contrl(6) == CIRCLE) {
	    ptsin(5) = radius 
	    ptsin(6) = 0
	    contrl(VERTICESxIN) = 3
	    }
         else {
	    ptsin(7) = radius 
	    ptsin(8) = 0
	    # For arc/pie-slice we must calculate the start angle and end angle
	    # We start by first normalizing the xy vector of start point and
	    # the xy vector of end point. Then we take the arc-tangent to get 
	    # the angle of equivalent of both
	    startx = xtemp / radius   # Normalize the start angle vector
	    starty = ytemp / radius 
	    xtemp = ptsin(5) - ptsin(1)
	    ytemp = ptsin(6) - ptsin(2)
	    if (ytemp == 0.0) ytemp = zeps # Check for bug in fortran lib
	    # Calculate the end angle radius and normalize
	    radius = sqrt(xtemp*xtemp + ytemp*ytemp)
	    endx = xtemp / radius
	    endy = ytemp / radius
            # ia(1) = start angle in tenths of degrees
	    ia(1) = ((atan2 (starty,startx))*57.295858) * 10.0
            # ia(2) = end angle in tenths of degrees
	    ia(2) = ((atan2 (endy,endx))*57.295858) * 10.0
	    contrl(VERTICESxIN) = 4
	    contrl(INTEGERxINxLENGTH) = 2
	    }
         }

     call gzddop (contrl, ia, ptsin, idummy, idummy)

     # Set screen erase flag to erase
     eraflg = YES
 
   return
end
E 1
