h12483
s 00003/00004/00069
d D 1.2 83/03/31 12:29:50 mmm 2 1
c 
e
s 00073/00000/00000
d D 1.1 83/03/15 21:36:33 tes 1 0
c date and time created 83/03/15 21:36:33 by tes
e
u
4
U
t
T
I 1
subroutine gicl (wkid,px,py,errind,coli)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire a cell                                         #
#                                                                      #
#     Input Parameters:                                                #
#            wkid    - workstation identifier                          #
#            px      - x point in world coordinates                    #
#            py      - y point in world coordinates                    #
#                                                                      #
#     Output Parameters:                                               #
#            errind  - error indicator                                 #
#            coli    - color index of the cell                         #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in the state      #
#               WSAC or in the state SGOP                              #
#           20  Specified workstation identifier is invalid            #
#           25  Specified workstation is not open                      #
#           37  Specified workstation is not an output workstation     #
#               nor an output/input workstation                        #
#           38  Specified workstation has no pixel store readback      #
#               capability                                             #
#                                                                      #
#     Routines Called:                                                 #
#               errchk - perform appropriate error checking            #
#               gzcell - inquire on cell array (general case)          #
#                                                                      #
########################################################################
integer wkid, errind, coli     
real px, py
 
integer colia(1), invval, idummy
D 2
real pxy(4)
REALS GETREAL
E 2
I 2
real pxy(4), gtreal
E 2

ifdef(`ERROR_ON',`
   integer errchk, ierary(1), erary1
   ')
include(`gkscom')

ifdef(`ERROR_ON',`
   equivalence (ierary(1), erary1)
   ')

   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0
   ifdef(`ERROR_ON',`
      rounum = GICL
      #   ierary(1) = wrktyp
      erary1 = wrktyp
      errind = errchk (wkid, ierary)
      if (errind !=  0) return
      ')

D 2
   pxy(1) = GETREAL(px) # Put in right format and ship
   pxy(2) = GETREAL(py)
E 2
I 2
   pxy(1) = gtreal (px, 0) # Put in right format and ship
   pxy(2) = gtreal (py, 0)
E 2
   pxy(3) = pxy(1)
   pxy(4) = pxy(2)

   call gzcell (pxy, 1, 1, invval, idummy, idummy, colia)
   if (invval == 0) coli = colia(1)

   return
end
E 1
