h49294
s 00003/00002/00109
d D 1.3 83/02/10 13:51:37 mrk 3 2
c bug in fat step graph, vertical fat lines
e
s 00000/00000/00111
d D 1.2 83/01/28 13:50:35 tes 2 1
c initial_internal_update
e
s 00111/00000/00000
d D 1.1 83/01/28 13:01:48 tes 1 0
c date and time created 83/01/28 13:01:48 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpdraw (x, y)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: output a fat line                                      #
#                                                                      #
#     Input Parameters:                                                #
#            x     - array of x vertices to be drawn to                #
#            y     - array of y vertices to be drawn to                #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gparc  - draw an arc                                      #
#            imove  - perform a 2d move                                #
#            idraw  - perform a 2d draw                                #
#                                                                      #
########################################################################
define(`ZEPS', `.00005')
 
real x, y
 
integer kount, i, gimnmx, kincr, kstyle
real  dnorm, dx, dxinc, dy, dyinc, end, radinc, radius, start, temp,
      xrast, yrast, width,
      x1, y1, x2, y2, x3, y3, x4, y4
 
include(`pltcom')

   kstyle = nlstyl

   width = zlwid
   x1 = zxabsl
   y1 = zyabsl
D 3
   #  call imove (ABSOLUTE, x1, y1)
E 3
   call idraw (ABSOLUTE, x, y)
   if (width > 0.0) {
      x2 = x
      y2 = y
D 3
      if (x1 >= x2) {
E 3
I 3
      if (x1 > x2) {
E 3
         temp = x1
         x1 = x2
         x2 = temp
         temp = y1
         y1 = y2
         y2 = temp
         }
      
      xrast = zpxlx
      yrast = zpxly
 
      dx = x2 - x1
      dy = y2 - y1
I 3
      if (dx == 0. & dy == 0.)  return   # 0 length line

E 3
      start = atan2 (-dx, dy)
      end = start + 3.14159
      dnorm = sqrt (dx**2 + dy**2)
      temp = dx
      dx = xrast*dy/dnorm
      dy = -yrast*temp/dnorm
      radinc = sqrt (dx**2 + dy**2)

      dxinc = dx
      dyinc = dy
      radius = radinc
      kount = width/radius + 1
      for (i=2; i<=kount; i=i+2) {
         kincr = radius/xrast
         kincr = gimnmx (kincr, 1, 6)
         x3 = x1 + dx
         y3 = y1 + dy
         x4 = x2 + dx
         y4 = y2 + dy
 
	 # move to the first point, probably the lower left corner
         call imove (ABSOLUTE, x3, y3)
         call idraw (ABSOLUTE, x4, y4)
         call gparc (x2, y2, radius, start, end, kincr)
         x3 = x2 - dx
         y3 = y2 - dy
         x4 = x1 - dx
         y4 = y1 - dy
 
         # If we are doing solid lines just output the line, otherwise,
         #    move to the first point and draw to the second. Then move
         #    to the end point and output the arc.
 
         if (kstyle == 1) call idraw (ABSOLUTE, x4, y4)
         else {
            call imove (ABSOLUTE, x4, y4)
            call idraw (ABSOLUTE, x3, y3)
            call imove (ABSOLUTE, x4, y4)
            }
 
         call gparc (x1, y1, radius, start+3.14159, end+3.14159, kincr)
         dx = dx + dxinc
         dy = dy + dyinc
         radius = radius + radinc
         }
      call imove (ABSOLUTE, x, y)
      }
 
   return
end
E 1
