; Released to the public domain 1-May-84. /s/ Norman L. Rogers
; President, Decmation, Inc. All are welcome to use this program
; for any use, commercial or noncommercial.
;
; fixed 1-MAY-84 not finding end of command line correctly
;; PATCH.ASM main routine
;
; copyright 1984, Decmation, Inc, 3375 Scott Bl. #422, Santa Clara, CA 95051
;
; The patch program combines a number of .HEX files to create or
; modify a .COM file. The .COM file is manipulated as a random access
; file which is an image of memory from 0100h to ...
; syntax of command:

;	A>PATCH OUTFIL=INFIL1/XXX>YYY,INFIL2/XXX>YYY, ETC.
; 
; If the file type is specified, the output file must be .COM
; and the input files .HEX. A relocation constant can be optionally
; specified for each input file. /xxx>yyy indicates that the code is
; to be relocated by a constant amount such that hex address xxx will
; map to hex address yyy. For example /fa00>fb00 will cause all code
; to be loaded 0100h bytes higher for the affected .HEX module. 
; If only one address is specifed (e.g. infil/a00) then that address
; will be added to each address in computing where the code is to be
; stored. The addition is modulo 64k.
;
; This program may be assembled with the standard CP/M assembler and it
; will accept .HEX files generated by the same assembler.
;
; If a bad checksum is encountered in a .HEX file, the line with the
; bad checksum is printed on the terminal and that line is ignored.
; On most other errors the program aborts with a message. The command
; line is printed with a pointer showing how far the execution of the 
; command has proceded. 
;
; The command of the form:
;
;   A>PATCH FILE=FILE
;
; is equivalent to the command:
;
;   A>LOAD FILE
;
; under standard CP/M. That is, it creates a file named FILE.COM from
; a file named FILE.HEX.
;
; FORMAT OF AN INTEL HEX FILE:
;
; A .HEX file consists of a variable number of lines, each terminated
; by a carriage-return, line-feed. The format of each line is as follows:
;
; :ccaaaattdddd....ddddkk
;
; ":" a colon in the first position
; cc- A 4-digit hex number giving the number of data bytes
; aaaa- A 4-digit hex number giving the load address for the cc
;       data bytes. e.g. 0000, 0001, ...fffe,ffff
; tt - record type code - ignored by this program
; dddd..- The data bytes, 2-hex digits for each byte
; kk - the checksum. Hex representation of a byte which is the sum
;      if the negation of all the other bytes. That is all the other
;      pairs of hex digits translated into binary form, including the
;      count, address and type fields.
; 
; Example of a valid hex format line:
; 
; :10FA70000000000000000000000000000000000086
;
; The above has 10h (16) data bytes. The load address is FA70. The type
; code is 00. The checksum is 86h.=-(10)-(FA)-(70)-(00)....
;
;
;
	org	0100h
	jmp	start
; space for the stack
	ds	100
stack:	db	0
	db	'copyright 1984, decmation, inc. '
	db	'released to public domain for all uses '
	db	'1-May-84 /s/ Norman L. Rogers, President '
	db	'Decmation, Inc., Santa Clara, CA 95051 '
;
;proto command string for debug (move to 80h under DDT for debug)
	db	16,' junk=junk,junk1'
;begin program
start:	lxi	sp,stack
	call	errmsg
	db	'Patch Utility Program',0
;make lower case upper and put null at end of command string
	call	inicmd	;initialize command string
; parse the output file name
	mvi	a,'C'	; specify default of .COM
	sta	deflt
	mvi	a,'O'
	sta	deflt+1
	mvi	a,'M'
	sta	deflt+2	;file type must be .COM
	mvi	b,1	;use default flag on
	lxi	d,outfcb	;pass adr of file control block
	call	filnam	;fill in fcb
	call	opout	;open output file in random access mode
; check for equal sign
; parptr is a running pointer to command line
; now just past output file specification
	lhld	parptr
	mov	a,m
	cpi	'='
	jz	pat3
;error in syntax
	call	shoerr	;show command line with pointer to position
	call	errmsg
	db	'must be equal sign',0
	jmp	aexit
;
; begin loop to parse input files and load, one after the other
;
pat3:	inx	h	;skip delimitor
	shld	parptr	;point to next file
	call	opinp	;parse on open input file
	lxi	h,0	;address offset assumed zero
	shld	adr1
	lhld	parptr	;check for / option
	mov	a,m
	cpi	'/'
	jnz	pat8	;no option
; option is of form /fa00>1f80 or /deee
pat4:	inx	h
	shld	parptr
	call	hexadr	;convert string to hex adr
	xchg
	shld	adr1	;first option address
	xchg
	shld	parptr
	mov	a,m	;see if > char
	cpi	'>'
	jnz	pat5
	inx	h
	shld	parptr
	call	hexadr	;convert second hex adr
	shld	parptr
	xchg
	shld	adr2
;compute differenc between two adr2-adr1
	lhld	adr1
;my method of negating hl
	mov	a,h
	cma
	mov	h,a
	mov	a,l
	cma
	mov	l,a
	inx	h	;negation of h
	xchg
	lhld	adr2
	dad	d	;difference
	shld	adr1	;offset
pat5:
pat8:	lhld	adr1	;offset
	call	hexmov	;move the whole file
	lhld	parptr
	mov	a,m
	cpi	','
	jz	pat3
;all done, close files
	lxi	d,outbuf
	mvi	c,26
	call	5 	;dma adr
	mvi	c,34
	lxi	d,outfcb
	call	5	;output current record
	ora	a
	jz	pat10
	call	errmsg
	db	'error writing output file at end',0
	jmp	aexit
pat10:	lxi	d,outfcb
	mvi	c,16
	call	5
	cpi	0ffh
	jnz	0
	call	errmsg
	db	'error closing output file',0
	jmp	0
adr1:	dw	0
adr2:	dw	0
;               
; UTIL1.ASM utility routines to print strings
;
; print a string ending in null, enter with hl pointing to string
; saves all registers
;
prstrng:	push h ! push b ! push d  !push psw
prst1:	mov	e,m	;get char
	mov	a,m	;check for nul
	ora	a
	jz	prst2
	mvi	c,6
	push	h
	call	5	;print one char
	pop	h
	inx	h
	jmp	prst1
prst2:	pop psw ! pop d ! pop b ! pop h
	ret
;
; print a carriage return line feed, saves all regs
;
pcrlf:	push	h
	lxi	h,crlf
	call	prstrng
	pop	h
	ret
crlf:	db	13,10,0	;crlf with term null
;
;
; print an error message terminated by null in inline code
; this routine inserts the crlf
;
ersavm:	dw	0	;save pointer
ersavh:	dw	0	;save hl reg
;
errmsg:	shld	ersavh	;save h
	pop	h	;return address, points to string
	shld	ersavm
	push	psw
ermsg1:	mov	a,m	;byte of message
	ora	a	;null for end
	jz	ermsg2
	inx	h
	jmp	ermsg1	;find end of string
ermsg2:	inx	h	;point to continuing code
	pop	psw	;restore
	push	h	;new return address past message
	lhld	ersavm	;point to start of message
	call	prstrng
	call	pcrlf
	lhld	ersavh	;restore h
	ret		;back to ins after message
;
; utility to set up to parse command line at 80h
; includes utilit to print command line with pointer
; to point parsing when bad
; parptr is the parsing pointer 
;
cbuf	equ	081h
parptr:	dw	0
;
inicmd:	lda	cbuf-1	;byte count
	lxi	h,cbuf+1	;first non blank byte
	shld	parptr
	dcx	h
;find end of string and insert null to terminate
	mov	e,a	;fixed 1-may-84
	mvi	d,0
	dad	d	;points to last+1
	xra	a
	mov	m,a	;store null
;convert all lower case to upper
	lda	cbuf-1
	ora	a
	rz		;if nothing
	lhld	parptr
inicmd1:	mov	a,m	;get byte
	ora	a
	jz	inicmd4	;if end
	cpi	'a'	;less than 'a'
	jc	inicmd3	;jmp if yes
	cpi	'z'+1	;larger than 'z'
	jnc	inicmd3	;jmp if yes
	ani	05fh	;force to upper case
	mov	m,a	;put back
inicmd3:	inx	h	;next
	jmp	inicmd1
inicmd4:	lda	cbuf-1
	ora	a
	ret		;exit
;
;
; utility to show parsing error, uses parptr to point to
; place in string where parsing stopped
;
; saves all regs
;
shoerr:	push h ! push b ! push d ! push psw 
	lxi	h,cbuf
	call	prstrng
	call	pcrlf
	lxi	h,cbuf
	lda	parptr
	sub	l	;number of spaces
shoerr1:	ora	a
	jz	shoerr3
	push	psw
	mvi	e,' '	;space print
	mvi	c,6
	call	5
	pop	psw
	dcr	a
	jmp	shoerr1	;print a spaces
shoerr3:	mvi	e,'^'	;pointer
	mvi	c,6
	call	5
	call	pcrlf
	pop psw ! pop d ! pop b ! pop h
	ret
;          
; utility routines for converting hex numbers
;
; converts 2 hex digits to byte in a
; enter with hl pointing to digit string
; steps hl by 2
; carry set and a=0 if non-hex digit encountered
; hl still stepped by 2 if error
;
hexby:	push	b
	mov	a,m	;get first digit
	call	chex	;convert
	jc	hexby5	;error if carry
	stc !cmc
	ral ! ral ! ral ! ral
	mov	b,a	;stash in b
	inx	h
	mov	a,m
	inx	h
	call	chex	;convert next digit
	jc	hexby6	;not hex digit
	ora	b	;meld together
	pop	b
	stc ! cmc
	ret
hexby5:	inx	h ! inx h
hexby6:	stc	;error exit
	pop	b
	ret
;
;
;convert a single hex character in a to a 4-bit binary 
; value
; carry set and a unchanged if illegal hex digit
;
chex:	ani	07fh
	cpi	'0'
	jc	chexe	;if less than 0
	cpi	'9'+1
	jc	chex1	;if less than ok
	cpi	'A'
	jc	chexe	;illegal
	cpi	'F'+1
	jnc	chexe	;if greater than 'F'
;A-F
	sui	55
	stc ! cmc ! ret
chex1:	sui	'0'
	stc ! cmc! ret
chexe:	stc ! ret
;
;
; convert character string to hex address
; enter with hl pointing to string, return address in de
; string terminated by non-hex character
; hl left pointing at terminator
;
;
hadr:	dw	0
;
hexadr:	push	h
	lxi	h,0
	shld	hadr	;assume address 0 default
	pop	h	;ptr to char string
hexa1:	mov	a,m	;get char
	push	h
	lhld	hadr
	call	chex	;convert 4 bits
	jc	hexa3	;terminator encountered
	call	hexs	;add 4 bits to hl
	shld	hadr	;save
	pop	h
	inx	h	;step ptr
	jmp	hexa1	;next char
hexa3:	lhld	hadr
	xchg		;result
	pop	h	;advanced hl
	ret
;
; utility to shift 4-bits to hl from a
;
hexs:	push	b
	mvi	b,4	;count
	stc !cmc
	ral ! ral ! ral ! ral
hexs1	dad	h	;shift hl left
	ral
	jnc	hexs2
	inx	h	;set least bit of hl
hexs2:	dcr	b
	jnz	hexs1	;loop 4 times
	pop	b
	ret
;
; UTIL4.ASM ROUTINE TO PARSE A FILE NAME
;
; use variable parptr to point to parsed string
; de points to fcb 36 chars long
; if b#0 then file must by type given in string deflt
;
; steps parptr
;
deflt:	db	0,0,0
defflg:	db	0
fcbptr:	dw	0
;
filnam:	xchg
	shld	fcbptr
	mov	a,b
	sta	defflg	;default flag code
;init fcb
	xra	a
	mov	m,a	;zero disk num
	inx	h
; init file name field to blanks
	mvi	b,11	;file name
	mvi	a,' '
fnam1:	mov	m,a
	inx	h
	dcr	b
	jnz	fnam1
	xra	a
;init rest of fcb (24 bytes) to zeros
	mvi	b,24
fnam2:	mov	m,a
	inx	h
	dcr	b
	jnz	fnam2
;fcb now inited
;check for explicit file name
; use parptr which points to file name in ascii
	lhld	parptr
	inx	h
;check for explicit disk name e.g. A:
	mov	a,m
	cpi	':'
	jnz	fnam4
;here for explicit disk name
	dcx	h
	mov	a,m	;get disk code
	inx	h !inx h	;skip past disk name
	shld	parptr
	lhld	fcbptr
	ani	0fh	;A:, B:, etc goes to 1, 2, etc.
	mov	m,a	;put in fcb
; parse file name 8 bytes
fnam4:	lhld	fcbptr
	inx	h
	xchg
	lhld	parptr
	mvi	b,9	;limit for name
fnam5:	mov	a,m	;get byte
	call	ckterm	;see if end of name
	jc	fnam6
	stax	d
	inx	h
	inx	d
	dcr	b
	jnz	fnam5
;error
	shld	parptr
fnam55:	call	shoerr
	call	errmsg
	db	'file name too long',0
	jmp	aexit
;utility to check for termination of file name
;file name may be terminated by .=/, or null
;carry set if terminator encountered
ckterm:	cpi	'.'
	jz	ckterm2
	cpi	'='
	jz	ckterm2
	cpi	'/'
	jz	ckterm2
	cpi	0
	jz	ckterm2
	cpi	','
	jz	ckterm2
	stc !cmc
	ret
ckterm2:	stc
	ret
;
fnam6:	cpi	'.'	;file type following?
	jnz	fnam10	;no
; must parse file type code (3-characters)
	inx	h	;skip past period
	shld	parptr
	lhld	fcbptr
	lxi	d,9
	dad	d	;point to type field
	xchg
	lhld	parptr
	mvi	b,4	;limit for type
fnam7:	mov	a,m
	call	ckterm
	jc	fnam8
	stax	d
	inx	h
	inx	d
	dcr	b
	jnz	fnam7
	shld	parptr	;error
	jmp	fnam55
fnam8:	shld	parptr
; check for legal file type
; type must be identical to default field if defflg non zero
	lda	defflg	;see if default specified
	ora	a
	jz	fnam13	;no
	dcx	d
	lxi	h,deflt+2
	mvi	b,3	;count
fnam9:	ldax	d
	cmp	m
	jnz	fnam95
	dcx	d
	dcx	h
	dcr	b
	jnz	fnam9
	jmp	fnam13	;ok
fnam95:	call	shoerr
	call	errmsg
	db	'wrong file type, output must be .COM, input .HEX',0
	call	aexit
; insert default file type when not specified
fnam10:	shld	parptr
	lhld	fcbptr
	lxi	d,9
	dad	d	;point to file type
	xchg
	lxi	h,deflt
	mvi	b,3
fnam11:	mov	a,m
	stax	d
	inx	h
	inx	d
	dcr	b
	jnz	fnam11
fnam13:	ret
;
;abnormal exit
;
aexit:	call	errmsg
	db	'abnormal exit',0
	jmp	0
;
; UTIL5.ASM  routine to open output file in random access mode
;
outfcb:	ds	36
curadr:	dw	0100h	;current virtual address base
outbuf:	ds	080h	;data buffer
;
opout:	lxi	h,outbuf	;zero output buffer
	mvi	c,128
	xra	a
opout1:	mov	m,a	;zero buffer
	inx	h
	dcr	c
	jnz	opout1
; try to open existing file
	lxi	d,outfcb
	mvi	c,15	;open existing file
	call	5
	cpi	0ffh
	jnz	opout5	;if exists, not ff returned
;file does not exist, so make a file
	lxi	h,outfcb	;re-zero last 24 bytes of fcb
	lxi	d,12
	dad	d
	mvi	c,24
	xra	a
opout3:	mov	m,a	;zero fcb
	inx	h
	dcr	c
	jnz	opout3
;do a make file operation
	lxi	d,outfcb
	mvi	c,22
	call	5
	cpi	0ffh
	jnz	opout5	
	call	shoerr
	call	errmsg
	db	'no directoy space to open file',0
	call	aexit
;read the first record of the com file and set address to 0100h
opout5:	lxi	d,outbuf	;dma adr
	mvi	c,26	;set dma address
	call	5
	lxi	d,outfcb
	mvi	c,33	;read random record zero
	xra	a
	sta	outfcb+33
	sta	outfcb+34	;zero record number
	call	5
	cpi	3
	jz	oper1
	cpi	6
	jz	oper2
;read ok here	errors for unwritten data accepted
	lxi	h,0100h	;first record corresponds to 0100h
	shld	curadr
	ret
oper1:	call	shoerr
	call	errmsg
	db	'cannot close current extent',0
	jmp	aexit
oper2:	call	shoerr
	call	errmsg
	db	'seek past physical end of disk',0
	jmp	aexit
;
;
; call to insert one byte at random in the output file
;
; enter with address in hl, byte in a
;
pubyte:	push	psw
	push	h
;set lower 7 bits of address to zero see if same as curadr
; if so the record is in buffer and no read required
	mov	a,l
	ani	080h
	mov	l,a
	lda	curadr	;least
	cmp	l
	jnz	pub5	;not current page
	lda	curadr+1	;most byte
	cmp	h
	jnz	pub5
; upper and lower address bytes agree here
; compute location in buffer to put byte
; use least 7 bits as offset
	pop	d	;get address
	mov	a,e
	ani	07fh	;least 7 bits
	mov	e,a
	xra	a
	mov	d,a
	lxi	h,outbuf
	dad	d	;pointer into buf
	pop	psw	;char
	mov	m,a	;stash
	ret
;here to write out previous record and read in new record
; then double back to entry point to stash byte
;
pub5:	lxi	d,outbuf
	mvi	c,26
	call	5	;set dma adr
	lxi	d,outfcb
	mvi	c,34	;write random
	call	5
	ora	a
	jz	pub6
	call	errmsg
	db	'error writing output file',0
	call	aexit
pub6:	pop	h	;get output address
	push	h	;save
	lxi	d,-0100h	;offset
	dad	d
;hl has record number times 128
;my method to shift 7 places
;
	mov	a,l	;least bit in high
	ral		;least bit in c
	mov	a,h
	ral
	mov	l,a	;least 8 bits
	mvi	a,0
	ral
	mov	h,a
	mov	a,l
	sta	outfcb+33	;random record num to fcb
	mov	a,h
	sta	outfcb+34
	pop	h
	push	h
;compute base address of this 128 byte page
	mov	a,l
	ani	080h
	mov	l,a	
	shld	curadr	;current address
;read the needed page
	mvi	c,33	;random read
	lxi	d,outfcb
	call	5
	cpi	3
	jz	oper1	;erro
	cpi	6
	jz	oper2
	cpi	0
	jz	pub8
;must zero buffer if this page unwritten data (nothing read)
	mvi	c,128
	lxi	h,outbuf
	xra	a
pub7:	mov	m,a
	inx	h
	dcr	c
	jnz	pub7
;now double back with the right page in buffer
pub8:	pop	h
	pop	psw
	jmp	pubyte	;go let start of program insert byte
;
; UTIL6.ASM  routine to open input file
;
inpfcb	ds	36
inpbuf	ds	128
inpptr	dw	0
;
opinp:	mvi	b,1	;flag to signal filnam use default type
;set the required or default file type to .HEX
	mvi	a,'H'
	sta	deflt
	mvi	a,'E'
	sta	deflt+1
	mvi	a,'X'
	sta	deflt+2
	lxi	d,inpfcb	;point to fcb
	call	filnam	;fill in fcb parsing file name from buffer
	lxi	d,inpfcb
	mvi	c,15	;open file
	call	5
	cpi	0ffh
	jnz	opinp3
;file not found
	call	shoerr
	call	errmsg
	db	'cant find input file',0
	jmp	aexit
opinp3:	lxi	d,inpbuf
	mvi	c,26	;set dma adr
	call	5
	lxi	d,inpfcb
	mvi	c,20	;read sequential first record of file
	call	5
	ora	a
	jz	opinp5
;zero length file
	call	shoerr
	call	errmsg
	db	'zero length file',0
	jmp	aexit
opinp5:	lxi	h,0	;initialize byte index to zero this buffer
	shld	inpptr
	ret
;
; code to get next byte from input file
; returns carry set if end of file
;
inbyte:	push	h
	push	d
	push	b
	lhld	inpptr
	mov	a,l
	cpi	080h
	jc	inby5	;record is in memory if ptr not yet at end
; must read the next record
	mvi	c,26	;set dma address
	lxi	d,inpbuf
	call	5
	mvi	c,20	;read sequential
	lxi	d,inpfcb
	call	5
	ora	a
	jz	inby3
; end of file encountered, exit with carry set
inbyexa:	stc
inbyex:	pop b ! pop d ! pop h
	ret
inby3:	lxi	h,0	;reset index to start of buffer
	shld	inpptr
inby5:	lxi	d,inpbuf
	dad	d	;point to address
	mov	a,m
	cpi	01ah	;ctrl-z?
	jz	inbyexa	;eof
	lhld	inpptr
	inx	h
	shld	inpptr
	stc !cmc	;exit with carry off byte returned
	jmp	inbyex	;exit
;
;
; code to get a line from input file
;
; returns with carry set if end of file
;
lincnt:	db	0
linbuf:	ds	80	;line buffer, up to 80 bytes
;
getlin:	mvi	b,79	;count of max line length
	lxi	h,linbuf
	mvi	c,0	;line count
getl1:	call	inbyte
	rc
	cpi	13	;carriage return?
	jz	getln6
	mov	m,a	;put away byte in line buffer
	inr	c	;inc count of bytes
	inx	h	;inc buf ptr
	dcr	b	;limit on bytes
	jnz	getl1
	call	shoerr
	call	errmsg
	db	'line too long  in input file',0
	jmp	aexit
getln6:	call	inbyte	;skip line feed
	rc
	xra	a
	mov	m,a	;null at end of line
	mov	a,c
	sta	lincnt
	ora	a
	jz	getlin	;if zero length line, try again
	stc !cmc
	ret
;
; code to get a hex line from input file and do checksum.
; lines which don't start with ":" are ignored without comment.
; lines which have a bad checksum are ignored with message.
; returns byte count in c, count of binary bytes.
; returns carry if end of file.
hexbuf:	ds	40
hexcnt:	db	0
;
hexlin:	call	getlin
	rc		;carry for end of file
	lxi	h,linbuf
	mov	a,m
	cpi	':'
	jnz	hexlin	;continue if not hex record
	inx	h	;point to first byte
	lxi	d,hexbuf
	mvi	c,0	;count of bytes
hexl2:	call	hexby	;check to see if hex digit, convert 2
;digits to binary byte in A
	jc	hexl5	;jump if not, should be carriage return
	stax	d	;stash byte
	inr	c
	inx	d
	jmp	hexl2
hexl5:	push	b	;save count
	lxi	h,hexbuf	;do checksup
	dcr	c
	mvi	b,0	;checksup
;loop over all bytes except last (checksum) summing negations
hexl4:	mov	a,m
	cma
	inr	a	;negation
	add	b
	mov	b,a	;sum
	inx	h	;step input ptr
	dcr	c	;count
	jnz	hexl4
	mov	a,b	;checksum
	cmp	m	;see if matches existing sum at end of line
	jz	hexl6
;checksum error
	pop	b
	call	errmsg
	db	'checksum error, line ignored',0
	lxi	h,linbuf
	call	prstrng
	call	pcrlf
	jmp	hexlin	;ignore bad line, continue
hexl6:	pop	b
	stc !cmc	;carry clear, not eof
	ret
;
; routine to move a hex file to output file
;
; enter with word address offset in hl
;
hexoff:	dw	0
;
hexmov:	shld	hexoff
hexm1:	call	hexlin	;get and checksum a hex line
	rc		;return on end of file
	lxi	d,hexbuf	;point to hex line in binary
	ldax	d	;get data count byte
	ora	a
	jz	hexm1	;if no data continue
	mov	c,a	;data count
	inx	d
	ldax	d
	mov	h,a	;most load address
	inx	d
	ldax	d
	mov	l,a	;least address
	push	d
	xchg
	lhld	hexoff
	dad	d	;add in offset
	pop	d
	inx	d
	inx	d	;record type byte ignore
;loop over data bytes in hex line
hexm3:	ldax	d	;data byte
; check for store to address 00h to ffh (illegal)
	push	psw
	mov	a,h	;high address
	ora	a
	jnz	hexm33	;jmp if ok
	push	h
	push	b
	push	d
	call	errmsg
	db	'store to address between 00 and 0ffh ignored',0
	pop	d
	pop	b
	pop	h
	pop	psw
	jmp	hexm34
hexm33:	pop	psw
	push	h
	push	d
	push	b
	call	pubyte
	pop	b
	pop	d
	pop	h
hexm34:	inx	h
	inx	d
	dcr	c
	jnz	hexm3
	jmp	hexm1	;continue until end of file

e other
s	100
stack:	db	0
	db	'copyright 1984, decmation, syntax
	call	shoerr	;show command line with pointer to pos