; CUSTOM BIOS FOR MOVE-IT USING NEW MODEM CALLS
; 30-MAY-84
; COPYRIGHT 1984 DECMATION, INC.
;
	ORG	0100H
	JMP	0302H	;START MOVEIT
	JMP	04000H	;POINT TO FREE AREA
	JMP	INITI	;INITIALIZE MODEM PORT
	JMP	FINISH	;DEINITIALIZE MODEM PORT
	JMP	INSTA	;INPUT STATUS
	JMP	INDAT
	JMP	OUTSTA	;OUTPUT STATUS
	JMP	OUTDAT	;OUTPUT A CHARACTER
	JMP	CNFGMS	;CONFIGURATION MESSAGE
	JMP	DIAL	;NOT IMPLEMENTED
;
INITI:	PUSH PSW ! PUSH H ! PUSH D ! PUSH B
	CALL	INIMDM
	POP B ! POP D ! POP H ! POP PSW
	RET
FINISH:	PUSH PSW ! PUSH H! PUSH D! PUSH B
	CALL	DINIM
	POP B! POP D! POP H! POP PSW
	RET
INSTA:	PUSH H! PUSH D! PUSH B
	CALL	TESTI
INSTA2:	POP B! POP D! POP H
	RET
INDAT:	PUSH H! PUSH D! PUSH B
	CALL	INCHAR
	JMP	INSTA2
OUTSTA:	PUSH H! PUSH D! PUSH B
	CALL	TESTO
	JMP	INSTA2
OUTDAT:	PUSH	B
	MOV	C,A	;CHAR OUT
	PUSH PSW! PUSH H! PUSH D
	CALL	OUTCHR
	POP D! POP H! POP PSW!POP B
	RET
;
CNFGMS:	DB	'     DECMATION SERIAL '
	DB	'PORT 5-30-84',0DH,0AH,0AH,'$'
DIAL:	RET
;
; code to work 2 circular buffers for modem I/O
; BUFFER STRUCTURE TO INPUT FROM 11
INPTRI:	DB	0
OTPTRI:	DB	0
BUFI:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; BUFFER STRUCTURE TO OUTPUT TO 11
INPRTO:	DB	0
OTPRTO:	DB	0
BUFO:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;TEST CALLS RETURN A=FF FOR READY, 00 FOR NOT READY
; TEST IF OUTPUT BUFFER HAS SPACE AVAILABLE
TESTO:	LHLD	INPRTO
	MOV	A,L
	INR	A
	ANI	63	;BUFFER MODULO 64
	CMP	H	;IF INPTR+1=OUTPTR BUFFER IS FULL
	JNZ	TESTO2
TESTO1:	XRA	A	;SIGNAL NO SPACE AVAILABLE
	RET
TESTO2:	MVI	A,0FFH	;SIGNAL SPACE AVAILABLE
	ANA	A
	RET
;TEST IF THERE IS DATA IN INPUT BUFFER
TESTI:	LHLD	INPTRI
	MOV	A,L
	CMP	H
	JZ	TESTO1	;IF INPTR=OUTPTR THE BUFFER IS EMPTY
	JMP	TESTO2	;IF INPTR#OUTPTR THERE IS DATA IN BUFFER
; CODE TO INPUT 1 CHARACTER FROM INPUT BUFFER
; RETURNS CHARACTER IN A
INCHAR:	LXI	H,BUFI
	LDA	OTPTRI
	MOV	E,A
	XRA	A
	MOV	D,A	;DE HAS OFFSET INTO BUFFER
	DAD	D	;HL POINTS TO CHARACTER
	MOV	B,M	;CHAR TO B
	MOV	A,E	;BUFFER POINTER
	INR	A
	ANI	63	;+1 MODULO 64
	STA	OTPTRI
	MOV	A,B	;CHAR RECEIVED
	RET
; CODE TO OUTPUT 1 CHARACTER FROM C TO OUTPUT BUFFER
OUTCHR:	LXI	H,BUFO
	LDA	INPRTO
	MOV	E,A
	XRA	A
	MOV	D,A	;DE HAS OFFSET
	DAD	D	;HL HAS ADDRESS OF SPACE
	MOV	M,C	;CHAR FROM C TO BUFFER
	MOV	A,E
	INR	A
	ANI	63	;STEP POINTER MODULO 64
	STA	INPRTO
	RET
; CALL TO SELDSK FOR SPECIAL CALLS
SELDSK:	PUSH	H
	PUSH	D
	LHLD	1	;WARM BOOT ADDRESS
	LXI	D,01BH-3
	DAD	D	;CALL ADDRESS IN HL
	SHLD	SELD1+1	;SET UP CALL
	POP	D
	POP	H
	MVI	C,16	;SPECIAL CODE
SELD1:	JMP	0
; CALL TO INITIALIZE THE MODEM PORT
INIMDM:	MVI	D,2	;INITIALIZE CODE
	MVI	B,21	;MODEM OUT CODE
	CALL	SELDSK
	MVI	D,4	;ATTACH TO CIRCULAR BUFFER OUTPUT TO 11
	MVI	B,21
	LXI	H,INPRTO
	CALL	SELDSK
	MVI	D,4	;ATTACH BUFFER INPUT FROM 11
	MVI	B,20
	LXI	H,INPTRI
	JMP	SELDSK
; CALL TO DEINITIALIZE MODEM PORT
DINIM:	MVI	D,3
	MVI	B,21	;MODEMOUT CODE
	JMP	SELDSK
DEMOUT CODE
	JMP	SELDSK

,0,0,0	; 64 byte 