       TITLE SET CLOCK PROGRAM
*********************************************************
*                                                       *
*     SET CLOCK PROGRAM FOR BIG-BOARD                   *
*                                                       *
*     PROGRAMMED BY DON RETZLAFF - 1/29/81              *
*                                                       *
*     PROGRAM SETS YEAR, MONTH, DAY, HOUR, MIN, SEC     *
*     TWO DIGITS MUST BE ENTERED FOLLOWING EACH QUERY   *
*     INSERT LEADING 0 IF NECESSARY                     *
*     C/R ENTERS ZERO                                   *
*                                                       *
*********************************************************
*
       PSECT ABS
       ORG  0100H
*
**  EQUATED SYMBOLS
*
CONST  EQU  0F006H       ;CONSOLE INPUT STATUS TEST
CONIN  EQU  0F009H       ;CONSOLE INPUT ROUTINE
CONOUT EQU  0F00CH       ;CONSOLE
CR     EQU  0DH          ;C/R
LF     EQU  0AH          ;L/F
EOT    EQU  04H          ;END OF TABLE
BELL   EQU  07H          ;BELL
BSPACE EQU  'H'-64       ;BACK SPACE
YEAR   EQU  0FF5FH       ;ADRS OF YEAR
MONTH  EQU  0FF60H       ;ADRS OF MONTH
DAY    EQU  0FF61H       ;ADRS OF DAY
HOUR   EQU  0FF62H       ;ADRS OF HOU
MIN    EQU  0FF63H       ;ADRS OF MIN
SEC    EQU  0FF64H       ;ADRS OF SEC
*
**  PRINT ENTER YEAR, MONTH, DAY, HOUR, MIN
*
       CALL PNEXT        ;PRINT "ENTER YEAR"
       DEFB CR,LF
       DEFM 'ENTER YEAR  '
       DEFB BELL,EOT
       CALL GET2D        ;GET 2 DIGITS - YEAR
       LD   (YEAR),A     ;STORE YEAR
       CP   0            ;CHECK IF 0
       JR   Z,HR-$       ;YES GO TO HOUR
*
       CALL PNEXT        ;PRINT "ENTER MONTH"
       DEFB CR,LF
       DEFM 'ENTER MONTH '
       DEFB BELL,EOT
       CALL GET2D        ;GET 2 DIGITS - MONTH
       LD   (MONTH),A    ;STORE MONTH
*
       CALL PNEXT        ;PRINT "ENTER DAY"
       DEFB CR,LF
       DEFM 'ENTER DAY   '
       DEFB BELL,EOT
       CALL GET2D        ;GET 2 DIGITS - DAY
       LD   (DAY),A      ;STORE DAY
*
HR     EQU  $
       CALL PNEXT        ;PRINT "ENTER HOUR"
       DEFB CR,LF
       DEFM 'ENTER HOUR  '
       DEFB BELL,EOT
       CALL GET2D        ;GET 2 DIGITS - HOUR
       LD   (HOUR),A     ;STORE HOUR
*
       CALL PNEXT        ;PRINT "ENTER MIN"
       DEFB CR,LF
       DEFM 'ENTER MIN   '
       DEFB BELL,EOT
       CALL GET2D        ;GET 2 DIGITS - MIN
       LD   (MIN),A      ;STORE MIN
*
       LD   A,0          ;CLEAR SECONDS
       LD   (SEC),A
       RET
*
**  ROUTINE TO GET 2 DIGITS AND CONVERT TO BINARY
*
GET2D  EQU  $
       CALL GETDIG       ;GET 10'S DIGIT
       CP   CR           ;CHECK FOR C/R
       JR   Z,CREXT-$    ;YES
       LD   B,A          ;SAVE 10'S DIGIT
       CALL GETDIG       ;GET 1'S DIGIT
       CP   CR           ;CHECK FOR C/R
       JR   Z,CREXT-$    ;YES
       LD   C,A          ;SAVE 1'S DIGIT
*
**  MULTIPLY 10'S DIGIT BY 10
*
       LD   A,B          ;GET 10'S DIGIT
       SLA  A            ;MULTIPLY BY 8
       SLA  A
       SLA  A
       ADD  A,B          ;ADD 10'S DIGIT TWICE
       ADD  A,B
*
       ADD  A,C          ;ADD 1'S DIGIT
       RET
*
CREXT  EQU  $
       LD   A,0          ;SET VALUE TO ZERO
       RET
*
**  ROUTINE TO GET DIGIT
*
GETDIG EQU  $
       CALL CONIN        ;INPUT A CHARACTER
       PUSH AF
       CALL CONOUT       ;ECHO IT
       POP  AF
       CP   CR           ;CHECK FOR C/R
       RET  Z            ;YES
       CP   BSPACE       ;CHECK FOR BACK SPACE
       JR   Z,GET2D-$    ;YES - GET DIGITS AGAIN
       CP   030H         ;CHECK IF >= ASCII 0
       JR   C,BADCHR-$   ;< ERROR
       CP   03AH         ;CHECK <= ASCII 9
       JR   NC,BADCHR-$  ;> ERROR
       AND  0FH          ;MASK OUT ASCII BITS
       RET
*
BADCHR EQU  $
       CALL PNEXT        ;DELETE LAST CHARACTER
       DEFB BSPACE,BELL,EOT
       JP   GETDIG       ;TRY AGAIN
*
**  PRINT MESSAGE ROUTINE - PRINT ASCII CHARACTER STRING
**  FOLLOWING CALL STMT UNTIL EOT IS ENCOUNTERED IN STRING
*
PNEXT  EQU  $
       EX   (SP),HL      ;GET RETURN ADRS
       CALL PMSG         ;PRINT MESSAGE
       EX   (SP),HL      ;SETUP NEW RETURN ADRS
       RET
*
PMSG   LD   A,(HL)       ;GET CHARACTER
       INC  HL           ;BUMP POINTER
       CP   EOT          ;CHECK FOR END OF TABLE
       RET  Z            ;DONE
       CALL OUTPUT       ;OUTPUT CHARACTER
       JR   PMSG-$       ;GET NEXT CHARACTER
*
**  OUTPUT ROUTINE
*
OUTPUT EQU  $
       CALL CONOUT       ;OUTPUT CHAR
       CALL CONST        ;SEE IF INPUT IS PENDING
       JR   Z,OUTP01-$   ;NO - OUTPUT NEXT CHAR
       CALL CONIN        ;GET CHARACTER - THROW AWAY
OUTP01 EQU  $
       RET
       END
