/*
	CB2ASCII - convert archive column-binary card to display ASCII.

			   The program takes two arguments - input archive filename
												 output ASCII filename
*/

#include <stdio.h>
#include <string.h>
#include "cvtables.h"

void main(int argc, char *argv[])
{
	int i;
	int j;
	char code;
	char eof;
	FILE *iF;
	FILE *oF;
	char iN[80];
	char oN[80];
	int lp;
	char ch;
	char Line[256];

	lp = 0;
	eof = EOF;

	printf("Convert archive column-binary to display ASCII.\n");

	if (argc > 1) {
		strcpy(iN, argv[1]);
	} else {
		strcpy(iN, "input.crd");
	}
	printf("  Input file: %s\n", iN);
	iF = fopen(iN, "r");
	if (iF == 0) {
		printf("No such input file - %s\n", iN);
		exit();
	}

	if (argc > 2) {
		strcpy(oN, argv[2]);
	} else {
		strcpy(oN, "output.asc");
	}
	printf("  Output file: %s\n", oN);
	oF = fopen(oN, "w");
	if (oF == 0) {
		printf("Cannot open output file - %s\n", oN);
		fclose(iF);
		exit();
	}

	while (!feof(iF)) {
		for (i=0; i<255 && (ch=fgetc(iF))!=eof && ch!='\n'; )
			if (ch!='\r') Line[i++] = ch;
		Line[i] = '\0';
		if (strncmp(Line, "$COLUMN_BINARY", 14)==0) break;
	}

	while (!feof(iF)) {
		for (i=0; i<255 && (ch=fgetc(iF))!=eof && ch!='\n'; )
			if (ch!='\r') Line[i++] = ch;
		if (i==0) break;
		while (i<160)
			Line[i++] = '@';
		Line[i] = '\0';
		if (Line[0]=='$') break;
		lp++;
		for (i=0; i<160; i+=2) {
			code = T2[T1[Line[i]&63] + T1[Line[i+1]&63+64]];
			fputc(T4[code], oF);
		}
		fputc('\n', oF);
	}

	fclose(iF);
	fclose(oF);

	printf("  Lines processed: %d\n", lp);
	printf("Conversion complete.\n\n");
}
