/*
IBM 1620 character conversion support.

Conversion tables:

	T1 - column binary to intermediate code
	T2 - intermediate code to I/O code
	T3 - I/O code to column binary
	T4 - I/O code to display ASCII
	T5 - display ASCII to I/O code

Conversion operations:

	column binary -> I/O code:

		code = T2[T1[char1&63]+T1[char2&63+64]];

	I/O code -> column binary:

		char1 = T3[code];
		char2 = T3[code+128];

	I/O code -> display ASCII:

		ascii = T4[code];

	display ASCII -> I/O code:

		code = T5[ascii&127];

Character mappings:

                 Memory        I/O Code                        Column  Display
Character Alphameric Numeric   Dec  Hex   PaperTape  PunchCard Binary   ASCII
-------------------------------------------------------------------------------
 <EL>       0<RM>    <RM>      128   80     EL                          ;
 <blank>    00       0          16   10     C         <blank>    @@     <blank>
 .          03       <RM821>   107   6B     XO821     12-3-8     aB     .
 )          04       <NB>      124   7C     XOC84     12-4-8     `b     )
 +          10       0         112   70     XOC       12         `@     +
 $          13      -<RM821>    91   5B     XC821     11-3-8     QB     $
 *          14      -<NB>       76   4C     X84       11-4-8     Pb     *
 -          20      -0          64   40     X         11         P@     -
 /          21       1          49   31     OC1       0-1        L@     /
 ,          23       <RM821>    59   3B     OC821     0-3-8      IB     ,
 (          24       <NB>       44   2C     O84       0-4-8      Hb     (
 <special>  26                  62   3E     OC842     0-6-8      HJ     ^
 =          33       <RM821>    11   0B     821       3-8        AB     =
 @          34       <NB>       28   1C     C84       4-8        @b     @
 A          41       1          97   61     XO1       12-1       d@     A
 B          42       2          98   62     XO2       12-2       b@     B
 C          43       3         115   73     XOC21     12-3       a@     C
 D          44       4         100   64     XO4       12-4       ``     D
 E          45       5         117   75     XOC41     12-5       `P     E
 F          46       6         118   76     XOC42     12-6       `H     F
 G          47       7         103   67     XO421     12-7       `D     G
 H          48       8         104   68     XO8       12-8       `B     H
 I          49       9         121   79     XOC81     12-9       `A     I
   -0       50      -0          93   5D     XC841     11-0       X@     ~
 J -1       51      -1          81   51     XC1       11-1       T@     J
 K -2       52      -2          82   52     XC2       11-2       R@     K
 L -3       53      -3          67   43     X21       11-3       Q@     L
 M -4       54      -4          84   54     XC4       11-4       P`     M
 N -5       55      -5          69   45     X41       11-5       PP     N
 O -6       56      -6          70   46     X42       11-6       PH     O
 P -7       57      -7          87   57     XC421     11-7       PD     P
 Q -8       58      -8          88   58     XC8       11-8       PB     Q
 R -9       59      -9          73   49     X81       11-9       PA     R
 S          62       2          50   32     OC2       0-2        J@     S
 T          63       3          35   23     O21       0-3        I@     T
 U          64       4          52   34     OC4       0-4        H`     U
 V          65       5          37   25     O41       0-5        HP     V
 W          66       6          38   26     O42       0-6        HH     W
 X          67       7          55   37     OC421     0-7        HD     X
 Y          68       8          56   38     OC8       0-8        HB     Y
 Z          69       9          41   29     O81       0-9        HA     Z
 0          70       0          32   20     0         0          H@     0
                                32   20     0         12-0       h@     0
 1          71       1           1   01     1         1          D@     1
 2          72       2           2   02     2         2          B@     2
 3          73       3          19   13     C21       3          A@     3
 4          74       4           4   04     4         4          @`     4
 5          75       5          21   15     C41       5          @P     5
 6          76       6          22   16     C42       6          @H     6
 7          77       7           7   07     421       7          @D     7
 8          78       8           8   08     8         8          @B     8
 9          79       9          25   19     C81       9          @A     9
 <RM>       0<RM>    <RM>       42   2A     O82       0-2-8      JB     #
-<RM>       0<RM>   -<RM>       74   4A     X82       11-2-8     RB     "
                               122   7A     XOC82     12-2-8     bB     "
 <GM>       0<GM>    <GM>       47   2F     O8421     0-7-8      HF     %
-<GM>       0<GM>   -<GM>       79   4F     X8421     11-7-8     PF     &
                               127   7F     XOC8421   12-7-8     `F     &
*/

const int T1[] = {11, 22, 33, 0, 44, 0, 0, 0, 55, 66, 77, 0, 88, 0, 0, 0, 99,
                  110, 121, 0, 132, 0, 0, 0, 143, 0, 0, 0, 0, 0, 0, 0, 154,
                  165, 176, 0, 187, 0, 0, 0, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                  1, 2, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 0, 0, 0, 0, 8, 0, 0, 0,
                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 10, 0, 0, 0, 0,
                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                  0, 0, 0, 0, 0};

const char T2[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 25, 8, 7, 0, 22, 0,
                   21, 4, 28, 0, 19, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0,
                   0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                   32, 41, 56, 55, 47, 38, 62, 37, 52, 44, 0, 35, 0, 59, 0, 0,
                   0, 0, 0, 0, 0, 0, 50, 0, 42, 0, 0, 0, 0, 0, 0, 0, 0, 49, 0,
                   0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 73, 88, 87, 79, 70, 0, 69,
                   84, 76, 0, 67, 0, 91, 0, 0, 0, 0, 0, 0, 0, 0, 82, 0, 74, 0,
                   0, 0, 0, 0, 0, 0, 0, 81, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93,
                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 121, 104, 103, 127, 118,
                   0, 117, 100, 124, 0, 115, 0, 107, 0, 0, 0, 0, 0, 0, 0, 0,
                   98, 0, 122, 0, 0, 0, 0, 0, 0, 0, 0, 97, 0, 0, 0, 0, 0, 0, 0,
                   0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

const char T3[] = {"?DB?@??@@??A????@??A?@@??@??@???H??I?HH??HJ?H??H?LJ?H??H"
                   "H??I??H?P??Q?PP??PR?P??P?TR?P??PP??Q?X???db?`??``??a????"
                   "`??a?``??`b?`??`"
                   "?@@?`??DB??B????@??@?PH??A??b???@??@?PH??AB?b??F?@@?`??D"
                   "B??B??J?@??@?PH??AB?b??F?@@?`??DB??B?@???@@?`??DB??B????"
                   "@??@?PH??AB?b??F"};

const char T4[] = {"?12?4??78??=???? ??3?56??9??@???0??T?VW??Z#?(??%?/S?U??X"
                   "Y??,??^?-??L?NO??R\"?*??&?JK?M??PQ??$?~???AB?D??GH??.???"
                   "?+??C?EF??I\"?)??&;"};

const int T5[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 74, 42, 91, 47,
                  79, 0, 44, 124, 76, 112, 59, 64, 107, 49, 32, 1, 2, 19, 4,
                  21, 22, 7, 8, 25, 0, 128, 0, 11, 0, 0, 28, 97, 98, 115, 100,
                  117, 118, 103, 104, 121, 81, 82, 67, 84, 69, 70, 87, 88,
                  73, 50, 35, 52, 37, 38, 55, 56, 41, 0, 0, 0, 62, 0, 0, 97,
                  98, 115, 100, 117, 118, 103, 104, 121, 81, 82, 67, 84, 69,
                  70, 87, 88, 73, 50, 35, 52, 37, 38, 55, 56, 41, 0, 0, 0,
                  93, 0};
