/* NO_TF - remove TapeFeed codes from a PT file */

#include <io.h>
#include <mem.h>
#include <process.h>
#include <stdio.h>

#define BUFSZ 60000L

char buf[BUFSZ];

int main(int argc, char *argv[])
{
    FILE *f = fopen(argv[1], "r+b");
    unsigned int i;
    long size;
    
    if (f == NULL)
    {
	perror(argv[1]);
	exit(1);
    }
    
    size = filelength(fileno(f));
    if (size == 0 || size > BUFSZ)
    {
	printf("size too large or zero");
	exit(1);
    }
    
    i = fread(buf, 1, size, f);
    if (i != size)
    {
	printf("short read");
	exit(1);
    }
    fclose(f);

    for (i=0; i<size; i++)
	if ((buf[i] & 0x7F) == 0x7F)
	{
	    memmove(&buf[i], &buf[i+1], size - i - 1);
	    i--;
	    size--;
	}
	
    f = fopen(argv[1], "wb");
    i = fwrite(buf, 1, size, f);
    if (i != size)
    {
	printf("short write");
	exit(1);
    }
    
    return 0;
}