(*$LIST-				*  do not include	*
					*  prolog in compiler	*
					*  listing	       *)
(****************************************************************
*								*
* MODULE NAME = UUPCPRB.INC					*
*								*
* DESCRIPTIVE NAME = CPRB Record Definition and Return Code	*
*		     Constants					*
*								*
* COPYRIGHT = (C) COPYRIGHT IBM CORP. 1984, 1987		*
*	      LICENSED MATERIAL - PROGRAM PROPERTY OF IBM	*
*	      ALL RIGHTS RESERVED				*
*								*
*								*
* FUNCTION = Define the CPRB Record and Return Code Constants	*
*								*
* NOTES =							*
*								*
*   DEPENDENCIES = None 					*
*								*
*   RESTRICTIONS = None 					*
*								*
*   REGISTER CONVENTIONS = N/A					*
*								*
* MODULE TYPE = Include 					*
*								*
*   PROCESSOR = IBM Personal Computer Pascal Compiler		*
*		Version 2.00					*
*   MODULE SIZE = N/A						*
*   ATTRIBUTES	= N/A						*
*								*
* ENTRY POINT = N/A						*
*								*
*   PURPOSE = N/A						*
*   LINKAGE = N/A						*
*								*
* INPUT = None							*
*								*
* OUTPUT = None 						*
*								*
* NORMAL RETURN = N/A						*
*								*
* ERROR RETURN = N/A						*
*								*
* EXTERNAL REFERENCES						*
*								*
*   OTHER ROUTINES = N/A					*
*   DATA AREAS = N/A						*
*   CONTROL BLOCKS = N/A					*
*								*
* TABLES = N/A							*
*								*
* MACROS = N/A							*
*								*
* CHANGE ACTIVITY =						*
*								*
****************************************************************)
(*$LIST+*)
(****************************************************************
*		       Return Codes				*
****************************************************************)
CONST
  UERERROK	 = #00000000;	   { Successful 			 }
(* Type 1 Errors *)
  UERERRT1START  = #01000402;	   { not started			 }
  UERERRT1LOAD	 = #01000404;	   { not loaded 			 }
  UERERRT1BUSY	 = #01000408;	   { busy				 }
  UERERRT1VER	 = #0100040A;	   { Unsupported version ID		 }
  UERERRT1EMU	 = #0100040C;	   { PC 3270 Emulation not loaded	 }
  UERERRT1QPLEN  = #01000602;	   { Request parameters length too large }
  UERERRT1RPLEN  = #01000604;	   { Reply parameters length too large	 }
  UERERRT1VERB	 = #01000606;	   { Invalid verb type			 }
  UERERRT1SERV	 = #01000608;	   { Invalid server name		 }
  UERERRT1QPAD	 = #0100060C;	   { Invalid request parameters address  }
  UERERRT1QDAD	 = #0100060E;	   { Invalid request data address	 }
  UERERRT1RPAD	 = #01000610;	   { Invalid reply parameters address	 }
  UERERRT1RDAD	 = #01000612;	   { Invalid reply data address 	 }
  UERERRT1TOPV	 = #01000616;	   { TOPVIEW not supported		 }
  UERERRT1CNCL	 = #01000802;	   { Cancelled by host			 }
  UERERRT1CONV	 = #01000C00;	   { Unable to maintain conversation	 }
  UERERRT1ISE	 = #01000C02;	   { Internal software error		 }
  UERERRT1PROT	 = #01000C04;	   { Protocol violation 		 }
  UERERRT1SYIN	 = #01000C06;	   { System inconsistency		 }

(****************************************************************
* For type 2 and type 3 errors the most significant byte of	*
* the return code is #02 and #03 respectively.	The 3 remain-	*
* ing bytes are the Exception Class, Exception Code, and	*
* Exception Object sent or received in the Acknowledge. 	*
****************************************************************)
  UERERRT2	 = #02; 	   { Error Type 2 - acknowledge sent	 }
  UERERRT3	 = #03; 	   { Error Type 3 - acknowledge received }

(****************************************************************
*			 CPRB Record				*
****************************************************************)
TYPE
    UERCPRBPTR = ADS of uercprb;
    uercprb = RECORD
      uerserver     : string(8);   { ASCII name of server	}
      uerfunct	    : word;	   { Function ID		}

      uerqparml     : word;	   { Request Parameters Length	}
      uerqparmad    : adsmem;	   { Request Parameters Address }
      uerqdatal     : word;	   { Request Data Length	}
      uerqdataad    : adsmem;	   { Request Data Address	}

      uerrparml     : word;	   { Reply Parameters Length	}
      uerrparmad    : adsmem;	   { Reply Parameters Address	}
      uerrdatal     : word;	   { Reply Data Length		}
      uerrdataad    : adsmem;	   { Reply Data Address 	}

      uerretcode    : integer4;    { Return Code		}
      uerservrc     : integer4;    { Server Return Code 	}
      uerrepldplen  : word;	   { Replied Parameters Length	}
      uerreplddlen  : word;	   { Replied Data Length	}
    end;
