c***********************************************
      BLOCK DATA
C***********************************************
C
      IMPLICIT  DOUBLE PRECISION (A-H,O-Z)
cIBM  IMPLICIT  REAL*8           (A-H,O-Z)
Cout  DOUBLE  PRECISION  SUMS                                           REDUNDNT
C
C     l1 :=  param-dimension governs the size of most 1-d arrays
C     l2 :=  param-dimension governs the size of most 2-d arrays
C
C  ISPAN :=  Array of limits for DO loop control in the kernels
C  IPASS :=  Array of limits for multiple pass execution of each kernel
C  FLOPN :=  Array of floating-point operation counts for one pass thru kernel
C     WT :=  Array of weights to average kernel execution rates.
C  SKALE :=  Array of scale factors for SIGNEL data generator.
C   BIAS :=  Array of scale factors for SIGNEL data generator.
C
C    MUL :=  Array of multipliers * FLOPN  for each pass
C    WTP :=  Array of multipliers *    WT  for each pass
C     FR :=  Array of vectorisation fractions in REPORT
C   SUMW :=  Array of quartile weights in REPORT
C     IQ :=  Array of workload weights in REPORT
C   SUMS :=  Array of Verified Checksums of Kernels results: Nruns= 1 and 7.
C
C/      PARAMETER( l1= 1001, l2=  101, l1d= 2*1001 )
C/      PARAMETER( l13=  64, l13h= l13/2, l213= l13+l13h, l813= 8*l13 )
C/      PARAMETER( l14=2048, l16=  75, l416= 4*l16 , l21= 25 )
C
C/      PARAMETER( l1=   27, l2=   15, l1d= 2*1001 )
C/      PARAMETER( l13=   8, l13h= 8/2, l213= 8+4, l813= 8*8 )
C/      PARAMETER( l14=  16, l16= 15, l416= 4*15 , l21= 15)
C
C
C/      PARAMETER( l1=   1001, l2=   101, l1d= 2*1001 )
C/      PARAMETER( l13= 64, l13h= 64/2, l213= 64+32, l813= 8*64 )
C/      PARAMETER( l14= 2048, l16= 75, l416= 4*75 , l21= 25)
C
C/      PARAMETER( kn= 47, kn2= 95, np= 3, ls= 3*47, krs= 24)
C/      PARAMETER( m1= 1001-1, m2= 101-1, m7= 1001-6 )
      parameter( nsys= 5, ns= nsys+1, nd= 11, nt= 4 )
C
      COMMON /SPACES/ ion,j5,k2,k3,MULTI,laps,Loop,m,kr,LP,n13h,ibuf,nx,
     1 L,npass,nfail,n,n1,n2,n13,n213,n813,n14,n16,n416,n21,nt1,nt2,
     2 last,idebug,mpy,Loops2,mucho,mpylim, intbuf(16)
C
      COMMON /SPACE0/ TIME(47), CSUM(47), WW(47), WT(47), ticks,
     1                FR(9), TERR1(47), SUMW(7), START,
     2              SKALE(47), BIAS(47), WS(95), TOTAL(47), FLOPN(47),
     3                IQ(7), NPF, NPFS1(47)
C
      CHARACTER  NAMES*8
      COMMON /TAGS/  NAMES(nd,nt)
      COMMON /RATS/  RATED(nd,nt)
      COMMON /SPACEI/ WTP(3), MUL(3), ISPAN(47,3), IPASS(47,3)
C
      COMMON /ORDER/ inseq, match, NSTACK(20), isave, iret
C
      COMMON /PROOF/  SUMS(24,3,8)
C     ****************************************************************
C
      DATA  ( ISPAN(i,1), i= 1,47) /
     : 1001, 101, 1001, 1001, 1001, 64, 995, 100,
     : 101, 101, 1001, 1000, 64, 1001, 101, 75,
     : 101, 100, 101, 1000, 101, 101, 100, 1001, 23*0/
C
C*   : l1, l2, l1, l1, l1, l13, m7, m2,
C*   : l2, l2, l1, m1, l13, l1, l2, l16,
C*   : l2, m2, l2, m1, l21, l2, m2, l1, 23*0/
C
      DATA  ( ISPAN(i,2), i= 1,47) /
     : 101, 101, 101, 101, 101,  32, 101, 100,
     : 101, 101, 101, 100,  32, 101, 101,  40,
     : 101, 100, 101, 100,  50, 101, 100, 101,  23*0/
C
      DATA  ( ISPAN(i,3), i= 1,47) /
     : 27, 15, 27, 27, 27,  8, 21, 14,
     : 15, 15, 27, 26,  8, 27, 15, 15,
     : 15, 14, 15, 26, 20, 15, 14, 27,  23*0/
C
      DATA  ( IPASS(i,1), i= 1,47) /
     :   7, 67,  9, 14, 10,  3,  4, 10, 36, 34, 11, 12,
     :  36,  2,  1, 25, 35,  2, 39,  1,  1, 11,  8,  5,  23*0/
C
      DATA  ( IPASS(i,2), i= 1,47) /
     :   40, 40, 53, 70, 55,  7, 22,  6, 21, 19, 64, 68,
     :   41, 10,  1, 27, 20,  1, 23,  8,  1,  7,  5, 31,  23*0/
C
      DATA  ( IPASS(i,3), i= 1,47) /
     :   28, 46, 37, 38, 40, 21, 20,  9, 26, 25, 46, 48,
     :   31,  8,  1, 14, 26,  2, 28,  7,  1,  8,  7, 23,  23*0/
C
      DATA  (  MUL(i), i= 1,3) / 1, 2, 8 /
      DATA  (  WTP(i), i= 1,3) / 1.0, 2.0, 1.0 /
c
c     The following flop-counts (FLOPN) are required for scalar or serial
c     execution.  The scalar version defines the NECESSARY computation
c     generally, in the absence of proof to the contrary.  The vector
c     or parallel executions are only credited with executing the same
c     necessary computation.  If the parallel methods do more computation
c     than is necessary then the extra flops are not counted as through-put.
c
      DATA  ( FLOPN(i), i= 1,47)
     :     /5., 4., 2., 2., 2., 2., 16., 36., 17., 9., 1., 1.,
     :     7., 11., 33.,10., 9., 44., 6., 26., 2., 17., 11., 1., 23*0.0/
C
      DATA  ( WT(i), i= 1,47) /
     : 1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,
     : 1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,
     : 1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0, 23*0.0/
C
C
      DATA  ( SKALE(i), i= 1,47) /
     & 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0,
     & 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0,
     & 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0,
     & 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0, 0.100D+0,
     &       23*0.000D+0 /
C
c    : 0.1,  0.1,  0.1,  0.1,  0.1,  0.1,  0.1,  0.1,
c    : 0.1,  0.1,  0.1,  0.1,  0.1,  0.1,  0.1,  0.1,
c    : 0.1,  0.1,  0.1,  0.1,  0.1,  0.1,  0.1,  0.1,  23*0.0/
C
      DATA  ( BIAS(i), i= 1,47) /
     : 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
     : 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
     : 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  23*0.0/
C
      DATA  ( FR(i), i= 1,9) /
     :  0.0, 0.2, 0.4, 0.6, 0.7, 0.8, 0.9, 0.95, 1.0/
C
      DATA  ( SUMW(i), i= 1,7) /
     : 1.0, 0.95, 0.9, 0.8, 0.7, 0.6, 0.5/
C
      DATA  ( IQ(i), i= 1,7) /
     : 1, 2, 1, 2, 1, 2, 1/
C
C
C                                                 NEC SX-3/14
      DATA  ( NAMES(1,i), i= 1,3) /
     :        'NEC     ', 'SX-3/14 ', 'F77v.012' /
C
      DATA  ( RATED(1,i), i= 1,4) /
     :        311.82,  95.59,  38.73, 499.78 /
C                                                 CRAY-YMP/1
      DATA  ( NAMES(2,i), i= 1,3) /
     :        'CRAY    ', 'YMP/1   ', 'CFT771.2' /
C
      DATA  ( RATED(2,i), i= 1,4) /
     :         78.23,  36.63,  17.66,  86.75 /
C                                                 IBM 3090S180
c     DATA  ( NAMES(2,i), i= 1,3) /
c    :        'IBM     ', '3090s180', 'VSF2.2.0' /
C
c     DATA  ( RATED(2,i), i= 1,4) /
c    :         17.56,  12.23,   9.02,  16.32 /
C                                                 HP  9000/730
      DATA  ( NAMES(3,i), i= 1,3) /
     :        'HP      ', '9000/730', 'f77 8.05' /
C
      DATA  ( RATED(3,i), i= 1,4) /
     :         18.31,  15.72,  13.28,   9.68 /
C                                                 IBM 6000/540
      DATA  ( NAMES(4,i), i= 1,3) /
     :        'IBM     ', '6000/540', 'XL v0.90' /
C
      DATA  ( RATED(4,i), i= 1,4) /
     :         14.17,  10.73,   7.45,   9.59 /
C                                                 COMPAQ i486/25
      DATA  ( NAMES(5,i), i= 1,3) /
     :        'COMPAQ  ', 'i486/25 ', '        ' /
C
      DATA  ( RATED(5,i), i= 1,4) /
     :          1.15,   1.05,   0.92,   0.48 /
C
C
      DATA  START /0.0/, NPF/0/, ibuf/0/, match/0/, MULTI/200/, laps/1/
      DATA  npass/0/, nfail/0/, last/-1/
C
c MULTI= 200
c
      DATA  ( SUMS(i,1,5), i= 1,24 ) /
     &5.114652693224671D+04,1.539721811668385D+03,1.000742883066363D+01,
     &5.999250595473891D-01,4.548871642387267D+03,4.375116344729986D+03,
     &6.104251075174761D+04,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.342910972650109D+07,2.907141294167248D-05,
     &1.202533961842803D+11,3.165553044000334D+09,3.943816690352042D+04,
     &5.650760000000000D+05,1.114641772902486D+03,1.015727037502300D+05,
     &5.421816960147207D+02,3.040644339351239D+07,1.597308280710199D+08,
     &2.938604376566697D+02,3.549900501563623D+04,5.000000000000000D+02/
c
      DATA  ( SUMS(i,2,5), i= 1,24 ) /
     &5.253344778937972D+02,1.539721811668385D+03,1.009741436578952D+00,
     &5.999250595473891D-01,4.589031939600982D+01,8.631675645333210D+01,
     &6.345586315784055D+02,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.433560407475758D+04,7.127569130821465D-06,
     &9.816387810944345D+10,3.039983465145393D+07,3.943816690352042D+04,
     &6.480410000000000D+05,1.114641772902486D+03,1.015727037502300D+05,
     &5.421816960147207D+02,3.126205178815431D+04,7.824524877232093D+07,
     &2.938604376566697D+02,3.549900501563623D+04,5.000000000000000D+01/
c
      DATA  ( SUMS(i,3,5), i= 1,24 ) /
     &3.855104502494961D+01,3.953296986903059D+01,2.699309089320672D-01,
     &5.999250595473891D-01,3.182615248447483D+00,1.120309393467088D+00,
     &2.845720217644024D+01,2.960543667875003D+03,2.623968460874250D+03,
     &1.651291227698265D+03,6.551161335845770D+02,1.943435981130448D-06,
     &3.847124199949426D+10,2.923540598672011D+06,1.108997288134785D+03,
     &5.152160000000000D+05,2.947368618589360D+01,9.700646212337040D+02,
     &1.268230698051003D+01,5.987713249475302D+02,5.009945671204667D+07,
     &6.109968728263972D+00,4.850340602749970D+02,1.300000000000000D+01/
C
c MULTI= 100
c
      DATA  ( SUMS(i,1,4), i= 1,24 ) /
     &5.114652693224671D+04,1.539721811668385D+03,1.000742883066363D+01,
     &5.999250595473891D-01,4.548871642387267D+03,4.375116344729986D+03,
     &6.104251075174761D+04,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.342910972650109D+07,2.907141294167248D-05,
     &4.958101723583047D+10,3.165278275112100D+09,3.943816690352042D+04,
     &2.825760000000000D+05,1.114641772902486D+03,7.507386432940455D+04,
     &5.421816960147207D+02,3.040644339351239D+07,8.002484742089500D+07,
     &2.938604376566697D+02,3.549900501563623D+04,5.000000000000000D+02/
c
      DATA  ( SUMS(i,2,4), i= 1,24 ) /
     &5.253344778937972D+02,1.539721811668385D+03,1.009741436578952D+00,
     &5.999250595473891D-01,4.589031939600982D+01,8.631675645333210D+01,
     &6.345586315784055D+02,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.433560407475758D+04,7.127569130821465D-06,
     &3.542728632259964D+10,3.015943681556781D+07,3.943816690352042D+04,
     &3.240410000000000D+05,1.114641772902486D+03,7.507386432940455D+04,
     &5.421816960147207D+02,3.126205178815431D+04,3.916171317449981D+07,
     &2.938604376566697D+02,3.549900501563623D+04,5.000000000000000D+01/
c
      DATA  ( SUMS(i,3,4), i= 1,24 ) /
     &3.855104502494961D+01,3.953296986903059D+01,2.699309089320672D-01,
     &5.999250595473891D-01,3.182615248447483D+00,1.120309393467088D+00,
     &2.845720217644024D+01,2.960543667875003D+03,2.623968460874250D+03,
     &1.651291227698265D+03,6.551161335845770D+02,1.943435981130448D-06,
     &1.161063924078402D+10,2.609194549277411D+06,1.108997288134785D+03,
     &2.576160000000000D+05,2.947368618589360D+01,9.700646212337040D+02,
     &1.268230698051003D+01,5.987713249475302D+02,2.505599006414913D+07,
     &6.109968728263972D+00,4.850340602749970D+02,1.300000000000000D+01/
C
c MULTI= 50
c
      DATA  ( SUMS(i,1,3), i= 1,24 ) /
     &5.114652693224671D+04,1.539721811668385D+03,1.000742883066363D+01,
     &5.999250595473891D-01,4.548871642387267D+03,4.375116344729986D+03,
     &6.104251075174761D+04,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.342910972650109D+07,2.907141294167248D-05,
     &2.217514090251080D+10,3.165140890667983D+09,3.943816690352042D+04,
     &1.413260000000000D+05,1.114641772902486D+03,6.203834985242972D+04,
     &5.421816960147207D+02,3.040644339351239D+07,4.017185709583275D+07,
     &2.938604376566697D+02,3.549900501563623D+04,5.000000000000000D+02/
c
      DATA  ( SUMS(i,2,3), i= 1,24 ) /
     &5.253344778937972D+02,1.539721811668385D+03,1.009741436578952D+00,
     &5.999250595473891D-01,4.589031939600982D+01,8.631675645333210D+01,
     &6.345586315784055D+02,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.433560407475758D+04,7.127569130821465D-06,
     &1.430504282675192D+10,3.003923789762475D+07,3.943816690352042D+04,
     &1.620410000000000D+05,1.114641772902486D+03,6.203834985242972D+04,
     &5.421816960147207D+02,3.126205178815431D+04,1.961994537558922D+07,
     &2.938604376566697D+02,3.549900501563623D+04,5.000000000000000D+01/
c
      DATA  ( SUMS(i,3,3), i= 1,24 ) /
     &3.855104502494961D+01,3.953296986903059D+01,2.699309089320672D-01,
     &5.999250595473891D-01,3.182615248447483D+00,1.120309393467088D+00,
     &2.845720217644024D+01,2.960543667875003D+03,2.623968460874250D+03,
     &1.651291227698265D+03,6.551161335845770D+02,1.943435981130448D-06,
     &3.899370197966012D+09,2.452021524580127D+06,1.108997288134785D+03,
     &1.288160000000000D+05,2.947368618589360D+01,9.700646212337040D+02,
     &1.268230698051003D+01,5.987713249475302D+02,1.253425674020030D+07,
     &6.109968728263972D+00,4.850340602749970D+02,1.300000000000000D+01/
C
c
c MULTI= 10     Old Checksums used before 1991 (longer run-times were needed)
c
      DATA  ( SUMS(i,1,2), i= 1,24 ) /
     &5.114652693224671D+04,1.539721811668385D+03,1.000742883066363D+01,
     &5.999250595473891D-01,4.548871642387267D+03,4.375116344729986D+03,
     &6.104251075174761D+04,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.342910972650109D+07,2.907141294167248D-05,
     &4.057110454105199D+09,3.165030983112689D+09,3.943816690352042D+04,
     &2.832600000000000D+04,1.114641772902486D+03,5.165625410754861D+04,
     &5.421816960147207D+02,3.040644339351239D+07,8.289464835782872D+06,
     &2.938604376566697D+02,3.549834542443621D+04,5.000000000000000D+02/
c
      DATA  ( SUMS(i,2,2), i= 1,24 ) /
     &5.253344778937972D+02,1.539721811668385D+03,1.009741436578952D+00,
     &5.999250595473891D-01,4.589031939600982D+01,8.631675645333210D+01,
     &6.345586315784055D+02,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.433560407475758D+04,7.127569130821465D-06,
     &2.325318944820753D+09,2.994307876327030D+07,3.943816690352042D+04,
     &3.244100000000000D+04,1.114641772902486D+03,5.165625410754861D+04,
     &5.421816960147207D+02,3.126205178815431D+04,3.986531136460764D+06,
     &2.938604376566697D+02,3.549894609774404D+04,5.000000000000000D+01/
c
      DATA  ( SUMS(i,3,2), i= 1,24 ) /
     &3.855104502494961D+01,3.953296986903059D+01,2.699309089320672D-01,
     &5.999250595473891D-01,3.182615248447483D+00,1.120309393467088D+00,
     &2.845720217644024D+01,2.960543667875003D+03,2.623968460874250D+03,
     &1.651291227698265D+03,6.551161335845770D+02,1.943435981130448D-06,
     &4.755211251524082D+08,2.326283104822299D+06,1.108997288134785D+03,
     &2.577600000000000D+04,2.947368618589360D+01,9.700646212337040D+02,
     &1.268230698051003D+01,5.987713249475302D+02,2.516870081041265D+06,
     &6.109968728263972D+00,4.850340602749970D+02,1.300000000000000D+01/
c
c MULTI=  1     Old Checksums used before 1986 (longer run-times were needed)
c
      DATA  ( SUMS(i,1,1), i= 1,24 ) /
     &5.114652693224671D+04,1.539721811668385D+03,1.000742883066363D+01,
     &5.999250595473891D-01,4.548871642387267D+03,4.375116344729986D+03,
     &6.104251075174761D+04,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.342910972650109D+07,2.907141294167248D-05,
     &4.468741170140841D+08,3.165006253912748D+09,3.943816690352042D+04,
     &2.901000000000000D+03,1.227055736845479D+03,4.932243865816480D+04,
     &5.421816960147207D+02,3.040644339351239D+07,1.115926577271652D+06,
     &2.938604376566697D+02,3.138872788135057D+04,5.000000000000000D+02/
c
      DATA  ( SUMS(i,2,1), i= 1,24 ) /
     &5.253344778937972D+02,1.539721811668385D+03,1.009741436578952D+00,
     &5.999250595473891D-01,4.589031939600982D+01,8.631675645333210D+01,
     &6.345586315784055D+02,1.501268005625798D+05,1.189443609974981D+05,
     &7.310369784325296D+04,3.433560407475758D+04,7.127569130821465D-06,
     &2.323352389500009D+08,2.992144295804055D+07,3.943816690352042D+04,
     &3.281000000000000D+03,1.114641772902486D+03,4.932243865816480D+04,
     &5.421816960147207D+02,3.126205178815431D+04,4.690129326568575D+05,
     &2.938604376566697D+02,3.228104575530876D+04,5.000000000000000D+01/
c
      DATA  ( SUMS(i,3,1), i= 1,24 ) /
     &3.855104502494961D+01,3.953296986903059D+01,2.699309089320672D-01,
     &5.999250595473891D-01,3.182615248447483D+00,1.120309393467088D+00,
     &2.845720217644024D+01,2.960543667875003D+03,2.623968460874250D+03,
     &1.651291227698265D+03,6.551161335845770D+02,1.943435981130448D-06,
     &4.143805389489125D+07,2.297991960376787D+06,1.108997288134785D+03,
     &2.592000000000000D+03,2.947368618589360D+01,9.700646212337040D+02,
     &1.268230698051003D+01,5.987713249475302D+02,2.629580827304779D+05,
     &6.109968728263972D+00,4.850340602749970D+02,1.300000000000000D+01/
C
C****************************************************************************
c
c     The following DP checksums are NOT used for the standard LFK
c     performance test but may be used to test Fortran compiler precision.
c
c     Checksums for Quadruple-Precision (IBM,DEC); or CRAY Double-Precision.
c     Quadruple precision checksums computed by Dr. D.S. Lindsay, HITACHI.
C     These Checksums were obtained with   MULTI= 10. (BLOCKDATA)
c     Change the numerical edit descriptor Q to D on CRAY systems.
CQc
CQ      DATA  ( SUMS(i,1,1), i= 1,24 )  /
CQ     a 0.5114652693224705102247326Q+05, 0.5150345372943066022569677Q+03,
CQ     b 0.1000742883066623145122027Q+02, 0.5999250595474070357564935Q+00,
CQ     c 0.4548871642388544199267412Q+04, 0.5229095383954675635496207Q+13,
CQ     d 0.6104251075163778121943921Q+05, 0.1501268005627157186827043Q+06,
CQ     e 0.1189443609975085966254160Q+06, 0.7310369784325972183233686Q+05,
CQ     f 0.3342910972650530676553892Q+08, 0.2907141428639174056565229Q-04,
CQ     g 0.4057110454105263471505061Q+10, 0.2982036205992255154832180Q+10,
CQ     h 0.3943816690352311804312052Q+05, 0.2832600000000000000000000Q+05,
CQ     i 0.1114641772903091760464680Q+04, 0.5165625410757306606559174Q+05,
CQ     j 0.5421816960150398899460410Q+03, 0.3040644339317275409518862Q+08,
CQ     k 0.8289464835786202431495974Q+07, 0.2938604376567099667790619Q+03,
CQ     l 0.3549834542446150511553453Q+05, 0.5000000000000000000000000Q+03/
CQc
CQ      DATA  ( SUMS(i,2,1), i= 1,24 )  /
CQ     a 0.5253344778938000681994399Q+03, 0.5150345372943066022569677Q+03,
CQ     b 0.1009741436579188086885138Q+01, 0.5999250595474070357564935Q+00,
CQ     c 0.4589031939602131581035992Q+02, 0.2693280957416549457193910Q+16,
CQ     d 0.6345586315772524401198340Q+03, 0.1501268005627157186827043Q+06,
CQ     e 0.1189443609975085966254160Q+06, 0.7310369784325972183233686Q+05,
CQ     f 0.3433560407476162346605343Q+05, 0.7127569144561925151361427Q-05,
CQ     g 0.2325318944820836005421577Q+10, 0.3045676741897511424188763Q+08,
CQ     h 0.3943816690352311804312052Q+05, 0.3244100000000000000000000Q+05,
CQ     i 0.1114641772903091760464680Q+04, 0.5165625410757306606559174Q+05,
CQ     j 0.5421816960150398899460410Q+03, 0.3126205178811007613028089Q+05,
CQ     k 0.3986531136462291709063170Q+07, 0.2938604376567099667790619Q+03,
CQ     l 0.3549894609776936556634240Q+05, 0.5000000000000000000000000Q+02/
CQc
CQ      DATA  ( SUMS(i,3,1), i= 1,24 )  /
CQ     a 0.3855104502494983491740258Q+02, 0.1199847611437483513040755Q+02,
CQ     b 0.2699309089321296439173090Q+00, 0.5999250595474070357564935Q+00,
CQ     c 0.3182615248448271678796560Q+01, 0.8303480073326955433087865Q+12,
CQ     d 0.2845720217638848365786224Q+02, 0.2960543667877649943946702Q+04,
CQ     e 0.2623968460874419268457298Q+04, 0.1651291227698377392796690Q+04,
CQ     f 0.6551161335846537217862474Q+03, 0.1943435981776804808483341Q-05,
CQ     g 0.4755211251524563699634913Q+09, 0.2547733008933910800455698Q+07,
CQ     h 0.1108997288135066584075059Q+04, 0.2577600000000000000000000Q+05,
CQ     i 0.2947368618590713935189324Q+02, 0.9700646212341513210532085Q+03,
CQ     j 0.1268230698051747067958265Q+02, 0.5987713249471801461035250Q+03,
CQ     k 0.2516870081042209239664473Q+07, 0.6109968728264795136407718Q+01,
CQ     l 0.4850340602751675804605762Q+03, 0.1300000000000000000000000Q+02/
CQc
      END
