      subroutine dzerovec( dir, n, nb, x )
      character*1       dir
      integer           n, nb
      double precision  x( * )
*
*  purpose
*  =======
*
*  zero out distributed vector
*
*  arguments
*  =========
*
*  dir    (input) character*1
*         direction in which vector is to be distributed
*         'column' or 'row'
*
*  n      (input) integer
*         total length of vector
*
*  nb     (input) integer
*         block size used for wrapping the vector
*
*  x      (output) double precision array, dimension ( myn )
*         local portion of the vector
*
*
*  details
*  =======
*
*  the vector is generated distributed like the first column
*  or row of the matrix generated by the subroutine matrix().  
*  see the documentation of that routine
*
*     this version dated 09/18/92
*     r. van de geijn
*  .. 
*  .. local scalars ..
*
*     nprow          row dimension of node grid
*     npcol          column dimension of node grid
*     myrow          my row index
*     mycol          my column index
*
      integer        nprow, npcol, myrow, mycol
*
*     myn            size of local portion of vector
*
      integer        myn
*
*     misc.
*
      integer        i, idummy
*  .. 
*  .. local arrays ..
*  .. 
*  .. intrinsic functions ..
*  .. 
*  .. external functions ..
      logical        lsame
*  .. 
*  .. external subroutines ..
      external       plamch2, imypart
*     ..
*     .. executable statements ..

      call plamch2(nprow, npcol, myrow, mycol)
*
*     this node's portion of the vector is size myn
*
      if ( lsame( dir, 'c' ) ) then
         call imypart( 1, n, nb, idummy, myn, myrow, nprow )

         do 100 i=1, myn
            x( i ) = 0.0d00
 100      continue
      else if ( lsame( dir, 'r' ) ) then
         call imypart( 1, n, nb, idummy, myn, mycol, npcol )

         do 110 i=1, myn
            x( i ) = 0.0d00
 110      continue
      endif

      return
      end

