/*
 *
 * $Copyright
 * Copyright 1992, 1993, 1994, 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 *
 */ 
/*	Copyright 1990 NCR Corporation - Dayton, Ohio, USA	*/
#ident  "@(#)./usr/src/arch/mca/uts/i386/sys/scsi:SCSI_str.h	1.2"

#ifndef _SYS_SCSI_STR_H
#define _SYS_SCSI_STR_H

/*
 * ANSI defined SCSI errors and strings needed for error logging
 */

/*
 * Max String produced by IO_FormatSCSI_Error()
 */
#define MAX_STRING_LENGTH	240

char *SenseKeyStrings[] = {
	"No Sense",
	"Recovered Error",
	"Not Ready",
	"Medium Error",
	"Hardware Error",
	"Illegal Request",
	"Unit Attention",
	"Data Protect",
	"Blank Check",
	"Vendor Specific",
	"Copy Aborted",
	"Aborted Command",
	"Equal",
	"Volumn Overflow",
	"Miscompare",
	"Reserved"
};

typedef struct {
	unsigned char ASC_Value;
	unsigned char ASQ_Value;
	char *Description;
} Additional_Sense_Code_t;


char *SCSI_DeviceType[] = {
	"Direct Access",
	"Sequential Access",
	"Printer",
	"Processor",
	"WORM",
	"CDROM",
	"Scanner",
	"Optical Memory",
	"Medium Changer",
	"Communications",
	"Unknown"
};

Additional_Sense_Code_t	Additional_Sense_Codes[] = {
{0x00, 0x00, "No Additional Sense Information" },
{0x00, 0x01, "Filemark Detected"},
{0x00, 0x02, "End of Partition/Medium Detected"},
{0x00, 0x03, "Setmark Detected"},
{0x00, 0x04, "Beginning of Partition/Medium Detected"},
{0x00, 0x05, "End of Data Detected"},
{0x00, 0x11, "Audio Play Operation in Progress"},
{0x00, 0x12, "Audio Play Operation Paused"},
{0x00, 0x13, "Audio Play Operation Successfully Completed"},
{0x00, 0x14, "Audio Play Operation Stopped Due to Error"},
{0x00, 0x15, "cwNo Current Audio Status To Return"},
{0x01, 0x00, "No Index/Sector Signal"},
{0x02, 0x00, "No Seek Complete"},
{0x03, 0x00, "Peripheral Device Write Fault"},
{0x03, 0x01, "No Write Current"},
{0x03, 0x02, "Excessive Write Errors"},
{0x04, 0x00, "Logical Unit Not Ready, Cause Not Reportable"},
{0x04, 0x01, "Logical Unit is in Process of Becoming Ready"},
{0x04, 0x02, "Logical Unit Not Ready, Initializing Command Required"},
{0x04, 0x03, "Logical Unit Not Ready, Manual Intervention Required"},
{0x04, 0x04, "Logical Unit Not Ready, Format in Progress"},
{0x05, 0x00, "Logical Unit Does Not Respond to Selection"},
{0x06, 0x00, "No Reference Position Found"},
{0x07, 0x00, "Multiple Peripheral Devices Selected"},
{0x08, 0x00, "Logical Unit Communication Failure"},
{0x08, 0x01, "Logical Unit Communication Time-Out"},
{0x08, 0x02, "Logical Unit Communication Parity Error"},
{0x09, 0x00, "Track Following Error"},
{0x09, 0x01, "Tracking Servo Failure"},
{0x09, 0x02, "Focus Servo Failure"},
{0x09, 0x03, "Spindle Servo Failure"},
{0x0A, 0x00, "Error Log Overflow"},
{0x0B, 0x00, "Who Knows?"},
{0x0C, 0x00, "Write Error"},
{0x0C, 0x01, "Write Error-Recovered with Auto Reallocation"},
{0x0C, 0x02, "Write Error-Auto Reallocation Failed"},
{0x0D, 0x00, "No Description Assigned"},
{0x0E, 0x00, "No Description Assigned"},
{0x0F, 0x00, "No Description Assigned"},
{0x10, 0x00, "ID CRC or ECC Error"},
{0x11, 0x00, "Unrecovered Read Error"},
{0x11, 0x01, "Read Retries Exhausted"},
{0x11, 0x02, "Error too Long to Correct"},
{0x11, 0x03, "Multiple Read Errors"},
{0x11, 0x04, "Unrecovered Read Error-Auto Reallocate Failed"},
{0x11, 0x05, "L-EC Uncorrectable Error(L-EC Codes Present and ON)"},
{0x11, 0x06, "CIRC Unrecovered Error(L-EC Codes Unavailable or OFF)"},
{0x11, 0x07, "Data Resynchronization Error"},
{0x11, 0x08, "Incomplete Block Read(Postamble Not Found)"},
{0x11, 0x09, "No Gap Found"},
{0x11, 0x0A, "Miscorrected Error"},
{0x12, 0x00, "ID Address Mark Not Found"},
{0x13, 0x00, "Data Address Mark Not Found"},
{0x14, 0x00, "Recorded Entity Not Found,(Probably Beamed Up)"},
{0x14, 0x01, "Record Not Found"},
{0x14, 0x02, "File Mark or Set Mark Not Found"},
{0x14, 0x03, "End of Data Not Found"},
{0x14, 0x04, "Block Sequence Error"},
{0x15, 0x00, "Random Positioniong Error"},
{0x15, 0x01, "Mechanical Positioning Error"},
{0x15, 0x02, "Positioning Error Detected by Read Medium"},
{0x16, 0x00, "Data Synchronization Mark Error"},
{0x17, 0x00, "Recovered Data With No Error Correction Applied"},
{0x17, 0x01, "Recovered Data With Retries"},
{0x17, 0x02, "Recovered Data With Positive Head Offset"},
{0x17, 0x03, "Recovered Data With Negative Head Offset"},
{0x17, 0x04, "Recovered Data With Retries and/or CIRC"},
{0x17, 0x05, "Recovered Data Using Previous Sector ID"},
{0x17, 0x06, "Recovered Data Without ECC, Data Auto Reallocated"},
{0x18, 0x00, "Recovered Data With Error Correction Applied"},
{0x18, 0x01, "Recovered Data With Error Correction and Retries Applied"},
{0x18, 0x02, "Recovered Data With ECC and/or Retries, Data Auto Reallocated"},
{0x18, 0x03, "Recovered Data With CIRC"},
{0x18, 0x04, "Recovered Data With LEC"},
{0x19, 0x00, "Defect List Error"},
{0x19, 0x01, "Defect List Not Available"},
{0x19, 0x02, "Defect List Error in Primary List"},
{0x19, 0x03, "Defect List Error in Grown List"},
{0x1A, 0x00, "Parameter List Length Error"},
{0x1B, 0x00, "Synchronous Data Transfer Error"},
{0x1C, 0x00, "Defect List Not Found"},
{0x1C, 0x01, "Primary Defect List Not Found"},
{0x1C, 0x02, "Grown Defect List Not Found"},
{0x1D, 0x00, "Miscomapre During Verify Operation"},
{0x1E, 0x00, "Recovered ID With ECC Correction"},
{0x1F, 0x00, "No Description Assigned"},
{0x20, 0x00, "Invalid Command Operation Coded"},
{0x21, 0x00, "Invalid Element Address"},
{0x22, 0x00, "Illegal Function for Device Type"},
{0x23, 0x00, "No Description Assigned"},
{0x24, 0x00, "Invalid Field in CDB"},
{0x25, 0x00, "Logical Unit Not Supported"},
{0x26, 0x00, "Invalid Field in Parameter List"},
{0x26, 0x01, "Parameter Not Supported"},
{0x26, 0x02, "Parameter Value Invalid"},
{0x26, 0x03, "Threshold Parameter Not Supported"},
{0x27, 0x00, "Write Protected"},
{0x28, 0x00, "Not Ready to Ready Transition(Medium May Have Changed)"},
{0x28, 0x01, "Import/Export Element Accessed"},
{0x29, 0x00, "Power On, Reset or Bus Device Reset Ocurred"},
{0x2A, 0x00, "Parameters Changed"},
{0x2A, 0x01, "Mode Parameters Changed"},
{0x2A, 0x02, "Net Parameters Changed"},
{0x2B, 0x00, "Copy Cannot Execute Because Host Cannot Disconnect"},
{0x2C, 0x00, "Command Sequence Error"},
{0x2C, 0x01, "Too Many Windows Specified"},
{0x2C, 0x02, "Invalid Combination of Windows Specified"},
{0x2D, 0x00, "Overwrite Error on Update in Place"},
{0x2E, 0x00, "No Description Assigned"},
{0x2F, 0x00, "Commands Cleared by Another Initiator"},
{0x30, 0x00, "Incompatible Medium Installed"},
{0x30, 0x01, "Cannot Read Medium, Unknown Format"},
{0x30, 0x02, "Cannot Read Medium, Incompatible Format"},
{0x30, 0x03, "Cleaning Cartridge Installed"},
{0x31, 0x00, "Medium Format Corrupted"},
{0x31, 0x01, "Format Command Failed"},
{0x32, 0x00, "No Defect Spare Location Available"},
{0x32, 0x01, "Defect List Update Error"},
{0x33, 0x00, "Tape Length Error"},
{0x34, 0x00, "No Description Assigned"},
{0x35, 0x00, "No Description Assigned"},
{0x36, 0x00, "Ribbon/Ink/Toner Failure"},
{0x37, 0x00, "Rounded Parameter"},
{0x38, 0x00, "No Description Assigned"},
{0x39, 0x00, "Saving Parameters Not Supported"},
{0x3A, 0x00, "Medium Not Present"},
{0x3B, 0x00, "Sequential Positioniong Error"},
{0x3B, 0x01, "Tape Position Error at Beginning of Medium"},
{0x3B, 0x02, "Tape Position Error at End of Medium"},
{0x3B, 0x03, "Tape or Electronic Vertical Forms Unit Not Ready"},
{0x3B, 0x04, "Slew Failure"},
{0x3B, 0x05, "Paper Jam"},
{0x3B, 0x06, "Failed to Sense Top-of-Form"},
{0x3B, 0x07, "Failed to Sense Bottom-of-Form"},
{0x3B, 0x08, "Reposition Error"},
{0x3B, 0x09, "Read Past End of Medium"},
{0x3B, 0x0a, "Read Past Beginning of Medium"},
{0x3B, 0x0b, "Position Past End Of Medium"},
{0x3B, 0x0c, "Position Past Beginning Of Medium"},
{0x3B, 0x0d, "Medium Destination Element Full"},
{0x3B, 0x0e, "Medium Source Element Empty"},
{0x3C, 0x00, "No Description Assigned"},
{0x3D, 0x00, "Invalid Bits In Identify Message"},
{0x3E, 0x00, "Logical Unit Has Not Self Configured Yet"},
{0x3F, 0x00, "Target Operating Conditions Have Changed"},
{0x3F, 0x01, "Microcode Has Been Changed"},
{0x3F, 0x02, "Changed Operating Definition"},
{0x3F, 0x03, "Inquiry Data Has Changed"},
{0x40, 0x00, "Ram Failure"},
{0x41, 0x00, "Data Path Failure"},
{0x42, 0x00, "Power-On or Self-Test Failure"},
{0x43, 0x00, "Message Error"},
{0x44, 0x00, "Internal Target Failure"},
{0x45, 0x00, "Select/Reselect Failure"},
{0x46, 0x00, "Unsuccessful Soft Reset"},
{0x47, 0x00, "SCSI Parity Error"},
{0x48, 0x00, "Initator Detected Error Message Received"},
{0x49, 0x00, "Invalid Message Error"},
{0x4A, 0x00, "Command Phase Error"},
{0x4B, 0x00, "Data Phase Error"},
{0x4C, 0x00, "Logical Unit Failed Self-Configuration"},
{0x4D, 0x00, "No Description Assigned"},
{0x4E, 0x00, "Overlapped Commands Attempted"},
{0x4F, 0x00, "No Description Assigned"},
{0x50, 0x00, "Write Append Error"},
{0x50, 0x01, "Write Append Position Error"},
{0x50, 0x02, "Position Error Related to Timing"},
{0x51, 0x00, "Erase Failure"},
{0x52, 0x00, "Cartridge Fault"},
{0x53, 0x00, "Media Load/Eject Failed"},
{0x53, 0x01, "Unload Tape Failure"},
{0x53, 0x02, "Medium Removal Prevented"},
{0x54, 0x00, "SCSI to Host System Interface Failure"},
{0x55, 0x00, "System Resource Failure"},
{0x56, 0x00, "No Description Assigned"},
{0x57, 0x00, "Unable to Recover Table-Of-Contents"},
{0x58, 0x00, "Generation Does Not Exist"},
{0x59, 0x00, "Updated Block Read"},
{0x5A, 0x00, "Operator Request or State Change Input"},
{0x5A, 0x01, "Operator Medium Removal Request"},
{0x5A, 0x02, "Operator Selected Write Protect"},
{0x5A, 0x03, "Operator Selected Write Permit"},
{0x5B, 0x00, "Log Exception"},
{0x5B, 0x01, "Threshold Condition Met"},
{0x5B, 0x02, "Log Counter At Maximum"},
{0x5B, 0x03, "Log List Codes Exhausted"},
{0x5C, 0x00, "RPL Status Change"},
{0x5C, 0x01, "Spindles Synchronized"},
{0x5C, 0x02, "Spindles Not Synchronized"},
{0x5D, 0x00, "Description Not Assigned"},
{0x5E, 0x00, "Description Not Assigned"},
{0x5F, 0x00, "Description Not Assigned"},
{0x60, 0x00, "Lamp Failure"},
{0x61, 0x00, "Video Acquisition Error"},
{0x61, 0x01, "Unable to Acquire Video"},
{0x61, 0x02, "Out of Focus"},
{0x62, 0x00, "Scan Head Positioning Error"},
{0x63, 0x00, "End Of User Area Encountered On This Track"},
{0x64, 0x00, "Illegal Mode For This Track"},
{0x65, 0x00, "No Description Assigned"},
{0x66, 0x00, "No Description Assigned"},
{0x67, 0x00, "No Description Assigned"},
{0x68, 0x00, "No Description Assigned"},
{0x69, 0x00, "No Description Assigned"},
{0x6A, 0x00, "No Description Assigned"},
{0x6B, 0x00, "No Description Assigned"},
{0x6C, 0x00, "No Description Assigned"},
{0x6D, 0x00, "No Description Assigned"},
{0x6E, 0x00, "No Description Assigned"},
{0x6F, 0x00, "No Description Assigned"},
{0x70, 0x00, "No Description Assigned"},
{0x71, 0x00, "No Description Assigned"},
{0x72, 0x00, "No Description Assigned"},
{0x73, 0x00, "No Description Assigned"},
{0x74, 0x00, "No Description Assigned"},
{0x75, 0x00, "No Description Assigned"},
{0x76, 0x00, "No Description Assigned"},
{0x77, 0x00, "No Description Assigned"},
{0x78, 0x00, "No Description Assigned"},
{0x79, 0x00, "No Description Assigned"},
{0x7A, 0x00, "No Description Assigned"},
{0x7B, 0x00, "No Description Assigned"},
{0x7C, 0x00, "No Description Assigned"},
{0x7D, 0x00, "No Description Assigned"},
{0x7E, 0x00, "No Description Assigned"},
{0x7F, 0x00, "No Description Assigned"},
{0x80, 0x00, "Vendor_Unique_Stuff_From_Here_to_0xff"},
{0xff, 0xff, "End of List Encountered, Brakes Applied"}
};

#endif

