/*
 * 
 * $Copyright
 * Copyright 1993, 1994 , 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: nfsm_subs.h,v $
 * Revision 1.5  1994/11/18  20:37:21  mtm
 * Copyright additions/changes
 *
 * Revision 1.4  1993/07/14  18:16:52  cfj
 * OSF/1 AD 1.0.4 code drop from Locus.
 *
 * Revision 1.1.1.3  1993/07/01  19:39:01  cfj
 * Adding new code from vendor
 *
 * Revision 1.3  1993/05/06  20:29:47  brad
 * ad103+tnc merged with Intel code.
 *
 * Revision 1.1.1.1  1993/05/03  17:36:02  cfj
 * Initial 1.0.3 code drop
 *
 * Revision 2.3  1993/04/14  14:26:49  durriya
 * 	define NFSMGETX used for allocating external mbufswith caller
 * 	     supplied data
 * 	[93/04/13            durriya]
 *
 * Revision 1.2  1992/11/30  22:32:49  dleslie
 * Copy of NX branch back into main trunk
 *
 * Revision 1.1.2.1  1992/11/05  23:30:45  dleslie
 * Local changes for NX through noon, November 5, 1992.
 *
 * Revision 4.1  1992/11/04  00:25:02  cfj
 * Bump major revision number.
 *
 * Revision 2.2  1991/08/31  13:53:48  rabii
 * 	Initial V2.0 Checkin
 * 
 * Revision 3.1  91/07/31  15:40:54  sp
 * Upgrade to 1.0.2
 * 
 * Revision 1.7  90/10/07  14:39:53  devrcs
 * 	Add vattr stuct arg to nfsm_mtofh, for socket creation.
 * 	[90/10/03  16:14:14  tmt]
 * 
 * 	Added EndLog Marker.
 * 	[90/09/28  11:22:36  gm]
 * 
 * Revision 1.6  90/07/27  09:04:55  devrcs
 * 	NFS parallelization.
 * 	[90/07/20  17:04:29  nags]
 * 
 * 	Add FIFO hack to nfsm_srvfillattr.
 * 	[90/06/18  00:17:41  ers]
 * 
 * 	Corrected calculation of fa_blocks in nfsm_srvfillattr.
 * 	[90/06/10  17:32:23  ers]
 * 
 * Revision 1.4  90/03/27  13:25:23  gm
 * 	Add arg to nfs_request for idempotency
 * 	Changes from George at Encore
 * 	[90/03/15  17:11:41  pam]
 * 
 * Revision 1.2  90/02/12  13:08:15  gmf
 * 	Add arg to nfs_request for idempotency.
 * 
 * Revision 1.1  90/02/12  13:06:41  gmf
 * 	Initial revision
 * 
 * Revision 1.3  90/01/02  20:22:38  gm
 * 	Fixes for first snapshot.
 * 
 * Revision 1.2  89/12/26  10:21:47  gm
 * 	New networking code from BSD.
 * 	[89/12/16            tmt]
 * 
 * $EndLog$
 */
/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Rick Macklem at The University of Guelph.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)nfsm_subs.h	7.4 (Berkeley) 11/3/89
 */

/*
 * These macros do strange and peculiar things to mbuf chains for
 * the assistance of the nfs code. To attempt to use them for any
 * other purpose will be dangerous. (they make weird assumptions)
 */

/*
 * First define what the actual subs. return
 */
extern struct mbuf *nfsm_reqh();
extern struct vnode *nfs_fhtovp();

/*
 * To try and deal with different variants of mbuf.h, I have used the
 * following defs. If M_HASCL is not defined in an older the 4.4bsd mbuf.h,
 * you will have to use a different ifdef
 */
#ifdef M_HASCL
#define	NFSMCLGET(m, w)	MCLGET(m)
#ifdef OSF1_ADFS
#define NFSMGETX(m,f,d,a,s,w) MGETX(m,f,d,a,s,w)
#endif
#define	NFSMGETHDR(m)	MGET(m, M_WAIT, MT_DATA)
#define	MHLEN		MLEN
#define	NFSMINOFF(m) \
		if (M_HASCL(m)) \
			(m)->m_off = ((int)MTOCL(m))-(int)(m); \
		else \
			(m)->m_off = MMINOFF
#define	NFSMADV(m, s)	(m)->m_off += (s)
#define	NFSMSIZ(m)	((M_HASCL(m))?MCLBYTES:MLEN)
#define	m_nextpkt	m_act
#define	NFSMCOPY(m, o, l, w)	m_copy((m), (o), (l))
#else
#define	M_HASCL(m)	((m)->m_flags & M_EXT)
#define	NFSMCLGET	MCLGET
#ifdef OSF1_ADFS
#define NFSMGETX(m,f,d,a,s,w) MGETX(m,f,d,a,s,w)
#endif
#define	NFSMGETHDR(m) \
		MGETHDR(m, M_WAIT, MT_DATA); \
		(m)->m_pkthdr.len = 0; \
		(m)->m_pkthdr.rcvif = (struct ifnet *)0
#define	NFSMINOFF(m) \
		if (M_HASCL(m)) \
			(m)->m_data = (m)->m_ext.ext_buf; \
		else \
			(m)->m_data = (m)->m_dat
#define	NFSMADV(m, s)	(m)->m_data += (s)
#define	NFSMSIZ(m)	((M_HASCL(m))?MCLBYTES: \
				(((m)->m_flags & M_PKTHDR)?MHLEN:MLEN))
#define	NFSMCOPY	m_copym
#endif

#ifndef MCLBYTES
#define	MCLBYTES	CLBYTES
#endif

#ifndef MT_CONTROL
#define	MT_CONTROL	MT_RIGHTS
#endif

/*
 * Now for the macros that do the simple stuff and call the functions
 * for the hard stuff.
 * These macros use several vars. declared in nfsm_reqhead and these
 * vars. must not be used elsewhere unless you are careful not to corrupt
 * them. The vars. starting with pN and tN (N=1,2,3,..) are temporaries
 * that may be used so long as the value is not expected to retained
 * after a macro.
 * I know, this is kind of dorkey, but it makes the actual op functions
 * fairly clean and deals with the mess caused by the xdr discriminating
 * unions.
 */

#ifndef lint
#define	nfsm_build(a,c,s) \
		t1 = NFSMSIZ(mb); \
		if ((s) > (t1-mb->m_len)) { \
			MGET(mb2, M_WAIT, MT_DATA); \
			if ((s) > MLEN) \
				panic("build > MLEN"); \
			mb->m_next = mb2; \
			mb = mb2; \
			mb->m_len = 0; \
			bpos = mtod(mb, caddr_t); \
		} \
		(a) = (c)(bpos); \
		mb->m_len += (s); \
		bpos += (s)
#else /* lint */
#define	nfsm_build(a,c,s) \
		t1 = NFSMSIZ(mb); \
		if ((s) > (t1-mb->m_len)) { \
			MGET(mb2, M_WAIT, MT_DATA); \
			mb->m_next = mb2; \
			mb = mb2; \
			mb->m_len = 0; \
			bpos = mtod(mb, caddr_t); \
		} \
		(a) = (c)(bpos); \
		mb->m_len += (s); \
		bpos += (s)
#endif /* lint */

#define	nfsm_disect(a,c,s) \
		t1 = mtod(md, caddr_t)+md->m_len-dpos; \
		if (t1 >= (s)) { \
			(a) = (c)(dpos); \
			dpos += (s); \
		} else if (error = nfsm_disct(&md, &dpos, (s), t1, TRUE, &cp2)) { \
			m_freem(mrep); \
			goto nfsmout; \
		} else { \
			(a) = (c)cp2; \
		}

#define	nfsm_disecton(a,c,s) \
		t1 = mtod(md, caddr_t)+md->m_len-dpos; \
		if (t1 >= (s)) { \
			(a) = (c)(dpos); \
			dpos += (s); \
		} else if (error = nfsm_disct(&md, &dpos, (s), t1, FALSE, &cp2)) { \
			m_freem(mrep); \
			goto nfsmout; \
		} else { \
			(a) = (c)cp2; \
		}

#define nfsm_fhtom(v) \
		nfsm_build(cp,caddr_t,NFSX_FH); \
		bcopy((caddr_t)&(VTONFS(v)->n_fh), cp, NFSX_FH)

#define nfsm_srvfhtom(f) \
		nfsm_build(cp,caddr_t,NFSX_FH); \
		bcopy((caddr_t)(f), cp, NFSX_FH)

#define nfsm_mtofh(d,v,vap) \
		{ struct nfsnode *np; nfsv2fh_t *fhp; \
		nfsm_disect(fhp,nfsv2fh_t *,NFSX_FH); \
		if (error = nfs_nget((d)->v_mount, fhp, &np)) { \
			m_freem(mrep); \
			goto nfsmout; \
		} \
		(v) = NFSTOV(np); \
		nfsm_loadattr(v, vap); \
		}

#define	nfsm_loadattr(v,a) \
		if (error = nfs_loadattrcache((v), &md, &dpos, (a))) { \
			m_freem(mrep); \
			goto nfsmout; \
		}

#define	nfsm_strsiz(s,m) \
		nfsm_disect(p,u_long *,NFSX_UNSIGNED); \
		if (((s) = fxdr_unsigned(long,*p)) > (m)) { \
			m_freem(mrep); \
			error = EBADRPC; \
			goto nfsmout; \
		}

#define	nfsm_srvstrsiz(s,m) \
		nfsm_disect(p,u_long *,NFSX_UNSIGNED); \
		if (((s) = fxdr_unsigned(long,*p)) > (m) || (s) <= 0) { \
			error = EBADRPC; \
			nfsm_reply(0); \
		}

#define nfsm_mtouio(p,s) \
		if ((s) > 0 && \
		   (error = nfsm_mbuftouio(&md,(p),(s),&dpos))) { \
			m_freem(mrep); \
			goto nfsmout; \
		}

#define nfsm_uiotom(p,s) \
		if (error = nfsm_uiotombuf((p),&mb,(s),&bpos)) { \
			m_freem(mreq); \
			goto nfsmout; \
		}

#define	nfsm_reqhead(a,c,s) \
		if ((mreq = nfsm_reqh(nfs_prog,nfs_vers,(a),(c),(s),&bpos,&mb,&xid)) == NULL) { \
			error = ENOBUFS; \
			goto nfsmout; \
		}

#define nfsm_reqdone	m_freem(mrep); \
		nfsmout:

#define nfsm_rndup(a)	(((a)+3)&(~0x3))

#define	nfsm_request(v,t)	\
		if (error = nfs_request((v), mreq, xid, 3*(t), \
		   (v)->v_mount, &mrep, &md, &dpos)) \
			goto nfsmout

#define	nfsm_strtom(a,s,m) \
		if ((s) > (m)) { \
			m_freem(mreq); \
			error = ENAMETOOLONG; \
			goto nfsmout; \
		} \
		t2 = nfsm_rndup(s)+NFSX_UNSIGNED; \
		if(t2<=(NFSMSIZ(mb)-mb->m_len)){ \
			nfsm_build(p,u_long *,t2); \
			*p++ = txdr_unsigned(s); \
			*(p+((t2>>2)-2)) = 0; \
			bcopy((caddr_t)(a), (caddr_t)p, (s)); \
		} else if (error = nfsm_strtmbuf(&mb, &bpos, (a), (s))) { \
			m_freem(mreq); \
			goto nfsmout; \
		}

#define	nfsm_srverr \
		{ \
			m_freem(mrep); \
			return(ENOBUFS); \
		}

#define	nfsm_srvdone \
		nfsmout: \
		return(error)

#ifndef lint
#define	nfsm_reply(s) \
		{ \
		*repstat = error; \
		if (error) \
			nfs_rephead(0, xid, error, mrq, &mb, &bpos); \
		else \
			nfs_rephead((s), xid, error, mrq, &mb, &bpos); \
		m_freem(mrep); \
		mreq = *mrq; \
		if (error) \
			return(0); \
		}
#else	/* lint */
#define	nfsm_reply(s) \
		{ \
		*repstat = error; \
		if (error) \
			nfs_rephead(0, xid, error, mrq, &mb, &bpos); \
		else \
			nfs_rephead((s), xid, error, mrq, &mb, &bpos); \
		m_freem(mrep); \
		mreq = *mrq; \
		mrep = mreq; \
		if (error) \
			return(0); \
		}
#endif	/* lint */

#define	nfsm_adv(s) \
		t1 = mtod(md, caddr_t)+md->m_len-dpos; \
		if (t1 >= (s)) { \
			dpos += (s); \
		} else if (error = nfs_adv(&md, &dpos, (s), t1)) { \
			m_freem(mrep); \
			goto nfsmout; \
		}

#define nfsm_srvmtofh(f) \
		nfsm_disecton(p, u_long *, NFSX_FH); \
		bcopy((caddr_t)p, (caddr_t)f, NFSX_FH)

#define	nfsm_clget \
		if (bp >= be) { \
			MGET(mp, M_WAIT, MT_DATA); \
			NFSMCLGET(mp, M_WAIT); \
			mp->m_len = NFSMSIZ(mp); \
			if (mp3 == NULL) \
				mp3 = mp2 = mp; \
			else { \
				mp2->m_next = mp; \
				mp2 = mp; \
			} \
			bp = mtod(mp, caddr_t); \
			be = bp+mp->m_len; \
		} \
		p = (u_long *)bp

#define	nfsm_srvfillattr \
	fp->fa_type = vtonfs_type(vap->va_type); \
	fp->fa_mode = vtonfs_mode(vap->va_type, vap->va_mode); \
	fp->fa_nlink = txdr_unsigned(vap->va_nlink); \
	fp->fa_uid = txdr_unsigned(vap->va_uid); \
	fp->fa_gid = txdr_unsigned(vap->va_gid); \
	fp->fa_size = txdr_unsigned(vap->va_size); \
	fp->fa_blocksize = txdr_unsigned(vap->va_blocksize); \
	if (vap->va_type == VFIFO) \
		fp->fa_rdev = txdr_unsigned(~0); \
	else \
		fp->fa_rdev = txdr_unsigned(vap->va_rdev); \
	fp->fa_blocks = txdr_unsigned(vap->va_bytes / NFS_FABLKSIZE); \
	fp->fa_fsid = txdr_unsigned(vap->va_fsid); \
	fp->fa_fileid = txdr_unsigned(vap->va_fileid); \
	fp->fa_atime.tv_sec = txdr_unsigned(vap->va_atime.tv_sec); \
	fp->fa_atime.tv_usec = txdr_unsigned(vap->va_flags); \
	txdr_time(&vap->va_mtime, &fp->fa_mtime); \
	fp->fa_ctime.tv_sec = txdr_unsigned(vap->va_ctime.tv_sec); \
	fp->fa_ctime.tv_usec = txdr_unsigned(vap->va_gen)

