/*  VDP Pacman    main game loop and pacman logic  */
/*       29 December 1983     Version 2.1 DLB      */

#define EXTERN

#include "stdio.h"
#include "pacdefs.h"



#define SCREEN 2


main()

{
    getscreen();
    highscore();
    instruct();
    game();
}


#define STARTPAC 3

game()
{
    init();
    for(paccnt = STARTPAC; paccnt > 0; paccnt--)	{
	tempscore = 0;
	killscore = KILLSCORE;
	killcnt = 0;
	dieflag = FALSE;
	potion = FALSE;
	gameloop();
    }
    over();
}


#define PSTARTX	16
#define PSTARTY	18
#define PACSTART 8
#define MONSTER	10

int goldbuf[MSGLNGT];
int ready[MSGLNGT] = {416, 416, 321, 322, 323, 324, 325, 416, 384, 416, 416};
int mnstcolor[MAXMONSTER + 1] = {YELLOW, GREEN, LTRED, RED, YELLOW};

gameloop()
{

    register i;

gmlp:
    pacptr->xpos = PSTARTX;

    pacptr->ypos = PSTARTY;
    pacptr->name = PACSTART;
    pacptr->color = YELLOW;

    pacptr->dirn = DNULL;

		
    display(PAC);
    xpacs();


    for(mptr = &monst[1], mcnt = 1; mcnt < MAXMONSTER+1; mptr++, mcnt++) {
	mptr->xpos = MSTARTX + (2 * mcnt);

	mptr->ypos = MSTARTY;
	mptr->name = MONSTER;
	mptr->color = mnstcolor[mcnt];

	mptr->dirn = DNULL;

	mptr->stat = START;
	
	display(mcnt);

    }
    
    rounds = 1;
    
    vdpram(PNTBASE + MSGLOC, READ);
    for(i = 0; i < MSGLNGT; i++)
	goldbuf[i]=in(VDPDATA);
    vdpram(PNTBASE + MSGLOC, WRITE);
    for(i = 0; i < MSGLNGT; i++)
	out(VDPDATA, ready[i]);
    sleep(180);
    vdpram(PNTBASE + MSGLOC, WRITE);
    for(i = 0; i < MSGLNGT; i++)
	out(VDPDATA, goldbuf[i]);


    while(TRUE)	{
	if(--rounds == 0)	{
 	    rounds = MSTARTINTVL;

	    startmonst();
	}
	pacman();
	if(dieflag) break;
	display(3);
	monster(1);
	if(dieflag) break;
	display(4);
	monster(2);
	if(dieflag) break;
	if(potion)	{
	    display(PAC);

	    if(--potioncnt == 0)	{
		potion = FALSE;
		killscore = KILLSCORE;
		for(mcnt = 1; mcnt < MAXMONSTER + 1; mcnt++)
		    monst[mcnt].color = mnstcolor[mcnt];
	    }
	    else if(potioncnt == 4)
		for(mcnt = 1; mcnt < MAXMONSTER + 1; mcnt++)
		    monst[mcnt].color = WHITE;
	    pacman();
	    if(dieflag) break;
	}
	monster(3);
	if(dieflag) break;
	display(PAC);
	monster(4);
	if(dieflag) break;
	display(1);
	update();
	display(2);
	if(goldcnt <= 0)	{
	    sleep(75);

	    reinit();
	    goto gmlp;
	}
    }
    die();
}



#define PLEFT	0
#define PRIGHT	2
#define PUP	4
#define PDOWN	6


pacman()

{

    int movetype, i;



    for (i = delay; i > 0; i--)
	;



    poll();



    tmpx = pacptr->xpos;

    tmpy = pacptr->ypos;



    board[tmpy][tmpx] = VACANT;

    vdpram(PNTBASE + 32 * tmpy + tmpx, WRITE);
    out(VDPDATA, BLANK);
    
    switch (pacptr->dirn)	{
    case DUP :
	if(board[tmpy + UPINT][tmpx] == WALL)
	    pacptr->dirn = olddirn;
	break;
    case DDOWN :
	if(board[tmpy + DOWNINT][tmpx] == WALL)
	    pacptr->dirn = olddirn;
	break;
    case DLEFT :
	if(tmpx <= 1) break;
	if(board[tmpy][tmpx + LEFTINT] == WALL)
	    pacptr->dirn = olddirn;
	break;
    case DRIGHT :
	if(tmpx >= XWRAP) break;
	if(board[tmpy][tmpx + RIGHTINT] == WALL)
	    pacptr->dirn = olddirn;
	break;
    default :
	pacptr->dirn = olddirn;
    }
    
    switch (pacptr->dirn)	{
    case DUP :

	pacptr->name = PUP;

	if ((movetype = board[tmpy + UPINT][tmpx]) == WALL)

	    pacptr->dirn = DNULL;
	else
	    pacptr->ypos += UPINT;

	break;

    case DDOWN:

	pacptr->name = PDOWN;

	if ((movetype = board[tmpy + DOWNINT][tmpx]) == WALL)
	    pacptr->dirn = DNULL;
	else
	    pacptr->ypos += DOWNINT;

	break;

    case DLEFT:

	if(tmpx <= 1)	{

	    pacptr->xpos = XWRAP;

	    movetype = VACANT;

	    break;
	}

	pacptr->name = PLEFT;

	if ((movetype = board[tmpy][tmpx + LEFTINT]) == WALL)

	    pacptr->dirn = DNULL;
	else
	    pacptr->xpos += LEFTINT;

	break;
    case DRIGHT:

	if(tmpx >= XWRAP)	{

	    pacptr->xpos = 2;

	    movetype = VACANT;

	    break;
	}

	pacptr->name = PRIGHT;

	if ((movetype = board[tmpy][tmpx + RIGHTINT]) == WALL)

	    pacptr->dirn = DNULL;
	else
	    pacptr->xpos += RIGHTINT;

	break;

    }


    switch (movetype)	{

    case GOLD :

	score++;
	tempscore++;

	goldcnt--;
	break;



    case TREASURE :

	score += treasval;

	tempscore += treasval;
	treasval = TREASVAL;
	break;
	    
    case POTION :

	potion = TRUE;

	potioncnt = POTINTVL;

	for(mptr = &monst[1], mcnt = 0; mcnt < MAXMONSTER; mptr++, mcnt++)

		mptr->color = BLUE;
	break;

    }
    if(score >= newman)	{

	putchar(BEEP);
	newman += NEWMAN;
	paccnt = min(MAXPAC, paccnt + 1);
	xpacs();
    }
    for(mptr = &monst[1], mcnt = 1; mcnt < MAXMONSTER + 1; mptr++, mcnt++)

	if((mptr->xpos == pacptr->xpos) && (mptr->ypos == pacptr->ypos))

	    dieflag = dokill(mcnt);

    offdsply(PAC);

}



#define STRTDIE	48
#define STOPDIE	101

die()
{
    register i;

    for(i = 4; i < 4 * MAXMONSTER + 1; i += 4)		{
	vdpram(SATBASE + 3 + i, WRITE);
	out(VDPDATA, CLEAR);
    }
    sleep(9);
    for(i = STRTDIE; i < STOPDIE; i += 4)	{
	vdpram(SATBASE + 2, WRITE);
	out(VDPDATA, i);
	sleep(14);
    }
    sleep(100);
}


int gameover[MSGLNGT] = {416,385,323,386,322,416,387,388,322,321,416};

over()
{
    register i;
    FILE *fopen(), *fp;
    
    if(score > hscore)	{
	reinit();
	putchar(BEEP);
	printf("\nNew high score !!!\n");
	printf("Enter name and date: ");
	gets(winner);
	fp = fopen("highscr.pac", "w");
	fprintf(fp, "%1d\n", hscore = score);
	fputs(winner, fp);
	fclose("highscr.pac");
    }
    vdpram(PNTBASE + MSGLOC, WRITE);
    for(i = 0; i < MSGLNGT; i++)
	out(VDPDATA, gameover[i]);
    while(i = keyboard())
	;
    printf("\nDo you want to play again? ");
    while(!(i = keyboard()))
	;
    if(i == 'n' || i == 'N') {
	graphics(OFF);
	exit(0);
  }
    game();
}


highscore()
{
    FILE *fopen(), *fp;
    char scorebuf[7];

    if((fp = fopen("highscr.pac", "r")) == NULL)	{
	sprintf(winner, "(No high score information is available)");
	hscore = 0;
	return;
    }
    hscore = atoi(fgets(scorebuf, 7, fp));
    fgets(winner, 60, fp);
}
