;
;TITLE ++ KSTROKES	Version 2.1  for KAYPRO CP/M version 2.2
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
KAYPRO2	EQU	FALSE		; TRUE, IF YOU HAVE AN OLD 2 OR 4
KAY484	EQU	FALSE   	; TRUE, IF YOU HAVE A NEW 2 OR 4
KAY484G	EQU	TRUE		; TRUE, IF YOU HAVE A NEW 2 OR 4 WITH
				; CP/M 2.2G
KAYTEN	EQU	FALSE		; TRUE, IF YOU HAVE A 10
;
;Define several addresses
;

IF	KAYPRO2
FBASE	EQU	0EC06H		;ORIGINAL FBASE FOR OLD 2 OR 4
ENDIF

IF	KAY484 
FBASE	EQU	0E806H		;ORIGINAL FBASE FOR NEW 2 OR 4
ENDIF

IF	KAY484G
FBASE	EQU	0E606H		;ORIGINAL FBASE FOR NEW 2,4 USING CP/M 2.2G
ENDIF

IF	KAYTEN 
FBASE	EQU	0DC06H		;ORIGINAL FBASE FOR TEN
ENDIF

DESTIN	EQU	FBASE-0C06H	;PROGRAM DESTINATION
BIOS	EQU	FBASE+0DFAH	;BOTTOM OF BIOS

CONST	EQU	BIOS+07H	;BIOS JMP TABLE ENTRY FOR CONSOLE STATUS
CONIN	EQU	BIOS+0AH	;BIOS JMP TABLE ENTRY FOR CONSOLE IN
KEYDEF	EQU	BIOS+35H	;KEYPAD DEFINITIONS
;
;Define several constants
;
CLRSCR	EQU	01AH	;clear KAYPRO screen
CR	EQU	00DH
FUNCT	EQU	5	;BDOS entry address
BS	EQU	008H	;cursor right
LF	EQU	00AH	;linefeed
UP	EQU	00BH	;cursor left
CL	EQU	00CH	;cursor up
PBUF	EQU	009H	;BDOS print function
SIZE	EQU	0400H	;size of the resident code, etc.
;
;
	ORG	100H
;
;
START:	LHLD	6		;check FBASE
	MOV	A,H
	LXI	B,FBASE
	CMP	B
	JNZ	NOLOAD		;if it's nonstandard, quit
;
;Relocate stack
;
	LXI	H,0
	DAD	SP
	SHLD	OLDSP
	LXI	SP,NEWSTK
;
;Check argument, if any
;
	LXI	B,5DH
	LDAX	B
	CPI	020H		;if it's not blank,
	JNZ	NSTALL		;  go directly to NSTALL
;
;Routines to alter default patterns
;
MENU1:	LXI	D,MENU1T	;put menu addr in DE
	CALL	DOMENU		;display menu and get response
	LXI	D,MENU1J	;put jmp table addr in DE
	CALL	DOOPT
	JMP	MENU1
;
;Code to define special function strings
;
DEFSPF:	MVI	E,CLRSCR	;clear screen
	MVI	C,2
	CALL	FUNCT
	LXI	H,NCHAR		;check # of chars in previous SPFN
	MOV	A,M
	CPI	65		;terminating null byte is counted, too
	JM	NCHOK
	LXI	D,MSG1A		;print warning
	CALL	PRINT
NCHOK:	LXI	D,MENU2T	;put menu addr in DE
	CALL	DOMENU
	CPI	'9'		;finished defining?
	RZ			;  yes, return to main menu
	LXI	B,00H		;BC will contain pattern buffer offset
	SUI	031H		;make function a binary number,
				;  subtracting 1 in the process
	RAL!RAL!RAL!RAL!RAL!RAL	;multiply by 64
	JNC	NCARY2		;if there was a carry,
	INR	B		;  put it in B
NCARY2:	MOV	C,A		;put low-order part of offset in C
	LXI	H,SPFNS-OFFSET	;put pattern buffer address in HL
	DAD	B		;add in offset,
	DCX	H		;  decrement it,
	SHLD	FILPTR		;  and store it
	CALL	SHOW
	LXI	D,MSG3A		;print 2nd part of menu 
	CALL	PRINT
	LXI 	D,MSG3C
	CALL	PRINT
	CALL	FILBUF
	JMP	DEFSPF
;
;Code to fill a buffer the beginning of which is pointed to by FILPTR
;
NCHAR:	DB	0
FILBUF:	MVI	C,6		;get a character
	MVI	E,0FFH
	CALL	FUNCT
	ORA	A		;if no character ready, try again
	JZ	FILBUF
	CPI	'~'		;if 1st character is '~`
	RZ			;  leave contents unchanged
	PUSH	A		;save character
	MVI	A,0		;set NCHAR to zero
	LXI	H,NCHAR
	MOV	M,A
	POP	A		;restore 1st character
	JMP	NXTCH		;and continue
FLOOP:	MVI	C,6		;get a character
	MVI	E,0FFH
	CALL	FUNCT
	ORA	A		;if no character ready, try again
	JZ	FLOOP
NXTCH:	LXI	H,NCHAR		;increment NCHAR
	INR	M
	LHLD	FILPTR		;get pointer to last character
	INX	H		;increment it
	CPI	'~'		;is this the end?
	JZ	FILEND
	MOV	M,A		;no, put character into string
	SHLD	FILPTR		;update pointer
	CALL	DISPLA		;display character
	CPI	CR		;if it was a <ret>,
	JNZ	FLOOP
	LXI	D,CRLF		;send a <cr><lf>
	CALL	PRINT
	JMP	FLOOP		;and get another character
FILPTR:	DS	2
FILEND:	XRA	A		;null out A
	MOV	M,A		;put null at end of string
	RET			;and return
;
;Code to set initial macro definition
;
SIMDEF:	LXI	D,MSG1B		;print instructions
	CALL	PRINT
	LXI	H,MACKRO-OFFSET-1	;put addr of macro string in FILPTR
	SHLD	FILPTR
	CALL	SHOW
	LXI	D,MSG3B		;print instructions
	CALL	PRINT
	LXI	H,MACKRO-OFFSET-1	;put addr of macro string in FILPTR
	SHLD	FILPTR
	CALL	FILBUF		;call routine to fill string buffer
	LXI	H,NCHAR		;zero NCHAR
	XRA	A
	MOV	M,A
	JMP	MENU1
;
;Code for defining keypad
;
DEFKEY:	LXI	D,MSG4		;print instructions
	CALL	PRINT
	LXI	H,KEYDEF
	CALL	SHOKEY
	LXI	H,NUKEYS
	CALL	SHOKEY
	LXI	H,NUKEYS	;put pointer in H
	MVI	C,18		;put counter in C
DKLOOP:	MOV	A,C		;are we done?
	ORA	A
	JZ	DKDONE		;yes, end
	PUSH	B		;save registers
	PUSH	H
	LXI	D,MSG4B		;position cursor
	CALL	PRINT
	LXI	D,MSG4C
	CALL	PRINT
	LXI	D,MSG4D
	CALL	PRINT
DKL2:	MVI	C,6		;get a character
	MVI	E,0FFH
	CALL	FUNCT
	ORA	A		;if no character ready, try again
	JZ	DKL2
	CPI	'~'		;was it an enya?
	JZ	MENU1		;  yes, return to main menu
	POP	H		;otherwise, store it
	MOV	M,A
	INX	H		;update pointer
	PUSH	H		;save pointer
	PUSH	PSW		;save character
	LXI	D,MSG4D2	;erase old new character
	CALL	PRINT
	POP	PSW		;restore character
	CALL	DISPLA		;display new character
	POP	H		;restore registers
	POP	B
	DCR	C		;decrement key counter
	JMP	DKLOOP		;loop back for next key
DKDONE:	LXI	D,MSG4E		;print message
	CALL	PRINT
	MVI	C,01H		;wait for response
	CALL	FUNCT
	JMP	MENU1		;return to main menu
;
;Routine to set speed
;
PAUSE:	LXI	D,MENU4T	;display "menu", get response
	CALL	DOMENU
	SUI	031H		;make it a number-1
	RAL!RAL			;multiply it by 4
	LXI	H,SETPAU-OFFSET	;store answer
	MOV	M,A
	JMP	DKDONE		;show them what they did
;
;Routine to process a menu
;
DOMENU:	LDAX	D		;get MAX from top of table
	LXI	B,MAXRES	;put MAX in argument of CPI
	STAX	B
	INX	D		;skip over MAX
	CALL	PRINT		;display menu
GETRES:	MVI	C,01H		;get a response
	CALL	FUNCT
	CPI	031H		;is it < "1"?
	JM	BADRES		;  yes, it's meaningless
MAXRES	EQU	$+1
	CPI	00H		;is it > MAX from jump table?
	JP	BADRES		;  yes, it's meaningless
	RET
BADRES:	MVI	C,09H		;erase bad response
	LXI	D,ERASE
	CALL	FUNCT
	JMP	GETRES		;and try again
DOOPT:	SUI	031H!RAL	;make the response into a table offset
	LXI	B,00H		;use BC for 16-bit value
	MOV	C,A
	XCHG			;get addr of table addr from DE
	DAD	B		;add it to table base in HL
	CALL	MEMHL		;get addr of routine
	PCHL			;and go to it
;
;Print routine
;
PRINT:	MVI	C,PBUF
	CALL	FUNCT
	RET
;
;Routine to show contents of buffer
;
SHOW:	LXI	D,MSG2
	CALL	PRINT
	LXI	H,NCHAR		;zero character counter
	XRA	A
	MOV	M,A
	LHLD	FILPTR		;get pointer to first character-1
	PUSH	H		;save it on stack
SHLOOP:	INX	H		;update pointer
	PUSH	H		;save pointer
	LXI	H,NCHAR		;count characters in string
	INR	M
	POP	H		;reclaim pointer
	SHLD	FILPTR		;save updated pointer
	MOV	A,M		;put next character in A
	ORA	A		;is it a null?
	JZ	SHEND		;  yes, end show
	CALL	DISPLA		;use display routine to print character
	CPI	CR		;if it was a <ret>
	JNZ	NOCR
	LXI	D,CRLF		;send a <cr><lf>
	CALL	PRINT
NOCR:	LHLD	FILPTR		;get pointer
	JMP	SHLOOP		;do next character
SHEND:	POP	H		;restore pointer
	SHLD	FILPTR
	RET
;
;Routine to show key definitions after option 3
;
SHOKEY:	LXI	B,NUKEYS	;get high order part of address
	MOV	A,B
	XRA	H		;are we displaying current or new settings?
	MOV	B,A		;zero = NUKEYS
	MVI	C,18		;use C for character counter
SKLOOP:	MOV	A,C		;done?
	ORA	A
	JZ	SKDONE		;yes, end
	DCR	C		;decrement character counter
	PUSH	H		;save registers
	PUSH	B
	LXI	D,MSG4B		;skip to right screen loc
	CALL	PRINT
	POP	B		;if displaying new settings, skip more
	ORA	A
	ORA	B
	JNZ	CURSET
	PUSH	B
	LXI	D,MSG4C
	CALL	PRINT
	POP	B
CURSET:	POP	H
	MOV	A,M		;get a character
	INX	H		;increment pointer
	PUSH	H
	PUSH	B
	CALL	DISPLA
	POP	B
	POP	H
	JMP	SKLOOP
SKDONE:	LXI	D,MSG4A		;restore cursor to top
	CALL	PRINT
	RET
;
;Routine to display characters being entered into buffer
;
DISPLA:	PUSH	PSW		;save character
	CPI	020H		;is it printable?
	JM	CONCHR		;  no, it's a control character
	CPI	07FH		;is it a 'del'?
	JZ	DELET		;  yes, go print it
	MOV	E,A		;just print it
	MVI	C,2
	CALL	FUNCT
	JMP	DIDONE
CONCHR:	CPI	CR		;is it a <ret>?
	JZ	PCR		;  yes, print <ret>
	CPI	LF		;is it a <lf>?
	JZ	PLF		;  yes, print <lf>
	CPI	01BH		;is it an escape?
	JZ	PESC		;  yes, print <esc>
	PUSH	PSW		;save character
	MVI	E,'^'		;output carat
	MVI	C,2
	CALL	FUNCT
	POP	PSW		;output character
	ADI	040H		;make it printable
	MOV	E,A
	MVI	C,2
	CALL	FUNCT
	JMP	DIDONE
DELET:	LXI	D,DELSTR
	CALL	PRINT
	JMP	DIDONE
PCR:	LXI	D,CRSTR
	CALL	PRINT
	JMP	DIDONE
PLF:	LXI	D,LFSTR
	CALL	PRINT
	JMP	DIDONE
PESC:	LXI	D,ESCSTR
	CALL	PRINT
	JMP	DIDONE
DELSTR:	DB	'<del>$'
CRSTR:	DB	'<ret>$'
LFSTR:	DB	'<lf>$'
ESCSTR:	DB	'<esc>$'
DIDONE:	POP	PSW		;restore character
	RET			;and return
;
;Routine to load HL with (M)
;
MEMHL:	SHLD	LARG
LARG	EQU	$+1
	LHLD	0000H
	RET
;
;Print messages after menu
;
SAVMSG:	LXI	D,MSG5		;print SAVE instructions
	CALL	PRINT

;
;Set up intercept of BIOS CONIN and CONST functions
;
NSTALL:	LXI	D,MSG6		;print notice, version
	CALL	PRINT	
	LHLD	CONST		;get original CONST destination
	SHLD	OSTDST		;  store it in dummy LXI argument
	LHLD	CONIN		;get original CONIN destination
	SHLD	OCIDST+1-OFFSET	;  store it in dummy JMP argument
	LXI	H,NDST1		;set up level 1 call intercept
	SHLD	CONIN		;  by altering BIOS jump table
	LXI	H,DESTIN	;"enlarge" FDOS and alter BDOS addr
	SHLD	06H		;  by altering CALL 0005 destination
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;; >>>>> NO MORE CALLS TO BDOS AFTER THIS POINT <<<<< ;;
        ;;     >>>>> UNTIL INSTALLATION IS COMPLETED <<<<<    ;;
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;Redo keypad definitions
;
SETKEY:	LXI	B,KEYDEF
	LXI	D,NUKEYS
LOOP01:	LDAX	D
	ORA	A
	JZ	MOVEIT
	STAX	B
	INX	B
	INX	D
	JMP	LOOP01
;
;Routine to move business end of prog to high memory
;  (see "Soul of CPM", pp. 259-261)
;
MOVEIT:	LXI	B,ENDP-BEGINP+1		;# of bytes to move
	LXI	D,BEGINP		;where they come from
	LXI	H,DESTIN		;where they're going
MOVEM:	LDAX	D			;get byte
	INX	D			;increment pointer
	MOV	M,A			;store byte
	INX	H			;increment pointer
	DCX	B			;decrement count
	MOV	A,B			;both B and C must be 0
	ORA	C			;  so OR them to see
	JNZ	MOVEM			;otherwise do another byte
	JMP	CPM
;
;Return to CCP
;
CPM:	LHLD	OLDSP
	SPHL
	RET
;
;Can't load - print message and quit
;
NOLOAD:	LXI	D,MSG7
	CALL	PRINT
	RET
;
;spaces for things
;
OLDSP:	DS	2
	DS	30
NEWSTK:
MENU1T:	DB	5+31H
	DB	CLRSCR,'KSTROKES +++ Version 2.1',CR,LF,LF
	DB	'Semi-intelligent keys for KAYPRO II and 4',CR,LF,LF,LF
	DB	'Options:',CR,LF,LF
	DB	'	1 - Define Special Function(s)',CR,LF
	DB	'	2 - Set initial Macro definition',CR,LF
	DB	'	3 - Define keypad',CR,LF
	DB	'	4 - Set speed',CR,LF
	DB	'	5 - Exit to CPM',CR,LF,LF,LF
	DB	'Enter your selection: $'
MENU1J:	DW	DEFSPF
	DW	SIMDEF
	DW	DEFKEY
	DW	PAUSE
	DW	SAVMSG
MENU2T:	DB	9+31H
	DB	'Enter special function number (1-8) or 9 to stop: $'
MENU4T:	DB	9+31H
	DB	CLRSCR,LF,LF,'Enter a number between 1 (fastest) and 9 '
	DB	'(slowest) to set the speed at which',CR,LF
	DB	'  Special Function and MACRO characters are passed to the '
	DB	'foreground program.',CR,LF,LF,'> $'
MSG1A:	DB	CR,LF,LF
	DB	'WARNING! You have exceeded 63 keystrokes, corrupting '
	DB	'one or more of ',CR,LF,'         the succeeding Special '
	DB	'Functions.',CR,LF
	DB	'Re-define or forgo the use of the corrupted Special'
	DB	' Function(s).'
	DB	CR,LF,LF,'$'
MSG1B:	DB	CLRSCR,'MACRO initialization$'
MSG2:	DB	CR,LF,LF
	DB	'Present contents of buffer are as follows:',CR,LF,LF,'$'
MSG3A:	DB	CR,LF,LF,LF
	DB	'Enter up to 63$'
MSG3B:	DB	CR,LF,LF,LF
	DB	'Enter up to 190'
MSG3C:	DB	' keystrokes. Terminate with "~"'
	DB	CR,LF,'    (To leave unchanged, enter ONLY "~")'
	DB	CR,LF,LF,'>$'
MSG4:	DB	CLRSCR
	DB	'"~" leaves remaining New values unchanged, '
	DB	'returns to main menu.',CR,LF,LF
	DB	'Key      Old value (currently in force)',CR,LF
	DB	'|        |      New value '
	DB	'(installed on exit to CP/M)',CR,LF
	DB	'|        |      |       change New values at cursor '
	DB	'with single keystrokes',CR,LF
	DB	'UP ----- ',CR,LF
	DB	'DOWN --- ',CR,LF
	DB	'LEFT --- ',CR,LF
	DB	'RIGHT -- ',CR,LF
	DB	'0 ------ ',CR,LF
	DB	'1 ------ ',CR,LF
	DB	'2 ------ ',CR,LF
	DB	'3 ------ ',CR,LF
	DB	'4 ------ ',CR,LF
	DB	'5 ------ ',CR,LF
	DB	'6 ------ ',CR,LF
	DB	'7 ------ ',CR,LF
	DB	'8 ------ ',CR,LF
	DB	'9 ------ ',CR,LF
	DB	'- ------ ',CR,LF
	DB	', ------ ',CR,LF
	DB	'<enter>  ',CR,LF
	DB	'. ------ '
MSG4A:	DB	CR,UP,UP,UP,UP,UP,UP,UP,UP,UP,UP
	DB	UP,UP,UP,UP,UP,UP,UP,UP,'$'
MSG4B:	DB	CR,LF,CL,CL,CL,CL,CL,CL,CL,CL,CL,'$'
MSG4C:	DB	CL,CL,CL,CL,CL,CL,CL,'$'
MSG4D:	DB	CL,CL,CL,CL,CL,CL,'< $'
MSG4D2:	DB	BS,BS,BS,BS,BS,BS,BS,'      ',BS,BS,BS,BS,BS,BS,BS,'$'
MSG4E:	DB	CR,LF,LF,'Hit any key to return to main menu.$'
MSG5:	DB	CR,LF,LF
	DB	'To execute a Special Function use "~<n>", where <n>'
	DB	' is a number (1 - 8).',CR,LF
	DB	'To define the MACRO function use "~D<string>~".',CR,LF
	DB	'To execute the MACRO function use "~X".',CR,LF
	DB	'To repeat the MACRO function use "~R<n>~",',CR,LF
	DB	'		where <n> is a '
	DB	'1 - 5 digit number less than 65536',CR,LF
	DB	'	OR use "~R~" to repeat 65535 times.',CR,LF
	DB	'	During MACRO repetition, hit any key to stop early.'
	DB	CR,LF
	DB	'To change the speed at which characters '
	DB	'are read out use "~S<n>",'
	DB	CR,LF,'		where <n> is a number (1 - 9).',CR,LF,LF
	DB	'Immediately after installation, use "SAVE 16 <filename>.COM"'
	DB	CR,LF,'	to save the current definitions'
	DB	', if desired.',CR,LF
	DB	'After RESET, use "<filename>  <anything>" to install the'
	DB	' current definitions,',CR,LF
	DB	'	OR "<filename>" to update definitions from menu,'
	DB	CR,LF
	DB	'	OR "KSTROKES" to start from scratch.'
	DB	CR,LF,LF,'$'
MSG6:	DB	LF,'Installing +++KSTROKES+++ version 2.1'
CRLF:	DB	CR,LF,'$'
MSG7:	DB	LF,'CANNOT LOAD KSTROKES - RESET SYSTEM AND TRY AGAIN'
	DB	CR,LF,'$'
ERASE:	DB	08H, 20H, 08H, 24H
NUKEYS:	DB	00BH, 00AH, 008H, 00CH
	DB	01AH, 018H, 006H, 004H, 005H, 001H, 013H
	DB	011H, 00FH, 00BH, 019H, 014H, 007H, 017H
NKEYS:	DB	00H
	DS	14H
;
;Code to be relocated to high memory
;
BEGINP	EQU	$
OFFSET	EQU	DESTIN-BEGINP
;
;First, transfer calls to BDOS
;
	JMP	FBASE
;
;Code to be executed on intercept of CONIN call
;
NDST1	EQU	$+OFFSET
	LXI	H,DESTIN	;"enlarge" FDOS and alter BDOS addr
	SHLD	06H		;  by altering CALL 0005 destination
	LXI	H,NRET1		;push new return addr onto stack
	PUSH	H		;  to intercept return from CONIN
OCIDST	EQU	$+OFFSET
	JMP	0000H		;complete original call to BIOS routine
				;  (0000 is a dummy argument)
;
;Code to recognize shift character (~)
;
NRET1	EQU	$+OFFSET
	CPI	'~'		;is it an "~"?
	JZ	ENYA		;  if so, do function
	RET			;otherwise, just return
;
;Code to interpret shift functions
;
ENYA	EQU	$+OFFSET
	LXI	H,NRET2		;set up 2nd level return intercept
	PUSH	H
	JMP	OCIDST		;and call BIOS again
NRET2	EQU	$+OFFSET
	CPI	05FH		;is it l.c.?
	JM	CAP		;  no, jump
	SUI	020H		;  yes, capitalize
CAP	EQU	$+OFFSET
	CPI	'D'		;is it a "D"?
	JZ	DEFMAC		;  yes, define macro
	CPI	'X'		;is it an "X"?
	JZ	EXMAC		;  yes, execute macro
	CPI	'R'		;is it an 'R'?
	JZ	RPTMAC		;  yes, repeat macro
	CPI	'S'		;is it an "S"?
	JZ	SETSPD		;  yes, set speed
	CPI	'1'		;is it < "1"?
	JM	OTHVAL		;  yes, it's meaningless
	CPI	'9'		;is it => "9"?
	JM	EXSPFN		;  no, execute special function
OTHVAL	EQU	$+OFFSET
	MVI	A,07EH		;any other value, return "~"
	RET
;
;macro definition routine
;
DEFMAC	EQU	$+OFFSET
	LXI	H,MACKRO	;initilize macro pointer
	SHLD	MACPTR
	LXI	H,NDST3M	;set up 3rd level call intercept
	SHLD	CONIN		;  by altering bios jump table
NDST3M	EQU	$+OFFSET
	CALL	OCIDST
	CPI	07EH		;is it an enya?
	JZ	ENDMAC		;  yes, we're done defining
	LHLD	MACPTR		;M = macro pointer
	MOV	M,A		;store character in buffer
	INX	H		;increment length
	SHLD	MACPTR		;  and save it
	MVI	M,00H		;terminate? macro
	RET			;and return character to prog
;
;macro definition end routine
;
ENDMAC	EQU	$+OFFSET
	LXI	H,NDST1		;restore level 1 call intercept
	SHLD	CONIN
	JMP	NDST1		;and go there, discarding terminal character
;
;macro execution routine
;
EXMAC	EQU	$+OFFSET
	LXI	H,MACKRO	;get macro pointer,
	SHLD	MACPTR		;  and put it in volitile storage
SEND	EQU	$+OFFSET
	LXI	H,NDST3I	;set up level 3 call intercept of CONIN
	SHLD	CONIN
NDST3I	EQU	$+OFFSET
	LHLD	MACPTR		;get pointer to next character
	MOV	A,M		;get next macro character
	MOV	B,A		;save it for now
	INX	H		;increment pointer
	MOV	A,M		;is next character a null?
	ORA	A
	JZ	FINMAC		;  yes, finish up
	SHLD	MACPTR		;store updated pointer
	LXI	H,NDST3S	;set up level 3 call intercept of CONST
	SHLD	CONST
	DCX	H		;point HL at pause counter
SETPAU	EQU	$+OFFSET+1
	MVI	A,1		;say no this many times
	MOV	M,A
	MOV	A,B		;reclaim character
	RET			;and return
PAUCNT	EQU	$+OFFSET
	DB	1
NDST3S	EQU	$+OFFSET
	LXI	H,PAUCNT	;how many times have we said no
	MOV	A,M
	ORA	A		;is it zero?
	JZ	SAYYES		;yes, done waiting
	DCR	A		;update pause count
	MOV	M,A
	MVI	A,0		;indicate no character ready
	RET
SAYYES	EQU	$+OFFSET
	MVI	A,0FFH		;indicate character ready
	RET
FINMAC	EQU	$+OFFSET
	MOV	A,B		;reclaim character
	PUSH	PSW		;  and save it on stack
OSTDST	EQU	$+1		;"Old STatus DeSTination"
	LXI	H,00		;restore original CONST destination
	SHLD	CONST
	LXI	H,NDST1		;restore level 1 call intercept
	SHLD	CONIN
	CALL	CONST-1		;check console status
	ORA	A		;if key was struck, stop
	JZ	NOSTOP
	CALL	OCIDST		;clear stop character
	JMP	RPTEND		;and end repititions
NOSTOP	EQU	$+OFFSET
	LHLD	RPTCNT		;otherwise, update count
	DCX	H
	SHLD	RPTCNT
	MOV	A,H		;test for zero count
	ADD	L
	JZ	RPTEND
	POP	PSW		;get last character
	LXI	H,LSTCHR	;put it at top of macro buffer
	MOV	M,A
	SHLD	MACPTR		;put pointer in volitile storage
	JMP	SEND		;and do macro again
RPTEND	EQU	$+OFFSET
	LXI	H,1		;put a 1 in repeat count
	SHLD	RPTCNT
	POP	PSW		;reclaim last character
	RET			;and return to foreground
;
;code for repeating macro
;
RPTMAC	EQU	$+OFFSET
	LXI	H,0		;zero counter
NEWDIG	EQU	$+OFFSET
	PUSH	H		;save counter on stack
	CALL	GETCH		;get a character
	POP	H
	CPI	'~'		;stop if enya
	JZ	RMLOOP
	SUI	030H		;make it a number
	PUSH 	H		;multiply counter by 10
	POP	D
	DAD	H
	DAD	H
	DAD	D
	DAD	H
	MVI	D,0		;zero in D
	MOV	E,A		;new digit in E
	DAD	D		;add in new digit
	JMP	NEWDIG
RMLOOP	EQU	$+OFFSET
	MOV	A,H		;test for zero count
	ADD	L
	JNZ	NZCNT
	DCX	H		;if it was zero, make it FFFF
NZCNT	EQU	$+OFFSET
	SHLD	RPTCNT		;store count
	JMP	EXMAC		;start doing macros
;
;Code for executing special functions
;
EXSPFN	EQU	$+OFFSET
	LXI	B,00H		;BC will contain pattern buffer offset
	SUI	031H		;make function a binary number,
				;  subtracting 1 in the process
	RAL!RAL!RAL!RAL!RAL!RAL	;multiply by 64
	JNC	NOCARY		;if there was a carry,
	INR	B		;  put it in B
NOCARY	EQU	$+OFFSET
	MOV	C,A		;put low-order part of offset in C
	LXI	H,SPFNS		;put pattern buffer address in HL
	DAD	B		;add in offset,
	SHLD	MACPTR		;  and store it
	JMP	SEND		;complete function with same code as EXMAC
;
;Routine to set speed
;
SETSPD	EQU	$+OFFSET
	CALL	GETCH		;get 1 character
	SUI	031H		;make it a number-1
	RAL!RAL			;multiply it by 4
	LXI	H,SETPAU	;store answer
	MOV	M,A
	JMP	NDST1		;go back to intercept
;
;Little routine to get a character
;
GETCH	EQU	$+OFFSET
	CALL	OCIDST		;get next digit
	ORA	A
	JZ	GETCH
	RET
;
;
MACPTR	EQU	$+OFFSET
	DS	2
RPTCNT	EQU	$+OFFSET
	DW	1
SPFNS	EQU	$+OFFSET
	DB 'This is special function number '
	DB '1.    It is 63 characters long.',0H
	DB 'This is special function number '
	DB '2.    It is 63 characters long.',0H
	DB 'This is special function number '
	DB '3.    It is 63 characters long.',0H
	DB 'This is special function number '
	DB '4.    It is 63 characters long.',0H
	DB 'This is special function number '
	DB '5.    It is 63 characters long.',0H
	DB 'This is special function number '
	DB '6.    It is 63 characters long.',0H
	DB 'This is special function number '
	DB '7.    It is 63 characters long.',0H
	DB 'This is special function number '
	DB '8.    It is 63 characters long.',0H
LSTCHR	EQU	$+OFFSET
	DS	1
MACKRO	EQU	$+OFFSET
	DB	'This is the MACRO. It can be up to 190 characters long.'
	DB	CR,0H
	DS	190-57
;
;End of code to be relocated
;
ENDP2	EQU	$+OFFSET
ENDP	EQU	$
	END	100H
umber '
	DB 