#ident "$Header: alarm.c,v 1.2 91/05/07 17:21:15 jayk Exp $"

/* ------------------------------------------------------------------ */
/* | Copyright Unpublished, MIPS Computer Systems, Inc.  All Rights | */
/* | Reserved.  This software contains proprietary and confidential | */
/* | information of MIPS and its suppliers.  Use, disclosure or     | */
/* | reproduction is prohibited without the prior express written   | */
/* | consent of MIPS.                                               | */
/* ------------------------------------------------------------------ */

/* This program opens the tty ports on a system and then generates	*/
/* random strings which it writes to and reads from the ports through	*/
/* jumpers installed by the operator.					*/

#include <sys/types.h>
#include <signal.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <time.h>

char buffer[80];
int use_message;
char message[80];
int time;

timeout()
{
	FILE	*alarmfile;

	alarmfile = fopen( buffer, "a" );
	if ( alarmfile == 0 ) {
		printf( "alarm.BIT: UNEXPECTED DIFFICULTY OPENING ERRORFILE!" );
		exit( 1 );
	}

	if (use_message) {
	    printf( "\nalarm.BIT: %s\n\n", message );
	    fprintf( alarmfile, "alarm.BIT: %s\n", message );
	} else {
	    printf( "\nalarm.BIT: %d seconds\n\n", time );
	    fprintf( alarmfile, "alarm.BIT: %d seconds\n", time );
	}
}

main( argc, argv )
int	argc;
char	*argv[];
{
	time = atoi( argv[ 2 ] );
	strncpy( buffer, argv[ 1 ], 79 );
	if (argc > 2) {
	    use_message = 1;
	    strncpy( message, argv[ 3 ], 79 );
	} else {
	    use_message = 0;
	}

	signal( SIGALRM, timeout );
	alarm( time );
	sleep( time + 10 );
}
