#ident "$Header: fptype.c,v 1.2 90/08/15 13:10:21 jayk Exp $"

/* ------------------------------------------------------------------ */
/* | Copyright Unpublished, MIPS Computer Systems, Inc.  All Rights | */
/* | Reserved.  This software contains proprietary and confidential | */
/* | information of MIPS and its suppliers.  Use, disclosure or     | */
/* | reproduction is prohibited without the prior express written   | */
/* | consent of MIPS.                                               | */
/* ------------------------------------------------------------------ */

#include <stdio.h>
#include <string.h>

#define SOFTWARE 0x0
#define R2360	 0x1
#define R2010	 0x2
#define R3010	 0x3
#define R6010	 0x4

extern unsigned short FPRevReg();


main(argc,argv)
int argc;
char **argv;
{
	union {
		unsigned short raw;
		struct {
			unsigned imp: 8;
			unsigned ver: 4;
			unsigned rev: 4;
		} fld;
	} type;

	type.raw = FPRevReg();
	switch (type.fld.imp) {
	case SOFTWARE: 
		printf("software");
		break;
	case R2360: 
		printf("R2360");
		break;
	case R2010: 
		printf("R2010");
		break;
	case R3010: 
		printf("R3010");
		break;
	case R6010: 
		printf("R6010");
		break;
	default: 
		printf("Unknown revision register value: 0x%x:0x%x:0x%x\n",
		    type.fld.imp, type.fld.ver, type.fld.rev);
		exit(1);
	}

	if ((argc>1) && (!strcmp(argv[1],"-v"))) {
		printf(" Rev %d.%d\n", type.fld.ver, type.fld.rev);
	} 
	else {
		printf("\n");
	}
}
