static char rcsid[] = "$Header: printer.c,v 1.1 90/03/13 14:28:22 jayk Exp $";

/* ------------------------------------------------------------------ */
/* | Copyright Unpublished, MIPS Computer Systems, Inc.  All Rights | */
/* | Reserved.  This software contains proprietary and confidential | */
/* | information of MIPS and its suppliers.  Use, disclosure or     | */
/* | reproduction is prohibited without the prior express written   | */
/* | consent of MIPS.                                               | */
/* ------------------------------------------------------------------ */

/* This program opens a tty and lp ports on a system and then		*/
/* generates random strings which it writes to the printer port and	*/
/* reads from the tty port.						*/
/*									*/
/* The gettys must be turned off on the tty port.			*/

#include <sys/types.h>

/* For timeout error during read (int receive). */
#include <signal.h>

/* Flag values for calls to "open". */
#include <fcntl.h>

/* Used for file manipulation. */
#include <stdio.h>

/* Used to read error returns from UNIX system calls. */
#include <errno.h>
extern char *sys_errlist[];

/* Used for tty setup and control. */
#include <sys/termio.h>
#include <sys/stermio.h>

/* Used to return system time stamp for seeding random number generator. */
#include <time.h>

/* Used to make program read better. */
#define NO_ERROR	-1000
#define BAD		1
#define GOOD		0
#define	NO		0
#define	YES		1
#define TEST		50

#define XMITLOW		0
#define XMITHIGH	1
#define TESTBAUD	9600
#define MINLENGTH	5
#define MAXLENGTH	250
#define	DELAY		20000

#define	TIME		30
#define	MAXTIME		90

#define	SPACE		0x20
#define	TILDA		0x7e

extern int	stoptest();
extern int	timeout();

/* Global variables. */
int	errno;
int	alrm;
int	gotalarm;
int	burst;

int	curmode;
int	curbaud;
int	numtoread;
int	numread;
int	numports;
int	writeport;
int	readport;
int	maxbaud;
int	maxport;

int	loop;

FILE	*errorfile;
FILE	*passfile;

struct	termio cb;

char	*devlp;
char	*devtty;
char	writestring[ MINLENGTH + MAXLENGTH ];
char	readstring[ MINLENGTH + MAXLENGTH ];

/* Opens the error file, checks the arguments, seeds the random number	*/
/* generator, and starts the tty test.					*/
main( argc, argv )
int	argc;
char	*argv[];
{
	long	time();

	openfiles();
	checkargs( argc, argv );
	srand( time( 0 ) );
	loop = YES;			/* start test */
	testports();
}

/* Opens the errorfile and passfile.  The filename contains the process	*/
/* ID of the current invocation of this program, which makes it easy to	*/
/* kill later.								*/
openfiles()
{
	int	processID;
	char	buffer[ 30 ];

	processID = getpid();
	sprintf( buffer, "%d.ERRptr", processID );
	errorfile = fopen( buffer, "w" );
	if ( errorfile == NULL ) {
		printf( "port.BIT: UNEXPECTED DIFFICULTY OPENING ERRORFILE!" );
		exit( 1 );
	}

	sprintf( buffer, "%d.PASSptr", processID );
	passfile = fopen( buffer, "w" );
	if ( passfile == NULL ) {
		printf( "port.BIT: UNEXPECTED DIFFICULTY OPENING PASSFILE!" );
		exit( 1 );
	}
}

/* Checks whether the arguments to the program are legitimate. */
checkargs( argc, argv )
int	argc;
char	*argv[];
{
	int	index;

	if ( argc < 3 ) {
		fprintf( errorfile, "   usage: printer.BIT <serial_port> <printer_port>\n" );
		fclose( errorfile );
		exit( 1 );
	}

	devtty = argv[ 1 ];
	devlp = argv[ 2 ];
}

/* This is the function that actually tests the ICP's.  It does so in	*/
/* an infinite loop, so the program must be killed to exit.		*/
testports()
{
	int	result;
	u_int	pass;

	signal( SIGHUP, stoptest );
	signal( SIGINT, stoptest );
	signal( SIGQUIT, stoptest );
	signal( SIGTERM, stoptest );

	curbaud = TESTBAUD;
	for ( pass = 1; loop == YES; pass++ ) {
printf("1\n");
		rewind( passfile );
printf("2\n");
		fprintf( passfile, "%u\n", pass );
		fflush( passfile );
printf("3\n");
		openpair();
printf("4\n");
		setstrings();
printf("5\n");
		result = transmit();
printf("6\n");
		closewrite();		/* flush printer buffer */
printf("7\n");
		if ( result == GOOD ) {
			result = receive();
			closeread();
			if ( result == GOOD ) {
				compare();
			}
		}
	}
}

/* Tries to open a pair of ports.  Generates error message if		*/
/* difficulty encountered.  If tries all ports unsuccessfully, aborts	*/
/* program.								*/
openpair()
{
	int	result;

	printf( "CURRENT BAUD RATE IS %d\n", curbaud );
	result = openwrite();
	if ( result == GOOD ) {
		result = openread();
	}

	if ( result == BAD ) {
		fprintf( errorfile,
		    "   EXCESSIVE NUMBER OF FAILURES OPENING PORTS--" );
		fprintf( errorfile, "ABORTING PROGRAM\n" );
		fclose( errorfile );
		exit( 1 );
	}
}

/* Opens the port to write to.  Sets up various parameters.  If		*/
/* encounters difficulty, generates error message.  Which value it uses	*/
/* for the tty number depends on curmode.				*/
openwrite()
{
	char	buffer[ 30 ];

	errno = NO_ERROR;
	printf( " CCC WRITEPORT IS %s\n", devlp );

	writeport = open( devlp, O_WRONLY | O_NDELAY );
	if ( writeport == EOF ) {
		fprintf( errorfile, "   COULD NOT OPEN '%s'", devlp );
		fprintf( errorfile, " AS TRANSMIT PORT\n" );
		if ( errno != NO_ERROR ) {
			fprintf( errorfile, "   UNIX ERRNO %d: '%s'\n",
			    errno, sys_errlist[ errno ] );
		}

		fprintf( errorfile, "\n\n" );
		return( BAD );
	}

	return( GOOD );
}

/* Opens the port to read from.  Sets up various parameters.  If	*/
/* encounters difficulty, generates error message.  Which value it uses	*/
/* for the tty number depends on curmode.				*/
openread()
{
	char	buffer[ 30 ];
	int flags;

	errno = NO_ERROR;
	printf( " CCC READPORT IS %s\n", devtty );

	readport = open( devtty, O_RDONLY | O_NDELAY );
	if ( readport == EOF ) {
		fprintf( errorfile, "   COULD NOT OPEN '%s'", devtty );
		fprintf( errorfile, " AS RECEIVE PORT\n" );
		if ( errno != NO_ERROR ) {
			fprintf( errorfile, "   UNIX ERRNO %d: '%s'\n",
			    errno, sys_errlist[ errno ] );
		}

		fprintf( errorfile, "\n" );
		return( BAD );
	}
	else {
		flags = fcntl( readport, F_GETFL, 0 );
		flags &= ~O_NDELAY;
		fcntl( readport, F_SETFL, flags );
		if ( ioctl( readport, TCGETA, &cb ) == -1 ) {
			fprintf( errorfile, "--ioctl 2 openread()--\n" );
			if ( errno != NO_ERROR ) {
				fprintf( errorfile, "UNIX ERRNO %d: '%s'\n",
				    errno, sys_errlist[ errno ] );
			}

			fprintf( errorfile, "\n" );
			return( BAD );
		}

		cb.c_cc[ VTIME ] = 1;
		cb.c_cc[ VMIN ] = 1;
		cb.c_cflag = CS7 | CREAD;
		cb.c_lflag = 0;
		cb.c_cflag &= ~CBAUD;
		switch ( curbaud ) {
		case  300:
			cb.c_cflag |= B300;
			break;

		case  600:
			cb.c_cflag |= B600;
			break;

		case  1200:
			cb.c_cflag |= B1200;
			break;

		case  2400:
			cb.c_cflag |= B2400;
			break;

		case  4800:
			cb.c_cflag |= B4800;
			break;

		case  9600:
			cb.c_cflag |= B9600;
			break;

		case 19200:
			cb.c_cflag |= EXTA;
			break;
		}

		cb.c_iflag = cb.c_oflag = 0;

		if ( ioctl( readport, TCSETAF, &cb ) == -1 ) {
			fprintf( errorfile, "--ioctl 4 openread()--\n" );
			if ( errno != NO_ERROR ) {
				fprintf( errorfile, "UNIX ERRNO %d: '%s'\n",
				    errno, sys_errlist[ errno ] );
			}

			fprintf( errorfile, "\n" );
			return( BAD );
		}
	}

	return( GOOD );
}

/* First pads both readstring and writestring with nulls, then, in	*/
/* order to insure that the ports are tested with a wide variety of bit	*/
/* patterns, this function generates a random string between MINLENGTH	*/
/* and (MINLENGTH + MAXLENGTH - 1) characters in length.  The string	*/
/* can contain any character from 1-255, so it is not necessarily	*/
/* printable (error messages print it out in hex).			*/
setstrings()
{
	int	index;
	int	length;

	index = 0;
	while ( index < (MINLENGTH + MAXLENGTH) ) {
		writestring[ index ] = '\0';
		readstring[ index ] = '\0';
		index++;
	}

	index = 0;
	length = (rand() % MAXLENGTH) + MINLENGTH;
	/* length = TEST; */

	/* Use just printable ASCII characters */
	do {
		writestring[ index ] = rand() % TILDA;
		if ( writestring[ index ] <= SPACE ) {
			writestring[ index ] += SPACE;
		}

		index++;
	} while ( index < length );
}

/* Sends the current random string to the writeport.  Looks for UNIX	*/
/* error returns and generates an error message if detects any.		*/
transmit()
{
	int	numtowrite;
	int	numwritten;
	int	*trash;

	errno = NO_ERROR;
	ioctl( writeport, TCFLSH, 1 );
	if ( ioctl( readport, TCFLSH, 0 ) == -1 ) {
		fprintf( errorfile, "--ioctl FAILED in transmit()" );
		fprintf( errorfile, "\n\n" );
		if ( errno != NO_ERROR ) {
			fprintf( errorfile, "UNIX ERRNO %d: '%s'",
			    errno, sys_errlist[ errno ] );
			fprintf( errorfile, "\n\n" );
			return( BAD );
		}
	}

	numtowrite = strlen( writestring );
	numwritten = write( writeport, writestring, numtowrite );

	printf( " CCC NUMTOWRITE = %d  NUMWRITTEN = %d \n",
	    numtowrite, numwritten );
	if ( numwritten != numtowrite ) {
		fprintf( errorfile, "   TRANSMIT ERROR:\n" );
		printsets();
		fprintf( errorfile, "     TRIED TO TRANSMIT (IN HEX):\n" );
		printstring( writestring, 8 );
		fprintf( errorfile, "     CHARACTERS TRANSMITTED: %d\n",
		    numwritten );
		if ( errno != NO_ERROR ) {
			fprintf( errorfile, "     UNIX ERRNO %d: '%s'\n",
			    errno, sys_errlist[ errno ] );
		}

		fprintf( errorfile, "\n" );
		return( BAD );
	}
	else {
		return( GOOD );
	}
}

/* Prints current settings. */
printsets()
{
	fprintf( errorfile, "     TRANSMIT PORT: '%s'\n", devlp );
	fprintf( errorfile, "     RECEIVE PORT : '%s'\n", devtty );
	fprintf( errorfile, "     CURRENT BAUD RATE: %d\n", curbaud );
}

/* Prints the given string in hex.  If the string is longer than a	*/
/* single line, it breaks it up onto more than one line.		*/
printstring( thistring, indent )
char	thistring[];
int	indent;
{
	int	index;
	int	counter;
	int	maxindex;

	counter = 0;
	while ( counter < indent ) {
		fprintf( errorfile, " " );
		counter++;
	}

	fprintf( errorfile, "'" );
	index = 0;
	maxindex = strlen( thistring );
	while ( index < maxindex ) {
		fprintf( errorfile, "%2.2x", thistring[ index ] & 0xff );
		index++;
		if ( ((index % 35) == 0) && (index < maxindex) ) {
			fprintf( errorfile, "\n" );
			counter = 0;
			while ( counter <= indent ) {
				fprintf( errorfile, " " );
				counter++;
			}
		}
	}

	fprintf( errorfile, "'\n" );
}

int	curtime;

timeout()
{
	fprintf( errorfile,
	    "AN ALARM SIGNAL OCCURRED WHILE ATTEMPTING TO READ TTY PORT AFTER %d SECONDS\n",
	    curtime );
	fflush( errorfile );
	if ( curtime == MAXTIME ) {
		fprintf( errorfile, "HAVE NO CHOICE BUT TO EXIT!\n" );
		fprintf( errorfile, "\n" );
		fflush( errorfile );
		closewrite();
		closeread();
		exit( 1 );
	}
	else {
		curtime += TIME;
		alarm( TIME );
	}
}

stoptest()
{
printf("stoptest\n");
	loop = NO;			/* terminate test */
}

/* Reads a random string from the readport.  Looks for UNIX error	*/
/* returns and generates an error message if detects any.		*/
receive()
{
	int	cnt1, cnt2, flags;

	errno = NO_ERROR;
	signal( SIGALRM, timeout );
	flags = fcntl( readport, F_GETFL, 0 );
	flags &= ~O_NDELAY;
	fcntl( readport, F_SETFL, flags );
	alrm = GOOD;
	cnt2 = numtoread = strlen( writestring );

	curtime = TIME;
	gotalarm = numread = 0;
	alarm( TIME );
	while ( !gotalarm && ((cnt1 = read( readport, &readstring[ numread ], cnt2 )) != cnt2 )) {
		cnt2 -= cnt1;
		numread += cnt1;
	}

	if ( cnt1 == cnt2 ) {
		numread += cnt1;	/* to catch last read when cnt1 = cnt2 */
	}

	alarm( 0 );
	if ( (numread != numtoread) || gotalarm ) {
		printsets();
		fprintf( errorfile, "READMISS " );
		if ( cnt1 == -1 ) {
			fprintf( errorfile, "ERRNO='%s'; ", sys_errlist[ errno ] );
		}

		if ( numread > 0 ) {
			fprintf(errorfile, "READ %d OUT OF %d CHARS; ",
			    numread, numtoread);
		}

		if ( gotalarm ) {
			/* non-block read */
			flags = fcntl( readport, F_GETFL, 0 );
			flags |= O_NDELAY;
			fcntl( readport, F_SETFL, flags );

			cnt1 = read( readport, readstring, numtoread-numread );
			if ( cnt1 > 0 ) {
				fprintf( errorfile, "RETRY GOT %d CHARS", cnt1 );
			}
			else if ( cnt1 != 0 ) {
				fprintf( errorfile, "NONBLOCKING READ ERROR:'%s'",
				    sys_errlist[ errno ]);
			}

			flags = fcntl( readport, F_GETFL, 0 );
			flags &= ~O_NDELAY;
			fcntl( readport, F_SETFL, flags );
		}
		else if ( cnt1 != -1 ) {
			fprintf(errorfile, "; READ ANOMALY");
		}

		fprintf( errorfile, "\n" );
		fflush( errorfile );
		return( BAD );
	}

	return( GOOD );
}

/* Compares the string sent and the string received.  Generates an	*/
/* error if not identical.						*/
compare()
{
	if ( (strcmp( writestring, readstring ) != 0) && (alrm == GOOD) ) {
		fprintf( errorfile, "   COMPARE ERROR:\n" );
		printsets();
		fprintf( errorfile, "     STRING TRANSMITTED (IN HEX):\n" );
		printstring( writestring, 8 );
		fprintf( errorfile, "     STRING RECEIVED (IN HEX):\n" );
		printstring( readstring, 8 );
		fprintf( errorfile, "     CHARACTERS TRANSMITTED: " );
		fprintf( errorfile, "%d\n", strlen( writestring ) );
		fprintf( errorfile, "     CHARACTERS RECEIVED   : " );
		fprintf( errorfile, "%d\n\n", strlen( readstring ) );
	}
}

/* Closes the current write port.  Generates an error message if	*/
/* encounters difficulty doing so.					*/
closewrite()
{
	errno = NO_ERROR;
	if ( close( writeport ) != 0 ) {
		fprintf( errorfile, "   ERROR CLOSING TRANSMIT PORT '%s'\n", devlp );
		if ( errno != NO_ERROR ) {
			fprintf( errorfile, "   UNIX ERRNO %d: '%s'\n",
			    errno, sys_errlist[ errno ] );
		}

		fprintf( errorfile, "\n" );
	}
}

/* Closes the current read port.  Generates an error message if		*/
/* encounters difficulty doing so.					*/
closeread()
{
	errno = NO_ERROR;
	if ( close( readport ) != 0 ) {
		fprintf( errorfile, "   ERROR CLOSING RECEIVE PORT '%s'\n", devtty );
		if ( errno != NO_ERROR ) {
			fprintf( errorfile, "   UNIX ERRNO %d: '%s'\n",
			    errno, sys_errlist[ errno ] );
		}

		fprintf( errorfile, "\n" );
	}
}
