static char rcsid[] = "$Header: graphic.c,v 1.1 90/03/13 14:27:41 jayk Exp $";

/* ------------------------------------------------------------------ */
/* | Copyright Unpublished, MIPS Computer Systems, Inc.  All Rights | */
/* | Reserved.  This software contains proprietary and confidential | */
/* | information of MIPS and its suppliers.  Use, disclosure or     | */
/* | reproduction is prohibited without the prior express written   | */
/* | consent of MIPS.                                               | */
/* ------------------------------------------------------------------ */

#include <stdio.h>
#include "Xlib.h"

#define	DELAY			20

FILE *errorfile;
FILE *passfile;

Display *disp;
GC sgc;
Window window;

char server[256] = "";
char *server_name = NULL;
int errors = 0;
int h;
int w;


usage(argv)
char *argv[];
{
	fprintf(stderr, "%s [-root] [-server name] [-delay seconds]\n", argv[0]);
	exit(1);
}


check_fb(fg)
int fg;
{
	XImage *xi;
	int x, y;
	unsigned int p;

	XSetForeground(disp, sgc, fg);
	XFillRectangle(disp, (Drawable)window, sgc, 0, 0, w, h);

	xi = XGetImage(disp, (Drawable)window, 0, 0, w, h,
	    AllPlanes, ZPixmap);

	for (y = 0; y < h; y++) {
		for (x = 0; x < w; x++) {
			if ((p = XGetPixel(xi, x, y)) != fg) {
				fprintf(errorfile, "Pixel is %02x, Expected %02x at (%d, %d)\n",
				    p, fg, x, y);
				fflush(errorfile);

				errors++;
			}
		}
	}

	XDestroyImage(xi);
	XClearWindow(disp, DefaultRootWindow(disp));
	XFlush(disp);

	printf("Total errors = %ld, with value %02x\n", errors, fg);
}


main(argc, argv)
int argc;
char *argv[];
{
	XEvent event;
	XExposeEvent *exposeEvent;
	XGCValues gc;
	int color;
	int delay = DELAY;
	int i;
	int pass;
	int root = 0;
	int screen;

	openfiles();

	for (i = 1; i < argc; i++) {
		if (strcmp(argv[i], "-root") == 0) {
			root = 1;
		}
		else if (strcmp(argv[i], "-delay") == 0) {
			if (++i >= argc) {
				usage(argv);
			}

			delay = atoi(argv[i]);
		}
		else if (strcmp(argv[i], "-server") == 0) {
			if (++i >= argc) {
				usage(argv);
			}

			strcpy(server, argv[i]);
			server_name = server;
		}
		else {
			usage(argv);
		}
	}

	color = 0;
	for (pass = 1; ; pass++) {
		rewind(passfile);
		fprintf(passfile, "%u\n", pass);
		fflush(passfile);

		if (!(disp = XOpenDisplay(server_name))) {
			fprintf(errorfile, "Unable to open connection to the server %s\n",
			    XDisplayName(server_name));
			fflush(errorfile);
			exit(1);
		}

		h = DisplayHeight(disp, 0);
		w = DisplayWidth(disp, 0);
		screen = DefaultScreen(disp);
		if (root) {
			window = RootWindow(disp, screen);
		}
		else {
			window = XCreateSimpleWindow(disp, RootWindow(disp,screen),
			    0, 0, w, h, 0, BlackPixel(disp, screen),
			    WhitePixel(disp, screen));
			XSelectInput(disp, window, ExposureMask);
			XMapWindow(disp, window);
			exposeEvent = (XExposeEvent *) & event;
			do {
				XNextEvent(disp, &event);
			} while ((event.type != Expose) || (exposeEvent->window != window));
		}

		gc.function = GXcopy;
		gc.foreground = BlackPixel(disp, 0);
		gc.plane_mask = AllPlanes;
		sgc = XCreateGC(disp, (Drawable)window,
		    GCFunction | GCForeground | GCPlaneMask, &gc);

		check_fb(color++ & 0xff);
		if (!root) {
			XDestroyWindow(disp, window);
		}

		XFreeGC(disp, sgc);
		XCloseDisplay(disp);
		sleep(delay);
	}
}


/* Opens the errorfile and passfile.  The filename contains the process	*/
/* ID of the current invocation of this program, which makes it easy to	*/
/* kill later.								*/
openfiles()
{
	int processID;
	char buffer[30];

	processID = getpid();
	sprintf(buffer, "%d.ERRgrf", processID);
	errorfile = fopen(buffer, "w");
	if (errorfile == NULL) {
		printf("graphic.BIT: UNEXPECTED DIFFICULTY OPENING ERRORFILE!");
		exit(1);
	}

	sprintf(buffer, "%d.PASSgrf", processID);
	passfile = fopen(buffer, "w");
	if (passfile == NULL) {
		printf("graphic.BIT: UNEXPECTED DIFFICULTY OPENING PASSFILE!");
		exit(1);
	}
}
