/*	$NetBSD: k_setreuid.c,v 1.3 1997/01/09 06:09:04 tls Exp $	*/

/*
 * Set*uid is a mess! Different systems have different ways of doing
 * things. This function is mainly here because of Solaris that
 * doesn't have a way of setting both real and effective uid at the
 * same time. That is if you don't want to link with libucb, and we
 * don't want that.
 *
 * It could probably do better than this, but currently this seem to
 * work good enough.  
 *
 * from: k_setreuid.c,v 1.4 1995/10/08 16:05:58 he Exp $
 *
 */

#include "kerberosIV/krb_config.h"

#include <kerberosIV/krb.h>

int
k_setreuid(r, e)
	int r;
	int e;
{
/* if there is a usable function, use that */
#ifdef HAVE_SETRESUID
  return setresuid(r, e, -1);
#else
#ifdef HAVE_SETREUID
  return setreuid(r, e);
#else

  return setuid(r); /* Weee! */

#endif /* HAVE_SETREUID */

#endif /* HAVE_SETRESUID */
}
