%{
  #include <string.h>
  #include "y.tab.h"
  unsigned lineno = 1;
  extern char *ds();
%}

PC	[^\"]
AN	[A-Z_a-z0-9]
%%

error_table	return ERROR_TABLE;
et		return ERROR_TABLE;
error_code	return ERROR_CODE_ENTRY;
ec		return ERROR_CODE_ENTRY;
end		return END;

[\t ]		;
\n		++lineno;

\"{PC}*\"	{ register char *p; yylval.dynstr = ds(yytext+1);
		  if (p=strrchr(yylval.dynstr, '"')) *p='\0';
		  return QUOTED_STRING;
		}

{AN}*	{ yylval.dynstr = ds(yytext); return STRING; }

#.*\n		++lineno;

.		{ return (*yytext); }
%%
#ifndef lint
static char rcsid_et_lex_lex_l[] = "$Header: /cvsroot/src/domestic/usr.bin/compile_et/et_lex.lex.l,v 1.2 1997/05/09 13:52:18 mycroft Exp $";
#endif
