/*	$NetBSD: sbrk.S,v 1.3.10.2 2000/08/22 07:28:15 kleink Exp $	*/

/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * from: Header: sbrk.s,v 1.3 92/07/02 00:56:49 torek Exp
 */

#include <machine/asm.h>
#if defined(SYSLIBC_SCCS) && !defined(lint)
#if 0
	.asciz "@(#)sbrk.s	8.1 (Berkeley) 6/4/93"
#else
	RCSID("$NetBSD: sbrk.S,v 1.3.10.2 2000/08/22 07:28:15 kleink Exp $")
#endif
#endif /* SYSLIBC_SCCS and not lint */

#include "SYS.h"

	.globl	_C_LABEL(__curbrk)
	.globl	_C_LABEL(_end)

#ifdef WEAK_ALIAS
WEAK_ALIAS(sbrk, _sbrk)
#endif

	.data
	.align	8
_C_LABEL(__curbrk):
	.xword	_C_LABEL(_end)
	.text

ENTRY(_sbrk)
#ifdef PIC
	PIC_PROLOGUE(%o5,%o4)
	set	_C_LABEL(__curbrk), %o3
	ldx	[%o5 + %o3], %o2
	ldx	[%o2], %o3			! %o3 = old break
	add	%o3, %o0, %o4			! %o4 = new break
	mov	%o4, %o0			! copy for syscall
	mov	SYS_break, %g1
	t	ST_SYSCALL			! break(new_break)
	bcc,a	1f				! if success,
	 mov	%o3, %o0			!    set return value
	ERROR()
1:
	retl					! and update curbrk
	 stx	%o4, [%o2]
#else
	sethi	%hi(_C_LABEL(__curbrk)), %o2
	ldx	[%o2 + %lo(_C_LABEL(__curbrk))], %o3	! %o3 = old break
	add	%o3, %o0, %o4			! %o4 = new break
	mov	%o4, %o0			! copy for syscall
	mov	SYS_break, %g1
	t	ST_SYSCALL			! break(new_break)
	bcc,a	1f				! if success,
	 mov	%o3, %o0			!    set return value
	ERROR()
1:
	retl					! and update curbrk
	 stx	%o4, [%o2 + %lo(_C_LABEL(__curbrk))]
#endif
